/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.converter.internal;

import java.lang.reflect.Array;
import java.util.Collection;
import org.hibernate.internal.build.AllowReflection;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.BasicCollectionJavaType;

public class CollectionConverter<X extends Collection<Object>, Y>
implements BasicValueConverter<X, Y> {
    private final BasicValueConverter<Object, Object> elementConverter;
    private final BasicCollectionJavaType<X, ?> domainJavaType;
    private final JavaType<Y> relationalJavaType;

    public CollectionConverter(BasicValueConverter<Object, Object> elementConverter, BasicCollectionJavaType<X, ?> domainJavaType, JavaType<Y> relationalJavaType) {
        this.elementConverter = elementConverter;
        this.domainJavaType = domainJavaType;
        this.relationalJavaType = relationalJavaType;
    }

    @Override
    public X toDomainValue(Y relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        Object[] relationalArray = (Object[])relationalForm;
        Collection domainForm = (Collection)this.domainJavaType.getSemantics().instantiateRaw(relationalArray.length, null);
        for (int i = 0; i < relationalArray.length; ++i) {
            domainForm.add(this.elementConverter.toDomainValue(relationalArray[i]));
        }
        return (X)domainForm;
    }

    @Override
    @AllowReflection
    public Y toRelationalValue(X domainForm) {
        if (domainForm == null) {
            return null;
        }
        Object[] relationalArray = (Object[])Array.newInstance(this.elementConverter.getRelationalJavaType().getJavaTypeClass(), domainForm.size());
        int i = 0;
        for (Object domainValue : domainForm) {
            relationalArray[i++] = this.elementConverter.toRelationalValue(domainValue);
        }
        return (Y)relationalArray;
    }

    @Override
    public JavaType<X> getDomainJavaType() {
        return this.domainJavaType;
    }

    @Override
    public JavaType<Y> getRelationalJavaType() {
        return this.relationalJavaType;
    }
}

