/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.listeners;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryExpired;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.util.concurrent.BlockingManager;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.sessions.infinispan.entities.RemoteUserSessionEntity;
import org.keycloak.models.sessions.infinispan.listeners.BaseUserSessionExpirationListener;

@ClientListener(converterFactoryName="___eager-key-value-version-converter", useRawData=true)
public class RemoteUserSessionExpirationListener
extends BaseUserSessionExpirationListener {
    private final Marshaller marshaller;

    public RemoteUserSessionExpirationListener(KeycloakSessionFactory factory, BlockingManager blockingManager, Marshaller marshaller) {
        super(factory, blockingManager);
        this.marshaller = marshaller;
    }

    @ClientCacheEntryExpired
    public void onSessionExpired(ClientCacheEntryCustomEvent<byte[]> entryExpired) {
        try {
            RemoteUserSessionEntity entity = this.extractRemoteUserSessionEntity(entryExpired);
            if (entity == null) {
                return;
            }
            this.sendExpirationEvent(entity.getUserSessionId(), entity.getUserId(), entity.getRealmId());
        }
        catch (Exception e) {
            logger.error((Object)"Error handling an expired entry", (Throwable)e);
        }
    }

    private RemoteUserSessionEntity extractRemoteUserSessionEntity(ClientCacheEntryCustomEvent<byte[]> event) throws IOException, ClassNotFoundException {
        byte[] data = (byte[])event.getEventData();
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int length = UnsignedNumeric.readUnsignedInt((ByteBuffer)buffer);
        buffer.position(buffer.position() + length);
        length = UnsignedNumeric.readUnsignedInt((ByteBuffer)buffer);
        return (RemoteUserSessionEntity)this.marshaller.objectFromByteBuffer(data, buffer.position(), length);
    }
}

