/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.compatibility.CompatibilityMetadataProvider;
import org.keycloak.config.ConfigProviderFactory;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.cli.command.AbstractAutoBuildCommand;
import org.keycloak.quarkus.runtime.cli.command.OptimizedMixin;
import picocli.CommandLine;

public abstract class AbstractUpdatesCommand
extends AbstractAutoBuildCommand {
    @CommandLine.Mixin
    OptimizedMixin optimizedMixin = new OptimizedMixin();

    @Override
    public boolean shouldStart() {
        return false;
    }

    @Override
    protected Optional<Integer> callCommand() {
        return super.callCommand().or(() -> {
            if (!Profile.isAnyVersionOfFeatureEnabled((Profile.Feature)Profile.Feature.ROLLING_UPDATES_V1)) {
                this.printFeatureDisabled();
                return Optional.of(4);
            }
            AbstractUpdatesCommand.loadConfiguration();
            this.printPreviewWarning();
            this.validateConfig();
            return Optional.of(this.executeAction());
        });
    }

    abstract int executeAction();

    static void validateFileIsNotDirectory(File file, String option) {
        if (file.isDirectory()) {
            throw new PropertyException("Incorrect argument %s. Path '%s' is not a valid file.".formatted(option, file.getAbsolutePath()));
        }
    }

    private void printPreviewWarning() {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ROLLING_UPDATES_V2) && (Profile.Feature.ROLLING_UPDATES_V2.getType() == Profile.Feature.Type.PREVIEW || Profile.Feature.ROLLING_UPDATES_V2.getType() == Profile.Feature.Type.EXPERIMENTAL)) {
            this.picocli.error("Warning! This command is '" + String.valueOf(Profile.Feature.ROLLING_UPDATES_V2.getType()) + "' and is not recommended for use in production. It may change or be removed at a future release.");
        }
    }

    void printFeatureDisabled() {
        this.picocli.error("Unable to use this command. None of the versions of the feature '" + Profile.Feature.ROLLING_UPDATES_V1.getUnversionedKey() + "' is enabled.");
    }

    static Map<String, CompatibilityMetadataProvider> loadAllProviders() {
        HashMap<String, CompatibilityMetadataProvider> providers = new HashMap<String, CompatibilityMetadataProvider>();
        for (CompatibilityMetadataProvider p : ServiceLoader.load(CompatibilityMetadataProvider.class)) {
            providers.merge(p.getId(), p, (existing, current) -> {
                if (existing.priority() == current.priority()) {
                    throw new IllegalArgumentException("Unable to handle two providers with the same id (%s) and priority.".formatted(existing.getId()));
                }
                return existing.priority() < current.priority() ? current : existing;
            });
        }
        return providers;
    }

    private static void loadConfiguration() {
        Config.ConfigProvider configProvider = (Config.ConfigProvider)ServiceLoader.load(ConfigProviderFactory.class).stream().findFirst().map(ServiceLoader.Provider::get).flatMap(ConfigProviderFactory::create).orElseThrow(() -> new RuntimeException("Failed to load Keycloak Configuration"));
        Config.init((Config.ConfigProvider)configProvider);
    }

    @Override
    protected OptimizedMixin getOptimizedMixin() {
        return this.optimizedMixin;
    }
}

