/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.resource;

import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import oracle.jdbc.driver.resource.InstalledProviders;
import oracle.jdbc.driver.resource.ResourceType;
import oracle.jdbc.spi.OracleResourceProvider;

public final class ProviderProperties {
    private final Map<String, String> propertyValues;

    private ProviderProperties(Map<String, String> propertyValues) {
        this.propertyValues = Collections.unmodifiableMap(new HashMap<String, String>(propertyValues));
    }

    public static ProviderProperties create(Hashtable<?, ?> ... connectionProperties) {
        HashMap<String, String> propertyValues = new HashMap<String, String>();
        for (Hashtable<?, ?> properties : connectionProperties) {
            if (properties == null) continue;
            for (Map.Entry<?, ?> entry : properties.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (!(key instanceof String) || !(value instanceof String) || !ProviderProperties.isProviderProperty((String)key)) continue;
                propertyValues.putIfAbsent((String)key, (String)value);
            }
        }
        return new ProviderProperties(propertyValues);
    }

    String getProviderName(ResourceType<?, ?> resourceType) {
        return this.propertyValues.getOrDefault(resourceType.getProviderNameProperty(), resourceType.getDefaultProviderName());
    }

    Map<String, String> getParameterValues(ResourceType<?, ?> resource) {
        String nameSpacePrefix = resource.getProviderNameProperty() + ".";
        HashMap<String, String> parameterProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> propertyValue : this.propertyValues.entrySet()) {
            String propertyName = propertyValue.getKey();
            if (!propertyName.startsWith(nameSpacePrefix)) continue;
            String parameterName = propertyName.substring(nameSpacePrefix.length());
            parameterProperties.put(parameterName, propertyValue.getValue());
        }
        return parameterProperties;
    }

    public Collection<DriverPropertyInfo> generatePropertyInfo() {
        Collection<ResourceType<?, ?>> resourceTypes = ResourceType.allTypes();
        ArrayList<DriverPropertyInfo> info = new ArrayList<DriverPropertyInfo>(resourceTypes.size());
        for (ResourceType<?, ?> resourceType : resourceTypes) {
            InstalledProviders<?> installedProviders = InstalledProviders.load(resourceType);
            DriverPropertyInfo nameInfo = this.generateProviderNamePropertyInfo(resourceType, installedProviders);
            info.add(nameInfo);
            Collection<DriverPropertyInfo> parameterInfo = this.generateParameterPropertyInfo(resourceType, installedProviders);
            info.addAll(parameterInfo);
        }
        return info;
    }

    private DriverPropertyInfo generateProviderNamePropertyInfo(ResourceType<?, ?> resourceType, InstalledProviders<?> installedProviders) {
        DriverPropertyInfo info = new DriverPropertyInfo(resourceType.getProviderNameProperty(), this.getProviderName(resourceType));
        info.choices = installedProviders.getNames().toArray(new String[0]);
        return info;
    }

    private Collection<DriverPropertyInfo> generateParameterPropertyInfo(ResourceType<?, ?> resourceType, InstalledProviders<?> installedProviders) {
        String providerName = this.getProviderName(resourceType);
        if (providerName == null) {
            return Collections.emptyList();
        }
        Object provider = installedProviders.get(providerName);
        if (provider == null) {
            return Collections.emptyList();
        }
        Collection<? extends OracleResourceProvider.Parameter> parameters = provider.getParameters();
        if (parameters == null) {
            return Collections.emptyList();
        }
        ArrayList<DriverPropertyInfo> info = new ArrayList<DriverPropertyInfo>(parameters.size());
        for (OracleResourceProvider.Parameter parameter : parameters) {
            if (parameter == null) continue;
            String propertyName = resourceType.getProviderNameProperty() + "." + parameter.name();
            CharSequence defaultValue = parameter.isSensitive() ? null : parameter.defaultValue();
            String propertyValue = this.propertyValues.getOrDefault(propertyName, defaultValue == null ? null : defaultValue.toString());
            DriverPropertyInfo parameterInfo = new DriverPropertyInfo(propertyName, propertyValue);
            parameterInfo.required = parameter.isRequired();
            parameterInfo.description = parameter.description();
            if ("".equals(parameterInfo.description)) {
                parameterInfo.description = null;
            }
            info.add(parameterInfo);
        }
        return info;
    }

    public static boolean isProviderProperty(String name) {
        if (name == null) {
            return false;
        }
        for (ResourceType<?, ?> resourceType : ResourceType.allTypes()) {
            String propertyName = resourceType.getProviderNameProperty();
            if (!name.startsWith(propertyName)) continue;
            if (propertyName.length() == name.length()) {
                return true;
            }
            if (name.length() < propertyName.length() + 2 || name.charAt(propertyName.length()) != '.' || name.charAt(propertyName.length() + 1) == '.') continue;
            return true;
        }
        return false;
    }
}

