/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import oracle.rsi.internal.AbstractIngester;
import oracle.rsi.internal.RSIBuilder;
import oracle.rsi.internal.StagingArea;

class IngesterForNonShardedDatabase
extends AbstractIngester {
    private StagingArea stagingArea = null;

    protected IngesterForNonShardedDatabase(RSIBuilder rSIBuilder) throws Exception {
        super(rSIBuilder);
        this.initDataSource();
        this.initializeStagingArea();
        this.scheduleBufferIntervalTask();
    }

    private void initializeStagingArea() {
        Consumer<List<Object>> consumer = list -> {
            try {
                this.jobsQueuedForExecution.incrementAndGet();
                this.executor.execute(new AbstractIngester.IngestJob(this.dataSource, (List<Object>)list));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                this.handleRejectedExecutionException(list.size(), rejectedExecutionException.getMessage());
            }
        };
        this.stagingArea = new StagingArea(this.maxRowsPerStagingQueue, this.bufferInterval, consumer);
    }

    @Override
    protected void accept(Object object) {
        this.stagingArea.accept(object);
    }

    @Override
    protected void flushItemsIfDue(boolean bl) {
        this.stagingArea.flushIfDue(bl);
    }

    @Override
    protected void cleanup() {
        this.stagingArea.close();
    }
}

