/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Base64;
import oracle.ons.NodeAddress;
import oracle.ons.Notification;
import oracle.ons.ONS;
import oracle.ons.ONSConfiguration;

class WebSocket {
    private static final String OnsWebSockGUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final int OnsWebSockSizeBase = 2;
    private static final int OnsWebSockSizeExtS = 2;
    private static final int OnsWebSockSizeExtL = 8;
    private static final int OnsWebSockSizeMask = 4;
    private static final int OnsWebSockLenLimit = 125;
    private static final int OnsWebSockLenCodeExtS = 126;
    private static final int OnsWebSockLenCodeExtL = 127;
    private static final int OnsWebSockLenExtSLimit = 16383;
    private static final int OnsWebSockCtrl1Fin = 1;
    private static final int OnsWebSockCtrl1Reserved = 14;
    private static final int OnsWebSockCtrl1OpCode = 240;
    private static final int OnsWebSockCtrl2Mask = 1;
    private static final int OnsWebSockCtrl2Len = 254;
    private static final int OnsWebSockOpCodeText = 16;
    private static final int OnsWebSockOpCodeBinary = 32;
    private static final int OnsWebSockShiftLen = 1;
    private static final int OnsWebSockFrameNone = 0;
    private static final int OnsWebSockFrameCtrl1 = 1;
    private static final int OnsWebSockFrameCtrl2 = 2;
    private static final int OnsWebSockFrameExtS1 = 3;
    private static final int OnsWebSockFrameExtS2 = 4;
    private static final int OnsWebSockFrameExtL1 = 5;
    private static final int OnsWebSockFrameExtL2 = 6;
    private static final int OnsWebSockFrameExtL3 = 7;
    private static final int OnsWebSockFrameExtL4 = 8;
    private static final int OnsWebSockFrameExtL5 = 9;
    private static final int OnsWebSockFrameExtL6 = 10;
    private static final int OnsWebSockFrameExtL7 = 11;
    private static final int OnsWebSockFrameExtL8 = 12;
    private static final int OnsWebSockFrameMask1 = 13;
    private static final int OnsWebSockFrameMask2 = 14;
    private static final int OnsWebSockFrameMask3 = 15;
    private static final int OnsWebSockFrameMask4 = 16;
    private static final int OnsWebSockFrameDone = 17;
    private static final int ONS_FNV_1A_OFFSET = -2128831035;
    private static final String ONSOraProxyHost = "(http_proxy=";
    private static final String ONSOraProxyPort = "(http_proxy_port=";
    private static final String ONSOraProxyHostSSL = "(https_proxy=";
    private static final String ONSOraProxyPortSSL = "(https_proxy_port=";
    private static final String ONSOraProtocol = "(protocol=";
    private static final String ONSProtocolSuffix = "://";
    private static int stamp = 0;
    static final int SSLNone = 0;
    static final int SSLTrue = 1;
    static final int SSLFalse = 2;
    final boolean enabled;
    String proxyHostname;
    int proxyPort;
    int proxySSL;
    String key;
    String subjectCN = null;
    private int maskOut = 0;
    private int maskShiftOut = 0;
    private int maskIn = 0;
    private int maskShiftIn = 0;
    private int bytesRemainIn = 0;
    private int framePhaseIn = 0;
    private int frameSizeIn = 0;
    private int frameMaskIn = 0;
    private int frameCtrl1In = 0;
    private int frameCtrl2In = 0;
    int frameAvailIn = 0;

    WebSocket(boolean bl) {
        this.proxyHostname = null;
        this.proxyPort = 0;
        this.proxySSL = 0;
        this.enabled = bl;
        if (bl) {
            this.maskOut = WebSocket.getMask();
        }
    }

    WebSocket(String string) {
        string = string.toLowerCase();
        int n = string.indexOf(40);
        if (n != -1) {
            this.setProxyOra(string);
        } else {
            n = string.indexOf(58);
            if (n != -1) {
                this.setProxyUri(string);
            } else {
                throw new IllegalArgumentException("Unknown syntax: " + string);
            }
        }
        this.enabled = true;
        this.maskOut = WebSocket.getMask();
    }

    private void setProxyOra(String string) {
        String string2;
        int n;
        int n2 = 0;
        int n3 = (string = string.replaceAll("\\s", "")).indexOf(ONSOraProtocol);
        if (n3 != -1) {
            n = string.indexOf(41, n3 += ONSOraProtocol.length());
            if (n == -1) {
                throw new IllegalArgumentException("Invalid protocol syntax");
            }
            string2 = string.substring(n3, n);
            n2 = WebSocket.parseProxyProto(string2);
        }
        this.proxySSL = n2;
        n3 = string.indexOf(ONSOraProxyHost);
        if (n3 == -1) {
            n3 = string.indexOf(ONSOraProxyHostSSL);
            if (n3 == -1) {
                throw new IllegalArgumentException("Missing host");
            }
            n3 += ONSOraProxyHostSSL.length();
        } else {
            n3 += ONSOraProxyHost.length();
        }
        n = string.indexOf(41, n3);
        if (n == -1) {
            throw new IllegalArgumentException("Invalid host syntax");
        }
        this.proxyHostname = string.substring(n3, n);
        n3 = string.indexOf(ONSOraProxyPort);
        if (n3 == -1) {
            n3 = string.indexOf(ONSOraProxyPortSSL);
            if (n3 == -1) {
                throw new IllegalArgumentException("Missing port");
            }
            n3 += ONSOraProxyPortSSL.length();
        } else {
            n3 += ONSOraProxyPort.length();
        }
        n = string.indexOf(41, n3);
        if (n == -1) {
            throw new IllegalArgumentException("Invalid port syntax");
        }
        string2 = string.substring(n3, n);
        try {
            this.proxyPort = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid port value: " + string2 + ": " + ONS.exceptionMsg(numberFormatException));
        }
    }

    private void setProxyUri(String string) {
        int n;
        String string2;
        int n2 = 0;
        int n3 = string.indexOf(ONSProtocolSuffix);
        if (n3 != -1) {
            string2 = string.substring(0, n3);
            n2 = WebSocket.parseProxyProto(string2);
            n = n3 + ONSProtocolSuffix.length();
            n3 = string.indexOf(58, n);
        } else {
            n = 0;
            n3 = string.indexOf(58);
        }
        this.proxySSL = n2;
        if (n3 == -1) {
            throw new IllegalArgumentException("Missing port");
        }
        this.proxyHostname = string.substring(n, n3);
        string2 = string.substring(++n3);
        try {
            this.proxyPort = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid port value: " + string2 + ": " + ONS.exceptionMsg(numberFormatException));
        }
    }

    private static int parseProxyProto(String string) {
        int n = 2;
        if (string.equals("wss") || string.equals("https") || string.equals("tcps")) {
            n = 1;
        } else if (!(string.equals("ws") || string.equals("http") || string.equals("tcp"))) {
            throw new IllegalArgumentException("Invalid protocol value: " + string);
        }
        return n;
    }

    private static int getMask() {
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = 0;
        while ((n2 = (int)(l >>> n & 0xFFFFFFFFFFFFFFFFL)) == 0 && (n += 32) < 64) {
        }
        if (n2 == 0) {
            n2 = 16777619;
        }
        return n2;
    }

    void setSubjectCN(String string) {
        this.subjectCN = string;
    }

    void setMaskOut() {
        this.maskOut *= -2128831035;
    }

    void createKey(NodeAddress nodeAddress) {
        byte[] byArray = new byte[16];
        int n = 0;
        int n2 = nodeAddress.hashCode();
        byArray[n++] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n++] = (byte)(n2 & 0xFF);
        n2 = nodeAddress.hostname.hashCode();
        byArray[n++] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n++] = (byte)(n2 & 0xFF);
        n2 = nodeAddress.websocket.hashCode();
        byArray[n++] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n++] = (byte)(n2 & 0xFF);
        n2 = (int)(System.currentTimeMillis() & 0xFFFFFFFFFFFFFFFFL);
        byArray[n++] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n++] = (byte)(n2 & 0xFF);
        byte[] byArray2 = ONSConfiguration.getSha1Digest(byArray);
        this.key = Base64.getEncoder().encodeToString(byArray2);
    }

    String validateResponse(Notification notification) {
        if (this.key == null) {
            return "no recorded key";
        }
        String string = this.key + OnsWebSockGUID;
        this.key = null;
        byte[] byArray = ONSConfiguration.getSha1Digest(string);
        String string2 = Base64.getEncoder().encodeToString(byArray);
        String string3 = this.validateProp(notification, "Sec-WebSocket-Accept", string2);
        if (string3 != null) {
            return string3;
        }
        try {
            int n = Integer.parseInt(notification.getMethod());
            if (n != 101) {
                return "unexpected GET response: " + notification.getMethod();
            }
        }
        catch (NumberFormatException numberFormatException) {
            return "invalid GET response: " + notification.getMethod();
        }
        string3 = this.validateProp(notification, "Upgrade", "websocket");
        if (string3 != null) {
            return string3;
        }
        return null;
    }

    private String validateProp(Notification notification, String string, String string2) {
        String string3 = notification.get(string);
        if (string3 == null) {
            return "response missing \"" + string + "\"";
        }
        if (!string3.equals(string2)) {
            return "unexpected value for \"" + string + "\": " + string3 + "(" + string2 + ")";
        }
        return null;
    }

    byte[] getFrame(int n) {
        int n2 = 33;
        int n3 = 1;
        int n4 = 6;
        this.maskShiftOut = 0;
        if (n <= 125) {
            n3 |= n << 1 & 0xFE;
        } else if (n <= 16383) {
            n3 |= 0xFC;
            n4 += 2;
        } else {
            n3 |= 0xFE;
            n4 += 8;
        }
        byte[] byArray = new byte[n4];
        int n5 = 0;
        byArray[n5++] = (byte)(n2 & 0xFF);
        byArray[n5++] = (byte)(n3 & 0xFF);
        if (n > 125) {
            if (n <= 16383) {
                byArray[n5++] = (byte)(n >>> 8 & 0xFF);
                byArray[n5++] = (byte)(n & 0xFF);
            } else {
                byArray[n5++] = 0;
                byArray[n5++] = 0;
                byArray[n5++] = 0;
                byArray[n5++] = 0;
                byArray[n5++] = (byte)(n >>> 24 & 0xFF);
                byArray[n5++] = (byte)(n >>> 16 & 0xFF);
                byArray[n5++] = (byte)(n >>> 8 & 0xFF);
                byArray[n5++] = (byte)(n & 0xFF);
            }
        }
        byArray[n5++] = (byte)(this.maskOut >>> 24 & 0xFF);
        byArray[n5++] = (byte)(this.maskOut >>> 16 & 0xFF);
        byArray[n5++] = (byte)(this.maskOut >>> 8 & 0xFF);
        byArray[n5++] = (byte)(this.maskOut & 0xFF);
        return byArray;
    }

    int parseFrame(byte[] byArray, int n, int n2) {
        if (this.framePhaseIn != 17) {
            this.frameAvailIn = 0;
            n = this.parseFrameHeader(byArray, n, n2);
        }
        if (n != n2) {
            int n3 = n2 - n;
            if (n3 >= this.bytesRemainIn) {
                this.frameAvailIn = this.bytesRemainIn;
                this.bytesRemainIn = 0;
                this.framePhaseIn = 0;
            } else {
                this.frameAvailIn = n3;
                this.bytesRemainIn -= n3;
            }
            if (this.maskIn != 0) {
                this.maskShiftIn = WebSocket.applyMask(byArray, n, this.frameAvailIn, this.maskIn, this.maskShiftIn);
            }
        }
        return n;
    }

    private int parseFrameHeader(byte[] byArray, int n, int n2) {
        while (n < n2 && this.framePhaseIn != 17) {
            ++this.framePhaseIn;
            switch (this.framePhaseIn) {
                case 1: {
                    this.maskIn = 0;
                    this.maskShiftIn = 0;
                    this.bytesRemainIn = 0;
                    this.frameSizeIn = 0;
                    this.frameMaskIn = 0;
                    this.frameCtrl1In = byArray[n] & 0xFF;
                    break;
                }
                case 2: {
                    this.frameCtrl2In = byArray[n] & 0xFF;
                    int n3 = this.frameCtrl2In >>> 1 & 0x7F;
                    if (n3 <= 125) {
                        this.frameSizeIn = n3;
                        if ((this.frameCtrl2In & 1) != 0) {
                            this.framePhaseIn = 12;
                            break;
                        }
                        this.framePhaseIn = 16;
                        break;
                    }
                    if (n3 == 126) {
                        this.framePhaseIn = 2;
                        break;
                    }
                    this.framePhaseIn = 4;
                    break;
                }
                case 3: {
                    this.frameSizeIn = byArray[n] << 8 & 0xFF00;
                    break;
                }
                case 4: {
                    this.frameSizeIn |= byArray[n] & 0xFF;
                    if ((this.frameCtrl2In & 1) != 0) {
                        this.framePhaseIn = 12;
                        break;
                    }
                    this.framePhaseIn = 16;
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    this.frameSizeIn = byArray[n] << 24 & 0xFF000000;
                    break;
                }
                case 10: {
                    this.frameSizeIn |= byArray[n] << 16 & 0xFF0000;
                    break;
                }
                case 11: {
                    this.frameSizeIn |= byArray[n] << 8 & 0xFF00;
                    break;
                }
                case 12: {
                    this.frameSizeIn |= byArray[n] & 0xFF;
                    if ((this.frameCtrl2In & 1) != 0) break;
                    this.framePhaseIn = 16;
                    break;
                }
                case 13: {
                    this.frameMaskIn = byArray[n] << 24 & 0xFF000000;
                    break;
                }
                case 14: {
                    this.frameMaskIn |= byArray[n] << 16 & 0xFF0000;
                    break;
                }
                case 15: {
                    this.frameMaskIn |= byArray[n] << 8 & 0xFF00;
                    break;
                }
                case 16: {
                    this.frameMaskIn |= byArray[n] & 0xFF;
                    break;
                }
                case 17: {
                    this.bytesRemainIn = this.frameSizeIn;
                    this.maskIn = this.frameMaskIn;
                    return n;
                }
            }
            ++n;
        }
        return n;
    }

    String putString(String string) {
        long l = Instant.now().getEpochSecond();
        int n = this.hashCode();
        int n2 = WebSocket.getStamp();
        String string2 = String.format("%d%d%x", n2, n, l);
        byte[] byArray = ONSConfiguration.getSha1Digest(string2);
        int n3 = WebSocket.getPadLength(byArray);
        int n4 = WebSocket.getKeyMask(byArray) * -2128831035;
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.putLong(l);
        byte[] byArray2 = byteBuffer.array();
        WebSocket.applyMask(byArray2, 0, 8, n4, 0);
        int n5 = byArray.length + byArray2.length + n3;
        byte[] byArray3 = string.getBytes();
        byte[] byArray4 = new byte[n5 + byArray3.length];
        int n6 = 0;
        System.arraycopy(byArray, 0, byArray4, n6, byArray.length);
        System.arraycopy(byArray2, 0, byArray4, n6 += byArray.length, byArray2.length);
        n6 += byArray2.length;
        if (n3 != 0) {
            byte[] byArray5 = new byte[]{(byte)(l >>> 8 & 0xFFL), (byte)(l >>> 16 & 0xFFL), (byte)(l & 0xFFL), (byte)(l >>> 24 & 0xFFL), (byte)((n *= n2 + 1) >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF)};
            System.arraycopy(byArray5, 0, byArray4, n6, n3);
            n6 += n3;
        }
        System.arraycopy(byArray3, 0, byArray4, n6, byArray3.length);
        WebSocket.extMaskApply(byArray4, n6, byArray4, n5, n3);
        return Base64.getEncoder().encodeToString(byArray4);
    }

    void applyMaskOut(byte[] byArray) {
        this.maskShiftOut = WebSocket.applyMask(byArray, 0, byArray.length, this.maskOut, this.maskShiftOut);
    }

    private static int applyMask(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5 = n4;
        for (int i = n; i < n2; ++i) {
            int n6 = byArray[i] & 0xFF;
            byArray[i] = (byte)((n6 ^= n3 >>> n5 & 0xFF) & 0xFF);
            if ((n5 += 8) <= 24) continue;
            n5 = 0;
        }
        return n5;
    }

    private static int getKeyMask(byte[] byArray) {
        int n = byArray[1] & 0xFF;
        int n2 = byArray[5] & 0xFF;
        int n3 = byArray[6] & 0xFF;
        int n4 = byArray[8] & 0xFF;
        int n5 = byArray[9] & 0xFF;
        int n6 = byArray[14] & 0xFF;
        int n7 = byArray[16] & 0xFF;
        int n8 = byArray[19] & 0xFF;
        return n2 ^ n8 | (n4 ^ n5) << 8 | (n3 ^ n7) << 16 | (n ^ n6) << 24;
    }

    private static int getPadLength(byte[] byArray) {
        int n = byArray[0] & 0xFF;
        int n2 = byArray[12] & 0xFF;
        return (n ^ n2) & 7;
    }

    private static void extMaskApply(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = 0;
        int n5 = n3 + 1;
        for (int i = n; i < byArray.length; ++i) {
            if (++n4 == n2) {
                n4 = 0;
                ++n5;
            }
            if (++n5 >= n2) {
                n5 = 0;
            }
            for (int j = 0; byArray2[n4] == byArray2[n5] && j < n2; ++j) {
                if (++n5 != n2) continue;
                n5 = 0;
            }
            int n6 = (byArray2[n4] ^ byArray2[n5]) & 0xFF;
            int n7 = byArray[i] & 0xFF;
            byArray[i] = (byte)((n7 ^= n6) & 0xFF);
        }
    }

    private static synchronized int getStamp() {
        return ++stamp;
    }

    public int hashCode() {
        if (this.proxyHostname != null) {
            return this.proxyHostname.hashCode() + this.proxyPort * 28952557 + 6263;
        }
        if (this.enabled) {
            return 6263;
        }
        return 0;
    }

    public boolean equals(Object object) {
        WebSocket webSocket;
        WebSocket webSocket2 = webSocket = object instanceof WebSocket ? (WebSocket)object : null;
        if (this == webSocket) {
            return true;
        }
        if (webSocket == null) {
            return false;
        }
        if (this.enabled != webSocket.enabled) {
            return false;
        }
        if (this.proxyHostname == null && webSocket.proxyHostname == null) {
            return true;
        }
        if (this.proxyHostname == null || webSocket.proxyHostname == null) {
            return false;
        }
        return this.proxyPort == webSocket.proxyPort && this.proxyHostname.equals(webSocket.proxyHostname);
    }

    public String toString() {
        if (this.proxyHostname != null) {
            return String.format("%s:%d enabled", this.proxyHostname, this.proxyPort);
        }
        if (this.enabled) {
            return "enabled";
        }
        return "disabled";
    }
}

