/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ua.DSTU4145NamedCurves;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.asymmetric.CustomNamedCurves;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersID;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;

public class ECDomainParametersIndex {
    public static NamedECDomainParameters lookupDomainParameters(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        X9ECParameters x9ECParameters = CustomNamedCurves.getByOID(aSN1ObjectIdentifier);
        if (x9ECParameters == null) {
            x9ECParameters = ECNamedCurveTable.getByOID(aSN1ObjectIdentifier);
        }
        if (x9ECParameters != null) {
            return new NamedECDomainParameters(aSN1ObjectIdentifier, x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
        }
        ECDomainParameters eCDomainParameters = DSTU4145NamedCurves.getByOID(aSN1ObjectIdentifier);
        if (eCDomainParameters != null) {
            return new NamedECDomainParameters(aSN1ObjectIdentifier, eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
        }
        return null;
    }

    public static NamedECDomainParameters lookupDomainParameters(ECDomainParametersID eCDomainParametersID) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        String string = eCDomainParametersID.getCurveName();
        X9ECParameters x9ECParameters = CustomNamedCurves.getByName(string);
        if (x9ECParameters == null) {
            x9ECParameters = ECNamedCurveTable.getByName(string);
        }
        if (x9ECParameters != null && (aSN1ObjectIdentifier = ECNamedCurveTable.getOID(string)) != null) {
            return new NamedECDomainParameters(aSN1ObjectIdentifier, x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
        }
        return null;
    }

    public static ASN1ObjectIdentifier lookupOID(ECDomainParameters eCDomainParameters) {
        Enumeration enumeration = ECNamedCurveTable.getNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            X9ECParameters x9ECParameters = ECNamedCurveTable.getByName(string);
            if (x9ECParameters == null || x9ECParameters.getN() == null || !x9ECParameters.getN().equals(eCDomainParameters.getN())) continue;
            return ECNamedCurveTable.getOID(string);
        }
        return null;
    }
}

