/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene912;

import java.io.IOException;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;

final class ForUtil {
    public static final int BLOCK_SIZE = 128;
    static final int BLOCK_SIZE_LOG2 = 7;
    private final long[] tmp = new long[64];
    static final long[] MASKS8;
    static final long[] MASKS16;
    static final long[] MASKS32;
    static final long MASK8_1;
    static final long MASK8_2;
    static final long MASK8_3;
    static final long MASK8_4;
    static final long MASK8_5;
    static final long MASK8_6;
    static final long MASK8_7;
    static final long MASK16_1;
    static final long MASK16_2;
    static final long MASK16_3;
    static final long MASK16_4;
    static final long MASK16_5;
    static final long MASK16_6;
    static final long MASK16_7;
    static final long MASK16_8;
    static final long MASK16_9;
    static final long MASK16_10;
    static final long MASK16_11;
    static final long MASK16_12;
    static final long MASK16_13;
    static final long MASK16_14;
    static final long MASK16_15;
    static final long MASK32_1;
    static final long MASK32_2;
    static final long MASK32_3;
    static final long MASK32_4;
    static final long MASK32_5;
    static final long MASK32_6;
    static final long MASK32_7;
    static final long MASK32_8;
    static final long MASK32_9;
    static final long MASK32_10;
    static final long MASK32_11;
    static final long MASK32_12;
    static final long MASK32_13;
    static final long MASK32_14;
    static final long MASK32_15;
    static final long MASK32_16;
    static final long MASK32_17;
    static final long MASK32_18;
    static final long MASK32_19;
    static final long MASK32_20;
    static final long MASK32_21;
    static final long MASK32_22;
    static final long MASK32_23;
    static final long MASK32_24;

    ForUtil() {
    }

    static long expandMask32(long mask32) {
        return mask32 | mask32 << 32;
    }

    static long expandMask16(long mask16) {
        return ForUtil.expandMask32(mask16 | mask16 << 16);
    }

    static long expandMask8(long mask8) {
        return ForUtil.expandMask16(mask8 | mask8 << 8);
    }

    static long mask32(int bitsPerValue) {
        return ForUtil.expandMask32((1L << bitsPerValue) - 1L);
    }

    static long mask16(int bitsPerValue) {
        return ForUtil.expandMask16((1L << bitsPerValue) - 1L);
    }

    static long mask8(int bitsPerValue) {
        return ForUtil.expandMask8((1L << bitsPerValue) - 1L);
    }

    static void expand8(long[] arr) {
        for (int i = 0; i < 16; ++i) {
            long l = arr[i];
            arr[i] = l >>> 56 & 0xFFL;
            arr[16 + i] = l >>> 48 & 0xFFL;
            arr[32 + i] = l >>> 40 & 0xFFL;
            arr[48 + i] = l >>> 32 & 0xFFL;
            arr[64 + i] = l >>> 24 & 0xFFL;
            arr[80 + i] = l >>> 16 & 0xFFL;
            arr[96 + i] = l >>> 8 & 0xFFL;
            arr[112 + i] = l & 0xFFL;
        }
    }

    static void collapse8(long[] arr) {
        for (int i = 0; i < 16; ++i) {
            arr[i] = arr[i] << 56 | arr[16 + i] << 48 | arr[32 + i] << 40 | arr[48 + i] << 32 | arr[64 + i] << 24 | arr[80 + i] << 16 | arr[96 + i] << 8 | arr[112 + i];
        }
    }

    static void expand16(long[] arr) {
        for (int i = 0; i < 32; ++i) {
            long l = arr[i];
            arr[i] = l >>> 48 & 0xFFFFL;
            arr[32 + i] = l >>> 32 & 0xFFFFL;
            arr[64 + i] = l >>> 16 & 0xFFFFL;
            arr[96 + i] = l & 0xFFFFL;
        }
    }

    static void collapse16(long[] arr) {
        for (int i = 0; i < 32; ++i) {
            arr[i] = arr[i] << 48 | arr[32 + i] << 32 | arr[64 + i] << 16 | arr[96 + i];
        }
    }

    static void expand32(long[] arr) {
        for (int i = 0; i < 64; ++i) {
            long l = arr[i];
            arr[i] = l >>> 32;
            arr[64 + i] = l & 0xFFFFFFFFL;
        }
    }

    static void collapse32(long[] arr) {
        for (int i = 0; i < 64; ++i) {
            arr[i] = arr[i] << 32 | arr[64 + i];
        }
    }

    void encode(long[] longs, int bitsPerValue, DataOutput out) throws IOException {
        int nextPrimitive;
        if (bitsPerValue <= 8) {
            nextPrimitive = 8;
            ForUtil.collapse8(longs);
        } else if (bitsPerValue <= 16) {
            nextPrimitive = 16;
            ForUtil.collapse16(longs);
        } else {
            nextPrimitive = 32;
            ForUtil.collapse32(longs);
        }
        ForUtil.encode(longs, bitsPerValue, nextPrimitive, out, this.tmp);
    }

    static void encode(long[] longs, int bitsPerValue, int primitiveSize, DataOutput out, long[] tmp) throws IOException {
        int i;
        int numLongs = 128 * primitiveSize / 64;
        int numLongsPerShift = bitsPerValue * 2;
        int idx = 0;
        int shift = primitiveSize - bitsPerValue;
        for (i = 0; i < numLongsPerShift; ++i) {
            tmp[i] = longs[idx++] << shift;
        }
        shift -= bitsPerValue;
        while (shift >= 0) {
            i = 0;
            while (i < numLongsPerShift) {
                int n = i++;
                tmp[n] = tmp[n] | longs[idx++] << shift;
            }
            shift -= bitsPerValue;
        }
        int remainingBitsPerLong = shift + bitsPerValue;
        long maskRemainingBitsPerLong = primitiveSize == 8 ? MASKS8[remainingBitsPerLong] : (primitiveSize == 16 ? MASKS16[remainingBitsPerLong] : MASKS32[remainingBitsPerLong]);
        int tmpIdx = 0;
        int remainingBitsPerValue = bitsPerValue;
        while (idx < numLongs) {
            long mask2;
            long mask1;
            if (remainingBitsPerValue >= remainingBitsPerLong) {
                int n = tmpIdx++;
                tmp[n] = tmp[n] | longs[idx] >>> (remainingBitsPerValue -= remainingBitsPerLong) & maskRemainingBitsPerLong;
                if (remainingBitsPerValue != 0) continue;
                ++idx;
                remainingBitsPerValue = bitsPerValue;
                continue;
            }
            if (primitiveSize == 8) {
                mask1 = MASKS8[remainingBitsPerValue];
                mask2 = MASKS8[remainingBitsPerLong - remainingBitsPerValue];
            } else if (primitiveSize == 16) {
                mask1 = MASKS16[remainingBitsPerValue];
                mask2 = MASKS16[remainingBitsPerLong - remainingBitsPerValue];
            } else {
                mask1 = MASKS32[remainingBitsPerValue];
                mask2 = MASKS32[remainingBitsPerLong - remainingBitsPerValue];
            }
            int n = tmpIdx;
            tmp[n] = tmp[n] | (longs[idx++] & mask1) << remainingBitsPerLong - remainingBitsPerValue;
            remainingBitsPerValue = bitsPerValue - remainingBitsPerLong + remainingBitsPerValue;
            int n2 = tmpIdx++;
            tmp[n2] = tmp[n2] | longs[idx] >>> remainingBitsPerValue & mask2;
        }
        for (int i2 = 0; i2 < numLongsPerShift; ++i2) {
            out.writeLong(tmp[i2]);
        }
    }

    static int numBytes(int bitsPerValue) {
        return bitsPerValue << 4;
    }

    static void decodeSlow(int bitsPerValue, IndexInput in, long[] tmp, long[] longs) throws IOException {
        int numLongs = bitsPerValue << 1;
        long mask = MASKS32[bitsPerValue];
        ForUtil.splitLongs(in, numLongs, longs, 32 - bitsPerValue, 32, mask, tmp, 0, -1L);
        int remainingBitsPerLong = 32 - bitsPerValue;
        long mask32RemainingBitsPerLong = MASKS32[remainingBitsPerLong];
        int tmpIdx = 0;
        int remainingBits = remainingBitsPerLong;
        for (int longsIdx = numLongs; longsIdx < 64; ++longsIdx) {
            int b = bitsPerValue - remainingBits;
            long l = (tmp[tmpIdx++] & MASKS32[remainingBits]) << b;
            while (b >= remainingBitsPerLong) {
                l |= (tmp[tmpIdx++] & mask32RemainingBitsPerLong) << (b -= remainingBitsPerLong);
            }
            if (b > 0) {
                l |= tmp[tmpIdx] >>> remainingBitsPerLong - b & MASKS32[b];
                remainingBits = remainingBitsPerLong - b;
            } else {
                remainingBits = remainingBitsPerLong;
            }
            longs[longsIdx] = l;
        }
    }

    static void splitLongs(IndexInput in, int count, long[] b, int bShift, int dec, long bMask, long[] c, int cIndex, long cMask) throws IOException {
        in.readLongs(c, cIndex, count);
        int maxIter = (bShift - 1) / dec;
        for (int i = 0; i < count; ++i) {
            for (int j = 0; j <= maxIter; ++j) {
                b[count * j + i] = c[cIndex + i] >>> bShift - j * dec & bMask;
            }
            int n = cIndex + i;
            c[n] = c[n] & cMask;
        }
    }

    void decode(int bitsPerValue, IndexInput in, long[] longs) throws IOException {
        switch (bitsPerValue) {
            case 1: {
                ForUtil.decode1(in, longs);
                ForUtil.expand8(longs);
                break;
            }
            case 2: {
                ForUtil.decode2(in, longs);
                ForUtil.expand8(longs);
                break;
            }
            case 3: {
                ForUtil.decode3(in, this.tmp, longs);
                ForUtil.expand8(longs);
                break;
            }
            case 4: {
                ForUtil.decode4(in, longs);
                ForUtil.expand8(longs);
                break;
            }
            case 5: {
                ForUtil.decode5(in, this.tmp, longs);
                ForUtil.expand8(longs);
                break;
            }
            case 6: {
                ForUtil.decode6(in, this.tmp, longs);
                ForUtil.expand8(longs);
                break;
            }
            case 7: {
                ForUtil.decode7(in, this.tmp, longs);
                ForUtil.expand8(longs);
                break;
            }
            case 8: {
                ForUtil.decode8(in, longs);
                ForUtil.expand8(longs);
                break;
            }
            case 9: {
                ForUtil.decode9(in, this.tmp, longs);
                ForUtil.expand16(longs);
                break;
            }
            case 10: {
                ForUtil.decode10(in, this.tmp, longs);
                ForUtil.expand16(longs);
                break;
            }
            case 11: {
                ForUtil.decode11(in, this.tmp, longs);
                ForUtil.expand16(longs);
                break;
            }
            case 12: {
                ForUtil.decode12(in, this.tmp, longs);
                ForUtil.expand16(longs);
                break;
            }
            case 13: {
                ForUtil.decode13(in, this.tmp, longs);
                ForUtil.expand16(longs);
                break;
            }
            case 14: {
                ForUtil.decode14(in, this.tmp, longs);
                ForUtil.expand16(longs);
                break;
            }
            case 15: {
                ForUtil.decode15(in, this.tmp, longs);
                ForUtil.expand16(longs);
                break;
            }
            case 16: {
                ForUtil.decode16(in, longs);
                ForUtil.expand16(longs);
                break;
            }
            case 17: {
                ForUtil.decode17(in, this.tmp, longs);
                ForUtil.expand32(longs);
                break;
            }
            case 18: {
                ForUtil.decode18(in, this.tmp, longs);
                ForUtil.expand32(longs);
                break;
            }
            case 19: {
                ForUtil.decode19(in, this.tmp, longs);
                ForUtil.expand32(longs);
                break;
            }
            case 20: {
                ForUtil.decode20(in, this.tmp, longs);
                ForUtil.expand32(longs);
                break;
            }
            case 21: {
                ForUtil.decode21(in, this.tmp, longs);
                ForUtil.expand32(longs);
                break;
            }
            case 22: {
                ForUtil.decode22(in, this.tmp, longs);
                ForUtil.expand32(longs);
                break;
            }
            case 23: {
                ForUtil.decode23(in, this.tmp, longs);
                ForUtil.expand32(longs);
                break;
            }
            case 24: {
                ForUtil.decode24(in, this.tmp, longs);
                ForUtil.expand32(longs);
                break;
            }
            default: {
                ForUtil.decodeSlow(bitsPerValue, in, this.tmp, longs);
                ForUtil.expand32(longs);
            }
        }
    }

    static void decode1(IndexInput in, long[] longs) throws IOException {
        ForUtil.splitLongs(in, 2, longs, 7, 1, MASK8_1, longs, 14, MASK8_1);
    }

    static void decode2(IndexInput in, long[] longs) throws IOException {
        ForUtil.splitLongs(in, 4, longs, 6, 2, MASK8_2, longs, 12, MASK8_2);
    }

    static void decode3(IndexInput in, long[] tmp, long[] longs) throws IOException {
        ForUtil.splitLongs(in, 6, longs, 5, 3, MASK8_3, tmp, 0, MASK8_2);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 12;
        while (iter < 2) {
            long l0 = tmp[tmpIdx + 0] << 1;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 1 & MASK8_1;
            long l1 = (tmp[tmpIdx + 1] & MASK8_1) << 2;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 2] << 0;
            ++iter;
            tmpIdx += 3;
            longsIdx += 2;
        }
    }

    static void decode4(IndexInput in, long[] longs) throws IOException {
        ForUtil.splitLongs(in, 8, longs, 4, 4, MASK8_4, longs, 8, MASK8_4);
    }

    static void decode5(IndexInput in, long[] tmp, long[] longs) throws IOException {
        ForUtil.splitLongs(in, 10, longs, 3, 5, MASK8_5, tmp, 0, MASK8_3);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 10;
        while (iter < 2) {
            long l0 = tmp[tmpIdx + 0] << 2;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 1 & MASK8_2;
            long l1 = (tmp[tmpIdx + 1] & MASK8_1) << 4;
            l1 |= tmp[tmpIdx + 2] << 1;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 3] >>> 2 & MASK8_1;
            long l2 = (tmp[tmpIdx + 3] & MASK8_2) << 3;
            longs[longsIdx + 2] = l2 |= tmp[tmpIdx + 4] << 0;
            ++iter;
            tmpIdx += 5;
            longsIdx += 3;
        }
    }

    static void decode6(IndexInput in, long[] tmp, long[] longs) throws IOException {
        ForUtil.splitLongs(in, 12, longs, 2, 6, MASK8_6, tmp, 0, MASK8_2);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 12;
        while (iter < 4) {
            long l0 = tmp[tmpIdx + 0] << 4;
            l0 |= tmp[tmpIdx + 1] << 2;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 2] << 0;
            ++iter;
            tmpIdx += 3;
            ++longsIdx;
        }
    }

    static void decode7(IndexInput in, long[] tmp, long[] longs) throws IOException {
        ForUtil.splitLongs(in, 14, longs, 1, 7, MASK8_7, tmp, 0, MASK8_1);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 14;
        while (iter < 2) {
            long l0 = tmp[tmpIdx + 0] << 6;
            l0 |= tmp[tmpIdx + 1] << 5;
            l0 |= tmp[tmpIdx + 2] << 4;
            l0 |= tmp[tmpIdx + 3] << 3;
            l0 |= tmp[tmpIdx + 4] << 2;
            l0 |= tmp[tmpIdx + 5] << 1;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 6] << 0;
            ++iter;
            tmpIdx += 7;
            ++longsIdx;
        }
    }

    static void decode8(IndexInput in, long[] longs) throws IOException {
        in.readLongs(longs, 0, 16);
    }

    static void decode9(IndexInput in, long[] tmp, long[] longs) throws IOException {
        ForUtil.splitLongs(in, 18, longs, 7, 9, MASK16_9, tmp, 0, MASK16_7);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 18;
        while (iter < 2) {
            long l0 = tmp[tmpIdx + 0] << 2;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 5 & MASK16_2;
            long l1 = (tmp[tmpIdx + 1] & MASK16_5) << 4;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 2] >>> 3 & MASK16_4;
            long l2 = (tmp[tmpIdx + 2] & MASK16_3) << 6;
            longs[longsIdx + 2] = l2 |= tmp[tmpIdx + 3] >>> 1 & MASK16_6;
            long l3 = (tmp[tmpIdx + 3] & MASK16_1) << 8;
            l3 |= tmp[tmpIdx + 4] << 1;
            longs[longsIdx + 3] = l3 |= tmp[tmpIdx + 5] >>> 6 & MASK16_1;
            long l4 = (tmp[tmpIdx + 5] & MASK16_6) << 3;
            longs[longsIdx + 4] = l4 |= tmp[tmpIdx + 6] >>> 4 & MASK16_3;
            long l5 = (tmp[tmpIdx + 6] & MASK16_4) << 5;
            longs[longsIdx + 5] = l5 |= tmp[tmpIdx + 7] >>> 2 & MASK16_5;
            long l6 = (tmp[tmpIdx + 7] & MASK16_2) << 7;
            longs[longsIdx + 6] = l6 |= tmp[tmpIdx + 8] << 0;
            ++iter;
            tmpIdx += 9;
            longsIdx += 7;
        }
    }

    static void decode10(IndexInput in, long[] tmp, long[] longs) throws IOException {
        ForUtil.splitLongs(in, 20, longs, 6, 10, MASK16_10, tmp, 0, MASK16_6);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 20;
        while (iter < 4) {
            long l0 = tmp[tmpIdx + 0] << 4;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 2 & MASK16_4;
            long l1 = (tmp[tmpIdx + 1] & MASK16_2) << 8;
            l1 |= tmp[tmpIdx + 2] << 2;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 3] >>> 4 & MASK16_2;
            long l2 = (tmp[tmpIdx + 3] & MASK16_4) << 6;
            longs[longsIdx + 2] = l2 |= tmp[tmpIdx + 4] << 0;
            ++iter;
            tmpIdx += 5;
            longsIdx += 3;
        }
    }

    static void decode11(IndexInput in, long[] tmp, long[] longs) throws IOException {
        ForUtil.splitLongs(in, 22, longs, 5, 11, MASK16_11, tmp, 0, MASK16_5);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 22;
        while (iter < 2) {
            long l0 = tmp[tmpIdx + 0] << 6;
            l0 |= tmp[tmpIdx + 1] << 1;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 2] >>> 4 & MASK16_1;
            long l1 = (tmp[tmpIdx + 2] & MASK16_4) << 7;
            l1 |= tmp[tmpIdx + 3] << 2;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 4] >>> 3 & MASK16_2;
            long l2 = (tmp[tmpIdx + 4] & MASK16_3) << 8;
            l2 |= tmp[tmpIdx + 5] << 3;
            longs[longsIdx + 2] = l2 |= tmp[tmpIdx + 6] >>> 2 & MASK16_3;
            long l3 = (tmp[tmpIdx + 6] & MASK16_2) << 9;
            l3 |= tmp[tmpIdx + 7] << 4;
            longs[longsIdx + 3] = l3 |= tmp[tmpIdx + 8] >>> 1 & MASK16_4;
            long l4 = (tmp[tmpIdx + 8] & MASK16_1) << 10;
            l4 |= tmp[tmpIdx + 9] << 5;
            longs[longsIdx + 4] = l4 |= tmp[tmpIdx + 10] << 0;
            ++iter;
            tmpIdx += 11;
            longsIdx += 5;
        }
    }

    static void decode12(IndexInput in, long[] tmp, long[] longs) throws IOException {
        ForUtil.splitLongs(in, 24, longs, 4, 12, MASK16_12, tmp, 0, MASK16_4);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 24;
        while (iter < 8) {
            long l0 = tmp[tmpIdx + 0] << 8;
            l0 |= tmp[tmpIdx + 1] << 4;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 2] << 0;
            ++iter;
            tmpIdx += 3;
            ++longsIdx;
        }
    }

    static void decode13(IndexInput in, long[] tmp, long[] longs) throws IOException {
        ForUtil.splitLongs(in, 26, longs, 3, 13, MASK16_13, tmp, 0, MASK16_3);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 26;
        while (iter < 2) {
            long l0 = tmp[tmpIdx + 0] << 10;
            l0 |= tmp[tmpIdx + 1] << 7;
            l0 |= tmp[tmpIdx + 2] << 4;
            l0 |= tmp[tmpIdx + 3] << 1;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 4] >>> 2 & MASK16_1;
            long l1 = (tmp[tmpIdx + 4] & MASK16_2) << 11;
            l1 |= tmp[tmpIdx + 5] << 8;
            l1 |= tmp[tmpIdx + 6] << 5;
            l1 |= tmp[tmpIdx + 7] << 2;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 8] >>> 1 & MASK16_2;
            long l2 = (tmp[tmpIdx + 8] & MASK16_1) << 12;
            l2 |= tmp[tmpIdx + 9] << 9;
            l2 |= tmp[tmpIdx + 10] << 6;
            l2 |= tmp[tmpIdx + 11] << 3;
            longs[longsIdx + 2] = l2 |= tmp[tmpIdx + 12] << 0;
            ++iter;
            tmpIdx += 13;
            longsIdx += 3;
        }
    }

    static void decode14(IndexInput in, long[] tmp, long[] longs) throws IOException {
        ForUtil.splitLongs(in, 28, longs, 2, 14, MASK16_14, tmp, 0, MASK16_2);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 28;
        while (iter < 4) {
            long l0 = tmp[tmpIdx + 0] << 12;
            l0 |= tmp[tmpIdx + 1] << 10;
            l0 |= tmp[tmpIdx + 2] << 8;
            l0 |= tmp[tmpIdx + 3] << 6;
            l0 |= tmp[tmpIdx + 4] << 4;
            l0 |= tmp[tmpIdx + 5] << 2;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 6] << 0;
            ++iter;
            tmpIdx += 7;
            ++longsIdx;
        }
    }

    static void decode15(IndexInput in, long[] tmp, long[] longs) throws IOException {
        ForUtil.splitLongs(in, 30, longs, 1, 15, MASK16_15, tmp, 0, MASK16_1);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 30;
        while (iter < 2) {
            long l0 = tmp[tmpIdx + 0] << 14;
            l0 |= tmp[tmpIdx + 1] << 13;
            l0 |= tmp[tmpIdx + 2] << 12;
            l0 |= tmp[tmpIdx + 3] << 11;
            l0 |= tmp[tmpIdx + 4] << 10;
            l0 |= tmp[tmpIdx + 5] << 9;
            l0 |= tmp[tmpIdx + 6] << 8;
            l0 |= tmp[tmpIdx + 7] << 7;
            l0 |= tmp[tmpIdx + 8] << 6;
            l0 |= tmp[tmpIdx + 9] << 5;
            l0 |= tmp[tmpIdx + 10] << 4;
            l0 |= tmp[tmpIdx + 11] << 3;
            l0 |= tmp[tmpIdx + 12] << 2;
            l0 |= tmp[tmpIdx + 13] << 1;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 14] << 0;
            ++iter;
            tmpIdx += 15;
            ++longsIdx;
        }
    }

    static void decode16(IndexInput in, long[] longs) throws IOException {
        in.readLongs(longs, 0, 32);
    }

    static void decode17(IndexInput in, long[] tmp, long[] longs) throws IOException {
        ForUtil.splitLongs(in, 34, longs, 15, 17, MASK32_17, tmp, 0, MASK32_15);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 34;
        while (iter < 2) {
            long l0 = tmp[tmpIdx + 0] << 2;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 13 & MASK32_2;
            long l1 = (tmp[tmpIdx + 1] & MASK32_13) << 4;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 2] >>> 11 & MASK32_4;
            long l2 = (tmp[tmpIdx + 2] & MASK32_11) << 6;
            longs[longsIdx + 2] = l2 |= tmp[tmpIdx + 3] >>> 9 & MASK32_6;
            long l3 = (tmp[tmpIdx + 3] & MASK32_9) << 8;
            longs[longsIdx + 3] = l3 |= tmp[tmpIdx + 4] >>> 7 & MASK32_8;
            long l4 = (tmp[tmpIdx + 4] & MASK32_7) << 10;
            longs[longsIdx + 4] = l4 |= tmp[tmpIdx + 5] >>> 5 & MASK32_10;
            long l5 = (tmp[tmpIdx + 5] & MASK32_5) << 12;
            longs[longsIdx + 5] = l5 |= tmp[tmpIdx + 6] >>> 3 & MASK32_12;
            long l6 = (tmp[tmpIdx + 6] & MASK32_3) << 14;
            longs[longsIdx + 6] = l6 |= tmp[tmpIdx + 7] >>> 1 & MASK32_14;
            long l7 = (tmp[tmpIdx + 7] & MASK32_1) << 16;
            l7 |= tmp[tmpIdx + 8] << 1;
            longs[longsIdx + 7] = l7 |= tmp[tmpIdx + 9] >>> 14 & MASK32_1;
            long l8 = (tmp[tmpIdx + 9] & MASK32_14) << 3;
            longs[longsIdx + 8] = l8 |= tmp[tmpIdx + 10] >>> 12 & MASK32_3;
            long l9 = (tmp[tmpIdx + 10] & MASK32_12) << 5;
            longs[longsIdx + 9] = l9 |= tmp[tmpIdx + 11] >>> 10 & MASK32_5;
            long l10 = (tmp[tmpIdx + 11] & MASK32_10) << 7;
            longs[longsIdx + 10] = l10 |= tmp[tmpIdx + 12] >>> 8 & MASK32_7;
            long l11 = (tmp[tmpIdx + 12] & MASK32_8) << 9;
            longs[longsIdx + 11] = l11 |= tmp[tmpIdx + 13] >>> 6 & MASK32_9;
            long l12 = (tmp[tmpIdx + 13] & MASK32_6) << 11;
            longs[longsIdx + 12] = l12 |= tmp[tmpIdx + 14] >>> 4 & MASK32_11;
            long l13 = (tmp[tmpIdx + 14] & MASK32_4) << 13;
            longs[longsIdx + 13] = l13 |= tmp[tmpIdx + 15] >>> 2 & MASK32_13;
            long l14 = (tmp[tmpIdx + 15] & MASK32_2) << 15;
            longs[longsIdx + 14] = l14 |= tmp[tmpIdx + 16] << 0;
            ++iter;
            tmpIdx += 17;
            longsIdx += 15;
        }
    }

    static void decode18(IndexInput in, long[] tmp, long[] longs) throws IOException {
        ForUtil.splitLongs(in, 36, longs, 14, 18, MASK32_18, tmp, 0, MASK32_14);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 36;
        while (iter < 4) {
            long l0 = tmp[tmpIdx + 0] << 4;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 10 & MASK32_4;
            long l1 = (tmp[tmpIdx + 1] & MASK32_10) << 8;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 2] >>> 6 & MASK32_8;
            long l2 = (tmp[tmpIdx + 2] & MASK32_6) << 12;
            longs[longsIdx + 2] = l2 |= tmp[tmpIdx + 3] >>> 2 & MASK32_12;
            long l3 = (tmp[tmpIdx + 3] & MASK32_2) << 16;
            l3 |= tmp[tmpIdx + 4] << 2;
            longs[longsIdx + 3] = l3 |= tmp[tmpIdx + 5] >>> 12 & MASK32_2;
            long l4 = (tmp[tmpIdx + 5] & MASK32_12) << 6;
            longs[longsIdx + 4] = l4 |= tmp[tmpIdx + 6] >>> 8 & MASK32_6;
            long l5 = (tmp[tmpIdx + 6] & MASK32_8) << 10;
            longs[longsIdx + 5] = l5 |= tmp[tmpIdx + 7] >>> 4 & MASK32_10;
            long l6 = (tmp[tmpIdx + 7] & MASK32_4) << 14;
            longs[longsIdx + 6] = l6 |= tmp[tmpIdx + 8] << 0;
            ++iter;
            tmpIdx += 9;
            longsIdx += 7;
        }
    }

    static void decode19(IndexInput in, long[] tmp, long[] longs) throws IOException {
        ForUtil.splitLongs(in, 38, longs, 13, 19, MASK32_19, tmp, 0, MASK32_13);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 38;
        while (iter < 2) {
            long l0 = tmp[tmpIdx + 0] << 6;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 7 & MASK32_6;
            long l1 = (tmp[tmpIdx + 1] & MASK32_7) << 12;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 2] >>> 1 & MASK32_12;
            long l2 = (tmp[tmpIdx + 2] & MASK32_1) << 18;
            l2 |= tmp[tmpIdx + 3] << 5;
            longs[longsIdx + 2] = l2 |= tmp[tmpIdx + 4] >>> 8 & MASK32_5;
            long l3 = (tmp[tmpIdx + 4] & MASK32_8) << 11;
            longs[longsIdx + 3] = l3 |= tmp[tmpIdx + 5] >>> 2 & MASK32_11;
            long l4 = (tmp[tmpIdx + 5] & MASK32_2) << 17;
            l4 |= tmp[tmpIdx + 6] << 4;
            longs[longsIdx + 4] = l4 |= tmp[tmpIdx + 7] >>> 9 & MASK32_4;
            long l5 = (tmp[tmpIdx + 7] & MASK32_9) << 10;
            longs[longsIdx + 5] = l5 |= tmp[tmpIdx + 8] >>> 3 & MASK32_10;
            long l6 = (tmp[tmpIdx + 8] & MASK32_3) << 16;
            l6 |= tmp[tmpIdx + 9] << 3;
            longs[longsIdx + 6] = l6 |= tmp[tmpIdx + 10] >>> 10 & MASK32_3;
            long l7 = (tmp[tmpIdx + 10] & MASK32_10) << 9;
            longs[longsIdx + 7] = l7 |= tmp[tmpIdx + 11] >>> 4 & MASK32_9;
            long l8 = (tmp[tmpIdx + 11] & MASK32_4) << 15;
            l8 |= tmp[tmpIdx + 12] << 2;
            longs[longsIdx + 8] = l8 |= tmp[tmpIdx + 13] >>> 11 & MASK32_2;
            long l9 = (tmp[tmpIdx + 13] & MASK32_11) << 8;
            longs[longsIdx + 9] = l9 |= tmp[tmpIdx + 14] >>> 5 & MASK32_8;
            long l10 = (tmp[tmpIdx + 14] & MASK32_5) << 14;
            l10 |= tmp[tmpIdx + 15] << 1;
            longs[longsIdx + 10] = l10 |= tmp[tmpIdx + 16] >>> 12 & MASK32_1;
            long l11 = (tmp[tmpIdx + 16] & MASK32_12) << 7;
            longs[longsIdx + 11] = l11 |= tmp[tmpIdx + 17] >>> 6 & MASK32_7;
            long l12 = (tmp[tmpIdx + 17] & MASK32_6) << 13;
            longs[longsIdx + 12] = l12 |= tmp[tmpIdx + 18] << 0;
            ++iter;
            tmpIdx += 19;
            longsIdx += 13;
        }
    }

    static void decode20(IndexInput in, long[] tmp, long[] longs) throws IOException {
        ForUtil.splitLongs(in, 40, longs, 12, 20, MASK32_20, tmp, 0, MASK32_12);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 40;
        while (iter < 8) {
            long l0 = tmp[tmpIdx + 0] << 8;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 4 & MASK32_8;
            long l1 = (tmp[tmpIdx + 1] & MASK32_4) << 16;
            l1 |= tmp[tmpIdx + 2] << 4;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 3] >>> 8 & MASK32_4;
            long l2 = (tmp[tmpIdx + 3] & MASK32_8) << 12;
            longs[longsIdx + 2] = l2 |= tmp[tmpIdx + 4] << 0;
            ++iter;
            tmpIdx += 5;
            longsIdx += 3;
        }
    }

    static void decode21(IndexInput in, long[] tmp, long[] longs) throws IOException {
        ForUtil.splitLongs(in, 42, longs, 11, 21, MASK32_21, tmp, 0, MASK32_11);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 42;
        while (iter < 2) {
            long l0 = tmp[tmpIdx + 0] << 10;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 1 & MASK32_10;
            long l1 = (tmp[tmpIdx + 1] & MASK32_1) << 20;
            l1 |= tmp[tmpIdx + 2] << 9;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 3] >>> 2 & MASK32_9;
            long l2 = (tmp[tmpIdx + 3] & MASK32_2) << 19;
            l2 |= tmp[tmpIdx + 4] << 8;
            longs[longsIdx + 2] = l2 |= tmp[tmpIdx + 5] >>> 3 & MASK32_8;
            long l3 = (tmp[tmpIdx + 5] & MASK32_3) << 18;
            l3 |= tmp[tmpIdx + 6] << 7;
            longs[longsIdx + 3] = l3 |= tmp[tmpIdx + 7] >>> 4 & MASK32_7;
            long l4 = (tmp[tmpIdx + 7] & MASK32_4) << 17;
            l4 |= tmp[tmpIdx + 8] << 6;
            longs[longsIdx + 4] = l4 |= tmp[tmpIdx + 9] >>> 5 & MASK32_6;
            long l5 = (tmp[tmpIdx + 9] & MASK32_5) << 16;
            l5 |= tmp[tmpIdx + 10] << 5;
            longs[longsIdx + 5] = l5 |= tmp[tmpIdx + 11] >>> 6 & MASK32_5;
            long l6 = (tmp[tmpIdx + 11] & MASK32_6) << 15;
            l6 |= tmp[tmpIdx + 12] << 4;
            longs[longsIdx + 6] = l6 |= tmp[tmpIdx + 13] >>> 7 & MASK32_4;
            long l7 = (tmp[tmpIdx + 13] & MASK32_7) << 14;
            l7 |= tmp[tmpIdx + 14] << 3;
            longs[longsIdx + 7] = l7 |= tmp[tmpIdx + 15] >>> 8 & MASK32_3;
            long l8 = (tmp[tmpIdx + 15] & MASK32_8) << 13;
            l8 |= tmp[tmpIdx + 16] << 2;
            longs[longsIdx + 8] = l8 |= tmp[tmpIdx + 17] >>> 9 & MASK32_2;
            long l9 = (tmp[tmpIdx + 17] & MASK32_9) << 12;
            l9 |= tmp[tmpIdx + 18] << 1;
            longs[longsIdx + 9] = l9 |= tmp[tmpIdx + 19] >>> 10 & MASK32_1;
            long l10 = (tmp[tmpIdx + 19] & MASK32_10) << 11;
            longs[longsIdx + 10] = l10 |= tmp[tmpIdx + 20] << 0;
            ++iter;
            tmpIdx += 21;
            longsIdx += 11;
        }
    }

    static void decode22(IndexInput in, long[] tmp, long[] longs) throws IOException {
        ForUtil.splitLongs(in, 44, longs, 10, 22, MASK32_22, tmp, 0, MASK32_10);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 44;
        while (iter < 4) {
            long l0 = tmp[tmpIdx + 0] << 12;
            l0 |= tmp[tmpIdx + 1] << 2;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 2] >>> 8 & MASK32_2;
            long l1 = (tmp[tmpIdx + 2] & MASK32_8) << 14;
            l1 |= tmp[tmpIdx + 3] << 4;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 4] >>> 6 & MASK32_4;
            long l2 = (tmp[tmpIdx + 4] & MASK32_6) << 16;
            l2 |= tmp[tmpIdx + 5] << 6;
            longs[longsIdx + 2] = l2 |= tmp[tmpIdx + 6] >>> 4 & MASK32_6;
            long l3 = (tmp[tmpIdx + 6] & MASK32_4) << 18;
            l3 |= tmp[tmpIdx + 7] << 8;
            longs[longsIdx + 3] = l3 |= tmp[tmpIdx + 8] >>> 2 & MASK32_8;
            long l4 = (tmp[tmpIdx + 8] & MASK32_2) << 20;
            l4 |= tmp[tmpIdx + 9] << 10;
            longs[longsIdx + 4] = l4 |= tmp[tmpIdx + 10] << 0;
            ++iter;
            tmpIdx += 11;
            longsIdx += 5;
        }
    }

    static void decode23(IndexInput in, long[] tmp, long[] longs) throws IOException {
        ForUtil.splitLongs(in, 46, longs, 9, 23, MASK32_23, tmp, 0, MASK32_9);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 46;
        while (iter < 2) {
            long l0 = tmp[tmpIdx + 0] << 14;
            l0 |= tmp[tmpIdx + 1] << 5;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 2] >>> 4 & MASK32_5;
            long l1 = (tmp[tmpIdx + 2] & MASK32_4) << 19;
            l1 |= tmp[tmpIdx + 3] << 10;
            l1 |= tmp[tmpIdx + 4] << 1;
            longs[longsIdx + 1] = l1 |= tmp[tmpIdx + 5] >>> 8 & MASK32_1;
            long l2 = (tmp[tmpIdx + 5] & MASK32_8) << 15;
            l2 |= tmp[tmpIdx + 6] << 6;
            longs[longsIdx + 2] = l2 |= tmp[tmpIdx + 7] >>> 3 & MASK32_6;
            long l3 = (tmp[tmpIdx + 7] & MASK32_3) << 20;
            l3 |= tmp[tmpIdx + 8] << 11;
            l3 |= tmp[tmpIdx + 9] << 2;
            longs[longsIdx + 3] = l3 |= tmp[tmpIdx + 10] >>> 7 & MASK32_2;
            long l4 = (tmp[tmpIdx + 10] & MASK32_7) << 16;
            l4 |= tmp[tmpIdx + 11] << 7;
            longs[longsIdx + 4] = l4 |= tmp[tmpIdx + 12] >>> 2 & MASK32_7;
            long l5 = (tmp[tmpIdx + 12] & MASK32_2) << 21;
            l5 |= tmp[tmpIdx + 13] << 12;
            l5 |= tmp[tmpIdx + 14] << 3;
            longs[longsIdx + 5] = l5 |= tmp[tmpIdx + 15] >>> 6 & MASK32_3;
            long l6 = (tmp[tmpIdx + 15] & MASK32_6) << 17;
            l6 |= tmp[tmpIdx + 16] << 8;
            longs[longsIdx + 6] = l6 |= tmp[tmpIdx + 17] >>> 1 & MASK32_8;
            long l7 = (tmp[tmpIdx + 17] & MASK32_1) << 22;
            l7 |= tmp[tmpIdx + 18] << 13;
            l7 |= tmp[tmpIdx + 19] << 4;
            longs[longsIdx + 7] = l7 |= tmp[tmpIdx + 20] >>> 5 & MASK32_4;
            long l8 = (tmp[tmpIdx + 20] & MASK32_5) << 18;
            l8 |= tmp[tmpIdx + 21] << 9;
            longs[longsIdx + 8] = l8 |= tmp[tmpIdx + 22] << 0;
            ++iter;
            tmpIdx += 23;
            longsIdx += 9;
        }
    }

    static void decode24(IndexInput in, long[] tmp, long[] longs) throws IOException {
        ForUtil.splitLongs(in, 48, longs, 8, 24, MASK32_24, tmp, 0, MASK32_8);
        int iter = 0;
        int tmpIdx = 0;
        int longsIdx = 48;
        while (iter < 16) {
            long l0 = tmp[tmpIdx + 0] << 16;
            l0 |= tmp[tmpIdx + 1] << 8;
            longs[longsIdx + 0] = l0 |= tmp[tmpIdx + 2] << 0;
            ++iter;
            tmpIdx += 3;
            ++longsIdx;
        }
    }

    static {
        int i;
        MASKS8 = new long[8];
        MASKS16 = new long[16];
        MASKS32 = new long[32];
        for (i = 0; i < 8; ++i) {
            ForUtil.MASKS8[i] = ForUtil.mask8(i);
        }
        for (i = 0; i < 16; ++i) {
            ForUtil.MASKS16[i] = ForUtil.mask16(i);
        }
        for (i = 0; i < 32; ++i) {
            ForUtil.MASKS32[i] = ForUtil.mask32(i);
        }
        MASK8_1 = MASKS8[1];
        MASK8_2 = MASKS8[2];
        MASK8_3 = MASKS8[3];
        MASK8_4 = MASKS8[4];
        MASK8_5 = MASKS8[5];
        MASK8_6 = MASKS8[6];
        MASK8_7 = MASKS8[7];
        MASK16_1 = MASKS16[1];
        MASK16_2 = MASKS16[2];
        MASK16_3 = MASKS16[3];
        MASK16_4 = MASKS16[4];
        MASK16_5 = MASKS16[5];
        MASK16_6 = MASKS16[6];
        MASK16_7 = MASKS16[7];
        MASK16_8 = MASKS16[8];
        MASK16_9 = MASKS16[9];
        MASK16_10 = MASKS16[10];
        MASK16_11 = MASKS16[11];
        MASK16_12 = MASKS16[12];
        MASK16_13 = MASKS16[13];
        MASK16_14 = MASKS16[14];
        MASK16_15 = MASKS16[15];
        MASK32_1 = MASKS32[1];
        MASK32_2 = MASKS32[2];
        MASK32_3 = MASKS32[3];
        MASK32_4 = MASKS32[4];
        MASK32_5 = MASKS32[5];
        MASK32_6 = MASKS32[6];
        MASK32_7 = MASKS32[7];
        MASK32_8 = MASKS32[8];
        MASK32_9 = MASKS32[9];
        MASK32_10 = MASKS32[10];
        MASK32_11 = MASKS32[11];
        MASK32_12 = MASKS32[12];
        MASK32_13 = MASKS32[13];
        MASK32_14 = MASKS32[14];
        MASK32_15 = MASKS32[15];
        MASK32_16 = MASKS32[16];
        MASK32_17 = MASKS32[17];
        MASK32_18 = MASKS32[18];
        MASK32_19 = MASKS32[19];
        MASK32_20 = MASKS32[20];
        MASK32_21 = MASKS32[21];
        MASK32_22 = MASKS32[22];
        MASK32_23 = MASKS32[23];
        MASK32_24 = MASKS32[24];
    }
}

