/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.wlm;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.wlm.stats.WlmStats;
import org.opensearch.wlm.stats.WorkloadGroupStats;

@ExperimentalApi
public class WlmStatsResponse
extends BaseNodesResponse<WlmStats>
implements ToXContentFragment {
    WlmStatsResponse(StreamInput in) throws IOException {
        super(in);
    }

    public WlmStatsResponse(ClusterName clusterName, List<WlmStats> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    @Override
    protected List<WlmStats> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(WlmStats::new);
    }

    @Override
    protected void writeNodesTo(StreamOutput out, List<WlmStats> nodes) throws IOException {
        out.writeList(nodes);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (WlmStats wlmStats : this.getNodes()) {
            builder.startObject(wlmStats.getNode().getId());
            WorkloadGroupStats workloadGroupStats = wlmStats.getWorkloadGroupStats();
            workloadGroupStats.toXContent(builder, params);
            builder.endObject();
        }
        return builder;
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return builder.toString();
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }
}

