/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.close;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opensearch.OpenSearchException;
import org.opensearch.action.support.clustermanager.ShardsAcknowledgedResponse;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.index.Index;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public class CloseIndexResponse
extends ShardsAcknowledgedResponse {
    private final List<IndexResult> indices;

    CloseIndexResponse(StreamInput in) throws IOException {
        super(in, true);
        this.indices = Collections.unmodifiableList(in.readList(IndexResult::new));
    }

    public CloseIndexResponse(boolean acknowledged, boolean shardsAcknowledged, List<IndexResult> indices) {
        super(acknowledged, shardsAcknowledged);
        this.indices = Collections.unmodifiableList(Objects.requireNonNull(indices));
    }

    public List<IndexResult> getIndices() {
        return this.indices;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.writeShardsAcknowledged(out);
        out.writeList(this.indices);
    }

    @Override
    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.addCustomFields(builder, params);
        builder.startObject("indices");
        for (IndexResult index : this.indices) {
            index.toXContent(builder, params);
        }
        builder.endObject();
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    @PublicApi(since="1.0.0")
    public static class IndexResult
    implements Writeable,
    ToXContentFragment {
        private final Index index;
        @Nullable
        private final Exception exception;
        @Nullable
        private final ShardResult[] shards;

        public IndexResult(Index index) {
            this(index, null, null);
        }

        public IndexResult(Index index, Exception failure) {
            this(index, Objects.requireNonNull(failure), null);
        }

        public IndexResult(Index index, ShardResult[] shards) {
            this(index, null, Objects.requireNonNull(shards));
        }

        private IndexResult(Index index, @Nullable Exception exception, @Nullable ShardResult[] shards) {
            this.index = Objects.requireNonNull(index);
            this.exception = exception;
            this.shards = shards;
        }

        IndexResult(StreamInput in) throws IOException {
            this.index = new Index(in);
            this.exception = in.readException();
            this.shards = (ShardResult[])in.readOptionalArray(ShardResult::new, ShardResult[]::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.index.writeTo(out);
            out.writeException((Throwable)this.exception);
            out.writeOptionalArray((Writeable[])this.shards);
        }

        public Index getIndex() {
            return this.index;
        }

        public Exception getException() {
            return this.exception;
        }

        public ShardResult[] getShards() {
            return this.shards;
        }

        public boolean hasFailures() {
            if (this.exception != null) {
                return true;
            }
            if (this.shards != null) {
                for (ShardResult shard : this.shards) {
                    if (!shard.hasFailures()) continue;
                    return true;
                }
            }
            return false;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.index.getName());
            if (this.hasFailures()) {
                builder.field("closed", false);
                if (this.exception != null) {
                    builder.startObject("exception");
                    OpenSearchException.generateFailureXContent((XContentBuilder)builder, (ToXContent.Params)params, (Exception)this.exception, (boolean)true);
                    builder.endObject();
                } else {
                    builder.startObject("failedShards");
                    for (ShardResult shard : this.shards) {
                        if (!shard.hasFailures()) continue;
                        shard.toXContent(builder, params);
                    }
                    builder.endObject();
                }
            } else {
                builder.field("closed", true);
            }
            return builder.endObject();
        }

        public String toString() {
            return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
        }
    }

    @PublicApi(since="1.0.0")
    public static class ShardResult
    implements Writeable,
    ToXContentFragment {
        private final int id;
        private final Failure[] failures;

        public ShardResult(int id, Failure[] failures) {
            this.id = id;
            this.failures = failures;
        }

        ShardResult(StreamInput in) throws IOException {
            this.id = in.readVInt();
            this.failures = (Failure[])in.readOptionalArray(Failure::readFailure, Failure[]::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.id);
            out.writeOptionalArray((Writeable[])this.failures);
        }

        public boolean hasFailures() {
            return !CollectionUtils.isEmpty((Object[])this.failures);
        }

        public int getId() {
            return this.id;
        }

        public Failure[] getFailures() {
            return this.failures;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(String.valueOf(this.id));
            builder.startArray("failures");
            if (this.failures != null) {
                for (Failure failure : this.failures) {
                    failure.toXContent(builder, params);
                }
            }
            builder.endArray();
            return builder.endObject();
        }

        public String toString() {
            return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
        }

        @PublicApi(since="1.0.0")
        public static class Failure
        extends DefaultShardOperationFailedException {
            @Nullable
            private String nodeId;

            private Failure(StreamInput in) throws IOException {
                super(in);
                this.nodeId = in.readOptionalString();
            }

            public Failure(String index, int shardId, Throwable reason) {
                this(index, shardId, reason, null);
            }

            public Failure(String index, int shardId, Throwable reason, String nodeId) {
                super(index, shardId, reason);
                this.nodeId = nodeId;
            }

            public String getNodeId() {
                return this.nodeId;
            }

            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
                out.writeOptionalString(this.nodeId);
            }

            public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                if (this.nodeId != null) {
                    builder.field("node", this.nodeId);
                }
                return super.innerToXContent(builder, params);
            }

            public String toString() {
                return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
            }

            static Failure readFailure(StreamInput in) throws IOException {
                return new Failure(in);
            }
        }
    }
}

