/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.pipeline;

import java.util.List;
import org.opensearch.search.pipeline.Pipeline;
import org.opensearch.search.pipeline.SearchPhaseResultsProcessor;
import org.opensearch.search.pipeline.SearchRequestProcessor;
import org.opensearch.search.pipeline.SearchResponseProcessor;
import org.opensearch.search.pipeline.SystemGeneratedPipelineHolder;

public class ProcessorConflictEvaluationContext {
    private final List<SearchRequestProcessor> userDefinedSearchRequestProcessors;
    private final List<SearchResponseProcessor> userDefinedSearchResponseProcessors;
    private final List<SearchPhaseResultsProcessor> userDefinedSearchPhaseResultsProcessors;
    private final List<SearchRequestProcessor> systemGeneratedPreSearchRequestProcessors;
    private final List<SearchResponseProcessor> systemGeneratedPreSearchResponseProcessors;
    private final List<SearchPhaseResultsProcessor> systemGeneratedPreSearchPhaseResultsProcessors;
    private final List<SearchRequestProcessor> systemGeneratedPostSearchRequestProcessors;
    private final List<SearchResponseProcessor> systemGeneratedPostSearchResponseProcessors;
    private final List<SearchPhaseResultsProcessor> systemGeneratedPostSearchPhaseResultsProcessors;

    ProcessorConflictEvaluationContext(Pipeline userDefinedPipeline, SystemGeneratedPipelineHolder systemGeneratedPipelineHolder) {
        this.userDefinedSearchRequestProcessors = userDefinedPipeline.getSearchRequestProcessors();
        this.userDefinedSearchResponseProcessors = userDefinedPipeline.getSearchResponseProcessors();
        this.userDefinedSearchPhaseResultsProcessors = userDefinedPipeline.getSearchPhaseResultsProcessors();
        this.systemGeneratedPreSearchRequestProcessors = systemGeneratedPipelineHolder.prePipeline().getSearchRequestProcessors();
        this.systemGeneratedPreSearchResponseProcessors = systemGeneratedPipelineHolder.prePipeline().getSearchResponseProcessors();
        this.systemGeneratedPreSearchPhaseResultsProcessors = systemGeneratedPipelineHolder.prePipeline().getSearchPhaseResultsProcessors();
        this.systemGeneratedPostSearchRequestProcessors = systemGeneratedPipelineHolder.postPipeline().getSearchRequestProcessors();
        this.systemGeneratedPostSearchResponseProcessors = systemGeneratedPipelineHolder.postPipeline().getSearchResponseProcessors();
        this.systemGeneratedPostSearchPhaseResultsProcessors = systemGeneratedPipelineHolder.postPipeline().getSearchPhaseResultsProcessors();
    }

    public List<SearchRequestProcessor> getUserDefinedSearchRequestProcessors() {
        return this.userDefinedSearchRequestProcessors;
    }

    public List<SearchResponseProcessor> getUserDefinedSearchResponseProcessors() {
        return this.userDefinedSearchResponseProcessors;
    }

    public List<SearchPhaseResultsProcessor> getUserDefinedSearchPhaseResultsProcessors() {
        return this.userDefinedSearchPhaseResultsProcessors;
    }

    public List<SearchRequestProcessor> getSystemGeneratedPreSearchRequestProcessors() {
        return this.systemGeneratedPreSearchRequestProcessors;
    }

    public List<SearchResponseProcessor> getSystemGeneratedPreSearchResponseProcessors() {
        return this.systemGeneratedPreSearchResponseProcessors;
    }

    public List<SearchPhaseResultsProcessor> getSystemGeneratedPreSearchPhaseResultsProcessors() {
        return this.systemGeneratedPreSearchPhaseResultsProcessors;
    }

    public List<SearchRequestProcessor> getSystemGeneratedPostSearchRequestProcessors() {
        return this.systemGeneratedPostSearchRequestProcessors;
    }

    public List<SearchResponseProcessor> getSystemGeneratedPostSearchResponseProcessors() {
        return this.systemGeneratedPostSearchResponseProcessors;
    }

    public List<SearchPhaseResultsProcessor> getSystemGeneratedPostSearchPhaseResultsProcessors() {
        return this.systemGeneratedPostSearchPhaseResultsProcessors;
    }
}

