/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.InvalidWrappingException;
import org.bouncycastle.crypto.KeyUnwrapper;
import org.bouncycastle.crypto.KeyWrapOperatorFactory;
import org.bouncycastle.crypto.KeyWrapper;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.PlainInputProcessingException;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsKeyWrapOperatorFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.ParametersCreatorProvider;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class BaseWrapCipher
extends CipherSpi {
    private final BouncyCastleFipsProvider fipsProvider;
    private AlgorithmParameters engineParams = null;
    private final Map<Algorithm, Parameters> baseParametersMap;
    private Algorithm algorithm;
    private FipsKeyWrapOperatorFactory fipsKeyWrapOperatorFactory;
    private KeyWrapOperatorFactory generalKeyWrapOperatorFactory;
    private ParametersCreatorProvider fipsParametersProvider;
    private ParametersCreatorProvider generalParametersProvider;
    private Class[] availableSpecs;
    private int keySizeInBits;
    private Parameters wrapParameters;
    private KeyWrapper keyWrapper;
    private KeyUnwrapper keyUnwrapper;
    private ErasableOutputStream wrapStream = null;

    private BaseWrapCipher(BouncyCastleFipsProvider bouncyCastleFipsProvider, Map<Algorithm, Parameters> map, Algorithm algorithm, FipsKeyWrapOperatorFactory fipsKeyWrapOperatorFactory, KeyWrapOperatorFactory keyWrapOperatorFactory, Class[] classArray, ParametersCreatorProvider parametersCreatorProvider, ParametersCreatorProvider parametersCreatorProvider2, int n) {
        this.fipsProvider = bouncyCastleFipsProvider;
        this.baseParametersMap = map;
        this.algorithm = algorithm;
        this.fipsKeyWrapOperatorFactory = fipsKeyWrapOperatorFactory;
        this.generalKeyWrapOperatorFactory = keyWrapOperatorFactory;
        this.availableSpecs = classArray;
        this.fipsParametersProvider = parametersCreatorProvider;
        this.generalParametersProvider = parametersCreatorProvider2;
        this.keySizeInBits = n;
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected byte[] engineGetIV() {
        if (this.wrapParameters instanceof ParametersWithIV) {
            return ((ParametersWithIV)this.wrapParameters).getIV();
        }
        return null;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        return key.getEncoded().length * 8;
    }

    @Override
    protected int engineGetOutputSize(int n) {
        return -1;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        ParametersWithIV parametersWithIV;
        if (this.wrapParameters instanceof ParametersWithIV && (parametersWithIV = (ParametersWithIV)this.wrapParameters).getIV() != null) {
            String string = Utils.getBaseName(this.wrapParameters.getAlgorithm());
            try {
                this.engineParams = AlgorithmParameters.getInstance(string, this.fipsProvider);
                this.engineParams.init(new DEROctetString(parametersWithIV.getIV()).getEncoded());
                return this.engineParams;
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception.toString(), exception);
            }
        }
        return null;
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Cannot support mode " + string);
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        throw new NoSuchPaddingException("Padding " + string + " unknown");
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        ParametersCreator parametersCreator = this.algorithm instanceof FipsAlgorithm ? this.fipsParametersProvider.get(this.baseParametersMap.get(this.algorithm)) : this.generalParametersProvider.get(this.baseParametersMap.get(this.algorithm));
        SymmetricSecretKey symmetricSecretKey = new SymmetricSecretKey(this.algorithm, key.getEncoded());
        if (this.keySizeInBits != 0 && Utils.keyNotLength(symmetricSecretKey, this.keySizeInBits)) {
            throw new InvalidKeyException("Cipher requires key of size " + this.keySizeInBits + " bits");
        }
        if (secureRandom == null) {
            secureRandom = this.fipsProvider.getDefaultSecureRandom();
        }
        this.wrapStream = null;
        try {
            switch (n) {
                case 1: {
                    this.wrapStream = new ErasableOutputStream();
                }
                case 3: {
                    this.wrapParameters = parametersCreator.createParameters(true, algorithmParameterSpec, secureRandom);
                    this.keyWrapper = this.algorithm instanceof FipsAlgorithm ? this.fipsKeyWrapOperatorFactory.createKeyWrapper(symmetricSecretKey, this.wrapParameters) : this.generalKeyWrapOperatorFactory.createKeyWrapper(symmetricSecretKey, this.wrapParameters);
                    this.keyWrapper = Utils.addRandomIfNeeded(this.keyWrapper, secureRandom);
                    this.keyUnwrapper = null;
                    break;
                }
                case 2: {
                    this.wrapStream = new ErasableOutputStream();
                }
                case 4: {
                    this.wrapParameters = parametersCreator.createParameters(false, algorithmParameterSpec, secureRandom);
                    this.keyUnwrapper = this.algorithm instanceof FipsAlgorithm ? this.fipsKeyWrapOperatorFactory.createKeyUnwrapper(symmetricSecretKey, this.wrapParameters) : this.generalKeyWrapOperatorFactory.createKeyUnwrapper(symmetricSecretKey, this.wrapParameters);
                    this.keyUnwrapper = Utils.addRandomIfNeeded(this.keyUnwrapper, secureRandom);
                    this.keyWrapper = null;
                    break;
                }
                default: {
                    throw new InvalidParameterException("Unknown mode parameter passed to init.");
                }
            }
        }
        catch (InvalidParameterException invalidParameterException) {
            throw invalidParameterException;
        }
        catch (IllegalKeyException illegalKeyException) {
            throw new InvalidKeyException(illegalKeyException.getMessage(), illegalKeyException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidAlgorithmParameterException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (Exception exception) {
            throw new InvalidKeyException(exception.getMessage(), exception);
        }
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (algorithmParameters != null) {
            for (int i = 0; i != this.availableSpecs.length; ++i) {
                try {
                    algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(this.availableSpecs[i]);
                    break;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (algorithmParameterSpec == null) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + algorithmParameters.toString());
            }
        }
        this.engineParams = algorithmParameters;
        this.engineInit(n, key, algorithmParameterSpec, secureRandom);
    }

    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        if (this.wrapStream == null) {
            throw new IllegalStateException("not supported in a wrapping mode");
        }
        this.wrapStream.write(byArray, n, n2);
        return null;
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        if (this.wrapStream == null) {
            throw new IllegalStateException("not supported in a wrapping mode");
        }
        this.wrapStream.write(byArray, n, n2);
        return 0;
    }

    /*
     * Loose catch block
     */
    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        if (this.wrapStream == null) {
            throw new IllegalStateException("not supported in a wrapping mode");
        }
        if (byArray != null) {
            this.wrapStream.write(byArray, n, n2);
        }
        if (this.keyWrapper != null) {
            try {
                byte[] byArray2 = this.keyWrapper.wrap(this.wrapStream.getBuf(), 0, this.wrapStream.size());
                return byArray2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalBlockSizeException(illegalArgumentException.getMessage());
            }
            catch (PlainInputProcessingException plainInputProcessingException) {
                throw new BadPaddingException(plainInputProcessingException.getMessage());
            }
        }
        byte[] byArray3 = this.keyUnwrapper.unwrap(this.wrapStream.getBuf(), 0, this.wrapStream.size());
        return byArray3;
        catch (InvalidWrappingException invalidWrappingException) {
            throw new BadPaddingException(invalidWrappingException.getMessage());
        }
        finally {
            this.wrapStream.erase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        if (this.wrapStream == null) {
            throw new IllegalStateException("not supported in a wrapping mode");
        }
        this.wrapStream.write(byArray, n, n2);
        try {
            byte[] byArray3;
            if (this.keyWrapper != null) {
                try {
                    byArray3 = this.keyWrapper.wrap(this.wrapStream.getBuf(), 0, this.wrapStream.size());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalBlockSizeException(illegalArgumentException.getMessage());
                }
                catch (PlainInputProcessingException plainInputProcessingException) {
                    throw new BadPaddingException(plainInputProcessingException.getMessage());
                }
            }
            try {
                byArray3 = this.keyUnwrapper.unwrap(this.wrapStream.getBuf(), 0, this.wrapStream.size());
            }
            catch (InvalidWrappingException invalidWrappingException) {
                throw new BadPaddingException(invalidWrappingException.getMessage());
            }
            if (n3 + byArray3.length > byArray2.length) {
                throw new ShortBufferException("output buffer too short for input.");
            }
            System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
            int n4 = byArray3.length;
            return n4;
        }
        finally {
            this.wrapStream.erase();
        }
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("Cannot wrap key, null encoding.");
        }
        try {
            return this.keyWrapper.wrap(byArray, 0, byArray.length);
        }
        catch (PlainInputProcessingException plainInputProcessingException) {
            throw new IllegalBlockSizeException(plainInputProcessingException.getMessage());
        }
    }

    @Override
    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray2;
        try {
            byArray2 = this.keyUnwrapper.unwrap(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw new InvalidKeyException(exception.getMessage(), exception.getCause());
        }
        return BaseWrapCipher.rebuildKey(string, n, byArray2, this.fipsProvider);
    }

    static Key rebuildKey(String string, int n, byte[] byArray, BouncyCastleFipsProvider bouncyCastleFipsProvider) throws InvalidKeyException, NoSuchAlgorithmException {
        if (n == 3) {
            return new SecretKeySpec(byArray, string);
        }
        if (n == 2) {
            try {
                if (string == null || string.equals("")) {
                    PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance(byArray);
                    PrivateKey privateKey = bouncyCastleFipsProvider.getPrivateKey(privateKeyInfo);
                    if (privateKey != null) {
                        return privateKey;
                    }
                    throw new InvalidKeyException("Algorithm " + privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm() + " not supported");
                }
                KeyFactory keyFactory = KeyFactory.getInstance(string, bouncyCastleFipsProvider);
                return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray));
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Invalid private key encoding: " + exception.getMessage(), exception);
            }
        }
        try {
            if (string == null || string.equals("")) {
                SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(byArray);
                PublicKey publicKey = bouncyCastleFipsProvider.getPublicKey(subjectPublicKeyInfo);
                if (publicKey != null) {
                    return publicKey;
                }
                throw new InvalidKeyException("Algorithm " + subjectPublicKeyInfo.getAlgorithm().getAlgorithm() + " not supported");
            }
            KeyFactory keyFactory = KeyFactory.getInstance(string, bouncyCastleFipsProvider);
            return keyFactory.generatePublic(new X509EncodedKeySpec(byArray));
        }
        catch (Exception exception) {
            throw new InvalidKeyException("Invalid private key encoding: " + exception.getMessage(), exception);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected static final class ErasableOutputStream
    extends ByteArrayOutputStream {
        public byte[] getBuf() {
            return this.buf;
        }

        public void erase() {
            Arrays.fill(this.buf, (byte)0);
            this.reset();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class Builder {
        private final BouncyCastleFipsProvider fipsProvider;
        private final Algorithm[] algorithms;
        private final Map<Algorithm, Parameters> baseParametersMap;
        private FipsKeyWrapOperatorFactory fipsFactory;
        private KeyWrapOperatorFactory generalFactory;
        private Class[] availableSpecs;
        private int keySizeInBits;
        private ParametersCreatorProvider fipsParametersProvider;
        private ParametersCreatorProvider generalParametersProvider;

        Builder(BouncyCastleFipsProvider bouncyCastleFipsProvider, Algorithm ... algorithmArray) {
            this.fipsProvider = bouncyCastleFipsProvider;
            this.algorithms = algorithmArray;
            this.baseParametersMap = null;
        }

        Builder(BouncyCastleFipsProvider bouncyCastleFipsProvider, Parameters ... parametersArray) {
            this.fipsProvider = bouncyCastleFipsProvider;
            this.baseParametersMap = new HashMap<Algorithm, Parameters>(parametersArray.length);
            this.algorithms = new Algorithm[parametersArray.length];
            for (int i = 0; i != parametersArray.length; ++i) {
                this.baseParametersMap.put(parametersArray[i].getAlgorithm(), parametersArray[i]);
                this.algorithms[i] = parametersArray[i].getAlgorithm();
            }
        }

        Builder withFixedKeySize(int n) {
            this.keySizeInBits = n;
            return this;
        }

        Builder withFipsOperators(ParametersCreatorProvider parametersCreatorProvider, FipsKeyWrapOperatorFactory fipsKeyWrapOperatorFactory) {
            this.fipsParametersProvider = parametersCreatorProvider;
            this.fipsFactory = fipsKeyWrapOperatorFactory;
            return this;
        }

        Builder withGeneralOperators(ParametersCreatorProvider parametersCreatorProvider, KeyWrapOperatorFactory keyWrapOperatorFactory) {
            this.generalParametersProvider = parametersCreatorProvider;
            this.generalFactory = keyWrapOperatorFactory;
            return this;
        }

        Builder withParameters(Class[] classArray) {
            this.availableSpecs = classArray;
            return this;
        }

        BaseWrapCipher build() {
            boolean bl = CryptoServicesRegistrar.isInApprovedOnlyMode();
            if (!bl) {
                return new BaseWrapCipher(this.fipsProvider, this.baseParametersMap, this.algorithms[0], this.fipsFactory, this.generalFactory, this.availableSpecs, this.fipsParametersProvider, this.generalParametersProvider, this.keySizeInBits);
            }
            Set<Algorithm> set = Utils.getActiveSet(this.algorithms);
            if (set.isEmpty()) {
                return null;
            }
            return new BaseWrapCipher(this.fipsProvider, this.baseParametersMap, set.toArray(new Algorithm[set.size()])[0], this.fipsFactory, this.generalFactory, this.availableSpecs, this.fipsParametersProvider, this.generalParametersProvider, this.keySizeInBits);
        }
    }
}

