/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.data.model;

import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import lombok.Generated;
import org.opensearch.sql.data.model.AbstractExprValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.ExpressionEvaluationException;

public class ExprIntervalValue
extends AbstractExprValue {
    private final TemporalAmount interval;

    @Override
    public TemporalAmount intervalValue() {
        return this.interval;
    }

    @Override
    public int compare(ExprValue other) {
        TemporalAmount otherInterval = other.intervalValue();
        if (!this.interval.getClass().equals(other.intervalValue().getClass())) {
            throw new ExpressionEvaluationException(String.format("invalid to compare intervals with units %s and %s", this.unit(), ((ExprIntervalValue)other).unit()));
        }
        return Long.compare(this.interval.get(this.unit()), otherInterval.get(((ExprIntervalValue)other).unit()));
    }

    @Override
    public boolean equal(ExprValue other) {
        return this.interval.equals(other.intervalValue());
    }

    @Override
    public TemporalAmount value() {
        return this.interval;
    }

    @Override
    public ExprType type() {
        return ExprCoreType.INTERVAL;
    }

    public TemporalUnit unit() {
        return this.interval.getUnits().stream().filter(v -> this.interval.get((TemporalUnit)v) != 0L).findAny().orElse(this.interval.getUnits().get(0));
    }

    @Generated
    public ExprIntervalValue(TemporalAmount interval) {
        this.interval = interval;
    }
}

