/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast;

import java.time.Instant;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.forecast.ExecuteForecastResultResponseRecorder;
import org.opensearch.forecast.indices.ForecastIndex;
import org.opensearch.forecast.indices.ForecastIndexManagement;
import org.opensearch.forecast.model.ForecastResult;
import org.opensearch.forecast.model.ForecastTask;
import org.opensearch.forecast.model.ForecastTaskType;
import org.opensearch.forecast.rest.handler.ForecastIndexJobActionHandler;
import org.opensearch.forecast.settings.ForecastSettings;
import org.opensearch.forecast.task.ForecastTaskManager;
import org.opensearch.forecast.transport.ForecastProfileAction;
import org.opensearch.forecast.transport.ForecastResultAction;
import org.opensearch.forecast.transport.ForecastResultRequest;
import org.opensearch.jobscheduler.spi.LockModel;
import org.opensearch.jobscheduler.spi.utils.LockService;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.JobProcessor;
import org.opensearch.timeseries.common.exception.EndRunException;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.Job;
import org.opensearch.timeseries.task.TaskCacheManager;
import org.opensearch.timeseries.transport.ResultRequest;

public class ForecastJobProcessor
extends JobProcessor<ForecastIndex, ForecastIndexManagement, TaskCacheManager, ForecastTaskType, ForecastTask, ForecastTaskManager, ForecastResult, ForecastProfileAction, ExecuteForecastResultResponseRecorder, ForecastIndexJobActionHandler> {
    private static final Logger log = LogManager.getLogger(ForecastJobProcessor.class);
    private static ForecastJobProcessor INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ForecastJobProcessor getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        Class<ForecastJobProcessor> clazz = ForecastJobProcessor.class;
        synchronized (ForecastJobProcessor.class) {
            if (INSTANCE != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
            INSTANCE = new ForecastJobProcessor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private ForecastJobProcessor() {
        super(AnalysisType.FORECAST, "forecast-threadpool", ForecastResultAction.INSTANCE);
    }

    public void registerSettings(Settings settings) {
        super.registerSettings(settings, ForecastSettings.FORECAST_MAX_RETRY_FOR_END_RUN_EXCEPTION);
    }

    @Override
    protected ResultRequest createResultRequest(String configId, long start, long end) {
        return new ForecastResultRequest(configId, start, end);
    }

    @Override
    protected void validateResultIndexAndRunJob(Job jobParameter, LockService lockService, LockModel lock, Instant executionStartTime, Instant executionEndTime, String configId, String user, List<String> roles, ExecuteForecastResultResponseRecorder recorder, Config detector) {
        ActionListener listener = ActionListener.wrap(r -> log.debug("Result index is valid"), e -> {
            EndRunException exception = new EndRunException(configId, e.getMessage(), false);
            this.handleException(jobParameter, lockService, lock, executionStartTime, executionEndTime, exception, recorder, detector);
        });
        String resultIndex = jobParameter.getCustomResultIndexOrAlias();
        if (resultIndex == null) {
            ((ForecastIndexManagement)this.indexManagement).validateDefaultResultIndexForBackendJob(configId, user, roles, () -> {
                listener.onResponse((Object)true);
                this.runJob(jobParameter, lockService, lock, executionStartTime, executionEndTime, configId, user, roles, recorder, detector);
            }, listener);
        } else {
            ((ForecastIndexManagement)this.indexManagement).validateCustomIndexForBackendJob(resultIndex, configId, user, roles, () -> {
                listener.onResponse((Object)true);
                this.runJob(jobParameter, lockService, lock, executionStartTime, executionEndTime, configId, user, roles, recorder, detector);
            }, listener);
        }
    }
}

