/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.ratelimit;

import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.breaker.CircuitBreakerService;
import org.opensearch.timeseries.ratelimit.CheckpointMaintainRequest;
import org.opensearch.timeseries.ratelimit.CheckpointWriteRequest;
import org.opensearch.timeseries.ratelimit.RateLimitedRequestWorker;
import org.opensearch.timeseries.ratelimit.ScheduledWorker;

public abstract class CheckpointMaintainWorker
extends ScheduledWorker<CheckpointMaintainRequest, CheckpointWriteRequest> {
    private Function<CheckpointMaintainRequest, Optional<CheckpointWriteRequest>> converter;

    public CheckpointMaintainWorker(String workerName, long heapSizeInBytes, int singleRequestSizeInBytes, Setting<Float> maxHeapPercentForQueueSetting, ClusterService clusterService, Random random, CircuitBreakerService adCircuitBreakerService, ThreadPool threadPool, String threadPoolName, Settings settings, float maxQueuedTaskRatio, Clock clock, float mediumSegmentPruneRatio, float lowSegmentPruneRatio, int maintenanceFreqConstant, RateLimitedRequestWorker<CheckpointWriteRequest> targetQueue, Duration stateTtl, NodeStateManager nodeStateManager, Function<CheckpointMaintainRequest, Optional<CheckpointWriteRequest>> converter, AnalysisType context) {
        super(workerName, heapSizeInBytes, singleRequestSizeInBytes, maxHeapPercentForQueueSetting, clusterService, random, adCircuitBreakerService, threadPool, threadPoolName, settings, maxQueuedTaskRatio, clock, mediumSegmentPruneRatio, lowSegmentPruneRatio, maintenanceFreqConstant, targetQueue, stateTtl, nodeStateManager, context);
        this.converter = converter;
    }

    @Override
    protected List<CheckpointWriteRequest> transformRequests(List<CheckpointMaintainRequest> requests) {
        ArrayList<CheckpointWriteRequest> allRequests = new ArrayList<CheckpointWriteRequest>();
        for (CheckpointMaintainRequest request : requests) {
            Optional<CheckpointWriteRequest> converted = this.converter.apply(request);
            if (converted.isEmpty()) continue;
            allRequests.add(converted.get());
        }
        return allRequests;
    }
}

