/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.NeuronDeviceInfo;
import software.amazon.awssdk.services.ec2.model.NeuronDeviceInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NeuronInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NeuronInfo> {
    private static final SdkField<List<NeuronDeviceInfo>> NEURON_DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NeuronDevices").getter(NeuronInfo.getter(NeuronInfo::neuronDevices)).setter(NeuronInfo.setter(Builder::neuronDevices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NeuronDevices").unmarshallLocationName("neuronDevices").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NeuronDeviceInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> TOTAL_NEURON_DEVICE_MEMORY_IN_MIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalNeuronDeviceMemoryInMiB").getter(NeuronInfo.getter(NeuronInfo::totalNeuronDeviceMemoryInMiB)).setter(NeuronInfo.setter(Builder::totalNeuronDeviceMemoryInMiB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNeuronDeviceMemoryInMiB").unmarshallLocationName("totalNeuronDeviceMemoryInMiB").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEURON_DEVICES_FIELD, TOTAL_NEURON_DEVICE_MEMORY_IN_MIB_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NeuronInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<NeuronDeviceInfo> neuronDevices;
    private final Integer totalNeuronDeviceMemoryInMiB;

    private NeuronInfo(BuilderImpl builder) {
        this.neuronDevices = builder.neuronDevices;
        this.totalNeuronDeviceMemoryInMiB = builder.totalNeuronDeviceMemoryInMiB;
    }

    public final boolean hasNeuronDevices() {
        return this.neuronDevices != null && !(this.neuronDevices instanceof SdkAutoConstructList);
    }

    public final List<NeuronDeviceInfo> neuronDevices() {
        return this.neuronDevices;
    }

    public final Integer totalNeuronDeviceMemoryInMiB() {
        return this.totalNeuronDeviceMemoryInMiB;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNeuronDevices() ? this.neuronDevices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalNeuronDeviceMemoryInMiB());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NeuronInfo)) {
            return false;
        }
        NeuronInfo other = (NeuronInfo)obj;
        return this.hasNeuronDevices() == other.hasNeuronDevices() && Objects.equals(this.neuronDevices(), other.neuronDevices()) && Objects.equals(this.totalNeuronDeviceMemoryInMiB(), other.totalNeuronDeviceMemoryInMiB());
    }

    public final String toString() {
        return ToString.builder((String)"NeuronInfo").add("NeuronDevices", this.hasNeuronDevices() ? this.neuronDevices() : null).add("TotalNeuronDeviceMemoryInMiB", (Object)this.totalNeuronDeviceMemoryInMiB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NeuronDevices": {
                return Optional.ofNullable(clazz.cast(this.neuronDevices()));
            }
            case "TotalNeuronDeviceMemoryInMiB": {
                return Optional.ofNullable(clazz.cast(this.totalNeuronDeviceMemoryInMiB()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NeuronDevices", NEURON_DEVICES_FIELD);
        map.put("TotalNeuronDeviceMemoryInMiB", TOTAL_NEURON_DEVICE_MEMORY_IN_MIB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NeuronInfo, T> g) {
        return obj -> g.apply((NeuronInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<NeuronDeviceInfo> neuronDevices = DefaultSdkAutoConstructList.getInstance();
        private Integer totalNeuronDeviceMemoryInMiB;

        private BuilderImpl() {
        }

        private BuilderImpl(NeuronInfo model) {
            this.neuronDevices(model.neuronDevices);
            this.totalNeuronDeviceMemoryInMiB(model.totalNeuronDeviceMemoryInMiB);
        }

        public final List<NeuronDeviceInfo.Builder> getNeuronDevices() {
            List<NeuronDeviceInfo.Builder> result = NeuronDeviceInfoListCopier.copyToBuilder(this.neuronDevices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNeuronDevices(Collection<NeuronDeviceInfo.BuilderImpl> neuronDevices) {
            this.neuronDevices = NeuronDeviceInfoListCopier.copyFromBuilder(neuronDevices);
        }

        @Override
        public final Builder neuronDevices(Collection<NeuronDeviceInfo> neuronDevices) {
            this.neuronDevices = NeuronDeviceInfoListCopier.copy(neuronDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder neuronDevices(NeuronDeviceInfo ... neuronDevices) {
            this.neuronDevices(Arrays.asList(neuronDevices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder neuronDevices(Consumer<NeuronDeviceInfo.Builder> ... neuronDevices) {
            this.neuronDevices(Stream.of(neuronDevices).map(c -> (NeuronDeviceInfo)((NeuronDeviceInfo.Builder)NeuronDeviceInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalNeuronDeviceMemoryInMiB() {
            return this.totalNeuronDeviceMemoryInMiB;
        }

        public final void setTotalNeuronDeviceMemoryInMiB(Integer totalNeuronDeviceMemoryInMiB) {
            this.totalNeuronDeviceMemoryInMiB = totalNeuronDeviceMemoryInMiB;
        }

        @Override
        public final Builder totalNeuronDeviceMemoryInMiB(Integer totalNeuronDeviceMemoryInMiB) {
            this.totalNeuronDeviceMemoryInMiB = totalNeuronDeviceMemoryInMiB;
            return this;
        }

        public NeuronInfo build() {
            return new NeuronInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NeuronInfo> {
        public Builder neuronDevices(Collection<NeuronDeviceInfo> var1);

        public Builder neuronDevices(NeuronDeviceInfo ... var1);

        public Builder neuronDevices(Consumer<NeuronDeviceInfo.Builder> ... var1);

        public Builder totalNeuronDeviceMemoryInMiB(Integer var1);
    }
}

