/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableAssociation;
import software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableAssociationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTransitGatewayPolicyTableAssociationsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetTransitGatewayPolicyTableAssociationsResponse> {
    private static final SdkField<List<TransitGatewayPolicyTableAssociation>> ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Associations").getter(GetTransitGatewayPolicyTableAssociationsResponse.getter(GetTransitGatewayPolicyTableAssociationsResponse::associations)).setter(GetTransitGatewayPolicyTableAssociationsResponse.setter(Builder::associations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Associations").unmarshallLocationName("associations").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransitGatewayPolicyTableAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetTransitGatewayPolicyTableAssociationsResponse.getter(GetTransitGatewayPolicyTableAssociationsResponse::nextToken)).setter(GetTransitGatewayPolicyTableAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTransitGatewayPolicyTableAssociationsResponse.memberNameToFieldInitializer();
    private final List<TransitGatewayPolicyTableAssociation> associations;
    private final String nextToken;

    private GetTransitGatewayPolicyTableAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.associations = builder.associations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssociations() {
        return this.associations != null && !(this.associations instanceof SdkAutoConstructList);
    }

    public final List<TransitGatewayPolicyTableAssociation> associations() {
        return this.associations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociations() ? this.associations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTransitGatewayPolicyTableAssociationsResponse)) {
            return false;
        }
        GetTransitGatewayPolicyTableAssociationsResponse other = (GetTransitGatewayPolicyTableAssociationsResponse)((Object)obj);
        return this.hasAssociations() == other.hasAssociations() && Objects.equals(this.associations(), other.associations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetTransitGatewayPolicyTableAssociationsResponse").add("Associations", this.hasAssociations() ? this.associations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Associations": {
                return Optional.ofNullable(clazz.cast(this.associations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Associations", ASSOCIATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTransitGatewayPolicyTableAssociationsResponse, T> g) {
        return obj -> g.apply((GetTransitGatewayPolicyTableAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<TransitGatewayPolicyTableAssociation> associations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTransitGatewayPolicyTableAssociationsResponse model) {
            super(model);
            this.associations(model.associations);
            this.nextToken(model.nextToken);
        }

        public final List<TransitGatewayPolicyTableAssociation.Builder> getAssociations() {
            List<TransitGatewayPolicyTableAssociation.Builder> result = TransitGatewayPolicyTableAssociationListCopier.copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociations(Collection<TransitGatewayPolicyTableAssociation.BuilderImpl> associations) {
            this.associations = TransitGatewayPolicyTableAssociationListCopier.copyFromBuilder(associations);
        }

        @Override
        public final Builder associations(Collection<TransitGatewayPolicyTableAssociation> associations) {
            this.associations = TransitGatewayPolicyTableAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(TransitGatewayPolicyTableAssociation ... associations) {
            this.associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<TransitGatewayPolicyTableAssociation.Builder> ... associations) {
            this.associations(Stream.of(associations).map(c -> (TransitGatewayPolicyTableAssociation)((TransitGatewayPolicyTableAssociation.Builder)TransitGatewayPolicyTableAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetTransitGatewayPolicyTableAssociationsResponse build() {
            return new GetTransitGatewayPolicyTableAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTransitGatewayPolicyTableAssociationsResponse> {
        public Builder associations(Collection<TransitGatewayPolicyTableAssociation> var1);

        public Builder associations(TransitGatewayPolicyTableAssociation ... var1);

        public Builder associations(Consumer<TransitGatewayPolicyTableAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

