/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.KNN9120Codec;

import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.lucene.codecs.lucene99.Lucene99HnswScalarQuantizedVectorsFormat;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsFormat;
import org.opensearch.common.collect.Tuple;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.codec.BasePerFieldKnnVectorsFormat;
import org.opensearch.knn.index.codec.KNN9120Codec.KNN9120HnswBinaryVectorsFormat;
import org.opensearch.knn.index.codec.nativeindex.NativeIndexBuildStrategyFactory;
import org.opensearch.knn.index.engine.KNNEngine;

public class KNN9120PerFieldKnnVectorsFormat
extends BasePerFieldKnnVectorsFormat {
    private static final Tuple<Integer, ExecutorService> DEFAULT_MERGE_THREAD_COUNT_AND_EXECUTOR_SERVICE = Tuple.tuple((Object)1, null);

    public KNN9120PerFieldKnnVectorsFormat(Optional<MapperService> mapperService) {
        this(mapperService, new NativeIndexBuildStrategyFactory());
    }

    public KNN9120PerFieldKnnVectorsFormat(Optional<MapperService> mapperService, NativeIndexBuildStrategyFactory nativeIndexBuildStrategyFactory) {
        super(mapperService, 16, 100, Lucene99HnswVectorsFormat::new, knnVectorsFormatParams -> {
            Tuple<Integer, ExecutorService> mergeThreadCountAndExecutorService = KNN9120PerFieldKnnVectorsFormat.getMergeThreadCountAndExecutorService();
            if (knnVectorsFormatParams.getSpaceType() == SpaceType.HAMMING) {
                return new KNN9120HnswBinaryVectorsFormat(knnVectorsFormatParams.getMaxConnections(), knnVectorsFormatParams.getBeamWidth(), (Integer)mergeThreadCountAndExecutorService.v1(), (ExecutorService)mergeThreadCountAndExecutorService.v2());
            }
            return new Lucene99HnswVectorsFormat(knnVectorsFormatParams.getMaxConnections(), knnVectorsFormatParams.getBeamWidth(), ((Integer)mergeThreadCountAndExecutorService.v1()).intValue(), (ExecutorService)mergeThreadCountAndExecutorService.v2());
        }, knnScalarQuantizedVectorsFormatParams -> {
            Tuple<Integer, ExecutorService> mergeThreadCountAndExecutorService = KNN9120PerFieldKnnVectorsFormat.getMergeThreadCountAndExecutorService();
            return new Lucene99HnswScalarQuantizedVectorsFormat(knnScalarQuantizedVectorsFormatParams.getMaxConnections(), knnScalarQuantizedVectorsFormatParams.getBeamWidth(), ((Integer)mergeThreadCountAndExecutorService.v1()).intValue(), knnScalarQuantizedVectorsFormatParams.getBits(), knnScalarQuantizedVectorsFormatParams.isCompressFlag(), knnScalarQuantizedVectorsFormatParams.getConfidenceInterval(), (ExecutorService)mergeThreadCountAndExecutorService.v2());
        }, nativeIndexBuildStrategyFactory);
    }

    @Override
    public int getMaxDimensions(String fieldName) {
        return KNNEngine.getMaxDimensionByEngine(KNNEngine.LUCENE);
    }

    private static Tuple<Integer, ExecutorService> getMergeThreadCountAndExecutorService() {
        int mergeThreadCount = KNNSettings.getIndexThreadQty();
        if (mergeThreadCount <= 1) {
            return DEFAULT_MERGE_THREAD_COUNT_AND_EXECUTOR_SERVICE;
        }
        return Tuple.tuple((Object)mergeThreadCount, (Object)Executors.newFixedThreadPool(mergeThreadCount));
    }
}

