/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.quantization.factory;

import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.opensearch.knn.quantization.factory.QuantizerRegistrar;
import org.opensearch.knn.quantization.factory.QuantizerRegistry;
import org.opensearch.knn.quantization.models.quantizationParams.QuantizationParams;
import org.opensearch.knn.quantization.quantizer.Quantizer;

public final class QuantizerFactory {
    private static final AtomicBoolean isRegistered = new AtomicBoolean(false);

    public static <P extends QuantizationParams, T, R> Quantizer<T, R> getQuantizer(P params) {
        if (params == null) {
            throw new IllegalArgumentException("Quantization parameters must not be null.");
        }
        QuantizerFactory.ensureRegistered();
        return QuantizerRegistry.getQuantizer(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void ensureRegistered() {
        if (isRegistered.get()) return;
        Class<QuantizerFactory> clazz = QuantizerFactory.class;
        synchronized (QuantizerFactory.class) {
            if (isRegistered.get()) return;
            QuantizerRegistrar.registerDefaultQuantizers();
            isRegistered.set(true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Generated
    private QuantizerFactory() {
    }
}

