/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.highlight.batch.config;

import java.util.Locale;
import lombok.Generated;
import org.opensearch.ml.common.FunctionName;

public class HighlightConfig {
    private final String fieldName;
    private final String modelId;
    private final String queryText;
    private final String preTag;
    private final String postTag;
    private final boolean batchInference;
    private final int maxBatchSize;
    private final String validationError;
    private final FunctionName modelType;

    public boolean isValid() {
        return this.validationError == null && this.fieldName != null && this.modelId != null && this.queryText != null && this.validateBatchInference() == null;
    }

    public boolean hasRequiredFields() {
        return this.fieldName != null && this.modelId != null && this.queryText != null;
    }

    public boolean modelSupportsBatchInference() {
        return this.modelType == FunctionName.REMOTE;
    }

    public String validateBatchInference() {
        if (this.batchInference && this.modelType != null && !this.modelSupportsBatchInference()) {
            return String.format(Locale.ROOT, "Model [%s] with type [%s] does not support batch inference. Batch inference is only supported for REMOTE models. Please set 'batch_inference' to false or use a remote model.", this.modelId, this.modelType);
        }
        return null;
    }

    public boolean isInvalid() {
        return this.validationError != null;
    }

    public static HighlightConfig invalid(String errorMessage) {
        return HighlightConfig.builder().validationError(errorMessage).build();
    }

    public static HighlightConfig empty() {
        return HighlightConfig.builder().validationError("No semantic highlight field found").build();
    }

    @Generated
    private static String $default$preTag() {
        return "<em>";
    }

    @Generated
    private static String $default$postTag() {
        return "</em>";
    }

    @Generated
    private static boolean $default$batchInference() {
        return false;
    }

    @Generated
    private static int $default$maxBatchSize() {
        return 100;
    }

    @Generated
    HighlightConfig(String fieldName, String modelId, String queryText, String preTag, String postTag, boolean batchInference, int maxBatchSize, String validationError, FunctionName modelType) {
        this.fieldName = fieldName;
        this.modelId = modelId;
        this.queryText = queryText;
        this.preTag = preTag;
        this.postTag = postTag;
        this.batchInference = batchInference;
        this.maxBatchSize = maxBatchSize;
        this.validationError = validationError;
        this.modelType = modelType;
    }

    @Generated
    public static HighlightConfigBuilder builder() {
        return new HighlightConfigBuilder();
    }

    @Generated
    public HighlightConfigBuilder toBuilder() {
        return new HighlightConfigBuilder().fieldName(this.fieldName).modelId(this.modelId).queryText(this.queryText).preTag(this.preTag).postTag(this.postTag).batchInference(this.batchInference).maxBatchSize(this.maxBatchSize).validationError(this.validationError).modelType(this.modelType);
    }

    @Generated
    public String getFieldName() {
        return this.fieldName;
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public String getQueryText() {
        return this.queryText;
    }

    @Generated
    public String getPreTag() {
        return this.preTag;
    }

    @Generated
    public String getPostTag() {
        return this.postTag;
    }

    @Generated
    public boolean isBatchInference() {
        return this.batchInference;
    }

    @Generated
    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    @Generated
    public String getValidationError() {
        return this.validationError;
    }

    @Generated
    public FunctionName getModelType() {
        return this.modelType;
    }

    @Generated
    public HighlightConfig withValidationError(String validationError) {
        return this.validationError == validationError ? this : new HighlightConfig(this.fieldName, this.modelId, this.queryText, this.preTag, this.postTag, this.batchInference, this.maxBatchSize, validationError, this.modelType);
    }

    @Generated
    public HighlightConfig withModelType(FunctionName modelType) {
        return this.modelType == modelType ? this : new HighlightConfig(this.fieldName, this.modelId, this.queryText, this.preTag, this.postTag, this.batchInference, this.maxBatchSize, this.validationError, modelType);
    }

    @Generated
    public static class HighlightConfigBuilder {
        @Generated
        private String fieldName;
        @Generated
        private String modelId;
        @Generated
        private String queryText;
        @Generated
        private boolean preTag$set;
        @Generated
        private String preTag$value;
        @Generated
        private boolean postTag$set;
        @Generated
        private String postTag$value;
        @Generated
        private boolean batchInference$set;
        @Generated
        private boolean batchInference$value;
        @Generated
        private boolean maxBatchSize$set;
        @Generated
        private int maxBatchSize$value;
        @Generated
        private String validationError;
        @Generated
        private FunctionName modelType;

        @Generated
        HighlightConfigBuilder() {
        }

        @Generated
        public HighlightConfigBuilder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        @Generated
        public HighlightConfigBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Generated
        public HighlightConfigBuilder queryText(String queryText) {
            this.queryText = queryText;
            return this;
        }

        @Generated
        public HighlightConfigBuilder preTag(String preTag) {
            this.preTag$value = preTag;
            this.preTag$set = true;
            return this;
        }

        @Generated
        public HighlightConfigBuilder postTag(String postTag) {
            this.postTag$value = postTag;
            this.postTag$set = true;
            return this;
        }

        @Generated
        public HighlightConfigBuilder batchInference(boolean batchInference) {
            this.batchInference$value = batchInference;
            this.batchInference$set = true;
            return this;
        }

        @Generated
        public HighlightConfigBuilder maxBatchSize(int maxBatchSize) {
            this.maxBatchSize$value = maxBatchSize;
            this.maxBatchSize$set = true;
            return this;
        }

        @Generated
        public HighlightConfigBuilder validationError(String validationError) {
            this.validationError = validationError;
            return this;
        }

        @Generated
        public HighlightConfigBuilder modelType(FunctionName modelType) {
            this.modelType = modelType;
            return this;
        }

        @Generated
        public HighlightConfig build() {
            String preTag$value = this.preTag$value;
            if (!this.preTag$set) {
                preTag$value = HighlightConfig.$default$preTag();
            }
            String postTag$value = this.postTag$value;
            if (!this.postTag$set) {
                postTag$value = HighlightConfig.$default$postTag();
            }
            boolean batchInference$value = this.batchInference$value;
            if (!this.batchInference$set) {
                batchInference$value = HighlightConfig.$default$batchInference();
            }
            int maxBatchSize$value = this.maxBatchSize$value;
            if (!this.maxBatchSize$set) {
                maxBatchSize$value = HighlightConfig.$default$maxBatchSize();
            }
            return new HighlightConfig(this.fieldName, this.modelId, this.queryText, preTag$value, postTag$value, batchInference$value, maxBatchSize$value, this.validationError, this.modelType);
        }

        @Generated
        public String toString() {
            return "HighlightConfig.HighlightConfigBuilder(fieldName=" + this.fieldName + ", modelId=" + this.modelId + ", queryText=" + this.queryText + ", preTag$value=" + this.preTag$value + ", postTag$value=" + this.postTag$value + ", batchInference$value=" + this.batchInference$value + ", maxBatchSize$value=" + this.maxBatchSize$value + ", validationError=" + this.validationError + ", modelType=" + String.valueOf(this.modelType) + ")";
        }
    }
}

