/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.mapper.dto;

import java.util.Map;
import lombok.Generated;
import org.opensearch.neuralsearch.mapper.dto.ChunkingConfig;
import org.opensearch.neuralsearch.mapper.dto.SparseEncodingConfig;

public class SemanticParameters {
    private final String modelId;
    private final String searchModelId;
    private final String rawFieldType;
    private final String semanticInfoFieldName;
    private final ChunkingConfig chunkingConfig;
    private final String semanticFieldSearchAnalyzer;
    private final Map<String, Object> denseEmbeddingConfig;
    private final SparseEncodingConfig sparseEncodingConfig;
    private final Boolean skipExistingEmbedding;

    public boolean isChunkingEnabled() {
        if (this.chunkingConfig == null) {
            return false;
        }
        return this.chunkingConfig.isEnabled();
    }

    @Generated
    SemanticParameters(String modelId, String searchModelId, String rawFieldType, String semanticInfoFieldName, ChunkingConfig chunkingConfig, String semanticFieldSearchAnalyzer, Map<String, Object> denseEmbeddingConfig, SparseEncodingConfig sparseEncodingConfig, Boolean skipExistingEmbedding) {
        this.modelId = modelId;
        this.searchModelId = searchModelId;
        this.rawFieldType = rawFieldType;
        this.semanticInfoFieldName = semanticInfoFieldName;
        this.chunkingConfig = chunkingConfig;
        this.semanticFieldSearchAnalyzer = semanticFieldSearchAnalyzer;
        this.denseEmbeddingConfig = denseEmbeddingConfig;
        this.sparseEncodingConfig = sparseEncodingConfig;
        this.skipExistingEmbedding = skipExistingEmbedding;
    }

    @Generated
    public static SemanticParametersBuilder builder() {
        return new SemanticParametersBuilder();
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public String getSearchModelId() {
        return this.searchModelId;
    }

    @Generated
    public String getRawFieldType() {
        return this.rawFieldType;
    }

    @Generated
    public String getSemanticInfoFieldName() {
        return this.semanticInfoFieldName;
    }

    @Generated
    public ChunkingConfig getChunkingConfig() {
        return this.chunkingConfig;
    }

    @Generated
    public String getSemanticFieldSearchAnalyzer() {
        return this.semanticFieldSearchAnalyzer;
    }

    @Generated
    public Map<String, Object> getDenseEmbeddingConfig() {
        return this.denseEmbeddingConfig;
    }

    @Generated
    public SparseEncodingConfig getSparseEncodingConfig() {
        return this.sparseEncodingConfig;
    }

    @Generated
    public Boolean getSkipExistingEmbedding() {
        return this.skipExistingEmbedding;
    }

    @Generated
    public static class SemanticParametersBuilder {
        @Generated
        private String modelId;
        @Generated
        private String searchModelId;
        @Generated
        private String rawFieldType;
        @Generated
        private String semanticInfoFieldName;
        @Generated
        private ChunkingConfig chunkingConfig;
        @Generated
        private String semanticFieldSearchAnalyzer;
        @Generated
        private Map<String, Object> denseEmbeddingConfig;
        @Generated
        private SparseEncodingConfig sparseEncodingConfig;
        @Generated
        private Boolean skipExistingEmbedding;

        @Generated
        SemanticParametersBuilder() {
        }

        @Generated
        public SemanticParametersBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Generated
        public SemanticParametersBuilder searchModelId(String searchModelId) {
            this.searchModelId = searchModelId;
            return this;
        }

        @Generated
        public SemanticParametersBuilder rawFieldType(String rawFieldType) {
            this.rawFieldType = rawFieldType;
            return this;
        }

        @Generated
        public SemanticParametersBuilder semanticInfoFieldName(String semanticInfoFieldName) {
            this.semanticInfoFieldName = semanticInfoFieldName;
            return this;
        }

        @Generated
        public SemanticParametersBuilder chunkingConfig(ChunkingConfig chunkingConfig) {
            this.chunkingConfig = chunkingConfig;
            return this;
        }

        @Generated
        public SemanticParametersBuilder semanticFieldSearchAnalyzer(String semanticFieldSearchAnalyzer) {
            this.semanticFieldSearchAnalyzer = semanticFieldSearchAnalyzer;
            return this;
        }

        @Generated
        public SemanticParametersBuilder denseEmbeddingConfig(Map<String, Object> denseEmbeddingConfig) {
            this.denseEmbeddingConfig = denseEmbeddingConfig;
            return this;
        }

        @Generated
        public SemanticParametersBuilder sparseEncodingConfig(SparseEncodingConfig sparseEncodingConfig) {
            this.sparseEncodingConfig = sparseEncodingConfig;
            return this;
        }

        @Generated
        public SemanticParametersBuilder skipExistingEmbedding(Boolean skipExistingEmbedding) {
            this.skipExistingEmbedding = skipExistingEmbedding;
            return this;
        }

        @Generated
        public SemanticParameters build() {
            return new SemanticParameters(this.modelId, this.searchModelId, this.rawFieldType, this.semanticInfoFieldName, this.chunkingConfig, this.semanticFieldSearchAnalyzer, this.denseEmbeddingConfig, this.sparseEncodingConfig, this.skipExistingEmbedding);
        }

        @Generated
        public String toString() {
            return "SemanticParameters.SemanticParametersBuilder(modelId=" + this.modelId + ", searchModelId=" + this.searchModelId + ", rawFieldType=" + this.rawFieldType + ", semanticInfoFieldName=" + this.semanticInfoFieldName + ", chunkingConfig=" + String.valueOf(this.chunkingConfig) + ", semanticFieldSearchAnalyzer=" + this.semanticFieldSearchAnalyzer + ", denseEmbeddingConfig=" + String.valueOf(this.denseEmbeddingConfig) + ", sparseEncodingConfig=" + String.valueOf(this.sparseEncodingConfig) + ", skipExistingEmbedding=" + this.skipExistingEmbedding + ")";
        }
    }
}

