/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.DelimitedPayloadEncoding;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class DelimitedPayloadTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant,
ToCopyableBuilder<Builder, DelimitedPayloadTokenFilter> {
    @Nullable
    private final String delimiter;
    @Nullable
    private final DelimitedPayloadEncoding encoding;
    public static final JsonpDeserializer<DelimitedPayloadTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DelimitedPayloadTokenFilter::setupDelimitedPayloadTokenFilterDeserializer);

    private DelimitedPayloadTokenFilter(Builder builder) {
        super(builder);
        this.delimiter = builder.delimiter;
        this.encoding = builder.encoding;
    }

    public static DelimitedPayloadTokenFilter of(Function<Builder, ObjectBuilder<DelimitedPayloadTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.DelimitedPayload;
    }

    @Nullable
    public final String delimiter() {
        return this.delimiter;
    }

    @Nullable
    public final DelimitedPayloadEncoding encoding() {
        return this.encoding;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "delimited_payload");
        super.serializeInternal(generator, mapper);
        if (this.delimiter != null) {
            generator.writeKey("delimiter");
            generator.write(this.delimiter);
        }
        if (this.encoding != null) {
            generator.writeKey("encoding");
            this.encoding.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupDelimitedPayloadTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        DelimitedPayloadTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::delimiter, JsonpDeserializer.stringDeserializer(), "delimiter");
        op.add(Builder::encoding, DelimitedPayloadEncoding._DESERIALIZER, "encoding");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.delimiter);
        result = 31 * result + Objects.hashCode(this.encoding);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelimitedPayloadTokenFilter other = (DelimitedPayloadTokenFilter)o;
        return Objects.equals(this.delimiter, other.delimiter) && Objects.equals(this.encoding, other.encoding);
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, DelimitedPayloadTokenFilter> {
        @Nullable
        private String delimiter;
        @Nullable
        private DelimitedPayloadEncoding encoding;

        public Builder() {
        }

        private Builder(DelimitedPayloadTokenFilter o) {
            super(o);
            this.delimiter = o.delimiter;
            this.encoding = o.encoding;
        }

        private Builder(Builder o) {
            super(o);
            this.delimiter = o.delimiter;
            this.encoding = o.encoding;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder delimiter(@Nullable String value) {
            this.delimiter = value;
            return this;
        }

        @Nonnull
        public final Builder encoding(@Nullable DelimitedPayloadEncoding value) {
            this.encoding = value;
            return this;
        }

        @Override
        @Nonnull
        public DelimitedPayloadTokenFilter build() {
            this._checkSingleUse();
            return new DelimitedPayloadTokenFilter(this);
        }
    }
}

