/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.CharFilterBase;
import org.opensearch.client.opensearch._types.analysis.CharFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.CharFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class PatternReplaceCharFilter
extends CharFilterBase
implements CharFilterDefinitionVariant,
ToCopyableBuilder<Builder, PatternReplaceCharFilter> {
    @Nullable
    private final String flags;
    @Nonnull
    private final String pattern;
    @Nullable
    private final String replacement;
    public static final JsonpDeserializer<PatternReplaceCharFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PatternReplaceCharFilter::setupPatternReplaceCharFilterDeserializer);

    private PatternReplaceCharFilter(Builder builder) {
        super(builder);
        this.flags = builder.flags;
        this.pattern = ApiTypeHelper.requireNonNull(builder.pattern, this, "pattern");
        this.replacement = builder.replacement;
    }

    public static PatternReplaceCharFilter of(Function<Builder, ObjectBuilder<PatternReplaceCharFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public CharFilterDefinition.Kind _charFilterDefinitionKind() {
        return CharFilterDefinition.Kind.PatternReplace;
    }

    @Nullable
    public final String flags() {
        return this.flags;
    }

    @Nonnull
    public final String pattern() {
        return this.pattern;
    }

    @Nullable
    public final String replacement() {
        return this.replacement;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "pattern_replace");
        super.serializeInternal(generator, mapper);
        if (this.flags != null) {
            generator.writeKey("flags");
            generator.write(this.flags);
        }
        generator.writeKey("pattern");
        generator.write(this.pattern);
        if (this.replacement != null) {
            generator.writeKey("replacement");
            generator.write(this.replacement);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPatternReplaceCharFilterDeserializer(ObjectDeserializer<Builder> op) {
        PatternReplaceCharFilter.setupCharFilterBaseDeserializer(op);
        op.add(Builder::flags, JsonpDeserializer.stringDeserializer(), "flags");
        op.add(Builder::pattern, JsonpDeserializer.stringDeserializer(), "pattern");
        op.add(Builder::replacement, JsonpDeserializer.stringDeserializer(), "replacement");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.flags);
        result = 31 * result + this.pattern.hashCode();
        result = 31 * result + Objects.hashCode(this.replacement);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternReplaceCharFilter other = (PatternReplaceCharFilter)o;
        return Objects.equals(this.flags, other.flags) && this.pattern.equals(other.pattern) && Objects.equals(this.replacement, other.replacement);
    }

    public static class Builder
    extends CharFilterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, PatternReplaceCharFilter> {
        @Nullable
        private String flags;
        private String pattern;
        @Nullable
        private String replacement;

        public Builder() {
        }

        private Builder(PatternReplaceCharFilter o) {
            super(o);
            this.flags = o.flags;
            this.pattern = o.pattern;
            this.replacement = o.replacement;
        }

        private Builder(Builder o) {
            super(o);
            this.flags = o.flags;
            this.pattern = o.pattern;
            this.replacement = o.replacement;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder flags(@Nullable String value) {
            this.flags = value;
            return this;
        }

        @Nonnull
        public final Builder pattern(String value) {
            this.pattern = value;
            return this;
        }

        @Nonnull
        public final Builder replacement(@Nullable String value) {
            this.replacement = value;
            return this;
        }

        @Override
        @Nonnull
        public PatternReplaceCharFilter build() {
            this._checkSingleUse();
            return new PatternReplaceCharFilter(this);
        }
    }
}

