/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.structuredencryption.model;

import java.util.Objects;

public class StructureSegment {
    private final String key;

    protected StructureSegment(BuilderImpl builder) {
        this.key = builder.key();
    }

    public String key() {
        return this.key;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String key;

        protected BuilderImpl() {
        }

        protected BuilderImpl(StructureSegment model) {
            this.key = model.key();
        }

        @Override
        public Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public StructureSegment build() {
            if (Objects.isNull(this.key())) {
                throw new IllegalArgumentException("Missing value for required field `key`");
            }
            return new StructureSegment(this);
        }
    }

    public static interface Builder {
        public Builder key(String var1);

        public String key();

        public StructureSegment build();
    }
}

