/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.sas;

import java.util.Locale;

public final class AccountSasPermission {
    private boolean readPermission;
    private boolean addPermission;
    private boolean createPermission;
    private boolean writePermission;
    private boolean deletePermission;
    private boolean deleteVersionPermission;
    private boolean permanentDeletePermission;
    private boolean listPermission;
    private boolean updatePermission;
    private boolean processMessagesPermission;
    private boolean tagsPermission;
    private boolean filterTagsPermission;
    private boolean immutabilityPolicyPermission;

    public static AccountSasPermission parse(String permissionString) {
        AccountSasPermission permissions = new AccountSasPermission();
        block15: for (int i = 0; i < permissionString.length(); ++i) {
            char c = permissionString.charAt(i);
            switch (c) {
                case 'r': {
                    permissions.readPermission = true;
                    continue block15;
                }
                case 'w': {
                    permissions.writePermission = true;
                    continue block15;
                }
                case 'd': {
                    permissions.deletePermission = true;
                    continue block15;
                }
                case 'x': {
                    permissions.deleteVersionPermission = true;
                    continue block15;
                }
                case 'y': {
                    permissions.permanentDeletePermission = true;
                    continue block15;
                }
                case 'l': {
                    permissions.listPermission = true;
                    continue block15;
                }
                case 'a': {
                    permissions.addPermission = true;
                    continue block15;
                }
                case 'c': {
                    permissions.createPermission = true;
                    continue block15;
                }
                case 'u': {
                    permissions.updatePermission = true;
                    continue block15;
                }
                case 'p': {
                    permissions.processMessagesPermission = true;
                    continue block15;
                }
                case 't': {
                    permissions.tagsPermission = true;
                    continue block15;
                }
                case 'f': {
                    permissions.filterTagsPermission = true;
                    continue block15;
                }
                case 'i': {
                    permissions.immutabilityPolicyPermission = true;
                    continue block15;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "%s could not be parsed from '%s' due to invalid value %s.", "Permissions", permissionString, Character.valueOf(c)));
                }
            }
        }
        return permissions;
    }

    public boolean hasReadPermission() {
        return this.readPermission;
    }

    public AccountSasPermission setReadPermission(boolean hasReadPermission) {
        this.readPermission = hasReadPermission;
        return this;
    }

    public boolean hasAddPermission() {
        return this.addPermission;
    }

    public AccountSasPermission setAddPermission(boolean hasAddPermission) {
        this.addPermission = hasAddPermission;
        return this;
    }

    public boolean hasCreatePermission() {
        return this.createPermission;
    }

    public AccountSasPermission setCreatePermission(boolean hasCreatePermission) {
        this.createPermission = hasCreatePermission;
        return this;
    }

    public boolean hasWritePermission() {
        return this.writePermission;
    }

    public AccountSasPermission setWritePermission(boolean hasWritePermission) {
        this.writePermission = hasWritePermission;
        return this;
    }

    public boolean hasDeletePermission() {
        return this.deletePermission;
    }

    public AccountSasPermission setDeletePermission(boolean hasDeletePermission) {
        this.deletePermission = hasDeletePermission;
        return this;
    }

    public boolean hasDeleteVersionPermission() {
        return this.deleteVersionPermission;
    }

    public AccountSasPermission setDeleteVersionPermission(boolean hasDeleteVersionPermission) {
        this.deleteVersionPermission = hasDeleteVersionPermission;
        return this;
    }

    public boolean hasPermanentDeletePermission() {
        return this.permanentDeletePermission;
    }

    public AccountSasPermission setPermanentDeletePermission(boolean permanentDeletePermission) {
        this.permanentDeletePermission = permanentDeletePermission;
        return this;
    }

    public boolean hasListPermission() {
        return this.listPermission;
    }

    public AccountSasPermission setListPermission(boolean hasListPermission) {
        this.listPermission = hasListPermission;
        return this;
    }

    public boolean hasUpdatePermission() {
        return this.updatePermission;
    }

    public AccountSasPermission setUpdatePermission(boolean hasUpdatePermission) {
        this.updatePermission = hasUpdatePermission;
        return this;
    }

    public boolean hasProcessMessages() {
        return this.processMessagesPermission;
    }

    public AccountSasPermission setProcessMessages(boolean hasProcessMessagesPermission) {
        this.processMessagesPermission = hasProcessMessagesPermission;
        return this;
    }

    public boolean hasTagsPermission() {
        return this.tagsPermission;
    }

    public AccountSasPermission setTagsPermission(boolean tagsPermission) {
        this.tagsPermission = tagsPermission;
        return this;
    }

    public boolean hasFilterTagsPermission() {
        return this.filterTagsPermission;
    }

    public AccountSasPermission setFilterTagsPermission(boolean filterTagsPermission) {
        this.filterTagsPermission = filterTagsPermission;
        return this;
    }

    public boolean hasImmutabilityPolicyPermission() {
        return this.immutabilityPolicyPermission;
    }

    public AccountSasPermission setImmutabilityPolicyPermission(boolean immutabilityPolicyPermission) {
        this.immutabilityPolicyPermission = immutabilityPolicyPermission;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.readPermission) {
            builder.append('r');
        }
        if (this.writePermission) {
            builder.append('w');
        }
        if (this.deletePermission) {
            builder.append('d');
        }
        if (this.deleteVersionPermission) {
            builder.append('x');
        }
        if (this.permanentDeletePermission) {
            builder.append('y');
        }
        if (this.listPermission) {
            builder.append('l');
        }
        if (this.addPermission) {
            builder.append('a');
        }
        if (this.createPermission) {
            builder.append('c');
        }
        if (this.updatePermission) {
            builder.append('u');
        }
        if (this.processMessagesPermission) {
            builder.append('p');
        }
        if (this.tagsPermission) {
            builder.append('t');
        }
        if (this.filterTagsPermission) {
            builder.append('f');
        }
        if (this.immutabilityPolicyPermission) {
            builder.append('i');
        }
        return builder.toString();
    }
}

