/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockIdManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoStriped;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.ReplicaUnderConstruction;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

public class BlockUnderConstructionFeature {
    private HdfsServerConstants.BlockUCState blockUCState;
    private static final ReplicaUnderConstruction[] NO_REPLICAS = new ReplicaUnderConstruction[0];
    private ReplicaUnderConstruction[] replicas = NO_REPLICAS;
    private int primaryNodeIndex = -1;
    private long blockRecoveryId = 0L;
    private BlockInfo truncateBlock;

    public BlockUnderConstructionFeature(Block blk, HdfsServerConstants.BlockUCState state, DatanodeStorageInfo[] targets, BlockType blockType) {
        assert (this.getBlockUCState() != HdfsServerConstants.BlockUCState.COMPLETE) : "BlockUnderConstructionFeature cannot be in COMPLETE state";
        this.blockUCState = state;
        this.setExpectedLocations(blk, targets, blockType);
    }

    public void setExpectedLocations(Block block, DatanodeStorageInfo[] targets, BlockType blockType) {
        if (targets == null) {
            return;
        }
        int numLocations = 0;
        for (DatanodeStorageInfo target : targets) {
            if (target == null) continue;
            ++numLocations;
        }
        this.replicas = new ReplicaUnderConstruction[numLocations];
        int offset = 0;
        for (int i = 0; i < targets.length; ++i) {
            if (targets[i] == null) continue;
            Block replicaBlock = blockType == BlockType.STRIPED ? new Block(block.getBlockId() + (long)i, 0L, block.getGenerationStamp()) : block;
            this.replicas[offset++] = new ReplicaUnderConstruction(replicaBlock, targets[i], HdfsServerConstants.ReplicaState.RBW);
        }
    }

    public DatanodeStorageInfo[] getExpectedStorageLocations() {
        int numLocations = this.getNumExpectedLocations();
        DatanodeStorageInfo[] storages = new DatanodeStorageInfo[numLocations];
        for (int i = 0; i < numLocations; ++i) {
            storages[i] = this.replicas[i].getExpectedStorageLocation();
        }
        return storages;
    }

    public Iterator<DatanodeStorageInfo> getExpectedStorageLocationsIterator() {
        return new Iterator<DatanodeStorageInfo>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < BlockUnderConstructionFeature.this.replicas.length;
            }

            @Override
            public DatanodeStorageInfo next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return BlockUnderConstructionFeature.this.replicas[this.index++].getExpectedStorageLocation();
            }
        };
    }

    public byte[] getBlockIndices() {
        int numLocations = this.getNumExpectedLocations();
        byte[] indices = new byte[numLocations];
        for (int i = 0; i < numLocations; ++i) {
            indices[i] = BlockIdManager.getBlockIndex(this.replicas[i]);
        }
        return indices;
    }

    public byte[] getBlockIndicesForSpecifiedStorages(List<Integer> storageIdx) {
        byte[] indices = new byte[storageIdx.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = BlockIdManager.getBlockIndex(this.replicas[storageIdx.get(i)]);
        }
        return indices;
    }

    public int getNumExpectedLocations() {
        return this.replicas.length;
    }

    void updateStorageScheduledSize(BlockInfoStriped storedBlock) {
        assert (storedBlock.getUnderConstructionFeature() == this);
        if (this.replicas.length == 0) {
            return;
        }
        short dataBlockNum = storedBlock.getDataBlockNum();
        short realDataBlockNum = storedBlock.getRealDataBlockNum();
        if (realDataBlockNum < dataBlockNum) {
            for (ReplicaUnderConstruction replica : this.replicas) {
                byte index = BlockIdManager.getBlockIndex(replica);
                if (index < realDataBlockNum || index >= dataBlockNum) continue;
                DatanodeStorageInfo storage = replica.getExpectedStorageLocation();
                storage.getDatanodeDescriptor().decrementBlocksScheduled(storage.getStorageType());
            }
        }
    }

    public HdfsServerConstants.BlockUCState getBlockUCState() {
        return this.blockUCState;
    }

    void setBlockUCState(HdfsServerConstants.BlockUCState s) {
        this.blockUCState = s;
    }

    public long getBlockRecoveryId() {
        return this.blockRecoveryId;
    }

    public BlockInfo getTruncateBlock() {
        return this.truncateBlock;
    }

    public void setTruncateBlock(BlockInfo recoveryBlock) {
        this.truncateBlock = recoveryBlock;
    }

    void commit() {
        this.blockUCState = HdfsServerConstants.BlockUCState.COMMITTED;
    }

    List<ReplicaUnderConstruction> getStaleReplicas(long genStamp) {
        ArrayList<ReplicaUnderConstruction> staleReplicas = new ArrayList<ReplicaUnderConstruction>();
        for (ReplicaUnderConstruction r : this.replicas) {
            if (genStamp == r.getGenerationStamp()) continue;
            staleReplicas.add(r);
        }
        return staleReplicas;
    }

    public void initializeBlockRecovery(BlockInfo blockInfo, long recoveryId, boolean startRecovery) {
        this.setBlockUCState(HdfsServerConstants.BlockUCState.UNDER_RECOVERY);
        this.blockRecoveryId = recoveryId;
        if (!startRecovery) {
            return;
        }
        if (this.replicas.length == 0) {
            NameNode.blockStateChangeLog.warn("BLOCK* BlockUnderConstructionFeature.initializeBlockRecovery: No blocks found, lease removed.");
            this.primaryNodeIndex = -1;
            return;
        }
        boolean allLiveReplicasTriedAsPrimary = true;
        for (ReplicaUnderConstruction replica : this.replicas) {
            if (!replica.isAlive()) continue;
            allLiveReplicasTriedAsPrimary = allLiveReplicasTriedAsPrimary && replica.getChosenAsPrimary();
        }
        if (allLiveReplicasTriedAsPrimary) {
            for (ReplicaUnderConstruction replica : this.replicas) {
                replica.setChosenAsPrimary(false);
            }
        }
        long mostRecentLastUpdate = 0L;
        ReplicaUnderConstruction primary = null;
        this.primaryNodeIndex = -1;
        for (int i = 0; i < this.replicas.length; ++i) {
            ReplicaUnderConstruction ruc;
            long lastUpdate;
            if (!this.replicas[i].isAlive() || this.replicas[i].getChosenAsPrimary() || (lastUpdate = (ruc = this.replicas[i]).getExpectedStorageLocation().getDatanodeDescriptor().getLastUpdateMonotonic()) <= mostRecentLastUpdate) continue;
            this.primaryNodeIndex = i;
            primary = ruc;
            mostRecentLastUpdate = lastUpdate;
        }
        if (primary != null) {
            primary.getExpectedStorageLocation().getDatanodeDescriptor().addBlockToBeRecovered(blockInfo);
            primary.setChosenAsPrimary(true);
            NameNode.blockStateChangeLog.debug("BLOCK* {} recovery started, primary={}", (Object)this, (Object)primary);
        }
    }

    void addReplicaIfNotPresent(DatanodeStorageInfo storage, Block reportedBlock, HdfsServerConstants.ReplicaState rState) {
        if (this.replicas.length == 0) {
            this.replicas = new ReplicaUnderConstruction[1];
            this.replicas[0] = new ReplicaUnderConstruction(reportedBlock, storage, rState);
        } else {
            for (int i = 0; i < this.replicas.length; ++i) {
                DatanodeStorageInfo expected = this.replicas[i].getExpectedStorageLocation();
                if (expected == storage) {
                    this.replicas[i].setGenerationStamp(reportedBlock.getGenerationStamp());
                    return;
                }
                if (expected == null || expected.getDatanodeDescriptor() != storage.getDatanodeDescriptor()) continue;
                this.replicas[i] = new ReplicaUnderConstruction(reportedBlock, storage, rState);
                return;
            }
            ReplicaUnderConstruction[] newReplicas = new ReplicaUnderConstruction[this.replicas.length + 1];
            System.arraycopy(this.replicas, 0, newReplicas, 0, this.replicas.length);
            newReplicas[newReplicas.length - 1] = new ReplicaUnderConstruction(reportedBlock, storage, rState);
            this.replicas = newReplicas;
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder(100);
        this.appendUCParts(b);
        return b.toString();
    }

    private void appendUCParts(StringBuilder sb) {
        sb.append("{UCState=").append((Object)this.blockUCState).append(", truncateBlock=").append((Object)this.truncateBlock).append(", primaryNodeIndex=").append(this.primaryNodeIndex).append(", replicas=[");
        int i = 0;
        for (ReplicaUnderConstruction r : this.replicas) {
            r.appendStringTo(sb);
            if (++i >= this.replicas.length) continue;
            sb.append(", ");
        }
        sb.append("]}");
    }

    public void appendUCPartsConcise(StringBuilder sb) {
        sb.append("replicas=");
        int i = 0;
        for (ReplicaUnderConstruction r : this.replicas) {
            sb.append((Object)r.getExpectedStorageLocation().getDatanodeDescriptor());
            if (++i >= this.replicas.length) continue;
            sb.append(", ");
        }
    }
}

