/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges.dlsfls;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import org.opensearch.security.privileges.dlsfls.FieldMasking;
import org.opensearch.security.privileges.dlsfls.FieldPrivileges;

class FlsDocumentFilter {
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private final JsonParser parser;
    private final JsonGenerator generator;
    private final FieldPrivileges.FlsRule flsRule;
    private final FieldMasking.FieldMaskingRule fieldMaskingRule;
    private final Set<String> metaFields;
    private Deque<String> nameStack = new ArrayDeque<String>();

    static byte[] filter(byte[] bytes, FieldPrivileges.FlsRule flsRule, FieldMasking.FieldMaskingRule fieldMaskingRule, Set<String> metaFields) throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
            byte[] byArray;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                FlsDocumentFilter.filter(in, out, flsRule, fieldMaskingRule, metaFields);
                byArray = out.toByteArray();
            }
            return byArray;
        }
    }

    static void filter(InputStream in, OutputStream out, FieldPrivileges.FlsRule flsRule, FieldMasking.FieldMaskingRule fieldMaskingRule, Set<String> metaFields) throws IOException {
        try (JsonParser parser = JSON_FACTORY.createParser(in);
             JsonGenerator generator = JSON_FACTORY.createGenerator(out);){
            new FlsDocumentFilter(parser, generator, flsRule, fieldMaskingRule, metaFields).copy();
        }
    }

    FlsDocumentFilter(JsonParser parser, JsonGenerator generator, FieldPrivileges.FlsRule flsRule, FieldMasking.FieldMaskingRule fieldMaskingRule, Set<String> metaFields) {
        this.parser = parser;
        this.generator = generator;
        this.flsRule = flsRule;
        this.fieldMaskingRule = fieldMaskingRule;
        this.metaFields = metaFields;
    }

    /*
     * Unable to fully structure code
     */
    private void copy() throws IOException {
        queuedFieldName = null;
        fullCurrentName = null;
        fullParentName = null;
        v0 = token = this.parser.currentToken() != null ? this.parser.currentToken() : this.parser.nextToken();
        while (token != null) {
            if (queuedFieldName == null) ** GOTO lbl17
            startOfObjectOrArray = token == JsonToken.START_OBJECT || token == JsonToken.START_ARRAY;
            fullQueuedFieldName = fullParentName == null ? queuedFieldName : fullParentName + "." + queuedFieldName;
            queuedFieldName = null;
            if (!(this.metaFields.contains(fullQueuedFieldName) || this.flsRule.isAllowedAssumingParentsAreAllowed(fullQueuedFieldName) || startOfObjectOrArray && this.flsRule.isObjectAllowedAssumingParentsAreAllowed(fullQueuedFieldName))) {
                if (startOfObjectOrArray) {
                    this.parser.skipChildren();
                }
            } else {
                this.generator.writeFieldName(this.parser.currentName());
                fullCurrentName = fullQueuedFieldName;
lbl17:
                // 2 sources

                switch (1.$SwitchMap$com$fasterxml$jackson$core$JsonToken[token.ordinal()]) {
                    case 1: {
                        queuedFieldName = this.parser.currentName();
                        break;
                    }
                    case 2: {
                        this.generator.writeStartObject();
                        if (fullParentName != null) {
                            this.nameStack.add(fullParentName);
                        }
                        fullParentName = fullCurrentName;
                        break;
                    }
                    case 3: {
                        this.generator.writeEndObject();
                        fullCurrentName = fullParentName;
                        if (this.nameStack.isEmpty()) {
                            fullParentName = null;
                            break;
                        }
                        fullParentName = this.nameStack.removeLast();
                        break;
                    }
                    case 4: {
                        this.generator.writeStartArray();
                        break;
                    }
                    case 5: {
                        this.generator.writeEndArray();
                        break;
                    }
                    case 6: {
                        this.generator.writeBoolean(Boolean.TRUE.booleanValue());
                        break;
                    }
                    case 7: {
                        this.generator.writeBoolean(Boolean.FALSE.booleanValue());
                        break;
                    }
                    case 8: {
                        this.generator.writeNull();
                        break;
                    }
                    case 9: {
                        this.generator.writeNumber(this.parser.getDecimalValue());
                        break;
                    }
                    case 10: {
                        this.generator.writeNumber(this.parser.getBigIntegerValue());
                        break;
                    }
                    case 11: {
                        field = this.fieldMaskingRule.get(fullCurrentName);
                        if (field != null) {
                            this.generator.writeString(field.apply(this.parser.getText()));
                            break;
                        }
                        this.generator.writeString(this.parser.getText());
                        break;
                    }
                    case 12: {
                        this.generator.writeEmbeddedObject(this.parser.getEmbeddedObject());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected token: " + String.valueOf(token));
                    }
                }
            }
            token = this.parser.nextToken();
        }
    }
}

