/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.abel;

import net.sourceforge.plantuml.abel.DisplayPositionned;
import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.style.ISkinSimple;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.utils.LineLocation;

public class DisplayPositioned
extends DisplayPositionned {
    private final Display display;
    private final HorizontalAlignment horizontalAlignment;
    private final VerticalAlignment verticalAlignment;
    private final LineLocation location;

    private DisplayPositioned(LineLocation location, Display display, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        this.location = location;
        this.display = display;
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
    }

    public DisplayPositioned withPage(int page, int lastpage) {
        Display newDisplay = this.display.withPage(page, lastpage);
        return new DisplayPositioned(this.location, newDisplay, this.horizontalAlignment, this.verticalAlignment);
    }

    public DisplayPositioned withDisplay(Display display) {
        return new DisplayPositioned(this.location, display, this.horizontalAlignment, this.verticalAlignment);
    }

    public DisplayPositioned withHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        return new DisplayPositioned(this.location, this.display, horizontalAlignment, this.verticalAlignment);
    }

    public DisplayPositioned withLocation(LineLocation location) {
        return new DisplayPositioned(location, this.display, this.horizontalAlignment, this.verticalAlignment);
    }

    public static DisplayPositioned single(Display display, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        return new DisplayPositioned(null, display, horizontalAlignment, verticalAlignment);
    }

    public static DisplayPositioned single(LineLocation location, Display display, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        return new DisplayPositioned(location, display, horizontalAlignment, verticalAlignment);
    }

    public static DisplayPositioned none(HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        return new DisplayPositioned(null, Display.NULL, horizontalAlignment, verticalAlignment);
    }

    @Override
    public final Display getDisplay() {
        return this.display;
    }

    public final HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public final VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    @Override
    public boolean isNull() {
        return Display.isNull(this.display);
    }

    public boolean hasUrl() {
        return this.display.hasUrl();
    }

    public LineLocation getLineLocation() {
        return this.location;
    }

    public TextBlock createRibbon(FontConfiguration fontConfiguration, ISkinSimple spriteContainer, Style style) {
        Display display = this.getDisplay();
        if (Display.isNull(display) || display.size() == 0) {
            return null;
        }
        if (style != null) {
            return style.createTextBlockBordered(display, spriteContainer.getIHtmlColorSet(), spriteContainer, null, LineBreakStrategy.NONE);
        }
        return display.create(fontConfiguration, this.getHorizontalAlignment(), spriteContainer);
    }
}

