#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-79e0z5flsSQ7XGVhkCMsxx
key:                  postgrest-10.0.0-79e0z5flsSQ7XGVhkCMsxx
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  2d5ddb0e5209ea0982b664913896a805
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.6.6/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.6.6/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-79e0z5flsSQ7XGVhkCMsxx
depends:
    HTTP-4000.4.1-64RrdSBxdcO5dWa3igNo2N
    Ranged-sets-0.5.0-9uYN7uKLSWGIes9EY5RtXM
    aeson-2.1.2.1-KAplhvfLEdp6k37mi9zTZA
    auto-update-0.1.6-Ht8jA9GahpED4uAHrNcjmH base-4.18.2.1
    base64-bytestring-1.2.1.0-9LHYaxMplJVGg4IRiFtzGp
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-26iNgmqHMOsJk4yniKxDB2
    cassava-0.5.4.1-Jxc7si6RwdpF5ANAcJYzTV
    configurator-pg-0.2.10-88YjuTSl23x4WHqvprZHVJ containers-0.6.7
    contravariant-extras-0.3.5.4-3woyg6AJRP6Lk666ZeP5zR
    cookie-0.5.0-Dqi2dsQ09KG8Z0mbWITxu5 directory-1.3.8.5
    either-5.0.3-965sjCyp20vC6uss2Pthu9
    gitrev-1.3.1-HjgHeGOzFY1JvYhlt8eDSs
    hasql-1.5.0.5-6xgX9lF7ywC8oNh7M9UgUa
    hasql-dynamic-statements-0.3.1.1-9Y48sjjBlWpIxrNIOKcrfX
    hasql-notifications-0.2.0.5-ImAloH6wIIJ2e060p1iCfx
    hasql-pool-0.5.2.2-1W6vsz1ITKZ3Fmd1tTYJcw
    hasql-transaction-1.0.1.1-Iam7ZakTL0IHfvZSLbciEJ
    heredoc-0.2.0.0-6fzsisYvDUd6tBbd4jIzIt
    http-types-0.12.4-DpLRlhCeIkXGgeQrwJBKkM
    insert-ordered-containers-0.2.5.3-KpRnt6pMpg13BWz4C9N0Jb
    interpolatedstring-perl6-1.0.2-JQSrNzxjN3eDFCUgOlr7jH
    jose-0.10-KqzmUwm2G4z2RcZU2ud9Vi lens-5.3.3-ATynRreA1Nv2YBaKYxJYCc
    lens-aeson-1.2.3-47RZuhii4NE2qfIh44LhYe mtl-2.3.1
    network-3.1.4.0-Kxe15bkS84aBmhotDoAJWo
    network-uri-2.6.4.2-3zCbFVr23iA8AOO7Y4yAP5
    optparse-applicative-0.18.1.0-5nnJ4FeW1ct8RzxtI8AAka
    parsec-3.1.16.1 protolude-0.3.5-9Njmreq1cN2CDaC9e70TkF
    regex-tdfa-1.3.2.5-HbcBjlVCDu1Hxg2xP0HSjv
    retry-0.9.3.1-FzNctIBE5mpKMpRgkxV7K0
    scientific-0.3.8.0-4yI3uLcaGfNJ0xFa1ruDPP
    swagger2-2.8.10-KoPlCTQP2LgEITBklBviV6 text-2.0.2 time-1.12.2
    unix-2.8.4.0 unordered-containers-0.2.20.1-CjV5euINhym8dGoasHPURS
    vault-0.3.1.5-L7ViAOX44QTH97vcWvOGP9
    vector-0.13.2.0-3Co1wNPhccp6XnsJEn8cXR
    wai-3.2.4-DP7Wq107T9eHDgy7g2zCw
    wai-cors-0.2.7-8L347cAZLwPJwzw2X5CVEt
    wai-extra-3.1.18-HOP6GiGN6Y3H7HQK0MkHft
    wai-logger-2.5.0-LfeowHm4Maw9ZVPJrzRjVC
    warp-3.4.0-4jTdxXQfffMAWOOz9ZYhu4

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

