# Interface for submodule: MetaDataObject
from typing import Union, Any
# additional imports
from .support.template_class import itkTemplate as _itkTemplate


# Interface for class: MetaDataObject
from ._proxies import MetaDataObjectProxy as _MetaDataObjectProxy
class _MetaDataObjectTemplateGetter():
    def __getitem__(self, parameters) -> _MetaDataObjectTemplate:
        """Specify class type with:
            	[INSERT_TYPE_NAMES_HERE]
            :return: MetaDataObjectTemplate
            """
        ...


class _MetaDataObjectTemplate(_itkTemplate, metaclass=_MetaDataObjectTemplateGetter):
    """Interface for instantiating itk::MetaDataObject< INSERT_TYPE_NAMES_HERE >
        Create a new MetaDataObject Object (of default type):
            'itk.MetaDataObject.New(**kwargs)
        Supports type specification through dictionary access:
            'itk.MetaDataObject[INSERT_TYPE_NAMES_HERE].New(**kwargs)"""

    @staticmethod
    def New(**kwargs) -> _MetaDataObjectProxy:
        """Instantiate itk::MetaDataObject< INSERT_TYPE_NAMES_HERE >"""
        ...

MetaDataObject = _MetaDataObjectTemplate

