\name{FastApproximateRankImageFilter}
\alias{FastApproximateRankImageFilter}
\title{FastApproximateRankImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
A separable rank filter.
FastApproximateRankImageFilter}
\details{
Medians aren't separable, but if you want a large robust smoother to
be relatively quick then it is worthwhile pretending that they are.
This code was contributed in the Insight Journal paper: "Efficient
implementation of kernel filtering" by Beare R., Lehmann G https://hdl.handle.net/1926/555 https://www.insight-journal.org/browse/publication/160
Richard Beare
See:
FastApproximateRank for the procedural interface
itk::FastApproximateRankImageFilter for the Doxygen on the original ITK class.
FastApproximateRankImageFilter}
%C++ includes: sitkFastApproximateRankImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{ FastApproximateRankImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< unsigned int > GetRadius() const:}{}
\item{double GetRank() const:}{}
\item{Self SetRadius(std::vector< unsigned int > Radius):}{}
\item{Self SetRadius(unsigned int value):}{
Set the values of the Radius vector all to value
}
\item{Self SetRank(double Rank):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~FastApproximateRankImageFilter():}{
Destructor
}
}
}
