\name{LabelToRGBImageFilter}
\alias{LabelToRGBImageFilter}
\title{LabelToRGBImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Apply a colormap to a label image.
LabelToRGBImageFilter}
\details{
Apply a colormap to a label image. The set of colors is a good
selection of distinct colors. The user can choose to use a background
value. In that case, a gray pixel with the same intensity than the
background label is produced.
This code was contributed in the Insight Journal paper: "The
watershed transform in ITK - discussion and new developments" by
Beare R., Lehmann G. https://www.insight-journal.org/browse/publication/92
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
Richard Beare. Department of Medicine, Monash University, Melbourne,
Australia.
See:
LabelOverlayImageFilter
LabelMapToRGBImageFilter , LabelToRGBFunctor, ScalarToRGBPixelFunctor
LabelToRGB for the procedural interface
itk::LabelToRGBImageFilter for the Doxygen on the original ITK class.
LabelToRGBImageFilter}
%C++ includes: sitkLabelToRGBImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{double GetBackgroundValue() const:}{
Set/Get the background value
}
\item{std::vector< uint8_t > GetColormap() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{ LabelToRGBImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetBackgroundValue(double BackgroundValue):}{
Set/Get the background value
}
\item{Self SetColormap(std::vector< uint8_t > Colormap):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~LabelToRGBImageFilter():}{
Destructor
}
}
}
