\name{HistogramMatchingImageFilter}
\alias{HistogramMatchingImageFilter}
\title{HistogramMatchingImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Normalize the grayscale values for a source image by matching the
shape of the source image histogram to a reference histogram.
HistogramMatchingImageFilter}
\details{
HistogramMatchingImageFilter normalizes the grayscale values of a source image based on the
grayscale values of either a reference image or a reference histogram.
This filter uses a histogram matching technique where the histograms
of the are matched only at a specified number of quantile values.
This filter was originally designed to normalize MR images of the same
MR protocol and same body part. The algorithm works best if background
pixels are excluded from both the source and reference histograms. A
simple background exclusion method is to exclude all pixels whose
grayscale values are smaller than the mean grayscale value. ThresholdAtMeanIntensityOn() switches on this simple background exclusion method. With ThresholdAtMeanIntensityOn() , The reference histogram returned from this filter will expand the
first and last bin bounds to include the minimum and maximum intensity
values of the entire reference image, but only intensity values
greater than the mean will be used to populate the histogram.
The source image can be set via either SetInput() or SetSourceImage().
The reference object used is selected with can be set via
SetReferenceImage() or SetReferenceHistogram().
SetNumberOfHistogramLevels() sets the number of bins used when creating histograms of the source
and reference images. SetNumberOfMatchPoints() governs the number of quantile values to be matched.
This filter assumes that both the source and reference are of the same
type and that the input and output image type have the same number of
dimension and have scalar pixel types.
REFERENCE
Laszlo G. Nyul, Jayaram K. Udupa, and Xuan Zhang, "New Variants of a
Method of MRI Scale Standardization", IEEE Transactions on Medical
Imaging, 19(2):143-150, 2000.
See:
HistogramMatching for the procedural interface
itk::HistogramMatchingImageFilter for the Doxygen on the original ITK class.
HistogramMatchingImageFilter}
%C++ includes: sitkHistogramMatchingImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image, const Image &referenceImage):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint32_t GetNumberOfHistogramLevels() const:}{
Set/Get the number of histogram levels used.
}
\item{uint32_t GetNumberOfMatchPoints() const:}{
Set/Get the number of match points used.
}
\item{bool GetThresholdAtMeanIntensity() const:}{
Set/Get the threshold at mean intensity flag. If true, only source
(reference) pixels which are greater than the mean source (reference)
intensity is used in the histogram matching. If false, all pixels are
used.
}
\item{ HistogramMatchingImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetNumberOfHistogramLevels(uint32_t NumberOfHistogramLevels):}{
Set/Get the number of histogram levels used.
}
\item{Self SetNumberOfMatchPoints(uint32_t NumberOfMatchPoints):}{
Set/Get the number of match points used.
}
\item{Self SetThresholdAtMeanIntensity(bool ThresholdAtMeanIntensity):}{
Set/Get the threshold at mean intensity flag. If true, only source
(reference) pixels which are greater than the mean source (reference)
intensity is used in the histogram matching. If false, all pixels are
used.
}
\item{Self ThresholdAtMeanIntensityOff():}{}
\item{Self ThresholdAtMeanIntensityOn():}{
Set the value of ThresholdAtMeanIntensity to true or false
respectfully.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~HistogramMatchingImageFilter():}{
Destructor
}
}
}
