# - Config file for rocprofiler-sdk-roctx and its component libraries
# It defines the following variables:
#
# rocprofiler-sdk-roctx_VERSION
# rocprofiler-sdk-roctx_INCLUDE_DIR
# rocprofiler-sdk-roctx_LIB_DIR
# rocprofiler-sdk-roctx_LIBRARIES
#
# It provides the following interface libraries:
#
# rocprofiler-sdk-roctx::rocprofiler-sdk-roctx
#

# prevent "target already exists" error
include_guard(DIRECTORY)

# compute paths
get_filename_component(rocprofiler-sdk-roctx_CMAKE_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set_and_check(rocprofiler-sdk-roctx_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include")
set_and_check(rocprofiler-sdk-roctx_LIB_DIR "${PACKAGE_PREFIX_DIR}/lib")
get_filename_component(rocprofiler-sdk-roctx_ROOT_DIR ${rocprofiler-sdk-roctx_INCLUDE_DIR} PATH)
set_and_check(rocprofiler-sdk-roctx_ROOT "${rocprofiler-sdk-roctx_ROOT_DIR}")

# extra validation
foreach(_rocprofiler-sdk-roctx_SUBDIR include/rocprofiler-sdk-roctx)
    set_and_check(_rocprofiler-sdk-roctx_SUBDIR_CHECK
                  "${PACKAGE_PREFIX_DIR}/${_rocprofiler-sdk-roctx_SUBDIR}")
    unset(_rocprofiler-sdk-roctx_SUBDIR_CHECK)
endforeach()

set(rocprofiler-sdk-roctx_LIBRARIES)

# add interface library
add_library(rocprofiler-sdk-roctx::rocprofiler-sdk-roctx INTERFACE IMPORTED)

if(rocprofiler-sdk-roctx_BUILD_TREE
   AND EXISTS "${CMAKE_CURRENT_LIST_DIR}/rocprofiler-sdk-roctx-build-config.cmake")
    include("${CMAKE_CURRENT_LIST_DIR}/rocprofiler-sdk-roctx-build-config.cmake")
else()
    include("${rocprofiler-sdk-roctx_CMAKE_DIR}/rocprofiler-sdk-roctx-targets.cmake")

    # Library dependencies
    if(rocprofiler-sdk-roctx_FIND_COMPONENTS)
        foreach(COMP ${rocprofiler-sdk-roctx_FIND_COMPONENTS})
            set(TARG rocprofiler-sdk-roctx::rocprofiler-sdk-roctx-${COMP})
            if(TARGET ${TARG})
                set(rocprofiler-sdk-roctx_${COMP}_FOUND 1)
                list(APPEND rocprofiler-sdk-roctx_LIBRARIES ${TARG})
                target_link_libraries(rocprofiler-sdk-roctx::rocprofiler-sdk-roctx INTERFACE ${TARG})
            else()
                set(rocprofiler-sdk-roctx_${COMP}_FOUND 0)
            endif()
        endforeach()
    else()
        foreach(TARG rocprofiler-sdk-roctx-shared-library)
            set(TARG rocprofiler-sdk-roctx::${TARG})
            list(APPEND rocprofiler-sdk-roctx_LIBRARIES ${TARG})
            target_link_libraries(rocprofiler-sdk-roctx::rocprofiler-sdk-roctx INTERFACE ${TARG})
        endforeach()
    endif()
endif()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(
    rocprofiler-sdk-roctx
    FOUND_VAR rocprofiler-sdk-roctx_FOUND
    VERSION_VAR rocprofiler-sdk-roctx_VERSION
    REQUIRED_VARS rocprofiler-sdk-roctx_ROOT_DIR rocprofiler-sdk-roctx_INCLUDE_DIR
                  rocprofiler-sdk-roctx_LIB_DIR rocprofiler-sdk-roctx_LIBRARIES rocprofiler-sdk-roctx_VERSION
    HANDLE_COMPONENTS HANDLE_VERSION_RANGE)
