//@ui5-bundle sap/ui/table/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/AnalyticalColumn", ["./Column","./library","sap/ui/core/Element","sap/ui/model/type/Boolean","sap/ui/model/type/DateTime","sap/ui/model/type/Float","sap/ui/model/type/Integer","sap/ui/model/type/Time","./utils/TableUtils","sap/base/Log"],function(e,t,n,o,i,r,a,s,p,l){"use strict";const u=t.GroupEventType;function d(e){return p.isA(e,"sap.ui.table.AnalyticalTable")}const g=e.extend("sap.ui.table.AnalyticalColumn",{metadata:{library:"sap.ui.table",properties:{leadingProperty:{type:"string",group:"Misc",defaultValue:null},summed:{type:"boolean",group:"Misc",defaultValue:false},inResult:{type:"boolean",group:"Misc",defaultValue:false},showIfGrouped:{type:"boolean",group:"Appearance",defaultValue:false},groupHeaderFormatter:{type:"function",group:"Appearance",defaultValue:null},grouped:{type:"boolean",group:"Appearance",defaultValue:false}}}});g._DEFAULT_FILTERTYPES={Time:new s({UTC:true}),DateTime:new i({UTC:true}),Float:new r,Integer:new a,Boolean:new o};g.prototype._setGrouped=function(e){const t=this._getTable();const n=e?u.group:u.ungroup;this.setGrouped(e);t.fireGroup({column:this,groupedColumns:t._aGroupedColumns,type:n})};g.prototype._isAggregatableByMenu=function(){const e=this._getTable();const t=e.getBinding();const n=t&&t.getAnalyticalQueryResult();return e&&n&&n.findMeasureByPropertyName(this.getLeadingProperty())};g.prototype.setGrouped=function(e){const t=this.getParent();if(d(t)){if(e){t._addGroupedColumn(this.getId())}else{t._removeGroupedColumn(this.getId())}}const n=this.setProperty("grouped",e);this._updateColumns();return n};g.prototype.setSummed=function(e){const t=this.setProperty("summed",e,true);this._updateTableAnalyticalInfo();return t};g.prototype.setVisible=function(t){e.prototype.setVisible.call(this,t);this._updateColumns();return this};g.prototype.getLabel=function(){let e=this.getAggregation("label");try{if(!e){if(!this._oBindingLabel){const e=this.getParent();if(d(e)){const t=e.getBinding();if(t){this._oBindingLabel=p._getTableTemplateHelper().createLabel();this.addDependent(this._oBindingLabel);p.Binding.metadataLoaded(e).then(function(){this._oBindingLabel.setText(t.getPropertyLabel(this.getLeadingProperty()))}.bind(this))}}}e=this._oBindingLabel}}catch(e){l.warning(e)}return e};g.prototype.getFilterProperty=function(){let e=this.getProperty("filterProperty");if(!e){const t=this.getParent();if(d(t)){const n=t.getBinding();const o=this.getLeadingProperty();if(n&&n.getFilterablePropertyNames().indexOf(o)>-1){e=o}}}return e};g.prototype.getSortProperty=function(){let e=this.getProperty("sortProperty");if(!e){const t=this.getParent();if(d(t)){const n=t.getBinding();const o=this.getLeadingProperty();if(n&&n.getSortablePropertyNames().indexOf(o)>-1){e=o}}}return e};g.prototype.getFilterType=function(){let e=this.getProperty("filterType");if(!e){const t=this.getParent();if(d(t)){const n=t.getBinding();const o=this.getLeadingProperty();const i=n&&n.getProperty(o);if(i){switch(i.type){case"Edm.Time":e=g._DEFAULT_FILTERTYPES["Time"];break;case"Edm.DateTime":case"Edm.DateTimeOffset":e=g._DEFAULT_FILTERTYPES["DateTime"];break;case"Edm.Single":case"Edm.Double":case"Edm.Decimal":e=g._DEFAULT_FILTERTYPES["Float"];break;case"Edm.SByte":case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":e=g._DEFAULT_FILTERTYPES["Integer"];break;case"Edm.Boolean":e=g._DEFAULT_FILTERTYPES["Boolean"];break}}}}return e};g.prototype._updateColumns=function(e,t){const n=this.getParent();if(d(n)){n._updateColumns(e,t)}};g.prototype._updateTableAnalyticalInfo=function(e){const t=this.getParent();if(t&&d(t)&&!t._bSuspendUpdateAnalyticalInfo){t.updateAnalyticalInfo(e)}};g.prototype._updateTableColumnDetails=function(){const e=this.getParent();if(e&&d(e)&&!e._bSuspendUpdateAnalyticalInfo){e._updateTableColumnDetails()}};g.prototype.shouldRender=function(){if(!this.getVisible()||!this.getTemplate()){return false}return(!this.getGrouped()||this._bLastGroupAndGrouped||this.getShowIfGrouped())&&(!this._bDependendGrouped||this._bLastGroupAndGrouped)};g.prototype._menuHasItems=function(){const t=function(){const e=this.getParent();const t=e.getBinding();const n=t&&t.getAnalyticalQueryResult();return e&&n&&n.findMeasureByPropertyName(this.getLeadingProperty())}.bind(this);return e.prototype._menuHasItems.apply(this)||t()};g.prototype.isFilterableByMenu=function(){const e=this.getFilterProperty();if(!e||!this.getShowFilterMenuEntry()){return false}const t=this.getParent();if(d(t)){const n=t.getBinding();if(n){if(n.getFilterablePropertyNames().indexOf(e)>-1&&n.getProperty(e)){return true}}}return false};g.prototype.isGroupableByMenu=function(){const e=this.getParent();if(!d(e)){return false}const t=e.getBinding();if(!t){return false}const n=t.getAnalyticalQueryResult();if(!n){return false}const o=n.findDimensionByPropertyName(this.getLeadingProperty());return!!(o&&t.getSortablePropertyNames().indexOf(o.getName())>-1&&t.getFilterablePropertyNames().indexOf(o.getName())>-1)};g.prototype._isGroupableByMenu=function(){return this.isGroupableByMenu()};g.prototype._setCellContentVisibilitySettings=function(){};g.prototype._applySorters=function(){this._updateTableAnalyticalInfo(true);e.prototype._applySorters.apply(this,arguments)};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/AnalyticalColumnMenu", ["./ColumnMenu","sap/ui/unified/MenuRenderer","./utils/TableUtils","./library","sap/ui/thirdparty/jquery"],function(t,e,o,n,jQuery){"use strict";const u=t.extend("sap.ui.table.AnalyticalColumnMenu",{metadata:{library:"sap.ui.table"},renderer:e});u.prototype._addMenuItems=function(){t.prototype._addMenuItems.apply(this);if(this._getColumn()){this._addSumMenuItem()}};u.prototype._addGroupMenuItem=function(){const t=this._getColumn();const e=this._getTable();if(t.isGroupableByMenu()){this._oGroupIcon=this._createMenuItem("group","TBL_GROUP",t.getGrouped()?"accept":null,function(n){const u=n.getSource();const i=!t.getGrouped();if(i&&!t.getShowIfGrouped()){let t;if(o.isNoDataVisible(e)){t=e.getDomRef("noDataCnt")}else{t=e.getDomRef("rowsel0")}if(t){t.focus()}}t._setGrouped(i);u.setIcon(i?"sap-icon://accept":null)});this.addItem(this._oGroupIcon)}};u.prototype._addSumMenuItem=function(){const t=this._getColumn();if(t._isAggregatableByMenu()){this._oSumItem=this._createMenuItem("total","TBL_TOTAL",t.getSummed()?"accept":null,jQuery.proxy(function(e){const o=e.getSource();const n=t.getSummed();t.setSummed(!n);o.setIcon(!n?"sap-icon://accept":null)},this));this.addItem(this._oSumItem)}};u.prototype.open=function(){t.prototype.open.apply(this,arguments);const e=this._getColumn();this._oSumItem&&this._oSumItem.setIcon(e.getSummed()?"sap-icon://accept":null);this._oGroupIcon&&this._oGroupIcon.setIcon(e.getGrouped()?"sap-icon://accept":null)};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/AnalyticalTable", ["./AnalyticalColumn","./Column","./Table","./TreeTable","./TableRenderer","./menus/AnalyticalTableContextMenu","sap/ui/core/Element","sap/ui/model/analytics/ODataModelAdapter","./utils/TableUtils","./plugins/BindingSelection","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/model/controlhelper/TreeBindingProxy"],function(e,t,o,n,i,s,r,a,l,p,u,jQuery,d){"use strict";const c=l.createWeakMapFacade();const y=o.extend("sap.ui.table.AnalyticalTable",{metadata:{library:"sap.ui.table",properties:{sumOnTop:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},numberOfExpandedLevels:{type:"int",group:"Misc",defaultValue:0,deprecated:true},autoExpandMode:{type:"string",group:"Misc",defaultValue:"Bundled",deprecated:true},columnVisibilityMenuSorter:{type:"any",group:"Appearance",defaultValue:null},collapseRecursive:{type:"boolean",defaultValue:true,deprecated:true},dirty:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true},extendedGroupHeaderMenu:{type:"boolean",group:"Behavior",defaultValue:true,visibility:"hidden"}},events:{group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.AnalyticalColumn"}}}},designtime:"sap/ui/table/designtime/AnalyticalTable.designtime"},renderer:i});y.prototype._getFixedBottomRowContexts=function(){const e=this.getBinding();return e?[e.getGrandTotalNode()]:[]};y.prototype._getContexts=function(e,t,o){if(!this.getVisible()){return[]}const n=this.getBinding();if(n){return n.getNodes(e,t,o)}else{return[]}};y.prototype._getRowContexts=n.prototype._getRowContexts;y.prototype.init=function(){o.prototype.init.apply(this,arguments);this.addStyleClass("sapUiAnalyticalTable");this.setShowColumnVisibilityMenu(true);this.setEnableColumnFreeze(true);this.setEnableCellFilter(true);this.setProperty("rowCountConstraints",{fixedTop:false,fixedBottom:false});this._aGroupedColumns=[];this._bSuspendUpdateAnalyticalInfo=false;l.Grouping.setToDefaultGroupMode(this);l.Hook.register(this,l.Hook.Keys.Row.UpdateState,f,this);l.Hook.register(this,l.Hook.Keys.Row.Expand,g,this);l.Hook.register(this,l.Hook.Keys.Row.Collapse,h,this);this._oProxy=new d(this,"rows")};y.prototype.setFixedRowCount=function(){u.error("The property fixedRowCount is not supported by control sap.ui.table.AnalyticalTable!");return this};y.prototype.setFixedBottomRowCount=function(){u.error("The property fixedBottomRowCount is managed by control sap.ui.table.AnalyticalTable!");return this};y.prototype.setDirty=function(e){u.error("The property dirty of control sap.ui.table.AnalyticalTable is deprecated. Please use showOverlay instead.");this.setProperty("dirty",e,true);this.setShowOverlay(this.getDirty());return this};y.prototype.setEnableGrouping=function(){u.error("The property enableGrouping is not supported by the sap.ui.table.AnalyticalTable control");return this};y.prototype.setGroupBy=function(){u.warning("The groupBy association is not supported by the sap.ui.table.AnalyticalTable control");return this};y.prototype.getModel=function(e){const t=o.prototype.getModel.apply(this,arguments);const n=this.getBindingInfo("rows");if(t&&n&&n.model===e){a.apply(t)}return t};y.prototype.updateRows=function(e){o.prototype.updateRows.apply(this,arguments);if(e!=="sort"){this._invalidateColumnMenus()}};y.prototype._bindRows=function(e){delete c(this).bPendingRequest;this._applyAnalyticalBindingInfo(e);o.prototype._bindRows.call(this,e)};y.prototype._bindAggregation=function(e,t){if(e==="rows"){this._invalidateColumnMenus();this._setFirstVisibleRowIndex(0,{onlySetProperty:true})}o.prototype._bindAggregation.call(this,e,t);if(e==="rows"){this._updateTotalRow(true);l.Binding.metadataLoaded(this).then(function(){this._updateColumns(true)}.bind(this))}};y.prototype._applyAnalyticalBindingInfo=function(e){e.parameters=e.parameters||{};e.parameters.analyticalInfo=this._getColumnInformation();if(!e.parameters.hasOwnProperty("sumOnTop")){e.parameters.sumOnTop=this.getSumOnTop()}if(!e.parameters.hasOwnProperty("numberOfExpandedLevels")){e.parameters.numberOfExpandedLevels=this.getNumberOfExpandedLevels()}if(e.parameters.numberOfExpandedLevels>this._aGroupedColumns.length){e.parameters.numberOfExpandedLevels=0}if(!e.parameters.hasOwnProperty("autoExpandMode")){let t=this.getAutoExpandMode();if(t!=="Bundled"&&t!=="Sequential"){t="Bundled"}e.parameters.autoExpandMode=t}};y.prototype._getColumnInformation=function(){const t=[];const o=this.getColumns();for(let e=0;e<this._aGroupedColumns.length;e++){const o=r.getElementById(this._aGroupedColumns[e]);if(!o){continue}t.push({name:o.getLeadingProperty(),visible:o.getVisible(),grouped:o.getGrouped(),total:o.getSummed(),inResult:o.getInResult(),formatter:o.getGroupHeaderFormatter()})}for(let n=0;n<o.length;n++){const i=o[n];if(this._aGroupedColumns.indexOf(i.getId())>-1){continue}if(!(i instanceof e)){u.error("You have to use AnalyticalColumns for the Analytical table")}t.push({name:i.getLeadingProperty(),visible:i.getVisible(),grouped:i.getGrouped(),total:i.getSummed(),inResult:i.getInResult(),formatter:i.getGroupHeaderFormatter()})}return t};function f(e){const t=this.getBinding();const o=this.getBindingInfo("rows");const n=e.context;e.context=n.context;if(!e.context){return}if(t.nodeHasChildren(n)){e.type=e.Type.GroupHeader;e.expandable=true}else if(n.nodeState.sum){e.type=e.Type.Summary}e.level=n.level+(e.type===e.Type.Summary?1:0);e.expanded=n.nodeState.expanded;e.contentHidden=e.expanded&&!o.parameters.sumOnTop;e.title=e.type===e.Type.GroupHeader?t.getGroupName(n.context,n.level):""}function g(e){this.expand(e.getIndex())}function h(e){this.collapse(e.getIndex())}y.prototype.onRowsUpdated=function(e){o.prototype.onRowsUpdated.apply(this,arguments);const n=this.getRows();const i=this.getBinding();const s=this._getVisibleColumns()[0];for(let e=0;e<n.length;e++){const o=n[e];const r=o.getCells();const a=r.length;for(let e=0;e<a;e++){const n=t.ofCell(r[e]);const a=i?i.isMeasure(n.getLeadingProperty()):false;const l=jQuery(r[e].$().closest("td"));let p=false;if(o.isSummary()&&a){p=!n.getSummed()}else if(o.isGroupHeader()&&n===s){p=!a}l.toggleClass("sapUiTableCellHidden",p)}}};y.prototype.getContextByIndex=function(e){return this._oProxy.getContextByIndex(e)};y.prototype.getContextInfoByIndex=function(e){return this._oProxy.getNodeByIndex(e)};y.prototype.suspendUpdateAnalyticalInfo=function(){this._bSuspendUpdateAnalyticalInfo=true};y.prototype.resumeUpdateAnalyticalInfo=function(e,t){this._bSuspendUpdateAnalyticalInfo=false;this._updateColumns(e,t)};y.prototype.addColumn=function(e,t){const n=this._getColumn(e);if(n.getGrouped()){this._addGroupedColumn(n.getId())}o.prototype.addColumn.call(this,n,t);this._updateColumns(t);return this};y.prototype.insertColumn=function(e,t,n){const i=this._getColumn(e);if(i.getGrouped()){this._addGroupedColumn(i.getId())}o.prototype.insertColumn.call(this,i,t,n);this._updateColumns(n);return this};y.prototype.removeColumn=function(e,t){const n=o.prototype.removeColumn.apply(this,arguments);if(!this._bReorderInProcess){this._aGroupedColumns=jQuery.grep(this._aGroupedColumns,function(t){if(e.getId){return t!==e.getId()}else{return t===e}})}this.updateAnalyticalInfo(t);return n};y.prototype.removeAllColumns=function(e){this._aGroupedColumns=[];const t=o.prototype.removeAllColumns.apply(this,arguments);this._updateColumns(e);return t};y.prototype._getColumn=function(t){if(typeof t==="string"){const o=new e({leadingProperty:t,template:t,managed:true});return o}else if(t instanceof e){return t}else{throw new Error("Wrong column type. You need to define a string (property) or pass an AnalyticalColumnObject")}};y.prototype._updateColumns=function(e,t){if(!this._bSuspendUpdateAnalyticalInfo){this._updateTableColumnDetails();this.updateAnalyticalInfo(e,t);if(this.bOutput){this.invalidate()}}};y.prototype.updateAnalyticalInfo=function(e,t){if(this._bSuspendUpdateAnalyticalInfo){return}const o=this.getBinding();if(o){const n=this._getColumnInformation();const i=o.getNumberOfExpandedLevels()||0;if(i>this._aGroupedColumns.length){o.setNumberOfExpandedLevels(0)}o.updateAnalyticalInfo(n,t);this._updateTotalRow(e);if(!e){this._getRowContexts()}}};y.prototype.refreshRows=function(){o.prototype.refreshRows.apply(this,arguments);this._updateTotalRow()};y.prototype._updateTotalRow=function(e){const t=this.getBinding();this.setProperty("rowCountConstraints",{fixedTop:false,fixedBottom:t?t.providesGrandTotal()&&t.hasTotaledMeasures():false},e)};y.prototype._updateTableColumnDetails=function(){if(this._bSuspendUpdateAnalyticalInfo){return}const e=this.getBinding();const t=e&&e.getAnalyticalQueryResult();if(t){const e=this.getColumns();const o=[];let n=[];const i=[];const s={};let a;let l;for(let n=0;n<e.length;n++){a=e[n];a._isLastGroupableLeft=false;a._bLastGroupAndGrouped=false;a._bDependendGrouped=false;if(!a.getVisible()){continue}const r=a.getLeadingProperty();l=t.findDimensionByPropertyName(r);if(l){const e=l.getName();if(!s[e]){s[e]={dimension:l,columns:[a]}}else{s[e].columns.push(a)}if(a.getGrouped()&&o.indexOf(e)===-1){o.push(e)}if(i.indexOf(e)===-1){i.push(e)}}}n=jQuery.grep(i,function(e){return o.indexOf(o,e)===-1});if(o.length>0){jQuery.each(o,function(e,t){jQuery.each(s[t].columns,function(e,t){if(!t.getGrouped()){t._bDependendGrouped=true}})});if(o.length===i.length){l=t.findDimensionByPropertyName(r.getElementById(this._aGroupedColumns[this._aGroupedColumns.length-1]).getLeadingProperty());const e=s[l.getName()].columns;jQuery.each(e,function(e,t){t._bLastGroupAndGrouped=true})}}if(n.length===1){jQuery.each(s[n[0]].columns,function(e,t){t._isLastGroupableLeft=true})}}};y.prototype._getFirstMeasureColumnIndex=function(){const e=this.getBinding();const t=e&&e.getAnalyticalQueryResult();const o=this._getVisibleColumns();if(!t){return-1}for(let e=0;e<o.length;e++){const n=o[e];const i=n.getLeadingProperty();if(t.findMeasureByName(i)||t.findMeasureByPropertyName(i)){return e}}};y.prototype._getTotalRowCount=function(){let e=o.prototype._getTotalRowCount.apply(this,arguments);if(e===1){const t=this.getBinding();const o=t?t.providesGrandTotal()&&t.hasTotaledMeasures():false;if(o){e=0}}return e};y.prototype.getTotalSize=function(){const e=this.getBinding();if(e){return e.getTotalSize()}return 0};y.prototype._onPersoApplied=function(){o.prototype._onPersoApplied.apply(this,arguments);this._aGroupedColumns=[];const e=this.getColumns();for(let t=0,o=e.length;t<o;t++){if(e[t].getGrouped()){this._addGroupedColumn(e[t].getId())}}this._updateColumns()};y.prototype._addGroupedColumn=function(e){if(this._aGroupedColumns.indexOf(e)===-1){this._aGroupedColumns.push(e)}};y.prototype._removeGroupedColumn=function(e){const t=this._aGroupedColumns.indexOf(e);if(t>=0){this._aGroupedColumns.splice(t,1)}};y.prototype.getGroupedColumns=function(){return this._aGroupedColumns};y.prototype.setCollapseRecursive=function(e){this._oProxy.setCollapseRecursive(e);this.setProperty("collapseRecursive",!!e,true);return this};y.prototype.expand=n.prototype.expand;y.prototype.collapse=n.prototype.collapse;y.prototype.expandAll=function(){this._oProxy.expandToLevel(this._aGroupedColumns.length);this.setFirstVisibleRow(0);this._getSelectionPlugin().clearSelection();return this};y.prototype.collapseAll=n.prototype.collapseAll;y.prototype.isExpanded=n.prototype.isExpanded;y.prototype.getAnalyticalInfoOfRow=function(e){const t=this.getBinding();const o=e?e.getRowBindingContext():null;if(!l.isA(e,"sap.ui.table.Row")||e.getParent()!==this||!t||!o){return null}const n=o===t.getGrandTotalContext();let i=null;let s=-1;if(n){i=t.getGrandTotalContextInfo();s=0}else{i=this.getContextInfoByIndex(e.getIndex());if(i){s=i.level}}const r=i&&t.nodeHasChildren&&t.nodeHasChildren(i);const a=!r&&!n&&i&&i.nodeState&&i.nodeState.sum;const p=[];if(a||r){const e=this.getGroupedColumns();if(e.length>0&&s>0&&s<=e.length){for(let t=0;t<s;t++){p.push(e[t])}}}return{grandTotal:n,group:r,groupTotal:a,level:s,context:o,groupedColumns:p}};y.prototype._createLegacySelectionPlugin=function(){return new p};y.prototype._setRowCountConstraints=function(){};y.prototype._getDefaultContextMenu=function(){let e=this.getAggregation("_hiddenDependents").find(e=>e.isA("sap.ui.table.menus.AnalyticalTableContextMenu"));if(!e){e=new s;this.addAggregation("_hiddenDependents",e)}return e};y.prototype._onBindingDataRequested=function(e){if(e.getParameter("__simulateAsyncAnalyticalBinding")){return}const t=this.getBinding();if(!t.bUseBatchRequests){c(this).bPendingRequest=true}o.prototype._onBindingDataRequested.apply(this,arguments)};y.prototype._onBindingDataReceived=function(e){if(e.getParameter("__simulateAsyncAnalyticalBinding")){return}const t=this.getBinding();if(!t.bUseBatchRequests){c(this).bPendingRequest=false}o.prototype._onBindingDataReceived.apply(this,arguments)};y.prototype._isWaitingForData=function(){if(c(this).hasOwnProperty("bPendingRequest")){return c(this).bPendingRequest}else{return o.prototype._isWaitingForData.apply(this,arguments)}};return y});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/Column", ["./utils/TableUtils","./menus/ColumnHeaderMenuAdapter","sap/ui/core/Element","sap/ui/core/library","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/FilterType","sap/ui/model/Sorter","sap/ui/model/Type","sap/ui/model/type/String","sap/base/util/ObjectPath","sap/base/util/JSTokenizer","sap/base/Log"],function(e,t,r,n,o,i,l,s,a,u,p,f,d){"use strict";const g=n.HorizontalAlign;const c=n.SortOrder;const h=n.ValueState;const y={Standard:"Standard",Creation:"Creation"};const m=e.createWeakMapFacade();const b=new window.WeakMap;const T=r.extend("sap.ui.table.Column",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minWidth:{type:"int",group:"Dimension",defaultValue:0},flexible:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},resizable:{type:"boolean",group:"Behavior",defaultValue:true},hAlign:{type:"sap.ui.core.HorizontalAlign",group:"Appearance",defaultValue:g.Begin},sorted:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},sortOrder:{type:"sap.ui.core.SortOrder",group:"Appearance",defaultValue:c.None},sortProperty:{type:"string",group:"Behavior",defaultValue:null},filtered:{type:"boolean",group:"Appearance",defaultValue:false},filterProperty:{type:"string",group:"Behavior",defaultValue:null},filterValue:{type:"string",group:"Behavior",defaultValue:null},filterOperator:{type:"string",group:"Behavior",defaultValue:null},defaultFilterOperator:{type:"string",group:"Behavior",defaultValue:null},filterType:{type:"any",group:"Misc",defaultValue:null},grouped:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},visible:{type:"boolean",group:"Appearance",defaultValue:true},name:{type:"string",group:"Appearance",defaultValue:null},showFilterMenuEntry:{type:"boolean",group:"Appearance",defaultValue:true},showSortMenuEntry:{type:"boolean",group:"Appearance",defaultValue:true},headerSpan:{type:"any",group:"Behavior",defaultValue:1},autoResizable:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"label",aggregations:{label:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},multiLabels:{type:"sap.ui.core.Control",multiple:true,singularName:"multiLabel"},template:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},creationTemplate:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},menu:{type:"sap.ui.unified.Menu",multiple:false}},associations:{headerMenu:{type:"sap.ui.core.IColumnHeaderMenu",multiple:false}},events:{columnMenuOpen:{allowPreventDefault:true,parameters:{menu:{type:"sap.ui.unified.Menu"}}}}}});T._DEFAULT_FILTER_TYPE=new u;T.prototype.init=function(){this.mSkipPropagation={template:true,creationTemplate:true};m(this).oSorter=null;m(this).mCellContentVisibilitySettings=F(this);m(this).bHasDefaultLabel=false;m(this).bHasDefaultTemplate=false;this._initTemplateClonePool()};T.prototype._initTemplateClonePool=function(){this._mTemplateClones=Object.keys(y).reduce(function(e,t){e[t]=[];return e},{})};T.prototype.exit=function(){this._destroyTemplateClones();t.unlink(this)};T.prototype.invalidate=function(t){if(t!==this.getTemplate()&&t!==this.getCreationTemplate()&&!e.isA(t,"sap.ui.table.ColumnMenu")){r.prototype.invalidate.apply(this,arguments)}};T.prototype.setLabel=function(t){let r=t;if(typeof t==="string"){if(m(this).bHasDefaultLabel){this.getLabel().setText(t);return this}r=e._getTableTemplateHelper().createLabel({text:t});m(this).bHasDefaultLabel=true}else if(m(this).bHasDefaultLabel){this.destroyLabel();m(this).bHasDefaultLabel=false}if(r&&r.setIsInColumnHeaderContext){r.setIsInColumnHeaderContext(true)}const n=this.getLabel();if(n&&r!==n&&n.setIsInColumnHeaderContext){n.setIsInColumnHeaderContext(false)}return this.setAggregation("label",r)};T.prototype.setTemplate=function(t){let r=t;const n=this._getTable();const o=this.getTemplate();let i=true;if(typeof t==="string"){if(m(this).bHasDefaulTemplate){this.getTemplate().bindProperty("text",t);i=false}else{r=e._getTableTemplateHelper().createTextView().bindProperty("text",t);m(this).bHasDefaulTemplate=true}}else if(m(this).bHasDefaulTemplate){this.destroyTemplate();m(this).bHasDefaulTemplate=false}if(i){this.setAggregation("template",r,true)}if(this.getVisible()){this.invalidate()}this._destroyTemplateClones("Standard");if(n&&this.getVisible()){if(r){n.invalidateRowsAggregation()}if(!o||!r){const e=n.getCreationRow();if(e){e._update()}}}return this};T.prototype.destroyTemplate=function(){this.destroyAggregation("template");this._destroyTemplateClones("Standard");const e=this._getTable();const t=e?e.getCreationRow():null;if(t){t._update()}return this};T.prototype.setCreationTemplate=function(e){const t=this._getTable();this.setAggregation("creationTemplate",e,true);this._destroyTemplateClones("Creation");if(e&&t&&this.getVisible()){const e=t.getCreationRow();if(e){e._update()}}return this};T.prototype.getCreationTemplate=function(){return this.getAggregation("creationTemplate")};T.prototype.destroyCreationTemplate=function(){this.destroyAggregation("creationTemplate",true);this._destroyTemplateClones("Creation");return this};T.prototype._menuHasItems=function(){const e=this._getTable();const t=(e?e.getEnableColumnFreeze():false)||(e?e.getShowColumnVisibilityMenu():false)||this.isSortableByMenu()||this.isFilterableByMenu()||this.isGroupableByMenu();return t};T.prototype.isFilterableByMenu=function(){return!!(this.getFilterProperty()&&this.getShowFilterMenuEntry())};T.prototype.isSortableByMenu=function(){return!!(this.getSortProperty()&&this.getShowSortMenuEntry())};T.prototype.isGroupableByMenu=function(){const e=this._getTable();return!!(e&&e.getEnableGrouping&&e.getEnableGrouping()&&this.getSortProperty())};T.prototype._isGroupableByMenu=function(){let e=false;e=this.isGroupableByMenu();return e};T.prototype.setSorted=function(e){if(e&&this.getSortOrder()===c.None&&!this.isBound("sortOrder")){this.setSortOrder(c.Ascending)}return this.setProperty("sorted",e)};T.prototype.setFilterValue=function(e){return this.setProperty("filterValue",e,true)};T.prototype.setFilterOperator=function(e){return this.setProperty("filterOperator",e,true)};T.prototype.setDefaultFilterOperator=function(e){return this.setProperty("defaultFilterOperator",e,true)};T.prototype._openHeaderMenu=function(e){const r=this.getHeaderMenuInstance();this._cellPressed=e;t.activateFor(this).then(function(){if(r){r.openBy(e)}})};T.prototype._isHeaderMenuOpen=function(){const e=this.getHeaderMenuInstance();return e?.isOpen()||false};T.prototype._setGrouped=function(e){const t=this._getTable();t.setGroupBy(e?this:null)};T.prototype._isAggregatableByMenu=function(){return false};T.prototype.toggleSort=function(){this.sort(this.getSorted()&&this.getSortOrder()===c.Ascending)};T.prototype.sort=function(e,t){this._sort(e?c.Descending:c.Ascending,t);return this};T.prototype._sort=function(e,t){const r=this._getTable();if(!r||this.getSortProperty()===""){return}const n=r.fireSort({column:this,sortOrder:e,columnAdded:e!==c.None&&t===true});if(!n){return}if(e===c.None){r._removeSortedColumn(this)}else{r.pushSortedColumn(this,t)}this.setSorted(e!==c.None);this.setSortOrder(e);this._updateSorters()};T.prototype._updateSorters=function(){const e=this._getTable();const t=e.getSortedColumns();const r=e.getColumns();const n=this.getSortOrder();for(let e=0,n=r.length;e<n;e++){if(t.indexOf(r[e])<0){r[e].resetProperty("sorted");r[e].resetProperty("sortOrder");delete m(r[e]).oSorter}}if(n!==c.None){m(this).oSorter=new s(this.getSortProperty(),n===c.Descending)}this._applySorters()};T.prototype._applySorters=function(){const e=this._getTable();const t=e.getBinding();if(!t){d.warning("Sorting not performed because no binding present",this);return}const r=e.getSortedColumns();const n=r.map(e=>m(e).oSorter);t.sort(n)};T.prototype._getFilterState=function(){try{this._getFilter();return h.None}catch(e){return h.Error}};T.prototype._getFilter=function(){let e;const t=this.getFilterProperty();const r=this.getFilterValue();let n=this.getFilterOperator();let l;let s;const a=this.getFilterType()||T._DEFAULT_FILTER_TYPE;const p=a instanceof u;let f;if(r){if(!n){f=r.match(/(.*)\s*\.\.\s*(.*)/);if(r.indexOf("=")===0){n=i.EQ;l=r.substr(1)}else if(r.indexOf("!=")===0){n=i.NE;l=r.substr(2)}else if(r.indexOf("<=")===0){n=i.LE;l=r.substr(2)}else if(r.indexOf("<")===0){n=i.LT;l=r.substr(1)}else if(r.indexOf(">=")===0){n=i.GE;l=r.substr(2)}else if(r.indexOf(">")===0){n=i.GT;l=r.substr(1)}else if(f){if(f[1]&&f[2]){n=i.BT;l=f[1];s=f[2]}else if(f[1]&&!f[2]){n=i.GE;l=f[1]}else{n=i.LE;l=f[2]}}else if(p&&r.indexOf("*")===0&&r.lastIndexOf("*")===r.length-1){n=i.Contains;l=r.substr(1,r.length-2)}else if(p&&r.indexOf("*")===0){n=i.EndsWith;l=r.substr(1)}else if(p&&r.lastIndexOf("*")===r.length-1){n=i.StartsWith;l=r.substr(0,r.length-1)}else{if(this.getDefaultFilterOperator()){n=this.getDefaultFilterOperator()}else if(p){n=i.Contains}else{n=i.EQ}l=r.substr(0)}if(!s){e=new o(t,n,this._parseFilterValue(l))}else{e=new o(t,n,this._parseFilterValue(l),this._parseFilterValue(s))}}else{e=new o(t,n,this._parseFilterValue(r))}}return e};T.prototype.filter=function(t){const r=this._getTable();if(!r?.getBinding()||this.getFilterProperty()===""){return}const n=r.fireFilter({column:this,value:t});if(!n){return}const o=[];const i=r.getColumns();this.setFiltered(!!t);this.setFilterValue(t);for(let t=0,r=i.length;t<r;t++){const r=i[t];let n;let l;try{n=r._getFilter();l=h.None}catch(e){l=h.Error}if(n){o.push(n)}e.Hook.call(this._getTable(),e.Hook.Keys.Column.SetFilterState,r,l)}r.getBinding().filter(o,l.Control)};T.prototype._parseFilterValue=function(e){const t=this.getFilterType();if(t){if(typeof t==="function"){e=t(e)}else{e=t.parseValue(e,"string")}}return e};T.prototype.shouldRender=function(){let e=this.getVisible()&&this.getTemplate()!=null;e=e&&!this.getGrouped();return e};T.prototype.setProperty=function(e,t){const n=this._getTable();const o=n&&this.getProperty(e)!==t;const i=o&&e==="visible";const l=o&&(e==="visible"||e==="headerSpan");const s=r.prototype.setProperty.apply(this,arguments);if(i){n.invalidateRowsAggregation();const e=n.getCreationRow();if(e){e._update()}}if(l){n._invalidateComputedFixedColumnCount()}return s};T.prototype.setFilterType=function(e){let t=e;if(typeof e==="string"){try{const r=f.parseJS(e);if(typeof r.type==="string"){let n=sap.ui.require(r.type.replaceAll(".","/"));if(!n){n=p.get(e)}t=n&&new n(r.formatOptions,r.constraints)}}catch(r){let n=sap.ui.require(e.replaceAll(".","/"));if(!n){n=p.get(e)}t=n&&new n}if(!(t instanceof a)){d.error("The filter type is not an instance of sap.ui.model.Type! Ignoring the filter type!");t=undefined}}this.setProperty("filterType",t,true);return this};T.prototype.getIndex=function(){const e=this._getTable();if(e){return e.indexOfColumn(this)}else{return-1}};T.prototype.isDragAllowed=function(t){return e.Column.isColumnMovable(this,true)};T.prototype._getFreeTemplateClone=function(e){const t=this._mTemplateClones[e];let r=null;if(!t){return null}for(let e=0;e<t.length;e++){if(!t[e]||t[e].bIsDestroyed){t.splice(e,1);e--}else if(!r&&!t[e].getParent()){r=t[e]}}return r};T.prototype.getTemplateClone=function(e,t){if(typeof e!=="number"||this.getTemplate()==null){return null}const r=t==null?"Standard":t;let n=this._getFreeTemplateClone(r);if(!n&&y.hasOwnProperty(r)){const e=this["get"+(r==="Standard"?"":r)+"Template"];const t=e.call(this);if(t){n=t.clone();if(!n.getFieldHelpDisplay()){n.setFieldHelpDisplay(this)}this._mTemplateClones[r].push(n)}}if(n){b.set(n,this);const e=this._getTable();if(e){e._getAccExtension().addColumnHeaderLabel(this,n)}}return n};function C(e){for(let t=0;t<e.length;t++){if(e[t]!=null&&!e[t].bIsDestroyed){e[t].destroy()}}}T.prototype._destroyTemplateClones=function(e){if(e==null){for(const e in y){C(this._mTemplateClones[e])}this._initTemplateClonePool()}else{C(this._mTemplateClones[e]);this._mTemplateClones[e]=[]}};T.prototype._getTable=function(){const t=this.getParent();return e.isA(t,"sap.ui.table.Table")?t:null};T.prototype._setCellContentVisibilitySettings=function(e){_(e);m(this).mCellContentVisibilitySettings=F(this,e)};T.prototype._getCellContentVisibilitySettings=function(){return m(this).mCellContentVisibilitySettings};T.prototype.getHeaderMenuInstance=function(){return r.getElementById(this.getHeaderMenu())};function _(e){if(e==null){return}S(e,null,false,["standard","groupHeader","summary"]);S(e.standard,"standard",true);S(e.groupHeader,"groupHeader",true,["nonExpandable","expanded","collapsed"]);S(e.summary,"summary",true,["group","total"])}function S(e,t,r,n){if(e!=null&&!(r&&typeof e==="boolean"||n&&typeof e==="object")){throw new Error("Invalid value"+(t?" for '"+t+"'":""))}if(n&&e!=null&&typeof e==="object"){Object.keys(e).forEach(function(r){if(n.includes(r)){if(t!=null){S(e[r],t+"."+r,true)}}else{throw new Error("Unsupported setting '"+(t?t+".":"")+r+"'")}})}}function F(e,t){t=t?t:{};return{standard:V(t.standard),groupHeader:{nonExpandable:V(t.groupHeader,"nonExpandable"),expanded:V(t.groupHeader,"expanded"),collapsed:V(t.groupHeader,"collapsed")},summary:{group:V(t.summary,"group"),total:V(t.summary,"total")}}}function V(e,t){if(typeof e==="boolean"){return e}else if(t&&e){return e[t]!==false}else{return true}}T.ofCell=function(e){return b.get(e)||null};T.prototype.autoResize=function(){if(!this.getDomRef()){throw new Error("Column is not rendered")}e.Column.autoResizeColumn(this)};T.prototype.getFieldHelpInfo=function(){return{label:e.Column.getHeaderText(this)}};return T});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/ColumnMenu", ["./library","sap/ui/core/Element","sap/ui/unified/Menu","sap/ui/unified/MenuItem","sap/ui/unified/MenuTextFieldItem","sap/ui/unified/MenuRenderer","./utils/TableUtils","sap/base/assert","sap/ui/thirdparty/jquery"],function(t,e,i,n,o,s,u,l,jQuery){"use strict";const r=new window.WeakMap;const a=i.extend("sap.ui.table.ColumnMenu",{metadata:{library:"sap.ui.table"},renderer:s});a.prototype.init=function(){if(i.prototype.init){i.prototype.init.apply(this,arguments)}this.addStyleClass("sapUiTableColumnMenu");this._bInvalidated=true;this._iPopupClosedTimeoutId=null};a.prototype.exit=function(){if(i.prototype.exit){i.prototype.exit.apply(this,arguments)}window.clearTimeout(this._iPopupClosedTimeoutId);a._destroyColumnVisibilityMenuItem(this._getTable())};a.prototype.onThemeChanged=function(){if(this.getDomRef()){this._invalidate()}};a.prototype.setParent=function(t){this._invalidate();return i.prototype.setParent.apply(this,arguments)};a.prototype._getColumn=function(){const t=this.getParent();return u.isA(t,"sap.ui.table.Column")?t:null};a.prototype._getTable=function(){const t=this._getColumn();return t?t._getTable():null};a._destroyColumnVisibilityMenuItem=function(t){if(!t||!t._oColumnVisibilityMenuItem){return}t._oColumnVisibilityMenuItem.destroy();t._oColumnVisibilityMenuItem=null};a.prototype._removeColumnVisibilityFromAggregation=function(){const t=this._getTable();if(!t||t._oColumnVisibilityMenuItem){return}this.removeAggregation("items",t._oColumnVisibilityMenuItem,true)};a.prototype._invalidate=function(){this._removeColumnVisibilityFromAggregation();this.destroyItems();this._bInvalidated=true};a.prototype.open=function(){if(!this._bInvalidated&&this._getColumn()){this._addColumnVisibilityMenuItem()}if(this._bInvalidated){this._bInvalidated=false;this._addMenuItems()}if(this.getItems().length>0){this._lastFocusedDomRef=arguments[4];i.prototype.open.apply(this,arguments)}};a.prototype._addMenuItems=function(){if(this._getColumn()){this._addSortMenuItem(false);this._addSortMenuItem(true);this._addFilterMenuItem();this._addGroupMenuItem();this._addFreezeMenuItem();this._addColumnVisibilityMenuItem()}};a.prototype._addSortMenuItem=function(t){const e=this._getColumn();if(e.isSortableByMenu()){const i=t?"desc":"asc";const n=t?"sort-descending":"sort-ascending";this.addItem(this._createMenuItem(i,"TBL_SORT_"+i.toUpperCase(),n,function(i){e.sort(t,i.getParameter("ctrlKey")===true)}))}};a.prototype._addFilterMenuItem=function(){const t=this._getColumn();if(t.isFilterableByMenu()){const e=t.getParent();const i=e&&e.getEnableCustomFilter();if(i){this.addItem(this._createMenuItem("filter","TBL_FILTER_ITEM","filter",function(){e.fireCustomFilter({column:t})}))}else{this.addItem(this._createMenuTextFieldItem("filter","TBL_FILTER","filter",t.getFilterValue(),function(){t.filter(this.getValue())}))}}};a.prototype._addGroupMenuItem=function(){const t=this._getColumn();if(t.isGroupableByMenu()){const e=this._getTable();this.addItem(this._createMenuItem("group","TBL_GROUP",null,function(){let i;e.setGroupBy(t);if(u.isNoDataVisible(e)){i=e.getDomRef("noDataCnt")}else{i=e.getDomRef("rowsel0")}if(i){i.focus()}}))}};a.prototype._addFreezeMenuItem=function(){const t=this._getColumn();const e=this._getTable();const i=e&&e.getEnableColumnFreeze();if(i){const i=t.getIndex();const n=i+u.Column.getHeaderSpan(t)===e.getComputedFixedColumnCount();this.addItem(this._createMenuItem("freeze",n?"TBL_UNFREEZE":"TBL_FREEZE",null,function(){const o=e.fireColumnFreeze({column:t});if(o){if(n){e.setFixedColumnCount(0)}else{e.setFixedColumnCount(i+1)}}}))}};a.prototype._addColumnVisibilityMenuItem=function(){const t=this._getTable();if(t&&t.getShowColumnVisibilityMenu()){if(!t._oColumnVisibilityMenuItem||t._oColumnVisibilityMenuItem.bIsDestroyed){t._oColumnVisibilityMenuItem=this._createMenuItem("column-visibilty","TBL_COLUMNS");const e=new i(t._oColumnVisibilityMenuItem.getId()+"-menu");t._oColumnVisibilityMenuItem.setSubmenu(e)}this.addItem(t._oColumnVisibilityMenuItem);this._updateColumnVisibilityMenuItem()}};a.prototype._createColumnVisibilityMenuItem=function(t){const e=this._getTable();const i=u.Column.getHeaderText(t);return new n({text:i,icon:t.getVisible()?"sap-icon://accept":null,ariaLabelledBy:[e.getId()+(t.getVisible()?"-ariahidecolmenu":"-ariashowcolmenu")],select:jQuery.proxy(function(i){const n=!t.getVisible();if(n||u.getVisibleColumnCount(e)>1){let i=true;if(u.isA(e,"sap.ui.table.Table")){i=e.fireColumnVisibility({column:t,newVisible:n})}if(i){if(e.getFocusDomRef().getAttribute("id")===t.getId()){const i=e._getVisibleColumns();i[Math.min(i.indexOf(t)+1,u.getVisibleColumnCount(e)-2)].focus()}t.setVisible(n)}}},this)})};a.prototype._createMenuItem=function(t,e,i,o){return new n(this.getId()+"-"+t,{text:u.getResourceText(e),icon:i?"sap-icon://"+i:null,select:o||function(){}})};a.prototype._createMenuTextFieldItem=function(t,e,i,n,s){s=s||function(){};return new o(this.getId()+"-"+t,{label:u.getResourceText(e),icon:i?"sap-icon://"+i:null,value:n,select:s||function(){}})};a.prototype._setFilterValue=function(t){const i=this.getParent();const n=i?i.getParent():undefined;const o=e.getElementById(this.getId()+"-filter");if(o&&o.setValue&&(n&&!n.getEnableCustomFilter())){o.setValue(t)}return this};a.prototype._setFilterState=function(t){const i=this.getParent();const n=i?i.getParent():undefined;const o=e.getElementById(this.getId()+"-filter");if(o&&o.setValueState&&(n&&!n.getEnableCustomFilter())){o.setValueState(t)}return this};function m(t){let e=t.getColumns();if(t.getColumnVisibilityMenuSorter&&typeof t.getColumnVisibilityMenuSorter==="function"){const i=t.getColumnVisibilityMenuSorter();if(typeof i==="function"){e=e.sort(i)}}return e}function c(t,e){if(e.isA("sap.ui.table.AnalyticalColumn")){const i=t.getAnalyticalQueryResult();const n=i.getEntityType();const o=t.getModel().getProperty("/#"+n.getTypeDescription().name+"/"+e.getLeadingProperty()+"/sap:visible");if(o&&(o.value==="false"||o.value===false)){return true}}return false}a.prototype._updateColumnVisibilityMenuItem=function(){const t=this._getTable();if(!t||!t._oColumnVisibilityMenuItem){return}const e=t._oColumnVisibilityMenuItem.getSubmenu();if(!e){return}const i=m(t);let n=e.getItems();const o=t._getVisibleColumns();const s=t.getBinding();const l=u.isA(s,"sap.ui.model.analytics.AnalyticalBinding");for(let u=0;u<i.length;u++){const a=i[u];if(l){if(c(s,a)){continue}}let m=r.get(a);if(!m||m.bIsDestroyed){m=this._createColumnVisibilityMenuItem(a);e.insertItem(m,u);r.set(a,m)}else{const t=n.indexOf(m);if(u!==t){e.removeItem(m);e.insertItem(m,u)}}const d=o.indexOf(a)>-1;const p=d?"sap-icon://accept":"";n=e.getItems();n[u].setProperty("icon",p);n[u].setEnabled(!d||o.length>1);n[u].removeAllAriaLabelledBy();n[u].addAriaLabelledBy(t.getId()+(d?"-ariahidecolmenu":"-ariashowcolmenu"))}for(let t=n.length;t>i.length;t--){n[t-1].destroy()}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/CreationRow", ["./CreationRowRenderer","./Column","./utils/TableUtils","sap/ui/core/Control","sap/m/library","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/Button"],function(t,e,o,n,l,i,r,s){"use strict";const a=n.extend("sap.ui.table.CreationRow",{metadata:{library:"sap.ui.table",properties:{applyEnabled:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell"},toolbar:{type:"sap.ui.core.Toolbar",multiple:false},_defaultToolbar:{type:"sap.ui.core.Toolbar",multiple:false,visibility:"hidden"}},events:{apply:{allowPreventDefault:true}}},renderer:t});a.prototype.setApplyEnabled=function(t){this.setProperty("applyEnabled",t,true);this._updateDefaultToolbar();return this};a.prototype.setVisible=function(t){const e=this.getVisible();const o=this.getTable();this.setProperty("visible",t);if(e!==t&&o){o.invalidate()}return this};a.prototype.setParent=function(t){n.prototype.setParent.apply(this,arguments);this._update();return this};a.prototype.resetFocus=function(){const t=o.getFirstInteractiveElement(this);if(t){t.focus();if(t instanceof window.HTMLInputElement){t.select()}return true}return false};a.prototype.getFocusDomRef=function(){const t=o.getFirstInteractiveElement(this);if(t){return t}return n.prototype.getFocusDomRef.apply(this,arguments)};a.prototype._fireApply=function(){let t=false;if(this.fireApply()){t=this.resetFocus()}return t};function u(t,e){const o=document.activeElement;t.getTable().getDomRef("focusDummy").focus();e.setMarked();window.setTimeout(function(){if(!t._fireApply()){o.focus()}},0)}a.prototype.onsapenter=function(t){if(this.getApplyEnabled()&&!t.isMarked()){u(this,t)}};a.prototype.onsapentermodifiers=function(t){if(this.getApplyEnabled()&&(t.metaKey||t.ctrlKey)){u(this,t)}};function p(t){return new i(t.getId()+"-tb",{content:[new r,new s(t.getId()+"-applyBtn",{text:o.getResourceText("TBL_CREATIONROW_APPLY"),enabled:t.getApplyEnabled(),press:function(){t._fireApply()}})],style:l.ToolbarStyle.Clear,ariaLabelledBy:[t.getId()+"-label"]})}a.prototype._getToolbar=function(){let t=this.getToolbar();if(!t){let e=this.getAggregation("_defaultToolbar");if(!e){e=p(this);this.setAggregation("_defaultToolbar",e,true)}t=e;if(t.data("sap-ui-table-invalid")){this._updateDefaultToolbar()}}return t};a.prototype._updateDefaultToolbar=function(){const t=this.getAggregation("_defaultToolbar");if(this.getToolbar()){if(t){t.data("sap-ui-table-invalid",true)}return}if(!t){return}const e=t.getContent()[1];e.setEnabled(this.getApplyEnabled());t.data("sap-ui-table-invalid",null)};a.prototype._getCell=function(t){const o=this.getCells();const n=o.filter(function(o){return e.ofCell(o).getIndex()===t})[0];if(!n){return null}return n};a.prototype._getCellDomRef=function(t){const e=this._getCell(t);const n=e?e.getDomRef():null;const l=o.getCell(this.getTable(),n,true);if(!l){return null}return l};a.prototype._focusCell=function(t){const e=this._getCellDomRef(t);const n=o.getInteractiveElements(e);if(n){n[0].focus();if(n[0]instanceof window.HTMLInputElement){n[0].select()}return true}return false};a.prototype._takeOverKeyboardHandling=function(t){const e=this.getTable();const n=e?e.getDomRef():null;if(!n||!n.contains(document.activeElement)){return false}const l=o.getCell(this.getTable(),document.activeElement);const i=o.getCellInfo(l);let r=false;if(i.columnIndex!=null&&i.columnIndex>=0){r=this._focusCell(i.columnIndex)}else{r=this.resetFocus()}if(r&&t){t.preventDefault()}return r};a.prototype._update=function(){const t=this.getTable();if(!t){this.removeAllCells();return}const e=t.getColumns();this.removeAllCells();for(let t=0,o=e.length;t<o;t++){if(e[t].getVisible()){this.addCell(e[t].getTemplateClone(t,"Creation"))}}};a.prototype.getTable=function(){const t=this.getParent();return o.isA(t,"sap.ui.table.Table")?t:null};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/CreationRowRenderer", ["./TableRenderer","./utils/TableUtils","sap/ui/core/Renderer"],function(e,t,n){"use strict";const o={apiVersion:2};o.render=function(e,t){const n=t.getTable();if(!n){return}e.openStart("div",t);e.attr("data-sap-ui-fastnavgroup","true");n._getAccRenderExtension().writeAriaAttributesFor(e,n,"CreationRow",{creationRow:t});e.class("sapUiTableCreationRow");e.openEnd();this.renderBeginSection(e);this.renderMiddleSection(e,t,n);this.renderEndSection(e,n);n._getAccRenderExtension().writeAccCreationRowText(e,n,t);e.close("div")};o.renderBeginSection=function(e){e.openStart("div");e.class("sapUiTableCreationRowBeginSection");e.class("sapUiTableRowHdrScr");e.openEnd();e.close("div")};o.renderMiddleSection=function(e,t,n){e.openStart("div");e.class("sapUiTableCreationRowMiddleSection");e.openEnd();this.renderForm(e,t,n);this.renderToolbar(e,t);e.close("div")};o.renderEndSection=function(e,n){e.openStart("div");e.class("sapUiTableCreationRowEndSection");if(t.hasRowActions(n)){e.class("sapUiTableCell");e.class("sapUiTableRowActionHeaderCell")}else{e.class("sapUiTableVSbBg")}e.openEnd();e.close("div")};o.renderForm=function(e,t,n){if(t.getCells().length===0){return}e.openStart("div");e.class("sapUiTableCreationRowForm");e.openEnd();if(n.getComputedFixedColumnCount()>0){this.renderRowFormTable(e,n,true)}e.openStart("div");e.class("sapUiTableCtrlScr");e.openEnd();this.renderRowFormTable(e,n,false);e.close("div");e.close("div")};o.renderRowFormTable=function(o,i,s){const l=s?0:i.getComputedFixedColumnCount();const a=s?i.getComputedFixedColumnCount():i.getColumns().length;const r=i.getCreationRow();o.openStart("table");i._getAccRenderExtension().writeAriaAttributesFor(o,i,"Presentation");o.class("sapUiTableCtrl");o.style(s?"width":"min-width",i._getColumnsWidth(l,a)+"px");o.openEnd();o.openStart("thead").openEnd();o.openStart("tr");o.class("sapUiTableCtrlCol");o.openEnd();const d=i.getColumns();const c=new Array(a);let p;let u;let C=!s&&a>l;let b;for(p=l;p<a;p++){u=d[p];b={shouldRender:!!(u&&u.shouldRender())};if(b.shouldRender){let e=u.getWidth();if(t.isVariableWidth(e)){C=false;if(s){u._iFixWidth=u._iFixWidth||160;e=u._iFixWidth+"px"}}else if(s){delete u._iFixWidth}b.width=e}c[p]=b}for(p=l;p<a;p++){u=d[p];b=c[p];if(b.shouldRender){o.openStart("th");o.style("width",b.width);o.attr("data-sap-ui-headcolindex",p);o.attr("data-sap-ui-colid",u.getId());o.openEnd();o.close("th")}}if(C){o.openStart("th").openEnd().close("th")}o.close("tr");o.close("thead");o.openStart("tbody").openEnd();o.openStart("tr");o.class("sapUiTableTr");o.openEnd();const g=r.getCells();const h=e.getColumnsToRender(i,l,a);for(p=l;p<a;p++){u=d[p];b=c[p];if(b.shouldRender){o.openStart("td");o.attr("data-sap-ui-colid",u.getId());const t=r._getCell(p);const l=h.length;const a=l>0&&h[0]===u;const d=l>0&&h[l-1]===u;const c=e.getLastFixedColumnIndex(i);const C=s&c===p;const b=n.getTextAlign(u.getHAlign(),t&&t.getTextDirection&&t.getTextDirection());o.style("text-align",b);o.class("sapUiTableCell");o.class("sapUiTablePseudoCell");if(a){o.class("sapUiTableCellFirst")}if(C){o.class("sapUiTableCellLastFixed")}if(d){o.class("sapUiTableCellLast")}o.openEnd();if(t){o.openStart("div");o.class("sapUiTableCellInner");o.openEnd();e.renderTableCellControl(o,i,t,a);o.close("div")}o.close("td")}}if(!s&&C&&g.length>0){o.openStart("td").class("sapUiTableCellDummy").openEnd().close("td")}o.close("tr");o.close("tbody");o.close("table")};o.renderToolbar=function(e,t){e.renderControl(t._getToolbar())};return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/Row", ["sap/ui/core/Element","./utils/TableUtils","sap/ui/thirdparty/jquery"],function(t,e,jQuery){"use strict";const o=Object.freeze({Standard:"Standard",Summary:"Summary",GroupHeader:"GroupHeader"});function n(){let t=null;let e=o.Standard;let n=false;let i="";let r=false;let s=false;let l=0;Object.defineProperties(this,{context:{get:function(){return t},set:function(e){t=e||null}},Type:{get:function(){return o}},type:{get:function(){return e},set:function(t){if(!(t in o)){throw Error("Is not a valid type for sap.ui.table.Row: "+t)}e=t}},empty:{get:function(){return this.context==null}},contentHidden:{get:function(){return this.empty?true:n},set:function(t){n=t===true}},title:{get:function(){return this.empty?"":i},set:function(t){i=typeof t==="string"?t:""}},expandable:{get:function(){return this.empty?false:s},set:function(t){s=t===true}},expanded:{get:function(){return this.expandable?r:false},set:function(t){r=t===true}},level:{get:function(){return this.empty?0:l},set:function(t){l=typeof t==="number"?Math.max(1,t||1):1}},reset:{value:function(){t=null;e=o.Standard;n=false;i="";s=false;r=false;l=1}}})}const i=new window.WeakMap;function r(t){if(!i.has(t)){i.set(t,Object.seal(new n))}return i.get(t)}const s=t.extend("sap.ui.table.Row",{metadata:{library:"sap.ui.table",defaultAggregation:"cells",aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell"},_rowAction:{type:"sap.ui.table.RowAction",multiple:false,visibility:"hidden"},_settings:{type:"sap.ui.table.RowSettings",multiple:false,visibility:"hidden"}}}});s.prototype.init=function(){this.initDomRefs()};s.prototype.exit=function(){this.initDomRefs()};s.prototype.getFocusInfo=function(){const e=this.getTable();return e?e.getFocusInfo():t.prototype.getFocusInfo.apply(this,arguments)};s.prototype.applyFocusInfo=function(e){const o=this.getTable();if(o){o.applyFocusInfo(e)}else{t.prototype.applyFocusInfo.apply(this,arguments)}return this};s.prototype._setFocus=function(t){const o=e.getFirstInteractiveElement(this);if(t===true&&o){o.focus()}else{this.getDomRef("col0").focus()}};s.prototype.addStyleClass=function(t){this.getDomRefs(true).row.addClass(t)};s.prototype.removeStyleClass=function(t){this.getDomRefs(true).row.removeClass(t)};s.prototype.initDomRefs=function(){this._mDomRefs={}};s.prototype.getIndex=function(){const t=this.getTable();if(!t){return-1}const e=t.indexOfRow(this);const o=t._getRowCounts();if(o.fixedTop>0&&e<o.fixedTop){return e}if(o.fixedBottom>0&&e>=o.count-o.fixedBottom){const n=t._getTotalRowCount();if(n>=o.count){return n-(o.count-e)}else{return e}}return t._getFirstRenderedRowIndex()+e};s.prototype.getDomRefs=function(t,e){t=t===true;e=e===true;const o=t?"jQuery":"dom";const n=this._mDomRefs;if(!n[o]){const e=this.getTable();const i=function(e){const o=document.getElementById(e);if(o){return t?jQuery(o):o}return null};const r=function(e){if(e){return t?e.parent():e.parentNode}return null};n[o]={};if(e){const t=e.indexOfRow(this);n[o].rowSelector=i(e.getId()+"-rowsel"+t);n[o].rowAction=i(e.getId()+"-rowact"+t)}n[o].rowHeaderPart=r(n[o].rowSelector);n[o].rowFixedPart=i(this.getId()+"-fixed");n[o].rowScrollPart=i(this.getId());n[o].rowActionPart=r(n[o].rowAction);n[o].rowSelectorText=i(this.getId()+"-rowselecttext");if(t){n[o].row=jQuery().add(n[o].rowHeaderPart).add(n[o].rowFixedPart).add(n[o].rowScrollPart).add(n[o].rowActionPart)}else{n[o].row=[n[o].rowHeaderPart,n[o].rowFixedPart,n[o].rowScrollPart,n[o].rowActionPart].filter(Boolean)}}const i=n[o];if(e){return Object.keys(i).map(function(t){return t==="row"?null:i[t]}).filter(Boolean)}return i};s.prototype._updateSelection=function(){const t=this.getTable();const e=this._isSelected();if(e){this.addStyleClass("sapUiTableRowSel")}else{this.removeStyleClass("sapUiTableRowSel")}t._getAccExtension().updateSelectionStateOfRow(this);t._getSyncExtension?.().syncRowSelection(t.indexOfRow(this),e)};s.prototype.setRowBindingContext=function(t,o){const n=o.getBindingInfo("rows");const i=n?n.model:undefined;const s=r(this);s.reset();s.context=t;if(s.context){e.Hook.call(o,e.Hook.Keys.Row.UpdateState,s)}this.setBindingContext(s.context,i);this.getDomRefs(true).row.toggleClass("sapUiTableRowHidden",this.isContentHidden());this._updateTableCells(o)};s.prototype.getRowBindingContext=function(){return r(this).context};s.prototype.setBindingContext=function(e,o){return t.prototype.setBindingContext.call(this,e||null,o)};s.prototype._updateTableCells=function(t){const e=this.getCells();const o=this.getIndex();const n=!!t._updateTableCell;let i;let r;let s;const l=this.getRowBindingContext();for(let a=0;a<e.length;a++){i=e[a];s=!!i._updateTableCell;r=s||n?i.$().closest("td"):null;if(s){i._updateTableCell(i,l,r,o)}if(n){t._updateTableCell(i,l,r,o)}}};s.prototype.getType=function(){return r(this).type};s.prototype.isGroupHeader=function(){return this.getType()===o.GroupHeader};s.prototype.isSummary=function(){return this.getType()===o.Summary};s.prototype.isGroupSummary=function(){return this.isSummary()&&this.getLevel()>1};s.prototype.isTotalSummary=function(){return this.isSummary()&&this.getLevel()===1};s.prototype.isEmpty=function(){return r(this).empty};s.prototype.isContentHidden=function(){return r(this).contentHidden};s.prototype.getLevel=function(){return r(this).level};s.prototype.getTitle=function(){return r(this).title};s.prototype.isExpandable=function(){return r(this).expandable};s.prototype.isExpanded=function(){return r(this).expanded};s.prototype.destroy=function(){this.removeAllCells();return t.prototype.destroy.apply(this,arguments)};s.prototype.invalidate=function(){};s.prototype.getDragGhost=function(){const t=this.getTable();const e=t.getDomRef();const o=this.getDomRefs();const n=e.cloneNode();let i;let r;const s=t._getSelectionPlugin().getSelectedCount();function l(t){t.removeAttribute("id");t.removeAttribute("data-sap-ui");t.removeAttribute("data-sap-ui-related");const e=t.children.length;for(let o=0;o<e;o++){l(t.children[o])}}function a(t,e){const o=t.cloneNode();const n=t.querySelector("thead").cloneNode(true);const i=t.querySelector("tbody").cloneNode();const r=e.cloneNode(true);i.appendChild(r);o.appendChild(n);o.appendChild(i);return o}n.classList.add("sapUiTableRowGhost");n.classList.remove("sapUiTableVScr");n.classList.remove("sapUiTableHScr");n.style.width=e.getBoundingClientRect().width+"px";if(o.rowSelector){i=t.getDomRef("sapUiTableRowHdrScr").cloneNode();r=o.rowSelector.cloneNode(true);i.appendChild(r);n.appendChild(i)}if(o.rowFixedPart){i=t.getDomRef("sapUiTableCtrlScrFixed").cloneNode();r=a(t.getDomRef("table-fixed"),o.rowFixedPart);i.appendChild(r);n.appendChild(i)}if(o.rowScrollPart){const e=t.getDomRef("sapUiTableCtrlScr");i=e.cloneNode();r=a(t.getDomRef("table"),o.rowScrollPart);i.appendChild(t.getDomRef("tableCtrlCnt").cloneNode());i.firstChild.appendChild(r);n.appendChild(i)}if(o.rowAction){i=t.getDomRef("sapUiTableRowActionScr").cloneNode();r=o.rowAction.cloneNode(true);i.appendChild(r);n.appendChild(i)}if(s>1){i=document.createElement("div");i.classList.add("sapUiTableRowGhostCount");const t=document.createElement("div");t.textContent=s;i.appendChild(t);n.appendChild(i)}l(n);return n};s.prototype._setSelected=function(t){this.getTable()._getSelectionPlugin().setSelected(this,t)};s.prototype._isSelected=function(){return this.getTable()._getSelectionPlugin().isSelected(this)};s.prototype._setHovered=function(t){const e=this.getTable();if(t){this.addStyleClass("sapUiTableRowHvr")}else{this.removeStyleClass("sapUiTableRowHvr")}e._getSyncExtension?.().syncRowHover(e.indexOfRow(this),t)};s.prototype.getRowAction=function(){return this.getAggregation("_rowAction")};s.prototype.getTable=function(){const t=this.getParent();return e.isA(t,"sap.ui.table.Table")?t:null};s.prototype.expand=function(){if(this.isExpandable()&&!this.isExpanded()){e.Hook.call(this.getTable(),e.Hook.Keys.Row.Expand,this)}};s.prototype.collapse=function(){if(this.isExpandable()&&this.isExpanded()){e.Hook.call(this.getTable(),e.Hook.Keys.Row.Collapse,this)}};s.prototype.toggleExpandedState=function(){if(this.isExpanded()){this.collapse()}else{this.expand()}};s.prototype.Type=o;return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/RowAction", ["./library","./utils/TableUtils","./RowActionRenderer","sap/ui/core/Control","sap/ui/core/Icon","sap/ui/unified/Menu","sap/ui/core/Popup"],function(e,t,i,s,o,n,a){"use strict";const c=s.extend("sap.ui.table.RowAction",{metadata:{library:"sap.ui.table",properties:{visible:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.table.RowActionItem",multiple:true},_icons:{type:"sap.ui.core.Icon",multiple:true,visibility:"hidden"},_menu:{type:"sap.ui.unified.Menu",multiple:false,visibility:"hidden"}},events:{}},renderer:i});c.prototype.init=function(){this._bFixedLayout=true;this._aActions=["",""];this._iLastCloseTime=0;this.addAggregation("_icons",new o(this.getId()+"-icon0",{decorative:false,press:[this._onIconPress,this]}).addStyleClass("sapUiTableActionIcon")).addDelegate({onAfterRendering:function(){const e=this.getAggregation("_icons")[0].getDomRef();if(this._aActions[0]==="menu"){e.setAttribute("aria-haspopup","menu")}else{e.removeAttribute("aria-haspopup")}}},this);this.addAggregation("_icons",new o(this.getId()+"-icon1",{decorative:false,press:[this._onIconPress,this]}).addStyleClass("sapUiTableActionIcon")).addDelegate({onAfterRendering:function(){const e=this.getAggregation("_icons")[1].getDomRef();if(this._aActions[1]==="menu"){e.setAttribute("aria-haspopup","menu")}else{e.removeAttribute("aria-haspopup")}}},this)};c.prototype.onBeforeRendering=function(){const e=this.getRow();const i=e?e.getTable():null;const s=this.getAggregation("_icons");const o=this.getItems();const n=this._getVisibleItems();const a=n.length;const c=this._getSize();const r=i?i.getId()+"-rowacthdr":"";if(this._bFixedLayout&&a===1&&c===2&&o.length>1&&n[0]===o[1]){n[0]._syncIcon(s[1]);this._aActions=["","action_fixed"]}else if(a===0||c===0){this._aActions=["",""]}else if(a===1&&c>0){n[0]._syncIcon(s[0]);this._aActions=["action",""]}else if(a===2&&c===2){n[0]._syncIcon(s[0]);n[1]._syncIcon(s[1]);this._aActions=["action","action"]}else if(a>2&&c===2){n[0]._syncIcon(s[0]);s[1].setSrc("sap-icon://overflow");s[1].setTooltip(t.getResourceText("TBL_ROW_ACTION_MORE"));this._aActions=["action","menu"]}else{s[0].setSrc("sap-icon://overflow");s[0].setTooltip(t.getResourceText("TBL_ROW_ACTION_MORE"));this._aActions=["menu",""]}s.forEach(function(e,t){e.removeAllAriaLabelledBy();e.removeStyleClass("sapUiTableActionHidden");if(r){e.addAriaLabelledBy(r)}if(this._aActions[t]===""){e.addStyleClass("sapUiTableActionHidden")}}.bind(this))};c.prototype.getAccessibilityInfo=function(){const e=this.getRow();const i=this._getVisibleItems().length;const s=this._getSize();const o=this.getVisible()&&i>0&&s>0&&(!e||!e.isContentHidden()&&!e.isGroupHeader()&&!e.isSummary());let n;if(o){n=t.getResourceText(i===1?"TBL_ROW_ACTION_SINGLE_ACTION":"TBL_ROW_ACTION_MULTIPLE_ACTION",[i])}else{n=t.getResourceText("TBL_ROW_ACTION_NO_ACTION")}return{focusable:o,enabled:o,description:n}};c.prototype._getVisibleItems=function(){return this.getItems().filter(function(e){return e.getVisible()})};c.prototype.getRow=function(){const e=this.getParent();return t.isA(e,"sap.ui.table.Row")?e:null};c.prototype._getSize=function(){const e=this.getRow();const t=e?e.getTable():null;return t?t.getRowActionCount():2};c.prototype._onIconPress=function(e){const t=e.getSource();const i=this.indexOfAggregation("_icons",t);const s=this._aActions[i];if(s==="action"){this._getVisibleItems()[i]._firePress()}else if(s==="action_fixed"){this._getVisibleItems()[0]._firePress()}else if(s==="menu"){let e=this.getAggregation("_menu");if(!e){e=new n;this.setAggregation("_menu",e,true);e.getPopup().attachClosed(function(){this._iLastCloseTime=Date.now()},this)}e.removeAllItems();if(Date.now()-this._iLastCloseTime<500){return}const s=this.getItems();for(let t=i;t<s.length;t++){e.addItem(s[t]._getMenuItem())}e.open(null,t,a.Dock.EndTop,a.Dock.EndBottom,t)}};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/RowActionItem", ["./library","./utils/TableUtils","sap/ui/core/Element","sap/ui/unified/MenuItem","sap/ui/core/IconPool"],function(t,e,i,o,n){"use strict";const s=t.RowActionType;const r=i.extend("sap.ui.table.RowActionItem",{metadata:{library:"sap.ui.table",properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},visible:{type:"boolean",group:"Misc",defaultValue:true},text:{type:"string",group:"Misc",defaultValue:""},type:{type:"sap.ui.table.RowActionType",group:"Behavior",defaultValue:s.Custom}},events:{press:{parameters:{item:{type:"sap.ui.table.RowActionItem"},row:{type:"sap.ui.table.Row"}}}}}});r.prototype.init=function(){this._oMenuItem=null};r.prototype.exit=function(){if(this._oMenuItem){this._oMenuItem.destroy();this._oMenuItem=null}};r.prototype.getRowAction=function(){const t=this.getParent();return e.isA(t,"sap.ui.table.RowAction")?t:null};r.prototype._firePress=function(){const t=this.getRowAction();this.firePress({item:this,row:t?t.getRow():null})};r.prototype._getMenuItem=function(){if(!this._oMenuItem){this._oMenuItem=new o({select:[this._firePress,this]})}this._oMenuItem.setIcon(this._getIcon());this._oMenuItem.setVisible(this.getVisible());this._oMenuItem.setText(this._getText(false));return this._oMenuItem};r.prototype._getIcon=function(){const t=this.getIcon();if(t){return t}if(this.getType()===s.Navigation){return n.getIconURI(e.ThemeParameters.navigationIcon)}if(this.getType()===s.Delete){return n.getIconURI(e.ThemeParameters.deleteIcon)}return null};r.prototype._getText=function(t){const i=t?this.getTooltip_AsString()||this.getText():this.getText()||this.getTooltip_AsString();if(i){return i}if(this.getType()===s.Navigation){return e.getResourceText("TBL_ROW_ACTION_NAVIGATE")}if(this.getType()===s.Delete){return e.getResourceText("TBL_ROW_ACTION_DELETE")}return null};r.prototype._syncIcon=function(t){t.setSrc(this._getIcon());t.setTooltip(this._getText(true))};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/RowActionRenderer", [],function(){"use strict";const e={apiVersion:2};e.render=function(e,t){e.openStart("div",t);e.class("sapUiTableAction");if(!t.getRow()){e.style("display","none")}if(!t.getVisible()){e.class("sapUiTableActionHidden")}const n=t.getTooltip_AsString();if(n){e.attr("title",n)}e.openEnd();const i=t.getAggregation("_icons");e.renderControl(i[0]);e.renderControl(i[1]);e.close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/RowSettings", ["sap/ui/core/Element","./utils/TableUtils","sap/ui/base/DataType","./library","sap/ui/core/library","sap/ui/core/message/MessageType"],function(t,e,i,s,o,a){"use strict";const r=o.IndicationColor;const n=t.extend("sap.ui.table.RowSettings",{metadata:{library:"sap.ui.table",properties:{highlight:{type:"string",group:"Appearance",defaultValue:"None"},highlightText:{type:"string",group:"Misc",defaultValue:""},navigated:{type:"boolean",group:"Appearance",defaultValue:false}}}});n.prototype.validateProperty=function(e,s){if(e!=="highlight"||s==null){return t.prototype.validateProperty.apply(this,arguments)}if(!i.getType("sap.ui.core.message.MessageType").isValid(s)&&!i.getType("sap.ui.core.IndicationColor").isValid(s)){throw new Error('"'+s+'" is of type '+typeof s+", expected is a value of the enums sap/ui/core/message/MessageType or sap.ui.core.IndicationColor"+' for property "'+e+'" of '+this)}return s};n.prototype.setHighlight=function(t){const e=this._getRow();const i=e?.getDomRef("highlight");this.setProperty("highlight",t,true);if(!i){return this}for(const t in a){i.classList.remove("sapUiTableRowHighlight"+t)}for(const t in r){i.classList.remove("sapUiTableRowHighlight"+t)}i.classList.add(this._getHighlightCSSClassName());const s=e.getParent();const o=s?s._getAccExtension():null;if(o){o.updateAriaStateOfRowHighlight(this)}return this};n.prototype.setNavigated=function(t){const e=this._getRow();const i=e?.getDomRef("navIndicator");this.setProperty("navigated",t,true);if(!i){return this}if(t){i.classList.add("sapUiTableRowNavigated")}else{i.classList.remove("sapUiTableRowNavigated")}const s=e.getParent();const o=s?s._getAccExtension():null;if(o){o._updateAriaStateOfNavigatedRow(this)}return this};n.prototype.setHighlightText=function(t){const e=this._getRow();const i=e?e.getParent():null;const s=i?i._getAccExtension():null;this.setProperty("highlightText",t,true);if(s){s.updateAriaStateOfRowHighlight(this)}return this};n.prototype._getHighlightCSSClassName=function(){let t=this.getHighlight();if(t==null){t=a.None}return"sapUiTableRowHighlight"+t};n.prototype._getHighlightText=function(){const t=this.getHighlight();if(t===a.None){return""}let i=this.getHighlightText();if(t in a&&i===""){i=e.getResourceText("TBL_ROW_STATE_"+t.toUpperCase())}return i};n.prototype._getRow=function(){const t=this.getParent();if(e.isA(t,"sap.ui.table.Row")){return t}else{return null}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/Table", ["sap/base/i18n/Localization","sap/ui/Device","sap/ui/core/Control","sap/ui/core/ControlBehavior","sap/ui/core/Element","sap/ui/core/util/PasteHelper","sap/ui/model/ChangeReason","sap/ui/model/Filter","sap/ui/model/Sorter","sap/ui/model/BindingMode","./Column","./Row","./library","./utils/TableUtils","./extensions/ExtensionBase","./extensions/Accessibility","./extensions/Keyboard","./extensions/Pointer","./extensions/Scrolling","./extensions/DragAndDrop","./TableRenderer","./rowmodes/Type","./rowmodes/Fixed","./rowmodes/Interactive","./rowmodes/Auto","./plugins/SelectionPlugin","./plugins/SelectionModelSelection","./menus/ContextMenu","sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/core/AnimationMode","sap/ui/core/library"],function(e,t,o,i,n,s,r,l,a,u,d,p,c,h,g,f,m,y,w,b,C,R,_,x,S,T,A,v,jQuery,I,B,M){"use strict";const F=c.GroupEventType;const D=c.SelectionMode;const P=c.SelectionBehavior;const V=M.SortOrder;const E=h.Hook.Keys.Table;const H=h.createWeakMapFacade();const U=o.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",dnd:true,properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},rowHeight:{type:"int",group:"Appearance",defaultValue:null,deprecated:true},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10,deprecated:true},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:D.MultiToggle},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:P.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1,deprecated:true},editable:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:"Scrollbar",deprecated:true},threshold:{type:"int",group:"Behavior",defaultValue:100},scrollThreshold:{type:"int",group:"Behavior",defaultValue:-1},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false,deprecated:true},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:"Fixed",deprecated:true},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5,deprecated:true},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0,deprecated:true},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0,deprecated:true},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false},rowActionCount:{type:"int",group:"Appearance",defaultValue:0},alternateRowColors:{type:"boolean",group:"Appearance",defaultValue:false},rowCountConstraints:{type:"object",visibility:"hidden"}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false,deprecated:true},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false,deprecated:true},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",defaultClass:d,multiple:true,singularName:"column",bindable:"bindable",dnd:{layout:"Horizontal"}},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable",selector:"#{id}-tableCCnt",dnd:true},rowMode:{type:"sap.ui.table.rowmodes.RowMode",multiple:false,altTypes:["sap.ui.table.rowmodes.Type"]},creationRow:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},_noColumnsMessage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},rowActionTemplate:{type:"sap.ui.table.RowAction",multiple:false},rowSettingsTemplate:{type:"sap.ui.table.RowSettings",multiple:false},contextMenu:{type:"sap.ui.core.IContextMenu",multiple:false},groupHeaderRowContextMenu:{type:"sap.ui.core.IContextMenu",multiple:false,visibility:"hidden"},plugins:{type:"sap.ui.table.plugins.SelectionPlugin",multiple:true,singularName:"plugin",deprecated:true},_messageStrip:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_hiddenDependents:{type:"sap.ui.core.Element",multiple:true,visibility:"hidden"}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false,deprecated:true},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"sap.ui.model.Context"},rowIndices:{type:"int[]"},selectAll:{type:"boolean"},userInteraction:{type:"boolean"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.core.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}},deprecated:true},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newVisible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}},deprecated:true},beforeOpenContextMenu:{allowPreventDefault:true,parameters:{rowIndex:{type:"int"},columnIndex:{type:"int"},contextMenu:{type:"sap.ui.core.IContextMenu"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},firstVisibleRowChanged:{parameters:{firstVisibleRow:{type:"int"}}},busyStateChanged:{parameters:{busy:{type:"boolean"}}},paste:{allowPreventDefault:true,parameters:{data:{type:"string[][]"}}},rowsUpdated:{}},designtime:"sap/ui/table/designtime/Table.designtime"},renderer:C});U.prototype.init=function(){this.mSkipPropagation={rowActionTemplate:true,rowSettingsTemplate:true};H(this).iCachedBindingLength=0;H(this).iFirstRenderedRowIndex=0;H(this).iComputedFixedColumnCount=null;this._attachExtensions();this._bRtlMode=e.getRTL();this._bRowsBeingBound=false;this._bContextsAvailable=false;this._bScrolled=false;this._aRowClones=[];this._bRowAggregationInvalid=true;this._mTimeouts={};this._mAnimationFrames={};this._aRowHeights=[];this._aSortedColumns=[];this._aTableHeaders=[];this._bAllowColumnHeaderTextSelection=false;H(this).iPendingRequests=0;this._iBindingLength=null;this._bFirstRendering=true;this._nDevicePixelRatio=window.devicePixelRatio;if(h.isThemeApplied()){h.readThemeParameters()}this._bInvalid=true};U.prototype.applySettings=function(e,t){if(e){const i=["threshold","firstVisibleRow","rowMode"];const n={};i.push("plugins");for(let t=0;t<i.length;t++){const o=i[t];if(o in e){n[o]=e[o];delete e[o]}}if(Object.keys(n).length>0){o.prototype.applySettings.call(this,n,t)}}N(this);o.prototype.applySettings.call(this,e,t)};U.prototype._attachExtensions=function(){if(this._bExtensionsInitialized){return}g.enrich(this,y);g.enrich(this,w);g.enrich(this,m);g.enrich(this,f);g.enrich(this,b);if(t.os.ios){sap.ui.require(["sap/ui/table/extensions/ScrollingIOS"],function(e){if(!this.bIsDestroyed){g.enrich(this,e)}}.bind(this))}this._bExtensionsInitialized=true};U.prototype.exit=function(){this.invalidateRowsAggregation();this._detachExtensions();this._cleanUpTimers();this._detachEvents();ee(this);delete this._aTableHeaders};U.prototype._detachExtensions=function(){g.cleanup(this)};U.prototype.onpaste=function(e){if(e.isMarked()||/^(input|textarea)$/i.test(document.activeElement.tagName)){return}const t=s.getPastedDataAs2DArray(e.originalEvent);if(t.length===0||t[0].length===0){return}this.firePaste({data:t})};U.prototype.onfocusfail=function(){if(this._bReorderInProcess){return undefined}else{return o.prototype.onfocusfail.apply(this,arguments)}};U.prototype.onThemeChanged=function(){h.readThemeParameters();if(this.getDomRef()){this.invalidate()}};U.prototype.onLocalizationChanged=function(t){const o=t.changes||{};const i=o.hasOwnProperty("rtl");const n=o.hasOwnProperty("language");if(i){this._bRtlMode=e.getRTL()}if(n){this._invalidateColumnMenus()}if(i||n){this.invalidate()}};U.prototype.onlocalizationChanged=U.prototype.onLocalizationChanged;U.prototype._collectRowHeights=function(e){const o=this.getDomRef();if(!o){return[]}let i=this._getBaseRowHeight();const n=e?".sapUiTableColHdrTr":".sapUiTableTr";const s=o.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+n);const r=o.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+n);const l=e?h.getHeaderRowCount(this):this.getRows().length;let a=[];const u=t.browser.chrome&&window.devicePixelRatio!==1;if(e){if(this.getColumnHeaderHeight()>0){i=this.getColumnHeaderHeight()}else if(this.getRowMode()){i=this._getDefaultRowHeight()}}for(let e=0;e<l;e++){const t=s[e]?s[e].getBoundingClientRect().height:0;const o=r[e]?r[e].getBoundingClientRect().height:0;const n=Math.max(t,o);if(u){const e=i-n;if(e>0&&e<1){a.push(Math.max(n,i-1));continue}}a.push(Math.max(n,i))}if(a.length>0&&!e){h.dynamicCall(this._getSyncExtension,function(e){const t=e.syncRowHeights(a.slice());if(t&&t.length===a.length){a=t.slice()}})}return a};U.prototype._resetRowHeights=function(){const e=this._getBaseRowHeight();let t="";if(e){t=e+"px"}const o=this.getDomRef("tableCCnt");if(o){const e=o.querySelectorAll(".sapUiTableTr");for(let o=0;o<e.length;o++){e[o].style.height=t}}};U.prototype._resetColumnHeaderHeights=function(){const e=this.getDomRef();if(e){const t=e.querySelectorAll(".sapUiTableColHdrTr");for(let e=0;e<t.length;e++){t[e].style.height=null}}};U.prototype._collectTableSizes=function(){const e={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlScrWidth:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0};const t=this.getDomRef();if(!t){return e}const o=t.querySelector(".sapUiTableCnt");if(o){e.tableCntHeight=o.clientHeight;e.tableCntWidth=o.clientWidth}const i=t.querySelector(".sapUiTableCtrlScroll:not(.sapUiTableCHT)");if(i){e.tableCtrlScrollWidth=i.getBoundingClientRect().width}const n=t.querySelector(".sapUiTableRowHdrScr");if(n){e.tableRowHdrScrWidth=n.clientWidth}const s=t.querySelector(".sapUiTableCtrlScr:not(.sapUiTableCHA)");if(s){e.tableCtrlScrWidth=s.getBoundingClientRect().width}const r=t.querySelector(".sapUiTableCtrlScrFixed:not(.sapUiTableCHA) > .sapUiTableCtrlFixed");if(r){e.tableCtrlFixedWidth=r.clientWidth}const l=this._getSpanBasedComputedFixedColumnCount();let a=0;if(l){const e=this.getColumns();const o=t.querySelectorAll(".sapUiTableCtrlFirstCol:not(.sapUiTableCHTHR) > th");for(let t=0;t<o.length;t++){const i=parseInt(o[t].getAttribute("data-sap-ui-headcolindex"));if(!isNaN(i)&&i<l){const n=e[i];let s;if(n._iFixWidth!=null){s=n._iFixWidth}else{s=o[t].getBoundingClientRect().width}a+=s}}}if(a>0){const t=this._getScrollExtension();let o=e.tableRowHdrScrWidth;const i=t.getVerticalScrollbar();if(i&&!t.isVerticalScrollbarExternal()){o+=i.offsetWidth}if(h.hasRowActions(this)){const e=this.getDomRef("sapUiTableRowActionScr");if(e){o+=e.offsetWidth}}o+=h.Column.getMinColumnWidth();const n=e.tableCntWidth-o;const s=n>a;const r=!s;if(this._bIgnoreFixedColumnCount!==r){this._bIgnoreFixedColumnCount=r;if(this.getEnableColumnFreeze()){this._invalidateColumnMenus()}this.invalidate()}}return e};U.prototype._updateRowHeights=function(e,t){const o=this.getDomRef();if(!o){return}function i(t,o){const i=e[o];if(i){t.style.height=i+"px"}}const n=t?".sapUiTableColHdrTr":".sapUiTableTr";const s=t?[]:o.querySelectorAll(".sapUiTableRowSelectionCell");const r=t?[]:o.querySelectorAll(".sapUiTableRowActionCell");const l=o.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+n);const a=o.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+n);Array.prototype.forEach.call(s,i);Array.prototype.forEach.call(r,i);Array.prototype.forEach.call(l,i);Array.prototype.forEach.call(a,i)};U.prototype.onBeforeRendering=function(e){this._bInvalid=true;this._detachEvents();if(e&&e.isMarked("renderRows")){return}this._cleanUpTimers();this._aTableHeaders=[]};U.prototype.onAfterRendering=function(e){const t=e&&e.isMarked("renderRows");this._bInvalid=false;this._attachEvents();this._initRowDomRefs();if(!this._bAllowColumnHeaderTextSelection&&!t){this._disableTextSelection(this.$().find(".sapUiTableColHdrCnt"))}this.getDomRef().classList.remove("sapUiTableRActFlexible");if(!t){this._aTableHeaders=this.$().find(".sapUiTableColHdrCnt th")}this._updateTableSizes(h.RowsUpdateReason.Render,true);h.registerResizeHandler(this,"Table",this._onTableResize.bind(this));this._bFirstRendering=false};U.prototype.invalidate=function(){this._bInvalid=true;h.Column.invalidateColumnUtils(this);return o.prototype.invalidate.call(this)};U.prototype._initRowDomRefs=function(){const e=this.getRows();for(let t=0;t<e.length;t++){e[t].initDomRefs()}};U.prototype._updateTableSizes=function(e,t){t=t===true;const o=this.getDomRef();if(this._bInvalid||!o||!h.isThemeApplied()||o.offsetWidth===0){return}if(!t){this._resetRowHeights();this._resetColumnHeaderHeights()}this._aRowHeights=this._collectRowHeights(false);const i=this._collectRowHeights(true);function n(e){const t=e.getDomRef();const o=h.Column.getMinColumnWidth();const i=[];const n=e.getColumnHeaderVisible();function s(e,t){if(e<=t){return Math.max(e,t-5,o)+"px"}return-1}function r(r){const l=Math.max(r._minWidth||0,o,r.getMinWidth());const a=r.getWidth();let u;let d;let p;if(h.isVariableWidth(a)&&!h.isFixedColumn(e,r.getIndex())){u=t.querySelectorAll('th[data-sap-ui-colid="'+r.getId()+'"]');d=u[n?0:1];p=d?d.offsetWidth:null;if(p!==null){if(p<=l){return{headers:u,newWidth:s(p,l)}}else if(d&&d.style.width!==a){i.push({col:r,header:d,minWidth:l,headers:u});return{headers:u,newWidth:a}}i.push({col:r,header:d,minWidth:l,headers:u})}}return null}function l(e){if(e){Array.prototype.forEach.call(e.headers,function(t){t.style.width=e.newWidth})}}e._getVisibleColumns().map(r).forEach(l);if(i.length){let e;for(let t=0;t<i.length;t++){e=i[t].header&&i[t].header.offsetWidth;i[t].newWidth=s(e,i[t].minWidth);if(parseInt(i[t].newWidth)>=0){l(i[t])}}}}n(this);const s=this._collectTableSizes();this._updateRowHeights(this._aRowHeights,false);this._updateRowHeights(i,true);h.dynamicCall(this._getSyncExtension,function(e){e.syncLayout({top:this.getDomRef("sapUiTableCnt").offsetTop,headerHeight:this.getDomRef().querySelector(".sapUiTableColHdrCnt").getBoundingClientRect().height,contentHeight:this.getDomRef("tableCCnt").getBoundingClientRect().height})},this);const r=this.$();if(h.hasRowActions(this)||h.hasRowNavigationIndicators(this)){const e=r.hasClass("sapUiTableRActFlexible");const t=this.getDomRef("dummycolhdr");if(t){const o=t.clientWidth>2;if(!e&&o){const e=this.getColumns().reduce(function(e,t){const o=t.getDomRef();if(o&&t.getIndex()>=this.getComputedFixedColumnCount()){e+=o.offsetWidth}return e}.bind(this),0);let t=e+s.tableRowHdrScrWidth+s.tableCtrlFixedWidth;const o={};if(!h.hasRowActions(this)){t=t-h.ThemeParameters.navIndicatorWidth+h.BaseBorderWidth}o[this._bRtlMode?"right":"left"]=t;this.$("sapUiTableRowActionScr").css(o);this.$("rowacthdr").css(o);r.toggleClass("sapUiTableRActFlexible",true)}else if(e&&!o){this.$("sapUiTableRowActionScr").removeAttr("style");this.$("rowacthdr").removeAttr("style");r.toggleClass("sapUiTableRActFlexible",false)}}}r.find(".sapUiTableNoOpacity").addBack().removeClass("sapUiTableNoOpacity");h.Hook.call(this,E.UpdateSizes,e)};U.prototype.setShowOverlay=function(e){this.setProperty("showOverlay",e,true);if(this.getDomRef()){this.$().toggleClass("sapUiTableOverlay",this.getShowOverlay());this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus()}return this};U.prototype._updateFixedBottomRows=function(){const e=this.getDomRef();if(!e||this._getRowCounts().fixedBottom===0){return}const t=h.getFirstFixedBottomRowIndex(this);const o=this.getRows();let i;jQuery(e).find(".sapUiTableRowLastScrollable").removeClass("sapUiTableRowLastScrollable");jQuery(e).find(".sapUiTableRowFirstFixedBottom").removeClass("sapUiTableRowFirstFixedBottom");if(t>=0&&t<o.length){i=o[t].getDomRefs(true);i.row.addClass("sapUiTableRowFirstFixedBottom",true)}if(t>=1&&t<o.length){i=o[t-1].getDomRefs(true);i.row.addClass("sapUiTableRowLastScrollable",true)}};U.prototype.focus=function(e){this._oFocusInfo=e;o.prototype.focus.apply(this,arguments);delete this._oFocusInfo};U.prototype.getFocusInfo=function(){const e=this.$().find(":focus").attr("id");if(e){return{customId:e}}else{return o.prototype.getFocusInfo.apply(this,arguments)}};U.prototype.applyFocusInfo=function(e){delete this._bApplyFocusInfoFailed;if(e&&e.customId){if(document.getElementById(e.customId)){jQuery(document.getElementById(e.customId)).trigger("focus")}else{this._bApplyFocusInfoFailed=true}}else{o.prototype.applyFocusInfo.apply(this,arguments)}return this};U.prototype.setTitle=function(e){let t=e;if(typeof e==="string"||e instanceof String){t=h._getTableTemplateHelper().createTextView({text:e});t.addStyleClass("sapUiTableHdrTitle")}this.setAggregation("title",t);return this};U.prototype.setFooter=function(e){let t=e;if(typeof e==="string"||e instanceof String){t=h._getTableTemplateHelper().createTextView({text:e})}this.setAggregation("footer",t);return this};U.prototype.setSelectionMode=function(e){if(e===D.Multi){e=D.MultiToggle;I.warning("The selection mode 'Multi' is deprecated and must not be used anymore."+" Your setting was defaulted to selection mode 'MultiToggle'",this)}if(T.findOn(this)){I.error("If a selection plugin is applied to the table, the selection mode is controlled by the plugin.",this)}else{this.setProperty("selectionMode",e);H(this).oLegacySelectionPlugin?.setSelectionMode(e)}return this};U.prototype.setFirstVisibleRow=function(e){if(e==null){e=0}else if(e<0){I.error("The index of the first visible row must be greater than or equal to 0. The value has been set to 0.",this);e=0}else if(this._bContextsAvailable){const t=this._getMaxFirstVisibleRowIndex();if(t<e){I.warning("The index of the first visible row is too high. The value has been set to "+t+".",this);e=t}}this._setFirstVisibleRowIndex(e);return this};U.prototype._setFirstVisibleRowIndex=function(e,t){t=Object.assign({onScroll:false,suppressScrolling:false,suppressEvent:false,forceEvent:false,suppressRendering:false,onlySetProperty:false},t);if(this._bContextsAvailable){e=Math.min(e,this._getMaxFirstVisibleRowIndex())}e=Math.max(0,e);const o=this.getFirstVisibleRow()!==e;const i=this._getFirstRenderedRowIndex();const n=this._bContextsAvailable?Math.min(e,this._getMaxFirstRenderedRowIndex()):e;const s=this._getScrollExtension();this.setProperty("firstVisibleRow",e,true);if(!t.suppressRendering){H(this).iFirstRenderedRowIndex=n}if(t.onlySetProperty){return false}if((o||t.forceEvent)&&!t.suppressEvent){this.fireFirstVisibleRowChanged({firstVisibleRow:e})}if(!this.getBinding()){s.updateVerticalScrollPosition();return false}let r=false;const l=this.getBinding()!=null&&n!==i;if(l){if(!t.suppressRendering){this._bScrolled=t.onScroll;$(this,t.onScroll?h.RowsUpdateReason.VerticalScroll:h.RowsUpdateReason.FirstVisibleRowChange);r=true}if(!t.onScroll&&!t.suppressScrolling){s.updateVerticalScrollPosition(r)}}else if(!t.onScroll&&!t.suppressScrolling){s.updateVerticalScrollPosition(!this._bContextsAvailable)}return r};U.prototype._setFocus=function(e,t){return new Promise(function(o){if(e===-1){e=this._getTotalRowCount()-1}if(typeof e!=="number"||e<-1){e=0}const i=this.getFirstVisibleRow();const n=this._getRowCounts().count;if(e>i&&e<i+n){this.getRows()[e-i]._setFocus(t);return o()}if(this._setFirstVisibleRowIndex(e)){this.attachEventOnce("_rowsUpdated",function(){O(this,e,t);return o()})}else{O(this,e,t);return o()}}.bind(this))};function O(e,t,o){const i=e._getTotalRowCount();const n=e._getFirstRenderedRowIndex();e.getRows()[Math.min(t,i-1)-n]._setFocus(o)}U.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;U.prototype.bindAggregation=function(e,t){if(e==="rows"){this._bindRows(z(Array.prototype.slice.call(arguments,1)));return this}return o.prototype.bindAggregation.apply(this,arguments)};U.prototype.bindRows=function(e){this._bindRows(z(arguments));return this};U.prototype._bindRows=function(e){W(this);this._bRowsBeingBound=true;j(this);X(this);U._addBindingListener(e,"change",function(){this._onBindingChange.apply(this,arguments)}.bind(this));U._addBindingListener(e,"dataRequested",function(){this._onBindingDataRequested.apply(this,arguments)}.bind(this));U._addBindingListener(e,"dataReceived",function(){this._onBindingDataReceived.apply(this,arguments)}.bind(this));h.Hook.call(this,E.BindRows,e);o.prototype.bindAggregation.call(this,"rows",e);this._bRowsBeingBound=false};U.prototype._bindAggregation=function(e,t){if(e==="rows"){W(this);this._bRowsBeingBound=true}o.prototype._bindAggregation.call(this,e,t);if(e==="rows"){h.Grouping.setupExperimentalGrouping(this);const e=this.getBinding();const t=e?e.getModel():null;this._bRowsBeingBound=false;h.Hook.call(this,E.RowsBound,e);if(t&&t.getDefaultBindingMode()===u.OneTime){I.error('The binding mode of the model is set to "OneTime".'+' This binding mode is not supported for the "rows" aggregation!'+" Scrolling can not be performed.",this)}}};U.prototype.unbindAggregation=function(e,t){if(e==="rows"){this._unbindRows();return this}return o.prototype.unbindAggregation.apply(this,arguments)};U.prototype.unbindRows=function(){this._unbindRows();return this};U.prototype._unbindRows=function(){const e=this.getBindingInfo("rows");if(e){h.Hook.call(this,E.UnbindRows,e)}o.prototype.unbindAggregation.call(this,"rows",true);if(this._bRowsBeingBound||this.bIsDestroyed||this._bIsBeingDestroyed){return}this._adjustToTotalRowCount();if(e){h.Hook.call(this,E.RowsUnbound)}W(this);X(this)};function W(e){e._bRowsBeingBound=false;e._bContextsAvailable=false;H(e).iPendingRequests=0;e._iBindingLength=null}function z(e){let t;if(e==null||e[0]==null){t={}}else if(typeof e[0]==="string"){const o=e[0];let i=e[1];let n=e[2];let s=e[3];if(i instanceof a||Array.isArray(n)&&n[0]instanceof l){s=n;n=i;i=undefined}t={path:o,sorter:n,filters:s,template:i}}else{t=e[0]}return t}U._addBindingListener=function(e,t,o,i){if(!e.events){e.events={}}const n=e.events[t];e.events[t]=function(){o.apply(i,arguments);if(n){n.apply(this,arguments)}}};U.prototype._onBindingChange=function(e){};U.prototype.setRowMode=function(e){q(this);this.setAggregation("rowMode",e);N(this);return this};U.prototype.destroyRowMode=function(){this.destroyAggregation("rowMode");if(!H(this).oDefaultRowMode){N(this)}return this};function L(e){const t=e.getRowMode();if(!e.isDestroyStarted()&&!h.isA(t,"sap.ui.table.rowmodes.RowMode")&&!H(e).oDefaultRowMode){N(e)}return h.isA(t,"sap.ui.table.rowmodes.RowMode")?t:H(e).oDefaultRowMode}function N(e){const t=e.getRowMode();const o=h.isA(t,"sap.ui.table.rowmodes.RowMode")?undefined:t||R.Fixed;if(o===undefined||H(e).oDefaultRowMode){return}if(t===null){switch(e.getVisibleRowCountMode()){case R.Fixed:H(e).oDefaultRowMode=new _(true);break;case R.Interactive:H(e).oDefaultRowMode=new x(true);break;case R.Auto:H(e).oDefaultRowMode=new S(true);break;default:throw new Error("Default row mode could not be created")}e.addAggregation("_hiddenDependents",H(e).oDefaultRowMode);return}switch(o){case R.Fixed:H(e).oDefaultRowMode=new _;break;case R.Interactive:H(e).oDefaultRowMode=new x;break;case R.Auto:H(e).oDefaultRowMode=new S;break;default:throw new Error("Default row mode could not be created")}e.addAggregation("_hiddenDependents",H(e).oDefaultRowMode)}function q(e){if(H(e).oDefaultRowMode){H(e).oDefaultRowMode.destroy();delete H(e).oDefaultRowMode}}U.prototype._getRowCounts=function(){const e=L(this).getComputedRowCounts();const t=this._bVariableRowHeightEnabled&&!e.fixedTop&&!e.fixedBottom;e._fullsize=e.count;e._scrollSize=e.scrollable;if(e.count>0&&t){e.count++;e.scrollable++}return e};U.prototype._isNoDataDisabled=function(){return!this.getShowNoData()||(L(this)?.isNoDataDisabled()??false)};U.prototype.setVisibleRowCountMode=function(e){if(this.getRowMode()){I.warning('If the "rowMode" aggregation is set, setting the "visibleRowCountMode" has no effect');return this.setProperty("visibleRowCountMode",e,true)}const t=this.getVisibleRowCountMode();this.setProperty("visibleRowCountMode",e);const o=this.getVisibleRowCountMode();if(o!==t){q(this);N(this)}return this};U.prototype.setVisibleRowCount=function(e){const t=this.getVisibleRowCountMode();if(t==="Auto"){I.error("VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto",this);return this}if(e!=null&&!isFinite(e)){return this}const o=this.getFixedRowCount()+this.getFixedBottomRowCount();if(e<=o&&o>0){I.error("Table: "+this.getId()+" visibleRowCount('"+e+"') must be bigger than number of"+" fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')",this);return this}if(this.getRowMode()){I.warning('If the "rowMode" aggregation is set, setting the "visibleRowCount" has no effect');return this.setProperty("visibleRowCount",e,true)}e=this.validateProperty("visibleRowCount",e);this.setProperty("visibleRowCount",e);h.dynamicCall(this._getSyncExtension,function(t){t.syncRowCount(e)});return this};U.prototype.setMinAutoRowCount=function(e){if(parseInt(e)<1){I.error("The minAutoRowCount property must be greater than 0. The value has been set to 1.",this);e=1}if(this.getRowMode()){I.warning('If the "rowMode" aggregation is set, setting the "minAutoRowCount" has no effect');return this.setProperty("minAutoRowCount",e,true)}return this.setProperty("minAutoRowCount",e)};U.prototype.setTooltip=function(e){I.warning("The aggregation tooltip is not supported for sap.ui.table.Table",this);return this.setAggregation("tooltip",e,true)};U.prototype.setNavigationMode=function(){this.setProperty("navigationMode","Scrollbar",true);I.error("The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'",this);return this};U.prototype._getRowContexts=function(e){const t=this.getBinding();const o=this._getRowCounts();let i=this._bScrolled?this._getScrollThreshold():this.getThreshold();this._bScrolled=false;e=e==null?o.count:e;if(i!==0){i=Math.max(e-o.fixedTop-o.fixedBottom,i)}e=Math.max(e,L(this).getMinRequestLength(),0);if(!t||e===0){return[]}const n=this._getFirstRenderedRowIndex();const s=[];if(o.fixedTop>0&&n>0){k(s,this._getFixedTopRowContexts(),0);k(s,this._getContexts(n+o.fixedTop,e-o.fixedBottom-o.fixedTop,i),o.fixedTop)}else{k(s,this._getContexts(n,e-o.fixedBottom,i),0)}if(o.fixedBottom>0){k(s,this._getFixedBottomRowContexts(),Math.min(o.fixedTop+o.scrollable,Math.max(this._getTotalRowCount()-o.fixedBottom,0)))}if(typeof s.bExpectMore==="boolean"){H(this).bIsWaitingForData=s.bExpectMore;X(this)}return s};function k(e,t,o){for(let i=0;i<t.length;i++){e[o+i]=t[i]}e.bExpectMore||=t.bExpectMore}U.prototype._getFixedTopRowContexts=function(){const e=this._getRowCounts();return e.fixedTop>0?this._getContexts(0,e.fixedTop,0,true):[]};U.prototype._getFixedBottomRowContexts=function(){const e=this._getRowCounts();const t=Y(this,true);if(e.fixedBottom>0&&e.count-e.fixedBottom<t){return this._getContexts(t-e.fixedBottom,e.fixedBottom,0,true)}else{return[]}};U.prototype._getContexts=function(e,t,o,i){if(!this.getVisible()){return[]}const n=this.getBinding();return n?n.getContexts(e,t,o,i):[]};U.prototype._adjustToTotalRowCount=function(){const e=this._getTotalRowCount();if(this._iBindingLength!==e){this._iBindingLength=e;this._updateFixedBottomRows();this._adjustFirstVisibleRowToTotalRowCount();h.Hook.call(this,E.TotalRowCountChanged)}};U.prototype._adjustFirstVisibleRowToTotalRowCount=function(){const e=this.getFirstVisibleRow();const t=this._getMaxFirstVisibleRowIndex();if(t<e&&this._bContextsAvailable){this._setFirstVisibleRowIndex(t,{onlySetProperty:true})}};U.prototype.refreshRows=function(e){this._bContextsAvailable=false;if(e===r.Sort||e===r.Filter){this.setFirstVisibleRow(0)}h.Hook.call(this,E.RefreshRows,e||h.RowsUpdateReason.Unknown)};U.prototype.updateRows=function(e,t){if(this.bIsDestroyed||this._bIsBeingDestroyed){return}if(t.detailedReason==="AddVirtualContext"){G(this);return}else if(t.detailedReason==="RemoveVirtualContext"){j(this);return}this._bContextsAvailable=true;if(e===r.Sort||e===r.Filter){this.setFirstVisibleRow(0)}this._adjustToTotalRowCount();$(this,e)};function G(e){const t=e._getRowContexts()[0];j(e);e._oVirtualRow=e._getRowClone("virtual");e._oVirtualRow.setBindingContext(t,e.getBindingInfo("rows").model);e.addAggregation("_hiddenDependents",e._oVirtualRow)}function j(e){if(e._oVirtualRow){e._oVirtualRow.destroy();delete e._oVirtualRow}}function $(e,t){if(e._bContextsAvailable){h.Hook.call(e,E.UpdateRows,t||h.RowsUpdateReason.Unknown)}}U.prototype.insertRow=function(){I.error('The control manages the rows aggregation. The method "insertRow" cannot be used programmatically!',this);return this};U.prototype.addRow=function(){I.error('The control manages the rows aggregation. The method "addRow" cannot be used programmatically!',this);return this};U.prototype.removeRow=function(){I.error('The control manages the rows aggregation. The method "removeRow" cannot be used programmatically!',this);return null};U.prototype.removeAllRows=function(){I.error('The control manages the rows aggregation. The method "removeAllRows" cannot be used programmatically!',this);return[]};U.prototype.destroyRows=function(){I.error('The control manages the rows aggregation. The method "destroyRows" cannot be used programmatically!',this);return this};U.prototype.setCreationRow=function(e){if(!h.isA(e,"sap.ui.table.CreationRow")){e=null}return this.setAggregation("creationRow",e)};U.prototype.getCreationRow=function(){return this.getAggregation("creationRow")};U.prototype.autoResizeColumn=function(e){const t=this._getVisibleColumns();const o=t[e];if(o?.getResizable()&&o?.getAutoResizable()){o.autoResize()}};U.prototype._attachEvents=function(){const e=this.$();const o=this.getId();if(i.getAnimationMode()!==B.none){jQuery(document.body).on("webkitTransitionEnd."+o+" transitionend."+o,function(t){if(jQuery(t.target).has(e).length>0){this._updateTableSizes(h.RowsUpdateReason.Animation)}}.bind(this))}t.resize.attachHandler(this._onWindowResize,this);g.attachEvents(this)};U.prototype._detachEvents=function(){const e=this.getId();jQuery(document.body).off("webkitTransitionEnd."+e+" transitionend."+e);h.deregisterResizeHandler(this,"Table");t.resize.detachHandler(this._onWindowResize,this);g.detachEvents(this)};U.prototype._cleanUpTimers=function(){let e;for(e in this._mTimeouts){if(this._mTimeouts[e]){window.clearTimeout(this._mTimeouts[e]);delete this._mTimeouts[e]}}for(e in this._mAnimationFrames){if(this._mAnimationFrames[e]){window.cancelAnimationFrame(this._mAnimationFrames[e]);delete this._mAnimationFrames[e]}}};function K(e){const t=e.getDomRef();if(t){e.getDomRef().classList.toggle("sapUiTableEmpty",h.isNoDataVisible(e));e._getAccExtension().updateAriaStateForOverlayAndNoData();e._getKeyboardExtension().updateNoDataAndOverlayFocus()}}U.prototype.removeColumn=function(e){e=this.removeAggregation("columns",e);if(e===null){return e}if(!this._bReorderInProcess){this._removeSortedColumn(e)}Z(this);return e};U.prototype.removeAllColumns=function(){const e=this.removeAllAggregation("columns");this._aSortedColumns=[];Z(this);return e};U.prototype.destroyColumns=function(){const e=this.destroyAggregation("columns");this._aSortedColumns=[];Z(this);return e};U.prototype.addColumn=function(e){this.addAggregation("columns",e);Z(this);return this};U.prototype.insertColumn=function(e,t){this.insertAggregation("columns",e,t);Z(this);return this};function Z(e){e.invalidateRowsAggregation();e._invalidateComputedFixedColumnCount();const t=e.getCreationRow();if(t){t._update()}}U.prototype._getTotalRowCount=function(){return Y(this)};function Y(e,t){const o=e.getBinding();const i=e.getBindingInfo("rows");if(!o){return 0}if(i.length!=null){return i.length}if(t===true){return o.getLength()}if(!e._bContextsAvailable){return H(e).iCachedBindingLength}H(e).iCachedBindingLength=o.getLength();return H(e).iCachedBindingLength}U.prototype._getMaxFirstVisibleRowIndex=function(){let e;if(h.isVariableRowHeightEnabled(this)){e=this._getTotalRowCount()-1}else{e=this._getTotalRowCount()-this._getRowCounts().count}return Math.max(0,e)};U.prototype._getMaxFirstRenderedRowIndex=function(){const e=this._getTotalRowCount()-this._getRowCounts().count;return Math.max(0,e)};U.prototype._getFirstRenderedRowIndex=function(){return H(this).iFirstRenderedRowIndex};U.prototype._getVisibleColumns=function(){const e=[];const t=this.getColumns();for(let o=0,i=t.length;o<i;o++){if(t[o].shouldRender()){e.push(t[o])}}return e};U.prototype._getColumnsWidth=function(e,t){const o=this.getColumns();let i=0;if(e!==0&&!e){e=0}if(t!==0&&!t){t=o.length}for(let n=e,s=t;n<s;n++){if(o[n]&&o[n].shouldRender()){let e=h.convertCSSSizeToPixel(o[n].getWidth());if(e==null){e=h.Column.getMinColumnWidth()}i+=e}}return i};U.prototype._onTableResize=function(e){const t=e.oldSize.width;const o=e.size.width;if(this._bInvalid||!this.getDomRef()||t===o){return}this._updateTableSizes(h.RowsUpdateReason.Resize)};U.prototype._onWindowResize=function(){if(this._bInvalid||!this.getDomRef()){return}if(t.browser.chrome&&window.devicePixelRatio!==this._nDevicePixelRatio){this._nDevicePixelRatio=window.devicePixelRatio;this._updateTableSizes(h.RowsUpdateReason.Zoom);this._adjustOutlineOffset()}};U.prototype._adjustOutlineOffset=function(){if(window.devicePixelRatio<1){this.addStyleClass("sapUiTableZoomout")}else{this.removeStyleClass("sapUiTableZoomout")}};U.prototype._disableTextSelection=function(e){jQuery(e||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).on("selectstart",function(e){e.preventDefault();return false})};U.prototype._enableTextSelection=function(e){jQuery(e||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).off("selectstart")};U.prototype._findAndfireCellEvent=function(e,t,o){const i=jQuery(t.target);const n=i.closest(".sapUiTableDataCell");const s=n.attr("id");const r=/.*-row(\d*)-col(\d*)/i.exec(s);let l=false;if(r){const t=r[1];const i=r[2];const s=this.getRows()[t];const a=s&&s.getCells()[i];const u=s&&s.getIndex();const p=d.ofCell(a).getId();const c=s.getRowBindingContext();const h={rowIndex:u,columnIndex:i,columnId:p,cellControl:a,rowBindingContext:c,cellDomRef:n.get(0)};l=!e.call(this,h);if(!l&&typeof o==="function"){h.cellDomRef=n[0];l=o.call(this,h)}}return l};U.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();if(this.getShowOverlay()){return this.getDomRef("overlay")}if(h.isNoDataVisible(this)){return this.getDomRef("noDataCnt")}const e=this._oFocusInfo&&this._oFocusInfo.targetInfo&&h.isA(this._oFocusInfo.targetInfo,"sap.ui.core.message.Message");if(e&&this.getColumnHeaderVisible()){const e=this._getVisibleColumns()[0];if(e){return e.getDomRef()}}const t=h.getFocusedItemInfo(this);if(t&&t.domRef){return t.domRef}return o.prototype.getFocusDomRef.apply(this,arguments)};U.prototype.pushSortedColumn=function(e,t){if(!t){this._aSortedColumns=[]}if(this._aSortedColumns.indexOf(e)===-1){this._aSortedColumns.push(e)}};U.prototype._removeSortedColumn=function(e){const t=this._aSortedColumns.indexOf(e);if(t>-1){this._aSortedColumns.splice(t,1)}};U.prototype.getSortedColumns=function(){return this._aSortedColumns.slice()};U.prototype.sort=function(e,t,o){if(!e){this._aSortedColumns.forEach(e=>{e.setSorted(false);e.setSortOrder(V.None)});this.getBinding()?.sort();this._aSortedColumns=[]}if(this.getColumns().indexOf(e)>=0){e._sort(t??V.Ascending,o)}};U.prototype.filter=function(e,t){if(this.getColumns().indexOf(e)>=0){if(t==null){t=""}else if(typeof t!=="string"){throw new Error("The filter value is not a string")}e.filter(t)}};U.prototype._updateSelection=function(){const e=this.getSelectionMode();if(e===D.None){return}const t=this._getSelectionPlugin().getRenderConfig();const o=this.$("selall");const i=this.getRows();for(let e=0;e<i.length;e++){const t=i[e];t._updateSelection()}if(!t.headerSelector.visible){return}if(t.headerSelector.type==="toggle"){const e=t.headerSelector.selected;o.toggleClass("sapUiTableSelAll",!e);this._getAccExtension().setSelectAllState(e)}else if(t.headerSelector.type==="custom"){o.toggleClass("sapUiTableSelAllDisabled",!t.headerSelector.enabled);if(t.headerSelector.enabled){o.removeAttr("aria-disabled")}else{o.attr("aria-disabled","true")}const e=t.headerSelector.tooltip;o.attr("title",e)}};function J(e){const t=H(this).oLegacySelectionPlugin;const o=e.getParameter("rowIndices");const i=e.getParameter("selectAll");const n=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:t.getSelectedIndex();this._updateSelection();if(this.getMetadata().hasProperty("selectedIndex")){this.setProperty("selectedIndex",t.getSelectedIndex(),true)}this.fireRowSelectionChange({rowIndex:n,rowContext:this.getContextByIndex(n),rowIndices:o,selectAll:i,userInteraction:this._iSourceRowIndex!==undefined})}U.prototype.getContextByIndex=function(e){const t=this.getBinding();let o=null;if(!t||e<0){return o}if(t.getContextByIndex){o=t.getContextByIndex(e)}else{o=t.getContexts(e,1,0,true)[0]}return o||null};U.prototype.getSelectedIndex=function(){if(T.findOn(this)){throw new Error("Unsupported operation: sap.ui.table.Table#getSelectedIndex must not be called if a selection plugin is applied.")}return this._getSelectionPlugin().getSelectedIndex()};U.prototype.setSelectedIndex=function(e){if(T.findOn(this)){throw new Error("Unsupported operation: sap.ui.table.Table#setSelectedIndex must not be called if a selection plugin is applied.")}H(this).oLegacySelectionPlugin?.setSelectedIndex(e);this.setProperty("selectedIndex",e,true);return this};U.prototype.clearSelection=function(){if(T.findOn(this)){throw new Error("Unsupported operation: sap.ui.table.Table#clearSelection must not be called if a selection plugin is applied.")}this._getSelectionPlugin().clearSelection();return this};U.prototype.selectAll=function(){if(T.findOn(this)){throw new Error("Unsupported operation: sap.ui.table.Table#selectAll must not be called if a selection plugin is applied.")}if(h.hasSelectAll(this)){this._getSelectionPlugin().selectAll()}return this};U.prototype.getSelectedIndices=function(){if(T.findOn(this)){throw new Error("Unsupported operation: sap.ui.table.Table#getSelectedIndices must not be called if a selection plugin is applied.")}return this._getSelectionPlugin().getSelectedIndices()};U.prototype.addSelectionInterval=function(e,t){if(T.findOn(this)){throw new Error("Unsupported operation: sap.ui.table.Table#addSelectionInterval must not be called if a selection plugin is applied.")}this._getSelectionPlugin().addSelectionInterval(e,t);return this};U.prototype.setSelectionInterval=function(e,t){if(T.findOn(this)){throw new Error("Unsupported operation: sap.ui.table.Table#setSelectionInterval must not be called if a selection plugin is applied.")}this._getSelectionPlugin().setSelectionInterval(e,t);return this};U.prototype.removeSelectionInterval=function(e,t){if(T.findOn(this)){throw new Error("Unsupported operation: sap.ui.table.Table#removeSelectionInterval must not be called if a selection plugin is applied.")}this._getSelectionPlugin().removeSelectionInterval(e,t);return this};U.prototype.isIndexSelected=function(e){if(T.findOn(this)){throw new Error("Unsupported operation: sap.ui.table.Table#isIndexSelected must not be called if a selection plugin is applied.")}return this._getSelectionPlugin().isIndexSelected(e)};U.prototype.setGroupBy=function(e){let t=e;const o=n.getElementById(this.getGroupBy());if(typeof t==="string"){t=n.getElementById(t)}let i=false;if(t instanceof d&&t!==o){if(this.getColumns().indexOf(t)===-1){throw new Error("Column has to be part of the columns aggregation!")}const e=this.fireGroup({column:t,groupedColumns:[t.getId()],type:F.group});if(o){o.setGrouped(false);i=true}if(e&&this.getEnableGrouping()){t.setGrouped(true)}}if(!t||i){if(o){o.setGrouped(false)}h.Grouping.resetExperimentalGrouping(this)}this.setAssociation("groupBy",t);h.Grouping.setupExperimentalGrouping(this);return this};U.prototype.getBinding=function(e){return o.prototype.getBinding.call(this,e==null?"rows":e)};U.prototype.setEnableGrouping=function(e){const t=n.getElementById(this.getGroupBy());this.setProperty("enableGrouping",e);if(t){t.setGrouped(e)}if(e){h.Grouping.setupExperimentalGrouping(this)}else{h.Grouping.resetExperimentalGrouping(this)}return this};U.prototype.getComputedFixedColumnCount=function(){if(this._bIgnoreFixedColumnCount){return 0}return this._getSpanBasedComputedFixedColumnCount()};U.prototype._getSpanBasedComputedFixedColumnCount=function(){if(H(this).iComputedFixedColumnCount===null){const e=this.getColumns();let t;let o=this.getFixedColumnCount();for(let i=o-1;i>=0;i--){t=e[i];if(t){o=Math.max(o,t.getIndex()+h.Column.getHeaderSpan(t));break}}H(this).iComputedFixedColumnCount=Math.min(o,e.length)}return H(this).iComputedFixedColumnCount};U.prototype.setFixedColumnCount=function(e){this.setProperty("fixedColumnCount",e);this._invalidateComputedFixedColumnCount();const t=this.getColumns();let o;const i=this.$().find(".sapUiTableCtrlFirstCol > th");for(let e=this._getSpanBasedComputedFixedColumnCount()-1;e>=0;e--){o=t[e];if(o&&h.isVariableWidth(o.getWidth())){o._iFixWidth=i.filter("[data-sap-ui-headcolindex='"+o.getIndex()+"']").width()}}this._collectTableSizes();if(this.getEnableColumnFreeze()){this._invalidateColumnMenus()}return this};U.prototype.setFixedRowCount=function(e){if(!(parseInt(e)>=0)){I.error("Number of fixed rows must be greater or equal 0",this);return this}if(e+this.getFixedBottomRowCount()>=this.getVisibleRowCount()){I.error("Table '"+this.getId()+"' fixed rows('"+(e+this.getFixedBottomRowCount())+"') must be smaller than"+" numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);return this}if(this.getRowMode()){I.warning('If the "rowMode" aggregation is set, setting the "fixedRowCount" has no effect');return this.setProperty("fixedRowCount",e,true)}return this.setProperty("fixedRowCount",e)};U.prototype.setFixedBottomRowCount=function(e){if(!(parseInt(e)>=0)){I.error("Number of fixed bottom rows must be greater or equal 0",this);return this}if(e+this.getFixedRowCount()>=this.getVisibleRowCount()){I.error("Table '"+this.getId()+"' fixed rows('"+(e+this.getFixedRowCount())+"') must be smaller than"+" numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);return this}if(this.getRowMode()){I.warning('If the "rowMode" aggregation is set, setting the "iFixedBottomRowCount" has no effect');return this.setProperty("fixedBottomRowCount",e,true)}return this.setProperty("fixedBottomRowCount",e)};U.prototype.setThreshold=function(e){this.setProperty("threshold",e,true);return this};U.prototype.setScrollThreshold=function(e){this.setProperty("scrollThreshold",e,true);return this};U.prototype._invalidateColumnMenus=function(){h.Hook.call(this,h.Hook.Keys.Table.InvalidateColumnMenus,this)};U.prototype._isTouchEvent=function(e){return!!(e&&e.originalEvent&&e.originalEvent.touches)};U.prototype._getRowClone=function(e){const t=typeof e==="number";const o=t;let i=o?this._aRowClones[e]:null;if(i&&!i.bIsDestroyed){return i}i=new p(this.getId()+"-rows"+"-row"+(t?e:"-"+e));if(o){this._aRowClones[e]=i}const n=this.getColumns();for(let e=0,t=n.length;e<t;e++){if(n[e].getVisible()){const t=n[e].getTemplateClone(e);if(t){i.addCell(t)}}}if(h.hasRowActions(this)){const e=this.getRowActionTemplate().clone();i.setAggregation("_rowAction",e,true)}const s=this.getRowSettingsTemplate();if(s){const e=s.clone();i.setAggregation("_settings",e,true)}return i};U.prototype.invalidateRowsAggregation=function(){this._bRowAggregationInvalid=true};U.prototype._invalidateComputedFixedColumnCount=function(){H(this).iComputedFixedColumnCount=null};U.prototype._getBaseRowHeight=function(){const e=L(this).getBaseRowContentHeight();if(e>0){return e+h.RowHorizontalFrameSize}else{return this._getDefaultRowHeight()}};U.prototype._getDefaultRowHeight=function(){const e=h.getContentDensity(this);return h.DefaultRowHeight[e]};U.prototype._getDefaultRowContentHeight=function(){const e=h.getContentDensity(this);return h.BaseSize[e]};U.prototype.setNoData=function(e){const t=h.getNoContentMessage(this);this.setAggregation("noData",e,true);const o=h.getNoContentMessage(this);if(h.isA(e,"sap.m.IllustratedMessage")){Q(this)}else{this.destroyAggregation("_noColumnsMessage",true)}if(typeof t==="string"&&typeof o==="string"){if(t!==o){this.$("noDataMsg").text(o)}}else{this.invalidate()}return this};function Q(e){if(e.getAggregation("_noColumnsMessage")||H(e).bIsLoadingNoColumnsMessage){return}H(e).bIsLoadingNoColumnsMessage=true;sap.ui.require(["sap/m/table/Util"],function(t){if(!h.isA(e.getNoData(),"sap.m.IllustratedMessage")){return}const o=t.getNoColumnsIllustratedMessage();o.setEnableVerticalResponsiveness(true);e.setAggregation("_noColumnsMessage",o,h.getVisibleColumnCount(e)>0);delete H(e).bIsLoadingNoColumnsMessage})}U.prototype.exportData=function(e){const t=sap.ui.requireSync("sap/ui/core/util/Export");e=e||{};if(!e.rows){const t=this.getBinding();const o=this.getBindingInfo("rows");const i=t.aFilters.concat(t.aApplicationFilters);e.rows={path:o.path,model:o.model,sorter:t.aSorters,filters:i,parameters:o.parameters}}if(!e.exportType){const t=sap.ui.requireSync("sap/ui/core/util/ExportTypeCSV");e.exportType=new t}let o=e.rows.model;if(!o){const t=e.rows.path;const i=t.indexOf(">");if(i>0){o=t.substr(0,i)}}if(!e.columns){e.columns=[];const t=this.getColumns();for(let i=0,n=t.length;i<n;i++){const n=t[i];if(n.getSortProperty()){e.columns.push({name:n.getLabel().getText(),template:{content:{path:n.getSortProperty(),model:o}}})}}}const i=new t(e);this.addDependent(i);return i};U.prototype._onPersoApplied=function(){const e=this.getColumns();const t=[];for(let o=0,i=e.length;o<i;o++){const i=e[o];if(i.getSorted()&&i.getSortOrder()!==V.None){t.push(new a(i.getSortProperty(),i.getSortOrder()===V.Descending))}}const o=this.getBinding();if(o){if(t.length>0){o.sort(t)}}};U.prototype.setBusy=function(e){const t=this.getBusy();const i=this.getCreationRow()?"sapUiTableGridCnt":"sapUiTableCnt";const n=o.prototype.setBusy.call(this,e,i);const s=this.getBusy();if(t!==s){this.fireBusyStateChanged({busy:s})}return n};U.prototype.setEnableBusyIndicator=function(e){this.setProperty("enableBusyIndicator",e,true);if(this.getEnableBusyIndicator()){X(this)}else{this.setBusy(false);ee(this)}return this};U.prototype._onBindingDataRequested=function(){H(this).iPendingRequests++;X(this)};U.prototype._onBindingDataReceived=function(){H(this).iPendingRequests--;X(this)};U.prototype._isWaitingForData=function(){const e=H(this);return e.iPendingRequests>0&&e.bIsWaitingForData!==false};function X(e){if(!e.getEnableBusyIndicator()){return}ee(e);if(e._isWaitingForData()){e.setBusy(true)}else{H(e).hideBusyIndicatorTimeoutId=setTimeout(function(){e.setBusy(false);ee(e)},10)}}function ee(e){clearTimeout(H(e).hideBusyIndicatorTimeoutId);delete H(e).hideBusyIndicatorTimeoutId}U.prototype._setLargeDataScrolling=function(e){this._bLargeDataScrolling=!!e};U.prototype.setRowActionTemplate=function(e){this.setAggregation("rowActionTemplate",e);this.invalidateRowsAggregation();return this};U.prototype.setRowActionCount=function(e){if(typeof e==="number"){e=Math.max(0,Math.min(e,2))}return this.setProperty("rowActionCount",e)};U.prototype.setRowSettingsTemplate=function(e){this.setAggregation("rowSettingsTemplate",e);this.invalidateRowsAggregation();return this};U.prototype._getSelectionPlugin=function(){let e=T.findOn(this);let t=H(this).oLegacySelectionPlugin;if(this.getPlugins().length>0){e=this.getPlugins()[0]}if(e&&t){delete H(this).oLegacySelectionPlugin;t.destroy()}else if(!e&&!t&&!this.isDestroyed()){t=this._createLegacySelectionPlugin();H(this).oLegacySelectionPlugin=t;t.setSelectionMode(this.getSelectionMode());t.setSelectedIndex(this.getProperty("selectedIndex"));t.attachSelectionChange(J,this);this.addAggregation("_hiddenDependents",t);if(typeof this._getSelectedIndicesCount==="function"&&t.getSelectedCount!==this._getSelectedIndicesCount){t.getSelectedCount=this._getSelectedIndicesCount;["isIndexSelected","setSelectedIndex","getSelectedIndex","getSelectedIndices","setSelectionInterval","addSelectionInterval","removeSelectionInterval","selectAll","clearSelection"].forEach(e=>{t[e]=this[e]});this._onSelectionChanged=J.bind(this)}}return e||t};U.prototype._createLegacySelectionPlugin=function(){return new A};U.prototype._onSelectionPluginChange=function(){let e=T.findOn(this);if(this.getPlugins().length>0){e=this.getPlugins()[0]}if(H(this).oSelectionPlugin!==e){H(this).oSelectionPlugin?.detachSelectionChange(this._updateSelection,this);e?.attachSelectionChange(this._updateSelection,this);H(this).oSelectionPlugin=e}};U.prototype._getDefaultContextMenu=function(){let e=this.getAggregation("_hiddenDependents").find(e=>e.isA("sap.ui.table.menus.ContextMenu"));if(!e){e=new v;this.addAggregation("_hiddenDependents",e)}return e};U.prototype.insertAggregation=function(e,t,i,n){if(e==="_hiddenDependents"){return o.prototype.insertAggregation.call(this,e,t,i,true)}return o.prototype.insertAggregation.apply(this,arguments)};U.prototype.addAggregation=function(e,t,i){if(e==="_hiddenDependents"){return o.prototype.addAggregation.call(this,e,t,true)}return o.prototype.addAggregation.apply(this,arguments)};U.prototype.removeAggregation=function(e,t,i){if(e==="_hiddenDependents"){return o.prototype.removeAggregation.call(this,e,t,true)}return o.prototype.removeAggregation.apply(this,arguments)};U.prototype.removeAllAggregation=function(e,t){if(e==="_hiddenDependents"){return o.prototype.removeAllAggregation.call(this,e,true)}return o.prototype.removeAllAggregation.apply(this,arguments)};U.prototype.destroyAggregation=function(e,t){if(e==="_hiddenDependents"){return o.prototype.destroyAggregation.call(this,e,true)}o.prototype.destroyAggregation.apply(this,arguments);if(e==="rows"){this._aRowClones.forEach(function(e){e.destroy()});this._aRowClones=[]}return this};U.prototype.getCellControl=function(e,t,o){const i=h.getRowColCell(this,e,t,!o);return i.cell};U.prototype._fireRowsUpdated=function(e){const t={reason:e||h.RowsUpdateReason.Unknown};this.onRowsUpdated(t);clearTimeout(this._mTimeouts.fireRowsUpdated);this._mTimeouts.fireRowsUpdated=setTimeout(function(){this.onRowsContentUpdated(t);this.fireEvent("_rowsUpdated",t);this.fireRowsUpdated()}.bind(this),0)};U.prototype.onRowsUpdated=function(e){h.Grouping.updateGroups(this);h.Menu.closeContentCellContextMenu(this);this._getAccExtension()._updateAriaRowIndices();this._updateSelection();K(this);this.getRows().forEach(function(e){e.getCells().forEach(function(t){const o=d.ofCell(t);const i=o._getCellContentVisibilitySettings();const n=e.getDomRefs(true).row.find('td[data-sap-ui-colid="'+o.getId()+'"]');let s=true;if(!n){return}if(e.isGroupHeader()){if(!e.isExpandable()){s=i.groupHeader.nonExpandable}else if(e.isExpanded()){s=i.groupHeader.expanded}else{s=i.groupHeader.collapsed}}else if(e.isTotalSummary()){s=i.summary.total}else if(e.isGroupSummary()){s=i.summary.group}else{s=i.standard}n.toggleClass("sapUiTableCellHidden",!s)})})};U.prototype.onRowsContentUpdated=function(e){if(this.getRows().length>0){this._resetRowHeights();this._aRowHeights=this._collectRowHeights(false);this._updateRowHeights(this._aRowHeights,false);this._getAccExtension().updateAccForCurrentCell(e.reason)}};U.prototype._enableSynchronization=function(){const e=this;return new Promise(function(t,o){sap.ui.require(["sap/ui/table/extensions/Synchronization"],function(o){t(g.enrich(e,o).getInterface())},function(e){o(e)})})};U.prototype._enableLegacyMultiSelection=function(){if(T.findOn(this)){throw new Error("Unsupported operation: sap.ui.table.Table#_enableLegacyMultiSelection must not be called"+" if a selection plugin is applied.")}this._legacyMultiSelection=function(e,t){if(T.findOn(this)){throw new Error("Unsupported operation: The legacy multi selection is not supported if a selection plugin is applied")}const o=!!(t.metaKey||t.ctrlKey);if(!this.isIndexSelected(e)){if(o){this.addSelectionInterval(e,e)}else{this.setSelectedIndex(e)}}else if(o||this.getSelectedIndices().length===1){this.removeSelectionInterval(e,e)}else{this.setSelectedIndex(e)}}.bind(this)};U.prototype._setRowCountConstraints=function(e){this.setProperty("rowCountConstraints",e)};function te(e,t){const o=e.getAggregation("_hiddenDependents")||[];return t.filter(e=>!o.includes(e))}U.prototype.findAggregatedObjects=function(){return te(this,o.prototype.findAggregatedObjects.apply(this,arguments))};U.prototype.findElements=function(){return te(this,o.prototype.findElements.apply(this,arguments))};U.prototype.getPlugin=function(e){if(!e||!e.startsWith("sap.ui.table.plugins.")){throw new Error("This method can only be used to get plugins of the sap.ui.table library")}let t=this.getDependents().find(t=>t.isA(e));if(!t){t=this.getPlugins().find(t=>t.isA(e))}return t};U.prototype._getScrollThreshold=function(){const e=this.getScrollThreshold();if(e===-1){return this.getThreshold()}return e};return U});
/*
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/TablePersoController", ["./library","sap/ui/base/ManagedObject","sap/ui/base/ManagedObjectMetadata","sap/ui/core/Element","sap/ui/core/syncStyleClass","sap/base/Log","sap/ui/thirdparty/jquery","./utils/TableUtils"],function(e,t,o,s,i,r,jQuery,a){"use strict";const n=e.ResetAllMode;const l=t.extend("sap.ui.table.TablePersoController",{constructor:function(e,o){t.apply(this,arguments)},metadata:{deprecated:true,properties:{autoSave:{type:"boolean",defaultValue:true},persoService:{type:"any"},customDataKey:{type:"string",defaultValue:"persoKey"},showResetAll:{type:"boolean",defaultValue:true,since:"1.88"},resetAllMode:{type:"sap.ui.table.ResetAllMode",defaultValue:n.Default,since:"1.88"}},associations:{table:{type:"sap.ui.table.Table",multiple:false}},library:"sap.ui.table"}});l.prototype.init=function(){this._schemaProperty="_persoSchemaVersion";this._schemaVersion="1.0";this._oInitialPersoData=null;this._aTableEvents=["columnResize","columnMove","columnVisibility","sort","filter","group"];this._aColumnProperties=["visible","width","sorted","sortOrder","grouped","summed"];this._bSaveFilters=false;if(this._bSaveFilters){this._aTableEvents.push("filter");this._aColumnProperties.push("filtered");this._aColumnProperties.push("filterValue")}};l.prototype.setResetAllMode=function(e){if(!this._resetAllModeSet){this.setProperty("resetAllMode",e);this._resetAllModeSet=true}else{r.warning("resetAllMode of the TablePersoController can only be set once.")}};l.prototype.exit=function(){const e=this._getTable();if(e){this._manageTableEventHandlers(e,false)}delete this._schemaProperty;delete this._schemaVersion;delete this._oInitialPersoData;if(this._oDialog){this._oDialog.destroy();delete this._oDialog}};l.prototype.setPersoService=function(e){e=this.validateProperty("persoService",e);if(e&&(typeof e.getPersData!=="function"||typeof e.setPersData!=="function"||typeof e.delPersData!=="function")){throw new Error('Value of property "persoService" needs to be null/undefined or an object that has the methods '+'"getPersData", "setPersData" and "delPersData".')}const t=this.getPersoService();this.setProperty("persoService",e,true);const o=this.getPersoService();if(o&&o!==t&&this._getTable()&&(this.getAutoSave()||!t)){this.refresh()}return this};l.prototype.setAutoSave=function(e){const t=this.getAutoSave();this.setProperty("autoSave",e,true);const o=this.getAutoSave();if(o&&!t){this.savePersonalizations()}return this};l.prototype.setTable=function(e){const t=this._getTable();if(t){t._oPersoController=undefined}this.setAssociation("table",e,true);const o=this._getTable();if(o){o._oPersoController=this}if(t){this._manageTableEventHandlers(t,false)}if(o&&o!==t){if(this.getResetAllMode()===n.Default){this._oInitialPersoData=this._getCurrentTablePersoData(true)}this._manageTableEventHandlers(o,true);if(this.getPersoService()&&(this.getAutoSave()||!t)){this.refresh()}}else if(!o){this._oInitialPersoData=null}return this};l.prototype.setCustomDataKey=function(e){const t=this.getCustomDataKey();this.setProperty("customDataKey",e,true);const o=this.getCustomDataKey();if(this.getResetAllMode()===n.Default&&this._getTable()){this._oInitialPersoData=this._getCurrentTablePersoData(true)}if(t!==o&&this.getAutoSave()){this.savePersonalizations()}return this};l.prototype._manageTableEventHandlers=function(e,t){for(let o=0,s=this._aTableEvents.length;o<s;o++){const s=e[t?"attachEvent":"detachEvent"];s.apply(e,[this._aTableEvents[o],this._tableEventHandler,this])}};l.prototype.refresh=function(){const e=this;const t=this.getPersoService();if(t){return t.getPersData().done(function(t){const o=t&&Array.isArray(t.aColumns)?t:e._oInitialPersoData;e._adjustTable(o);if(e.getResetAllMode()===n.ServiceDefault){e._oInitialPersoData=e._getCurrentTablePersoData(true)}}).fail(function(){r.error("Problem reading persisted personalization data.")})}else{r.error("The Personalization Service is not available!");const e=jQuery.Deferred();e.reject();return e.promise()}};l.prototype.savePersonalizations=function(){const e=this.getPersoService();if(e){const t=this._getCurrentTablePersoData();t[this._schemaProperty]=this._schemaVersion;return e.setPersData(t).fail(function(){r.error("Problem persisting personalization data.")})}else{r.error("The Personalization Service is not available!");const e=jQuery.Deferred();e.reject();return e.promise()}};l.prototype._adjustTable=function(e){const t=this._getTable();if(!t||!e||!Array.isArray(e.aColumns)){return}const o={};const s=t.getColumns();for(let e=0,t=s.length;e<t;e++){o[this._getColumnPersoKey(s[e])]=s[e]}const i=e.aColumns;for(let e=0,s=i.length;e<s;e++){const s=i[e];const a=o[s.id];if(a){if(t.indexOfColumn(a)!==s.order){t.removeColumn(a);t.insertColumn(a,s.order)}const e=a.getMetadata();for(let t=0,o=this._aColumnProperties.length;t<o;t++){const o=this._aColumnProperties[t];if(s[o]!==undefined){try{if(e.hasProperty(o)&&a.getProperty(o)!==s[o]){a.setProperty(o,s[o])}}catch(e){r.error('sap.ui.table.TablePersoController: failed to apply the value "'+a[o]+'" for the property + "'+o+'".')}}}}}if(typeof t._onPersoApplied==="function"){t._onPersoApplied()}};l.prototype._tableEventHandler=function(e){if(this.getAutoSave()&&!this._iTriggerSaveTimeout){const e=this;this._iTriggerSaveTimeout=setTimeout(function(){e.savePersonalizations();e._iTriggerSaveTimeout=null},0)}};l.prototype._getCurrentTablePersoData=function(e){const t=this._getTable();const o=t.getColumns();const s={aColumns:[]};for(let t=0,i=o.length;t<i;t++){const i=o[t];const r=this._getColumnPersoKey(i);const n={id:r,order:t};const l=i.getMetadata();for(let e=0,t=this._aColumnProperties.length;e<t;e++){const t=this._aColumnProperties[e];if(l.hasProperty(t)){n[t]=i.getProperty(t)}}if(e){n.text=a.Column.getHeaderText(i)||r}s.aColumns.push(n)}return s};l.prototype._getTable=function(){return s.getElementById(this.getTable())};l.prototype._getColumnPersoKey=function(e){return this._getPersoKey(this._getTable())+"-"+this._getPersoKey(e)};l.prototype._getPersoKey=function(e){let t=e.data(this.getCustomDataKey());if(!t){t=e.getId();if(t.indexOf(o.getUIDPrefix())===0){r.warning('Generated IDs should not be used as personalization keys! The stability cannot be ensured! (Control: "'+e.getId()+'")')}}return t};l.prototype.openDialog=function(e){const t=this;function o(){if(t._oDialog){i("sapUiSizeCompact",t._getTable(),t._oDialog._oDialog);t._oDialog.open()}}if(!this._oDialog){sap.ui.getCore().loadLibrary("sap.m",{async:true}).then(function(){sap.ui.require(["sap/m/TablePersoDialog"],function(s){t._oDialog=new s(t._getTable().getId()+"-PersoDialog",{persoService:t.getPersoService(),showSelectAll:true,showResetAll:e&&e.showResetAll||t.getShowResetAll(),hasGrouping:false,contentWidth:e&&e.contentWidth,contentHeight:e&&e.contentHeight||"20rem",initialColumnState:t._oInitialPersoData.aColumns,columnInfoCallback:function(e,o,s){return t._getCurrentTablePersoData(true).aColumns},confirm:function(){t._adjustTable(this.retrievePersonalizations());if(t.getAutoSave()){t.savePersonalizations()}}});t._oDialog._oDialog.addStyleClass("sapUiNoContentPadding");if(t.getResetAllMode()===n.ServiceReset&&t.getPersoService().getResetPersData){t._oDialog.setShowResetAll(false);t.getPersoService().getResetPersData().done(function(e){if(this._bIsBeingDestroyed){return}if(e){t._oDialog.setInitialColumnState(e.aColumns);t._oDialog.setShowResetAll(t.getShowResetAll())}})}o()})})}else{o()}};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/TableRenderer", ["sap/ui/Device","./library","./Column","./utils/TableUtils","./extensions/ExtensionBase","sap/ui/core/Renderer","sap/ui/core/library","sap/base/Log"],function(e,t,s,n,a,i,o,l){"use strict";const r=o.SortOrder;const d=n.Column;const c={Begin:"flex-start",End:"flex-end",Left:undefined,Right:undefined,Center:"center"};const p=n.Hook.Keys.TableRenderer;const b={apiVersion:2};b.render=function(t,s){delete s._iHeaderRowCount;c.Left=s._bRtlMode?"flex-end":"flex-start";c.Right=s._bRtlMode?"flex-start":"flex-end";t.openStart("div",s);t.class("sapUiTable");if(e.browser.chrome&&window.devicePixelRatio<1){t.class("sapUiTableZoomout")}if("ontouchstart"in document){t.class("sapUiTableTouch")}t.class("sapUiTableSelMode"+s.getSelectionMode());if(s.getColumnHeaderVisible()){t.class("sapUiTableCHdr")}if(n.hasRowHeader(s)){t.class("sapUiTableRowSelectors")}if(n.hasRowHighlights(s)){t.class("sapUiTableRowHighlights")}try{const e=n._getTableTemplateHelper(true).addTableClass();if(e){t.class(e)}}catch(e){}const a=s._getScrollExtension();if(a.isVerticalScrollbarRequired()&&!a.isVerticalScrollbarExternal()){t.class("sapUiTableVScr")}if(s.getEditable&&s.getEditable()){t.class("sapUiTableEdt")}if(n.hasRowActions(s)){const e=s.getRowActionCount();t.class(e===1?"sapUiTableRActS":"sapUiTableRAct")}else if(n.hasRowNavigationIndicators(s)){t.class("sapUiTableRowNavIndicator")}if(n.isNoDataVisible(s)&&!s._isWaitingForData()){t.class("sapUiTableEmpty")}if(s.getShowOverlay()){t.class("sapUiTableOverlay")}const i=n.Grouping.getModeCssClass(s);if(i){t.class(i)}t.style("width",s.getWidth());n.Hook.call(s,p.RenderTableStyles,t);if(s._bFirstRendering){t.class("sapUiTableNoOpacity")}t.openEnd();this.renderTabElement(t,"sapUiTableOuterBefore");t.openStart("div",s.getId()+"-before");t.class("sapUiTableBefore");t.openEnd();t.renderControl(s.getAggregation("_messageStrip"));if(s.getTitle()){this.renderHeader(t,s,s.getTitle())}if(s.getToolbar()){this.renderToolbar(t,s,s.getToolbar())}if(s.getExtension()&&s.getExtension().length>0){this.renderExtensions(t,s,s.getExtension())}t.close("div");t.openStart("div",s.getId()+"-sapUiTableCnt");t.class("sapUiTableCnt");t.attr("data-sap-ui-fastnavgroup","true");t.attr("data-sap-ui-pasteregion","true");t.openEnd();if(!s._getScrollExtension().isVerticalScrollbarExternal()){this.renderVSb(t,s)}const o=s.getRows().length||s.getColumnHeaderVisible();this.renderTabElement(t,"sapUiTableCtrlBefore",o?"0":"-1");t.openStart("div",s.getId()+"-sapUiTableGridCnt");s._getAccRenderExtension().writeAriaAttributesFor(t,s,"Content");t.openEnd();this.renderColRsz(t,s);this.renderColHdr(t,s);this.renderTable(t,s);t.close("div");this.renderTabElement(t,"sapUiTableCtrlAfter",o?"0":"-1");this.renderTabElement(t,null,"-1",s.getId()+"-focusDummy");const l=s.getCreationRow();if(l&&l.getVisible()){t.renderControl(l)}this.renderHSbBackground(t,s);this.renderHSb(t,s);s._getAccRenderExtension().writeHiddenAccTexts(t,s);t.openStart("div",s.getId()+"-overlay");t.class("sapUiTableOverlayArea");t.attr("tabindex","0");s._getAccRenderExtension().writeAriaAttributesFor(t,s,"Overlay");t.openEnd();t.close("div");t.close("div");t.openStart("div",s.getId()+"-after");t.openEnd();if(s.getFooter()){this.renderFooter(t,s,s.getFooter())}n.Hook.call(s,p.RenderInTableBottomArea,t);t.close("div");this.renderTabElement(t,"sapUiTableOuterAfter");t.close("div")};b.renderHeader=function(e,t,s){e.openStart("div");e.class("sapUiTableHdr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"TableHeader");e.openEnd();e.renderControl(s);e.close("div")};b.renderToolbar=function(e,t,s){if(!n.isA(s,"sap.ui.core.Toolbar")){return}e.openStart("div");e.class("sapUiTableTbr");if(typeof s.getStandalone==="function"&&s.getStandalone()){s.setStandalone(false)}if(s.isA("sap.m.Toolbar")){s.setDesign("Transparent",true);s.addStyleClass("sapMTBHeader-CTX");e.class("sapUiTableMTbr")}t._getAccRenderExtension().writeAriaAttributesFor(e,t,"TableSubHeader");e.openEnd();e.renderControl(s);e.close("div")};b.renderExtensions=function(e,t,s){for(let n=0,a=s.length;n<a;n++){this.renderExtension(e,t,s[n])}};b.renderExtension=function(e,t,s){e.openStart("div");e.class("sapUiTableExt");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"TableSubHeader");e.openEnd();e.renderControl(s);e.close("div")};b.renderTable=function(e,t){e.openStart("div",t.getId()+"-tableCCnt");n.Hook.call(t,p.RenderRowContainerStyles,e);e.class("sapUiTableCCnt");e.openEnd();this.renderTableCCnt(e,t);e.close("div")};b.renderTableCCnt=function(e,t){this.renderTableCtrl(e,t);this.renderRowHdr(e,t);this.renderRowActions(e,t);e.openStart("div",t.getId()+"-noDataCnt");e.class("sapUiTableCtrlEmpty");e.attr("tabindex","0");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"NoData");e.openEnd();const s=n.getNoContentMessage(t);if(n.isA(s,"sap.ui.core.Control")){e.renderControl(s)}else{e.openStart("span",t.getId()+"-noDataMsg");e.class("sapUiTableCtrlEmptyMsg");e.openEnd();e.text(s);e.close("span")}e.close("div")};b.renderFooter=function(e,t,s){e.openStart("div");e.class("sapUiTableFtr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"TableFooter");e.openEnd();e.renderControl(s);e.close("div")};b.renderColHdr=function(e,t){const s=n.getHeaderRowCount(t);const a=t.getColumns();const i=t.getComputedFixedColumnCount();e.openStart("div",t.getId()+"-sapUiTableColHdrCnt");e.class("sapUiTableColHdrCnt");e.openEnd();this.renderColRowHdr(e,t);if(i>0){e.openStart("div");e.class("sapUiTableCHA");e.class("sapUiTableCtrlScrFixed");e.class("sapUiTableNoOpacity");e.openEnd();this.renderTableControlCnt(e,t,true,0,i,true,false,0,s,true);e.close("div")}e.openStart("div",t.getId()+"-sapUiTableColHdrScr");e.class("sapUiTableCHA");e.class("sapUiTableCtrlScr");if(a.length===0){e.class("sapUiTableHasNoColumns")}if(i>0){if(t._bRtlMode){e.style("margin-right","0")}else{e.style("margin-left","0")}}e.openEnd();this.renderTableControlCnt(e,t,false,i,a.length,false,false,0,s,true);e.close("div");if(n.hasRowActions(t)){e.openStart("div",t.getId()+"-rowacthdr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"RowActionHeader");e.class("sapUiTableCell");e.class("sapUiTableHeaderCell");e.class("sapUiTableRowActionHeaderCell");e.attr("tabindex","-1");e.openEnd();e.openStart("span");e.openEnd();e.text(n.getResourceText("TBL_ROW_ACTION_COLUMN_LABEL"));e.close("span");e.close("div")}e.openStart("div");e.class("sapUiTableVSbHeader");e.openEnd();e.close("div");e.close("div")};b.renderColRowHdr=function(e,s){let a=false;let i=false;const o=s._getSelectionPlugin().getRenderConfig();e.openStart("div");s._getAccRenderExtension().writeAriaAttributesFor(e,s,"ColumnRowHeaderRow");e.openEnd();e.openStart("div",s.getId()+"-rowcolhdr");s._getAccRenderExtension().writeAriaAttributesFor(e,s,"ColumnRowHeaderCell");e.openEnd();e.openStart("div",s.getId()+"-selall");e.class("sapUiTableCell");e.class("sapUiTableHeaderCell");e.class("sapUiTableRowSelectionHeaderCell");if(o.headerSelector.visible){const t=o.headerSelector.selected;if(o.headerSelector.type==="toggle"){e.attr("title",n.getResourceText("TBL_SELECT_ALL"))}else if(o.headerSelector.type==="custom"){const t=o.headerSelector.tooltip;e.attr("title",t);if(!o.headerSelector.enabled){e.class("sapUiTableSelAllDisabled");e.attr("aria-disabled","true")}}if(!t){e.class("sapUiTableSelAll")}else{i=true}e.class("sapUiTableSelAllVisible");a=true}e.attr("tabindex","-1");const l={enabled:a,checked:i};s._getAccRenderExtension().writeAriaAttributesFor(e,s,"ColumnRowHeader",l);e.openEnd();if(o.headerSelector.visible){if(o.headerSelector.type==="custom"&&o.headerSelector.icon){e.renderControl(o.headerSelector.icon)}else{e.openStart("div");e.class("sapUiTableSelectAllCheckBox");e.openEnd();e.close("div")}}if(n.hasRowHeader(s)&&s.getSelectionMode()===t.SelectionMode.None){e.openStart("span",s.getId()+"-rowselecthdr");e.class("sapUiPseudoInvisibleText");e.openEnd();e.text(n.getResourceText("TBL_ROW_SELECTION_COLUMN_LABEL"));e.close("span")}e.close("div").close("div").close("div")};b.renderCol=function(e,t,s,a,o,l,d,p,b){let g;const u=!o;const f=s.getIndex();const T=s.getMultiLabels();if(T.length>0){g=T[a]}else if(a===0){g=s.getLabel()}let C=s.getId();if(a===0){e.openStart("td",s)}else{C=C+"_"+a;e.openStart("td",C)}e.attr("data-sap-ui-related",s.getId());e.attr("data-sap-ui-colid",s.getId());e.attr("data-sap-ui-colindex",f);e.attr("tabindex","-1");const h={column:s,headerId:C,index:f};if(o>1){e.attr("colspan",o);h.colspan=true}if(b){const t=s.getFiltered();let n=s.getSortOrder()!==r.None;if(!s.getSorted()){n=false}if(t){e.class("sapUiTableColFiltered")}if(n){e.class("sapUiTableColSorted");if(s.getSortOrder()===r.Descending){e.class("sapUiTableColSortedD")}}}t._getAccRenderExtension().writeAriaAttributesFor(e,t,"ColumnHeader",h);e.class("sapUiTableCell");e.class("sapUiTableHeaderCell");e.class("sapUiTableHeaderDataCell");const R=s.getHeaderMenuInstance();if(t.getEnableColumnReordering()||R&&R.getAriaHasPopupType()!=="None"){e.class("sapUiTableHeaderCellActive")}if(!t.getEnableColumnReordering()&&!t.hasListeners("columnSelect")&&!R&&s._menuHasItems()){e.class("sapUiTableHeaderCellActive")}if(l){e.class("sapUiTableCellFirst")}if(d){e.class("sapUiTableCellLastFixed")}if(p){e.class("sapUiTableCellLast")}if(u){e.class("sapUiTableHidden")}if(t.getColumnHeaderHeight()>0){e.style("height",t.getColumnHeaderHeight()+"px")}const S=s.getTooltip_AsString();if(S){e.attr("title",S)}e.openEnd();e.openStart("div",C+"-inner");e.class("sapUiTableCellInner");if(!n.hasRowHeader(t)&&l&&!n.hasRowHighlights(t)&&!n.Grouping.isInTreeMode(t)){e.class("sapUiTableFirstColumnCell")}const w=s.getHAlign();const x=i.getTextAlign(w);if(x){e.style("text-align",x)}e.openEnd();e.openStart("div");e.style("justify-content",c[w]);e.openEnd();if(g){e.renderControl(g)}e.close("div");e.close("div");e.close("td")};b.renderColRsz=function(e,t){e.openStart("div",t.getId()+"-rsz");e.class("sapUiTableColRsz");e.openEnd();e.close("div")};b.renderRowHdr=function(e,t){e.openStart("div",t.getId()+"-sapUiTableRowHdrScr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"Presentation");e.class("sapUiTableRowHdrScr");e.class("sapUiTableNoOpacity");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"RowHeaderCol");e.openEnd();for(let s=0,n=t.getRows().length;s<n;s++){this.renderRowAddon(e,t,t.getRows()[s],s,true)}e.close("div")};b.renderRowActions=function(e,t){if(!n.hasRowActions(t)&&!n.hasRowNavigationIndicators(t)){return}e.openStart("div",t.getId()+"-sapUiTableRowActionScr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"Presentation");n.hasRowActions(t)?e.class("sapUiTableRowWithAction"):e.class("sapUiTableRowActionScr");e.class("sapUiTableNoOpacity");e.openEnd();for(let s=0,n=t.getRows().length;s<n;s++){this.renderRowAddon(e,t,t.getRows()[s],s,false)}e.close("div")};b.addRowCSSClasses=function(e,t,s){const a=t._getRowCounts();const i=n.getFirstFixedBottomRowIndex(t);if(s===0){e.class("sapUiTableFirstRow")}else if(s===t.getRows().length-1){e.class("sapUiTableLastRow")}if(a.fixedTop>0){if(s===a.fixedTop-1){e.class("sapUiTableRowLastFixedTop")}if(s===a.fixedTop){e.class("sapUiTableRowFirstScrollable")}}if(i>=0&&i===s){e.class("sapUiTableRowFirstFixedBottom")}else if(i>=1&&i-1===s){e.class("sapUiTableRowLastScrollable")}};b.renderRowAddon=function(e,t,s,a,i){const o=s._isSelected();e.openStart("div");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"RowAddon");e.attr("data-sap-ui-related",s.getId());e.attr("data-sap-ui-rowindex",a);e.class("sapUiTableRow");e.class("sapUiTableContentRow");if(s.isContentHidden()){e.class("sapUiTableRowHidden")}else if(o){e.class("sapUiTableRowSel")}if(a%2!==0&&t.getAlternateRowColors()&&!n.Grouping.isInTreeMode(t)){e.class("sapUiTableRowAlternate")}this.addRowCSSClasses(e,t,a);e.openEnd();e.openStart("div",t.getId()+(i?"-rowsel":"-rowact")+a);e.class("sapUiTableCell");e.class("sapUiTableContentCell");e.class(i?"sapUiTableRowSelectionCell":"sapUiTableRowActionCell");n.Hook.call(t,p.RenderRowStyles,e);e.attr("tabindex","-1");const l={rowSelected:o,rowHidden:s.isEmpty()};t._getAccRenderExtension().writeAriaAttributesFor(e,t,i?"RowHeader":"RowAction",l);e.openEnd();if(i){this.writeRowHighlightContent(e,t,s,a);this.writeRowSelectorContent(e,t,s)}else{const n=s.getRowAction();if(n){e.renderControl(n)}this.writeRowNavigationContent(e,t,s,a)}e.close("div");e.close("div")};b.renderTableCtrl=function(e,t){if(t.getComputedFixedColumnCount()>0){e.openStart("div",t.getId()+"-sapUiTableCtrlScrFixed");e.class("sapUiTableCtrlScrFixed");e.openEnd();this.renderTableControl(e,t,true);e.close("div")}e.openStart("div",t.getId()+"-sapUiTableCtrlScr");e.class("sapUiTableCtrlScr");if(t.getComputedFixedColumnCount()>0){if(t._bRtlMode){e.style("margin-right","0")}else{e.style("margin-left","0")}}e.openEnd();e.openStart("div",t.getId()+"-tableCtrlCnt");e.class("sapUiTableCtrlCnt");e.openEnd();this.renderTableControl(e,t,false);e.close("div");e.close("div")};b.renderTableControl=function(e,t,s){let n;let a;if(s){n=0;a=t.getComputedFixedColumnCount()}else{n=t.getComputedFixedColumnCount();a=t.getColumns().length}const i=t._getRowCounts();const o=t.getRows();if(i.fixedTop>0){this.renderTableControlCnt(e,t,s,n,a,true,false,0,i.fixedTop)}this.renderTableControlCnt(e,t,s,n,a,false,false,i.fixedTop,o.length-i.fixedBottom);if(i.fixedBottom>0&&o.length>0){this.renderTableControlCnt(e,t,s,n,a,false,true,o.length-i.fixedBottom,o.length)}};b.renderTableControlCnt=function(e,t,s,a,i,o,l,r,d,c){let p=c?"-header":"-table";let b=t.getId()+p;const g=[];if(s){b+="-fixed";g.push("sapUiTableCtrlFixed")}else{g.push("sapUiTableCtrlScroll")}if(o){b+="-fixrow";g.push("sapUiTableCtrlRowFixed")}else if(l){b+="-fixrow-bottom";g.push("sapUiTableCtrlRowFixedBottom")}else{g.push("sapUiTableCtrlRowScroll")}e.openStart("table",b);g.forEach(function(t){e.class(t)});t._getAccRenderExtension().writeAriaAttributesFor(e,t,c?"Presentation":"Table");e.class("sapUiTableCtrl");if(c){e.class("sapUiTableCHT")}e.style(s?"width":"min-width",t._getColumnsWidth(a,i)+"px");e.openEnd();e.openStart("thead").openEnd();e.openStart("tr");e.class("sapUiTableCtrlCol");if(r===0){e.class("sapUiTableCtrlFirstCol")}if(c){e.class("sapUiTableCHTHR")}e.openEnd();const u=t.getColumns();const f=new Array(i);let T;let C;let h=!s&&i>a;const R=t._getVisibleColumns();for(T=a;T<i;T++){C=u[T];const e={shouldRender:!!(C&&C.shouldRender())};if(e.shouldRender){let t=C.getWidth();if(n.isVariableWidth(t)){h=false;if(s){C._iFixWidth=C._iFixWidth||160;t=C._iFixWidth+"px"}}else if(s){delete C._iFixWidth}e.width=t}f[T]=e}if(u.length===0){e.openStart("th").openEnd().close("th")}for(T=a;T<i;T++){p=c?"_hdr":"_col";C=u[T];const s=f[T];if(s.shouldRender){if(r===0){e.openStart("th",t.getId()+p+T);t._getAccRenderExtension().writeAriaAttributesFor(e,t,"Th",{column:C})}else{e.openStart("th")}e.style("width",s.width);e.attr("data-sap-ui-headcolindex",T);e.attr("data-sap-ui-colid",C.getId());if(C===R[0]){e.class("sapUiTableFirstVisibleColumnTH")}e.openEnd();if(r===0&&n.getHeaderRowCount(t)===0&&!c){if(C.getMultiLabels().length>0){e.renderControl(C.getMultiLabels()[0])}else{e.renderControl(C.getLabel())}}e.close("th")}}if(h){e.openStart("th",c&&t.getId()+"-dummycolhdr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"Presentation");e.openEnd().close("th")}e.close("tr");e.close("thead");e.openStart("tbody").openEnd();const S=t.getRows();let w;let x;if(c){for(w=r,x=d;w<x;w++){this.renderColumnHeaderRow(e,t,w,s,a,i,h,w===x-1)}}else{const o=n.isRowSelectionAllowed(t);const l=t.getDragDropConfig().some(function(e){return e.getMetadata().isInstanceOf("sap.ui.core.dnd.IDragInfo")&&e.getSourceAggregation()==="rows"});const c=this.getLastFixedColumnIndex(t);for(w=r,x=d;w<x;w++){this.renderTableRow(e,t,S[w],w,s,a,i,false,R,c,h,o,l)}}e.close("tbody");e.close("table")};b.writeRowSelectorContent=function(e,t,s){t._getAccRenderExtension().writeAccRowSelectorText(e,t,s);if(n.Grouping.isInGroupMode(t)){e.openStart("div");e.class("sapUiTableGroupShield");e.openEnd();e.close("div");e.openStart("div",s.getId()+"-groupHeader");e.class("sapUiTableGroupIcon");e.openEnd();e.close("div")}};b.writeRowHighlightContent=function(e,t,s,a){if(!n.hasRowHighlights(t)){return}const i=s.getAggregation("_settings");const o=i._getHighlightCSSClassName();e.openStart("div",s.getId()+"-highlight");e.class("sapUiTableRowHighlight");e.class(o);e.openEnd();t._getAccRenderExtension().writeAccRowHighlightText(e,t,s,a);e.close("div")};b.writeRowNavigationContent=function(e,t,s,a){if(!n.hasRowNavigationIndicators(t)){return}const i=s.getAggregation("_settings");e.openStart("div",s.getId()+"-navIndicator");if(i.getNavigated()){e.class("sapUiTableRowNavigated")}e.openEnd();e.close("div")};b.renderColumnHeaderRow=function(e,t,s,n,a,i,o,l){e.openStart("tr");e.class("sapUiTableRow");e.class("sapUiTableHeaderRow");e.class("sapUiTableColHdrTr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"ColumnHeaderRow");e.openEnd();const r=this.getColumnsToRender(t,a,i);let c=0;let p=-1;function b(e,t,n){let a=d.getHeaderSpan(e,s);let i;if(c<1){if(a>1){i=e.getIndex();a=n.slice(t+1,t+a).reduce(function(e,t){return t.getIndex()-i<a?e+1:e},1)}e._nSpan=c=a;p=t}else{e._nSpan=0}c--}r.forEach(b);function g(a,i){this.renderCol(e,t,a,s,a._nSpan,i===0,n&&i===p,!n&&i===p,a._nSpan===1&&!a._bIconsRendered);a._bIconsRendered=a._bIconsRendered||a._nSpan===1;delete a._nSpan;if(l){delete a._bIconsRendered}}r.forEach(g.bind(this));if(!n&&o&&r.length>0){e.openStart("td").class("sapUiTableCellDummy");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"Presentation");e.openEnd().close("td")}e.close("tr")};b.renderTableRow=function(e,t,s,a,i,o,l,r,d,c,b,g,u){if(!s){return}if(i){e.openStart("tr",s.getId()+"-fixed");e.attr("data-sap-ui-related",s.getId())}else{e.openStart("tr",s)}if(s._bDummyRow){e.style("opacity","0")}e.class("sapUiTableRow");e.class("sapUiTableContentRow");e.class("sapUiTableTr");if(u&&i){e.attr("draggable","true");e.attr("data-sap-ui-draggable","true")}if(s.isContentHidden()){e.class("sapUiTableRowHidden")}else if(s._isSelected()){e.class("sapUiTableRowSel")}if(a%2!==0&&t.getAlternateRowColors()&&!n.Grouping.isInTreeMode(t)){e.class("sapUiTableRowAlternate")}this.addRowCSSClasses(e,t,a);e.attr("data-sap-ui-rowindex",a);n.Hook.call(t,p.RenderRowStyles,e);const f=s.getAggregation("_settings");const T={index:a,fixedCol:i,rowNavigated:f?f.getNavigated():false};t._getAccRenderExtension().writeAriaAttributesFor(e,t,"Tr",T);e.openEnd();const C=!s.isEmpty()&&s._isSelected();const h=s.getCells();for(let n=0,a=h.length;n<a;n++){this.renderTableCell(e,t,s,h[n],n,i,o,l,d,c,C)}if(!i&&b&&h.length>0){e.openStart("td").class("sapUiTableCellDummy");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"Presentation");e.openEnd();e.close("td")}e.close("tr")};b.renderTableCell=function(e,t,a,o,l,r,d,c,b,g,u){const f=s.ofCell(o);const T=f.getIndex();if(f.shouldRender()&&d<=T&&c>T){const s=a.getId()+"-col"+l;e.openStart("td",s);e.attr("tabindex","-1");e.attr("data-sap-ui-colid",f.getId());const d=b.length;const c=d>0&&b[0]===f;const C=d>0&&b[d-1]===f;const h=r&&g===T;const R={index:T,column:f,row:a,fixed:r,rowSelected:u};t._getAccRenderExtension().writeAriaAttributesFor(e,t,"DataCell",R);const S=i.getTextAlign(f.getHAlign());if(S){e.style("text-align",S)}e.class("sapUiTableCell");e.class("sapUiTableContentCell");e.class("sapUiTableDataCell");if(c){e.class("sapUiTableCellFirst")}if(h){e.class("sapUiTableCellLastFixed")}if(C){e.class("sapUiTableCellLast")}if(c&&n.Grouping.isInTreeMode(t)){e.class("sapUiTableCellFlex")}e.openEnd();e.openStart("div");e.class("sapUiTableCellInner");if(!n.hasRowHeader(t)&&c&&!n.hasRowHighlights(t)&&!n.Grouping.isInTreeMode(t)){e.class("sapUiTableFirstColumnCell")}n.Hook.call(t,p.RenderCellContentStyles,e);e.openEnd();this.renderTableCellControl(e,t,o,c);e.close("div");e.close("td")}};b.renderTableCellControl=function(e,t,s,a){if(a&&n.Grouping.isInTreeMode(t)){const n=s.getParent();e.openStart("span",n.getId()+"-treeicon");e.class("sapUiTableTreeIcon");e.attr("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"TreeIcon",{row:n});e.openEnd();e.close("span")}e.renderControl(s)};b.renderVSb=function(e,t,s){const n=t._getScrollExtension();const a=t._getRowCounts();s=Object.assign({tabIndex:true},s);e.openStart("div");e.class("sapUiTableVSbContainer");if(!n.isVerticalScrollbarRequired()){e.class("sapUiTableHidden")}e.class(s.cssClass);const i=t._collectRowHeights(true).reduce((e,t)=>e+t,0)+1;e.style("margin-top",i+"px");e.openEnd();e.openStart("div",t.getId()+"-vsb");e.class("sapUiTableVSb");e.style("max-height",n.getVerticalScrollbarHeight()+"px");if(a.fixedTop>0){e.style("top",a.fixedTop*t._getBaseRowHeight()-1+"px")}if(s.tabIndex){e.attr("tabindex","-1")}e.openEnd();e.openStart("div");e.class("sapUiTableVSbContent");e.style("height",n.getVerticalScrollHeight()+"px");e.openEnd();e.close("div");e.close("div");e.close("div")};b.renderVSbExternal=function(e,t){if(a.isEnrichedWith(t,"sap.ui.table.extensions.Synchronization")){this.renderVSb(e,t,{cssClass:"sapUiTableVSbExternal",tabIndex:false})}else{l.error("This method can only be used with synchronization enabled.",t,"TableRenderer.renderVSbExternal")}};b.renderHSb=function(e,t,s){s=Object.assign({id:t.getId()+"-hsb",cssClass:"sapUiTableHSb",tabIndex:true,hidden:true,scrollWidth:0},s);e.openStart("div",s.id);e.class(s.cssClass);if(s.hidden){e.class("sapUiTableHidden")}if(s.tabIndex){e.attr("tabindex","-1")}e.openEnd();e.openStart("div",s.id+"-content");e.class("sapUiTableHSbContent");if(s.scrollWidth>0){e.style("width",s.scrollWidth+"px")}e.openEnd();e.close("div");e.close("div")};b.renderHSbExternal=function(e,t,s,n){if(a.isEnrichedWith(t,"sap.ui.table.extensions.Synchronization")){this.renderHSb(e,t,{id:s,cssClass:"sapUiTableHSbExternal",tabIndex:false,hidden:false,scrollWidth:n})}else{l.error("This method can only be used with synchronization enabled.",t,"TableRenderer.renderVSbExternal")}};b.renderHSbBackground=function(e,t){e.openStart("div",t.getId()+"-hsb-bg");e.class("sapUiTableHSbBg");e.openEnd().close("div")};b.renderTabElement=function(e,t,s,n){e.openStart("div");if(t){e.class(t)}if(n){e.attr("id",n)}e.attr("role","none");e.attr("tabindex",s==null?"0":s);e.openEnd().close("div")};b.getColumnsToRender=function(e,t,s){return e.getColumns().slice(t,s).filter(function(e){return e&&e.shouldRender()})};b.getLastFixedColumnIndex=function(e){const t=e.getComputedFixedColumnCount();const s=e.getColumns();let n;let a;for(let e=t-1;e>=0;e--){n=s[e];if(n.shouldRender()){a=e;break}}return a};return b},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/TreeTable", ["./Table","./TableRenderer","sap/ui/model/ClientTreeBindingAdapter","sap/ui/model/TreeBindingCompatibilityAdapter","./library","./utils/TableUtils","./plugins/BindingSelection","sap/base/Log","sap/base/assert","sap/ui/model/controlhelper/TreeBindingProxy"],function(e,t,o,n,i,r,s,p,a,l){"use strict";const u=r.createWeakMapFacade();const d=e.extend("sap.ui.table.TreeTable",{metadata:{library:"sap.ui.table",properties:{expandFirstLevel:{type:"boolean",defaultValue:false,deprecated:true},useGroupMode:{type:"boolean",group:"Appearance",defaultValue:false},groupHeaderProperty:{type:"string",group:"Data",defaultValue:null},collapseRecursive:{type:"boolean",defaultValue:true,deprecated:true},rootLevel:{type:"int",group:"Data",defaultValue:0,deprecated:true}},events:{toggleOpenState:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},expanded:{type:"boolean"}}}}},renderer:t});d.prototype.init=function(){e.prototype.init.apply(this,arguments);u(this).bPendingRequest=false;r.Grouping.setToDefaultTreeMode(this);r.Hook.register(this,r.Hook.Keys.Row.UpdateState,y,this);r.Hook.register(this,r.Hook.Keys.Row.Expand,c,this);r.Hook.register(this,r.Hook.Keys.Row.Collapse,g,this);this._oProxy=new l(this,"rows")};d.prototype._bindRows=function(t){u(this).bPendingRequest=false;const o=this.getExpandFirstLevel()?1:0;this._oProxy.applyLegacySettingsToBindingInfo(t,{rootLevel:this.isPropertyInitial("rootLevel")?undefined:this.getRootLevel(),collapseResursive:this.isPropertyInitial("collapseRecursive")?undefined:this.getCollapseRecursive(),numberOfExpandedLevels:this.isPropertyInitial("expandFirstLevel")?undefined:o});return e.prototype._bindRows.call(this,t)};function y(e){const t=e.context["_mProxyInfo"];e.level=t.level;e.expandable=!t.isLeaf;e.expanded=t.isExpanded;if(r.Grouping.isInGroupMode(this)){const t=this.getGroupHeaderProperty();if(t){e.title=e.context.getProperty(t)}if(e.expandable){e.type=e.Type.GroupHeader;e.contentHidden=true}}}function c(e){const t=e.getIndex();this._oProxy.expand(t);const o=this._oProxy.isExpanded(t);if(typeof o==="boolean"){this._onGroupHeaderChanged(t,o)}}function g(e){const t=e.getIndex();this._oProxy.collapse(t);const o=this._oProxy.isExpanded(t);if(typeof o==="boolean"){this._onGroupHeaderChanged(t,o)}}d.prototype.setFixedRowCount=function(e){p.warning('TreeTable: the property "fixedRowCount" is not supported and will be ignored!');return this};d.prototype.isTreeBinding=function(t){t=t||"rows";if(t==="rows"){return this._oProxy.isTreeBinding()}return e.prototype.isTreeBinding.apply(this,arguments)};d.prototype.getBinding=function(t){t=t==null?"rows":t;const i=e.prototype.getBinding.call(this,t);if(i&&t==="rows"&&!i.getLength){if(i.isA("sap.ui.model.odata.ODataTreeBinding")){n(i,this)}else if(i.isA("sap.ui.model.odata.v2.ODataTreeBinding")){i.applyAdapterInterface()}else if(i.isA("sap.ui.model.ClientTreeBinding")){o.apply(i)}else{p.error("Binding not supported by sap.ui.table.TreeTable")}}return i};d.prototype._getContexts=function(e,t,o,n){if(!this.getVisible()){return[]}return this._oProxy.getContexts(e,t,o,n)};d.prototype._getRowContexts=function(e){return h(this,e)};function h(t,o,n){const i=t._getTotalRowCount();let r=e.prototype._getRowContexts.call(t,o);if(n===true){return r}const s=t._getTotalRowCount();const p=t._getFirstRenderedRowIndex();const a=t._getMaxFirstRenderedRowIndex();t._adjustToTotalRowCount();if(a<p&&t._bContextsAvailable){r=h(t,o,true)}else if(i!==s){r=h(t,o,true)}return r}d.prototype._onGroupHeaderChanged=function(e,t){this.fireToggleOpenState({rowIndex:e,rowContext:this.getContextByIndex(e),expanded:t})};d.prototype.expand=function(e){this._oProxy.expand(e);return this};d.prototype.collapse=function(e){this._oProxy.collapse(e);return this};d.prototype.collapseAll=function(){this._oProxy.collapseAll();if(this.getBinding()){this.setFirstVisibleRow(0)}return this};d.prototype.expandToLevel=function(e){this._oProxy.expandToLevel(e);return this};d.prototype.isExpanded=function(e){return this._oProxy.isExpanded(e)};d.prototype.getContextByIndex=function(e){return this._oProxy.getContextByIndex(e)};d.prototype.setRootLevel=function(e){this.setFirstVisibleRow(0);this._oProxy.setRootLevel(e);this.setProperty("rootLevel",e,true);return this};d.prototype.setCollapseRecursive=function(e){this._oProxy.setCollapseRecursive(e);this.setProperty("collapseRecursive",!!e,true);return this};d.prototype.setUseGroupMode=function(e){this.setProperty("useGroupMode",!!e);f(this);return this};d.prototype.setEnableGrouping=function(){p.warning("The property enableGrouping is not supported by the sap.ui.table.TreeTable control");return this};d.prototype.setGroupBy=function(){p.warning("The groupBy association is not supported by the sap.ui.table.TreeTable control");return this};d.prototype.setUseFlatMode=function(e){this._bFlatMode=!!e;f(this);return this};function f(e){if(e.getUseGroupMode()){r.Grouping.setHierarchyMode(e,r.Grouping.HierarchyMode.GroupedTree)}else if(e._bFlatMode){r.Grouping.setToDefaultFlatMode(e)}else if(!e._bFlatMode){r.Grouping.setToDefaultTreeMode(e)}}d.prototype._createLegacySelectionPlugin=function(){return new s};d.prototype._onBindingDataRequested=function(t){u(this).bPendingRequest=true;e.prototype._onBindingDataRequested.apply(this,arguments)};d.prototype._onBindingDataReceived=function(t){u(this).bPendingRequest=false;e.prototype._onBindingDataReceived.apply(this,arguments)};d.prototype._isWaitingForData=function(){return u(this).bPendingRequest&&e.prototype._isWaitingForData.apply(this)};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/extensions/Accessibility", ["./ExtensionBase","./AccessibilityRender","../utils/TableUtils","../library","sap/ui/core/ControlBehavior","sap/ui/core/Element","sap/ui/thirdparty/jquery"],function(e,t,o,i,n,a,jQuery){"use strict";const r=i.SelectionMode;const l=o.CELLTYPE;const s={getAccInfoOfControl:function(e){let t=null;if(e&&typeof e.getAccessibilityInfo==="function"){if(typeof e.getVisible==="function"&&!e.getVisible()){t=s._normalize({})}else{const o=e.getAccessibilityInfo();if(o){const e={};s._flatten(o,e);t=e}}if(t&&!t.description){t.description=o.getResourceText("TBL_CTRL_STATE_EMPTY")}}return t},_normalize:function(e){if(!e){return null}if(e._normalized){return e}e.role=e.role||"";e.type=e.type||"";e.description=e.description||"";e.enabled=e.enabled===true||e.enabled===false?e.enabled:null;e.editable=e.editable===true||e.editable===false?e.editable:null;e.children=e.children||[];e._normalized=true;return e},_flatten:function(e,t,o){o=o?o:0;s._normalize(e);if(o===0){s._normalize(t);t._descriptions=[]}t._descriptions.push(s._getFullDescription(e));e.children.forEach(function(e){if(!e.getAccessibilityInfo||e.getVisible&&!e.getVisible()){return}const i=e.getAccessibilityInfo();if(i){s._flatten(i,t,o+1)}});if(o===0){t.description=t._descriptions.join(" ").trim();t._descriptions=undefined}},_getFullDescription:function(e){let t=e.type+" "+e.description;if(e.enabled===false){t=t+" "+o.getResourceText("TBL_CTRL_STATE_DISABLED")}else if(e.editable===false){t=t+" "+o.getResourceText("TBL_CTRL_STATE_READONLY")}else if(e.required===true){t=t+" "+o.getResourceText("TBL_CTRL_STATE_REQUIRED")}return t.trim()}};const c=function(e,t,i,n){const a=i&&e.getShowOverlay()||n&&o.isNoDataVisible(e);if(a){t["aria-hidden"]="true"}let r="";if(i){r="overlay"}if(n){r=i?r.concat(",","nodata"):"nodata"}if(r){t["data-sap-ui-table-acc-covered"]=r}};const u={getColumnIndexOfFocusedCell:function(e){const t=e.getTable();const i=o.getFocusedItemInfo(t);return i.cellInRow-(o.hasRowHeader(t)?1:0)},getInfoOfFocusedCell:function(e){const t=e.getTable();const i=t._getItemNavigation();const n=t.getDomRef();if(!e.getAccMode()||!n||!i){return null}const a=i.getFocusedDomRef();if(!a||a!==document.activeElement){return null}return o.getCellInfo(a)},getRelevantColumnHeaders:function(e,t){const i=[];if(!e||!t||!e.getColumnHeaderVisible()){return i}const n=o.getHeaderRowCount(e);if(n>0){const a=t.getId();i.push(a);for(let e=1;e<n;e++){i.push(a+"_"+e)}const r=o.Column.getParentSpannedColumns(e,a);if(r&&r.length){for(let e=0;e<r.length;e++){const t=r[e].level;const o=r[e].column.getId();i[t]=t===0?o:o+"_"+t}}}return i},isHiddenCell:function(e,t){const i=o.Grouping.isInGroupHeaderRow(e);const n=o.Grouping.isInSummaryRow(e);const a=!!t&&!!t.hasStyleClass;const r=e.parent().hasClass("sapUiTableRowHidden");const l=e.hasClass("sapUiTableCellHidden");const s=i&&a&&t.hasStyleClass("sapUiAnalyticalTableGroupCellHidden");const c=n&&a&&t.hasStyleClass("sapUiAnalyticalTableSumCellHidden");return r||l||s||c},isTreeColumnCell:function(e,t){return o.Grouping.isInTreeMode(e.getTable())&&t.hasClass("sapUiTableCellFirst")},getColumnTooltip:function(e){if(!e){return null}const t=e.getLabel();function i(e){if(!e){return false}const o=t&&t.getText?t.getText():"";return e===o}let n=e.getTooltip_AsString();if(!i(n)){return n}if(o.isA(t,"sap.ui.core.Control")){n=t.getTooltip_AsString()}if(!i(n)){return n}return null},getGridSize:function(e){const t=o.hasRowHeader(e);const i=o.hasRowActions(e);const n=o.getVisibleColumnCount(e)+(t?1:0)+(i?1:0);const a=o.isNoDataVisible(e)?0:Math.max(e._getTotalRowCount(),e._getRowCounts()._fullsize);return{columnCount:n,rowCount:o.getHeaderRowCount(e)+a}},getRowIndex:function(e){return e.getIndex()+1+o.getHeaderRowCount(e.getTable())},getRowColChange:function(e){const t=e.getTable();const i=t._getItemNavigation();let n=false;let a=false;let r=false;const l=o.hasRowHeader(t);if(i){const i=u.getColumnIndexOfFocusedCell(e)+1+(l?1:0);const s=t.getRows()[o.getRowIndexOfFocusedCell(t)];const c=s?u.getRowIndex(s):0;n=e._iLastRowNumber!==c||e._iLastRowNumber===c&&e._iLastColumnNumber===i;a=e._iLastColumnNumber!==i;r=e._iLastRowNumber==null&&e._iLastColumnNumber==null;e._iLastRowNumber=c;e._iLastColumnNumber=i}return{rowChange:n,colChange:a,initial:r}},cleanupCellModifications:function(e){if(e._cleanupInfo){e._cleanupInfo.cell.attr(e._cleanupInfo.attr);e._cleanupInfo=null}},storeDefaultsBeforeCellModifications:function(e,t,o,i){e._cleanupInfo={cell:t,attr:{"aria-labelledby":o&&o.length?o.join(" "):null,"aria-describedby":i&&i.length?i.join(" "):null}}},performCellModifications:function(e,t,i,n,a,r,l,s){u.storeDefaultsBeforeCellModifications(e,t,i,n);const c=u.getRowColChange(e);const d=e.getTable();const f=d.getId();d.$("cellacc").text(l||".");if(s){s(a,r,c.rowChange,c.colChange,c.initial)}if(c.initial||c.rowChange){if(o.hasRowNavigationIndicators(d)){const e=o.getCellInfo(t);if(e.type!==o.CELLTYPE.COLUMNHEADER&&e.type!==o.CELLTYPE.COLUMNROWHEADER){const t=d.getRows()[e.rowIndex].getAggregation("_settings");if(t.getNavigated()){a.push(f+"-rownavigatedtext")}}}}const g=a&&a.length?a.join(" "):null;t.attr({"aria-labelledby":g,"aria-describedby":r&&r.length?r.join(" "):null})},modifyAccOfDataCell:function(e){const t=this.getTable();const i=t.getId();const n=t._getItemNavigation();if(!n){return}const a=jQuery(e.cell);const r=o.getRowIndexOfFocusedCell(t);const l=u.getColumnIndexOfFocusedCell(this);const c=o.getRowColCell(t,r,l,false);let d=null;const f=c.row;const g=f.getId();const b=u.isHiddenCell(a,c.cell);const p=u.isTreeColumnCell(this,a);const h=u.getAriaAttributesForDataCell(this,{index:l,column:c.column,fixed:o.isFixedColumn(t,l)})["aria-labelledby"]||[];const C=[];let T=[];const A=f.isGroupHeader();const w=f.isSummary();if(A){T.push(i+"-ariarowgrouplabel")}else if(f.isTotalSummary()){T.push(i+"-ariagrandtotallabel")}else if(f.isGroupSummary()){T.push(i+"-ariagrouptotallabel")}if(o.hasRowHighlights(t)&&!A&&!w){T.push(g+"-highlighttext")}T=T.concat(h);if(!b){d=s.getAccInfoOfControl(c.cell);T.push(d?i+"-cellacc":c.cell.getId())}let m="";if(d){m=d.description;if(o.getInteractiveElements(a)!==null){m=o.getResourceText("TBL_CELL_INCLUDES",[m])}}if(p&&!b){const e=u.getAriaAttributesForTreeIcon(this,{row:c.row});if(e&&e["aria-label"]){m=e["aria-label"].concat(" ",m)}}u.performCellModifications(this,a,h,null,T,C,m,function(e,i,n,r){if(A&&n){e.splice(1,0,g+"-groupHeader")}const l=a.find(".sapUiTableTreeIcon").not(".sapUiTableTreeIconLeaf").length===1;if((l||A)&&(n||r)){i.push(t.getId()+(!f.isExpanded()?"-rowexpandtext":"-rowcollapsetext"))}else if(!b&&!A&&!w&&o.isRowSelectionAllowed(t)&&n){e.push(g+"-rowselecttext")}})},modifyAccOfRowHeader:function(e){const t=this.getTable();const i=t.getId();const n=jQuery(e.cell);const a=t.getRows()[e.rowIndex];const r=a.getId();const l=u.getAriaAttributesForRowHeader(this)["aria-labelledby"]||[];const s=[].concat(l);if(!a.isSummary()&&!a.isGroupHeader()&&!a.isContentHidden()){s.push(r+"-rowselecttext");if(o.hasRowHighlights(t)){s.push(r+"-highlighttext")}}if(a.isGroupHeader()){s.push(i+"-ariarowgrouplabel");s.push(r+"-groupHeader");s.push(i+(a.isExpanded()?"-rowcollapsetext":"-rowexpandtext"))}if(a.isTotalSummary()){s.push(i+"-ariagrandtotallabel")}else if(a.isGroupSummary()){s.push(i+"-ariagrouptotallabel")}u.performCellModifications(this,n,l,null,s,null,null)},modifyAccOfColumnHeader:function(e){const t=this.getTable();const i=jQuery(e.cell);const n=a.getElementById(i.attr("data-sap-ui-colid"));const r=o.Column.getHeaderLabel(n);const l=u.getAriaAttributesForColumnHeader(this,{headerId:i.attr("id"),column:n,index:i.attr("data-sap-ui-colindex")});const s=u.getColumnTooltip(n);const c=l["aria-labelledby"]||[];const d=e.columnSpan;if(r?.getRequired?.()){c.push(t.getId()+"-ariarequired")}if(d>1){c.push(t.getId()+"-ariacolspan");t.$("ariacolspan").text(o.getResourceText("TBL_COL_DESC_SPAN",[""+d]))}if(s){c.push(t.getId()+"-cellacc")}if(d<=1&&n&&n.getFiltered()){c.push(t.getId()+"-ariacolfiltered")}if(c.length>0){c.unshift(i.attr("id")+"-inner")}u.performCellModifications(this,i,l["aria-labelledby"],l["aria-describedby"],c,l["aria-describedby"],s)},modifyAccOfColumnRowHeader:function(e){const t=this.getTable();const o=jQuery(e.cell);const i=o.hasClass("sapUiTableSelAllVisible");const n=u.getAriaAttributesForColumnRowHeader(this,{enabled:i,checked:i&&!t.$().hasClass("sapUiTableSelAll")});const a=n["aria-labelledby"]||[];u.performCellModifications(this,o,[],n["aria-describedby"],a,n["aria-describedby"],null)},modifyAccOfRowAction:function(e){const t=this.getTable();const i=t.getId();const n=jQuery(e.cell);const a=t.getRows()[e.rowIndex];const r=a.getId();const l=u.isHiddenCell(n);const s=u.getAriaAttributesForRowAction(this)["aria-labelledby"]||[];const c=[].concat(s);const d=[];const f=a.isGroupHeader();if(f){c.push(i+"-ariarowgrouplabel");c.push(i+(a.isExpanded()?"-rowcollapsetext":"-rowexpandtext"))}if(a.isTotalSummary()){c.push(i+"-ariagrandtotallabel")}else if(a.isGroupSummary()){c.push(i+"-ariagrouptotallabel")}if(o.hasRowHighlights(t)&&!a.isGroupHeader()&&!a.isSummary()){c.push(r+"-highlighttext")}let g="";if(!l){const e=a.getRowAction();if(e){const t=e.getAccessibilityInfo();if(t){c.push(i+"-cellacc");g=t.description}}}u.performCellModifications(this,n,s,[],c,d,g,function(e,t,o){if(f&&o){const t=e.indexOf(i+"-ariarowgrouplabel")+1;e.splice(t,0,r+"-groupHeader")}})},getAriaAttributesForColumnRowHeaderRow:function(){return{role:"row","aria-hidden":"true"}},getAriaAttributesForColumnRowHeaderCell:function(){return{role:"columnheader"}},getAriaAttributesForColumnRowHeader:function(e,t){const i={};const n=e.getTable();const a=n._getSelectionPlugin().getRenderConfig();if(n.getSelectionMode()!==r.None){i["aria-label"]=o.getResourceText("TBL_TABLE_SELECTION_COLUMNHEADER")}if(a.headerSelector.visible){if(a.headerSelector.type==="toggle"){i["role"]=["checkbox"];if(t&&t.enabled){i["aria-checked"]=t.checked?"true":"false"}}else if(a.headerSelector.type==="custom"){i["role"]=["button"];if(!t||!t.enabled){i["aria-disabled"]="true"}}}return i},getAriaAttributesForRowAddon:function(){return{role:"row","aria-hidden":"true"}},getAriaAttributesForRowHeader:function(e){const t={};const i=e.getTable();const n=i.getId();t["role"]="gridcell";t["aria-colindex"]=1;if(o.hasRowHeader(i)&&i.getSelectionMode()===r.None){t["aria-labelledby"]=[n+"-rowselecthdr"]}return t},getAriaAttributesForRowAction:function(e){const t={};const i=e.getTable();const n=i.getId();t["role"]="gridcell";t["aria-colindex"]=o.getVisibleColumnCount(i)+1+(o.hasRowHeader(i)?1:0);t["aria-labelledby"]=[n+"-rowacthdr"];return t},getAriaAttributesForColumnHeader:function(e,t){const i={};const n=e.getTable();const a=n.getId();const r=t&&t.column;const l=t&&t.colspan;i["role"]="columnheader";i["aria-colindex"]=t.index+1+(o.hasRowHeader(n)?1:0);if(t&&t.index<n.getComputedFixedColumnCount()){i["aria-labelledby"]=[a+"-ariafixedcolumn"]}if(!l&&r){i["aria-sort"]=r.getSortOrder().toLowerCase();if(!r.getSorted()){i["aria-sort"]="none"}const e=r.getHeaderMenuInstance();if(e){const t=e.getAriaHasPopupType();if(t!=="None"){i["aria-haspopup"]=t.toLowerCase()}}if(!e&&r._menuHasItems()){i["aria-haspopup"]="menu"}}return i},getAriaAttributesForDataCell:function(e,t){const i={};const n=e.getTable();const a=n.getId();i["role"]="gridcell";i["aria-colindex"]=t.index+1+(o.hasRowHeader(n)?1:0);if(t.column&&t.fixed){i["aria-labelledby"]=[a+"-ariafixedcolumn"]}return i},getAriaAttributesForTable:function(e){const t={role:"presentation"};const o=e.getTable();c(o,t,true,true);return t},getAriaAttributesForContent:function(e){const t={};const i=e.getTable();const n=i.getId();t["role"]=o.Grouping.isInGroupMode(i)||o.Grouping.isInTreeMode(i)?"treegrid":"grid";t["aria-describedby"]=[n+"-ariaselection"];t["aria-labelledby"]=[].concat(i.getAriaLabelledBy());if(i.getTitle()){t["aria-labelledby"].push(i.getTitle().getId())}if(i.getSelectionMode()===r.MultiToggle){t["aria-multiselectable"]="true"}const a=i._getRowCounts();const l=o.hasFixedColumns(i);const s=a.fixedTop>0;const c=a.fixedBottom>0;const d=o.hasRowHeader(i);const f=o.hasRowActions(i);const g=u.getGridSize(i);t["aria-owns"]=[n+"-sapUiTableColHdrCnt",n+"-table"];if(l){t["aria-owns"].push(n+"-table-fixed")}if(s){t["aria-owns"].push(n+"-table-fixrow");if(l){t["aria-owns"].push(n+"-table-fixed-fixrow")}}if(c){t["aria-owns"].push(n+"-table-fixrow-bottom");if(l){t["aria-owns"].push(n+"-table-fixed-fixrow-bottom")}}if(d){t["aria-owns"].push(n+"-sapUiTableRowHdrScr")}if(f){t["aria-owns"].push(n+"-sapUiTableRowActionScr")}t["aria-rowcount"]=g.rowCount;t["aria-colcount"]=g.columnCount;if(i.isA("sap.ui.table.AnalyticalTable")){t["aria-roledescription"]=o.getResourceText("TBL_ANALYTICAL_TABLE_ROLE_DESCRIPTION")}return t},getAriaAttributesForTableHeader:function(e){const t={role:"heading","aria-level":"2"};const o=e.getTable();c(o,t,true,false);return t},getAriaAttributesForColumnHeaderRow:function(e){const t={role:"row"};const i=e.getTable();const n=i.getId();t["aria-rowindex"]=["1"];t["aria-owns"]=[];if(o.hasRowHeader(i)){t["aria-owns"].push(n+"-rowcolhdr")}for(let e=0;e<o.getVisibleColumnCount(i);e++){t["aria-owns"].push(i._getVisibleColumns()[e].getId())}if(o.hasRowActions(i)){t["aria-owns"].push(n+"-rowacthdr")}c(i,t,true,false);return t},getAriaAttributesForCreationRow:function(e,t){const o={};const i=e.getTable();o["role"]="form";o["aria-labelledby"]=t.creationRow.getId()+"-label";c(i,o,true,false);return o},getAriaAttributesForRowHeaderCol:function(e){const t={};const o=e.getTable();c(o,t,true,true);return t},getAriaAttributesForTh:function(){return{role:"presentation",scope:"col","aria-hidden":"true"}},getAriaAttributesForTr:function(e,t){const i={};const n=e.getTable();const a=n.getId();i["role"]="row";if(t.rowNavigated){i["aria-current"]=true}i["aria-owns"]=[];if(o.hasRowHeader(n)){i["aria-owns"].push(a+"-rowsel"+t.index)}for(let e=0;e<o.getVisibleColumnCount(n);e++){i["aria-owns"].push(a+"-rows-row"+t.index+"-col"+e)}if(o.hasRowActions(n)){i["aria-owns"].push(a+"-rowact"+t.index)}return i},getAriaAttributesForTreeIcon:function(e,t){let i={};const n=e.getTable();if(o.Grouping.isInTreeMode(n)){i={"aria-label":"",title:"",role:""};if(n.getBinding()){if(t&&t.row){if(t.row.isExpandable()){const e=o.getResourceText("TBL_COLLAPSE_EXPAND");i["title"]=e;i["aria-expanded"]=""+!!t.row.isExpanded();i["aria-hidden"]="false";i["role"]="button"}else{i["aria-label"]=o.getResourceText("TBL_LEAF");i["aria-hidden"]="true"}}}}return i},getAriaAttributesForNoData:function(e){const t={};const i=e.getTable();const n=i.getId();const a=o.getNoContentMessage(i);const r=[];t["role"]="gridcell";if(o.isA(a,"sap.ui.core.Control")){if(a.getAccessibilityReferences instanceof Function){const e=a.getAccessibilityReferences();r.push(e.title);r.push(e.description)}else{r.push(a.getId())}}else{r.push(n+"-noDataMsg")}t["aria-labelledby"]=r;c(i,t,true,false);return t},getAriaAttributesForOverlay:function(e){const t={};const o=e.getTable();const i=o.getId();t["role"]="region";t["aria-labelledby"]=[].concat(o.getAriaLabelledBy());if(o.getTitle()){t["aria-labelledby"].push(o.getTitle().getId())}t["aria-labelledby"].push(i+"-ariainvalid");return t},getAriaAttributesForTableFooter:function(e){const t={};const o=e.getTable();c(o,t,true,false);return t},getAriaAttributesForTableSubHeader:function(e){const t={};const o=e.getTable();c(o,t,true,false);return t},getAriaAttributesForRowActionHeader:function(){return{"aria-hidden":"true"}},getAriaAttributesForPresentation:function(){return{role:"presentation"}}};const d=e.extend("sap.ui.table.extensions.Accessibility",{_init:function(i,a,r){this._accMode=n.isAccessibilityEnabled();this._busyCells=[];o.addDelegate(i,this);e.enrich(i,t);return"AccExtension"},_attachEvents:function(){o.Hook.register(this.getTable(),o.Hook.Keys.Table.TotalRowCountChanged,this._updateAriaRowCount,this)},_detachEvents:function(){o.Hook.deregister(this.getTable(),o.Hook.Keys.Table.TotalRowCountChanged,this._updateAriaRowCount,this)},_debug:function(){this._ExtensionHelper=u;this._ACCInfoHelper=s},destroy:function(){this.getTable().removeEventDelegate(this);this._busyCells=[];e.prototype.destroy.apply(this,arguments)},getAriaAttributesFor:function(e,t){return u["getAriaAttributesFor"+e](this,t)},onfocusin:function(e){const t=this.getTable();if(!t||o.getCellInfo(e.target).cell==null){return}if(t._mTimeouts._cleanupACCExtension){clearTimeout(t._mTimeouts._cleanupACCExtension);t._mTimeouts._cleanupACCExtension=null}this.updateAccForCurrentCell("Focus")},onfocusout:function(e){const t=this.getTable();if(!t||e.target.classList.contains("sapUiTableCtrlBefore")){return}t._mTimeouts._cleanupACCExtension=setTimeout(function(){const e=this.getTable();if(!e){return}this._iLastRowNumber=null;this._iLastColumnNumber=null;u.cleanupCellModifications(this);e._mTimeouts._cleanupACCExtension=null}.bind(this),100)}});d.ELEMENTTYPES={DATACELL:"DataCell",COLUMNHEADER:"ColumnHeader",ROWHEADER:"RowHeader",ROWACTION:"RowAction",COLUMNROWHEADER:"ColumnRowHeader"};d.prototype.getAccMode=function(){return this._accMode};d.prototype._updateAriaRowIndices=function(){if(!this._accMode){return}const e=this.getTable();const t=e.getRows();let o;let i;let n;for(i=0;i<t.length;i++){o=t[i];n=o.getDomRefs(true);n.row.not(n.rowHeaderPart).not(n.rowActionPart).attr("aria-rowindex",u.getRowIndex(o))}};d.prototype._updateAriaRowCount=function(){const e=this.getTable();const t=e.$("sapUiTableGridCnt");if(t){t.attr("aria-rowcount",u.getGridSize(e).rowCount)}};d.prototype.updateAccForCurrentCell=function(e){if(!this._accMode||!this.getTable()._getItemNavigation()){return}if(e==="Focus"||e===o.RowsUpdateReason.Expand||e===o.RowsUpdateReason.Collapse){u.cleanupCellModifications(this)}const t=u.getInfoOfFocusedCell(this);let i;if(!t||!t.isOfType(l.ANY)){return}if(t.isOfType(l.DATACELL)){i=d.ELEMENTTYPES.DATACELL}else if(t.isOfType(l.COLUMNHEADER)){i=d.ELEMENTTYPES.COLUMNHEADER}else if(t.isOfType(l.ROWHEADER)){i=d.ELEMENTTYPES.ROWHEADER}else if(t.isOfType(l.ROWACTION)){i=d.ELEMENTTYPES.ROWACTION}else if(t.isOfType(l.COLUMNROWHEADER)){i=d.ELEMENTTYPES.COLUMNROWHEADER}if(!u["modifyAccOf"+i]){return}if(e!=="Focus"&&e!==o.RowsUpdateReason.Expand&&e!==o.RowsUpdateReason.Collapse){if(t.isOfType(l.ANYCONTENTCELL)){t.cell.setAttribute("role","status");t.cell.setAttribute("role","gridcell")}else{return}}u["modifyAccOf"+i].apply(this,[t])};d.prototype.updateSelectionStateOfRow=function(e){if(!this._accMode){return}const t=e.getDomRefs(true);let o="";if(!e.isEmpty()&&!e.isGroupHeader()&&!e.isSummary()){const i=this.getKeyboardTexts();const n=e._isSelected();if(t.row){t.row.not(t.rowHeaderPart).not(t.rowActionPart).add(t.row.children(".sapUiTableCell")).attr("aria-selected",n?"true":"false")}o=n?i.rowDeselect:i.rowSelect}if(t.rowSelectorText){t.rowSelectorText.text(o)}};d.prototype.updateAriaExpandAndLevelState=function(e){if(!this._accMode){return}const t=e.getDomRefs(true);const o=t.row.find(".sapUiTableTreeIcon");t.row.not(t.rowHeaderPart).not(t.rowActionPart).attr({"aria-expanded":e.isExpandable()?e.isExpanded()+"":null,"aria-level":e.getLevel()});if(o){o.attr(u.getAriaAttributesForTreeIcon(this,{row:e}))}};d.prototype.updateAriaStateOfRowHighlight=function(e){if(!this._accMode||!e){return}const t=e._getRow();const o=t?t.getDomRef("highlighttext"):null;if(o){o.innerText=e._getHighlightText()}};d.prototype._updateAriaStateOfNavigatedRow=function(e){if(!this._accMode||!e){return}const t=e._getRow();const o=e.getNavigated();t.getDomRefs(true).row.attr("aria-current",o?true:null)};d.prototype.updateAriaStateForOverlayAndNoData=function(){const e=this.getTable();if(!e||!e.getDomRef()||!this._accMode){return}if(e.getShowOverlay()){e.$().find("[data-sap-ui-table-acc-covered*='overlay']").attr("aria-hidden","true")}else{e.$().find("[data-sap-ui-table-acc-covered*='overlay']").removeAttr("aria-hidden");if(o.isNoDataVisible(e)){e.$().find("[data-sap-ui-table-acc-covered*='nodata']").attr("aria-hidden","true")}else{e.$().find("[data-sap-ui-table-acc-covered*='nodata']").removeAttr("aria-hidden")}}};d.prototype.getKeyboardTexts=function(){const e=this.getTable().getSelectionMode();const t={rowSelect:"",rowDeselect:""};if(e===r.None){return t}t.rowSelect=o.getResourceText("TBL_ROW_SELECT_KEY");t.rowDeselect=o.getResourceText("TBL_ROW_DESELECT_KEY");return t};d.prototype.setSelectAllState=function(e){const t=this.getTable();if(this._accMode&&t){t.$("selall").attr("aria-checked",e?"true":"false")}};d.prototype.addColumnHeaderLabel=function(e,t){const o=this.getTable();if(!this._accMode||!t.getAriaLabelledBy||!o){return}let i=o.getColumnHeaderVisible()?e.getId():null;if(!i){const t=e.getAggregation("label");if(t){i=t.getId()}}const n=t.getAriaLabelledBy();if(i&&n.indexOf(i)<0){t.addAriaLabelledBy(i)}};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/extensions/AccessibilityRender", ["./ExtensionBase","../utils/TableUtils","../library"],function(e,t,i){"use strict";const o=i.SelectionMode;const r=function(e,t,i,o,r){r=r||[];r.push("sapUiInvisibleText");e.openStart("span",t+"-"+i);r.forEach(function(t){e.class(t)});e.attr("aria-hidden","true");e.openEnd();if(o){e.text(o)}else{e.text(".")}e.close("span")};const c=e.extend("sap.ui.table.extensions.AccessibilityRender",{_init:function(e,t,i){return"AccRenderExtension"},writeHiddenAccTexts:function(e,i){if(!i._getAccExtension().getAccMode()){return}const c=i.getId();e.openStart("div");e.class("sapUiTableHiddenTexts");e.style("display","none");e.attr("aria-hidden","true");e.openEnd();r(e,c,"ariarowgrouplabel",t.getResourceText("TBL_ROW_GROUP_LABEL"));r(e,c,"ariagrandtotallabel",t.getResourceText("TBL_GRAND_TOTAL_ROW"));r(e,c,"ariagrouptotallabel",t.getResourceText("TBL_GROUP_TOTAL_ROW"));r(e,c,"cellacc");r(e,c,"ariacolmenu",t.getResourceText("TBL_COL_DESC_MENU"));r(e,c,"ariacolspan");r(e,c,"ariacolfiltered",t.getResourceText("TBL_COL_DESC_FILTERED"));r(e,c,"ariacolsortedasc",t.getResourceText("TBL_COL_DESC_SORTED_ASC"));r(e,c,"ariacolsorteddes",t.getResourceText("TBL_COL_DESC_SORTED_DES"));r(e,c,"ariainvalid",t.getResourceText("TBL_TABLE_INVALID"));r(e,c,"ariashowcolmenu",t.getResourceText("TBL_COL_VISBILITY_MENUITEM_SHOW"));r(e,c,"ariahidecolmenu",t.getResourceText("TBL_COL_VISBILITY_MENUITEM_HIDE"));r(e,c,"rowexpandtext",t.getResourceText("TBL_ROW_EXPAND_KEY"));r(e,c,"rowcollapsetext",t.getResourceText("TBL_ROW_COLLAPSE_KEY"));r(e,c,"ariarequired",t.getResourceText("TBL_COL_REQUIRED"));const n=i.getSelectionMode();if(n!==o.None){r(e,c,"ariaselection",t.getResourceText(n===o.MultiToggle?"TBL_TABLE_SELECTION_MULTI":"TBL_TABLE_SELECTION_SINGLE"))}if(i.getComputedFixedColumnCount()>0){r(e,c,"ariafixedcolumn",t.getResourceText("TBL_FIXED_COLUMN"))}if(t.hasRowNavigationIndicators(i)){r(e,c,"rownavigatedtext",t.getResourceText("TBL_ROW_STATE_NAVIGATED"))}e.close("div")},writeAriaAttributesFor:function(e,t,i,o){const r=t._getAccExtension();if(!r.getAccMode()){return}const c=r.getAriaAttributesFor(i,o);let n;let s;for(s in c){n=c[s];if(Array.isArray(n)){n=n.join(" ")}if(n){e.attr(s.toLowerCase(),n)}}},writeAccRowSelectorText:function(e,t,i){if(!t._getAccExtension().getAccMode()||i.isGroupHeader()||i.isSummary()){return}const o=t._getAccExtension().getKeyboardTexts();const c=i._isSelected()?o.rowDeselect:o.rowSelect;r(e,i.getId(),"rowselecttext",i.isEmpty()?"":c,["sapUiTableAriaRowSel"])},writeAccRowHighlightText:function(e,t,i,o){if(!t._getAccExtension().getAccMode()){return}const c=i.getAggregation("_settings");const n=c._getHighlightText();r(e,i.getId(),"highlighttext",n)},writeAccCreationRowText:function(e,i,o){if(!i._getAccExtension().getAccMode()){return}r(e,o.getId(),"label",t.getResourceText("TBL_CREATEROW_LABEL"))}});return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/extensions/DragAndDrop", ["./ExtensionBase","../utils/TableUtils","sap/ui/core/library"],function(t,e,o){"use strict";const n="sap.ui.table";const s=o.dnd.DropPosition;const i={getSessionData:function(t,e){return t.getComplexData(n+(e==null?"":"-"+e))},setSessionData:function(t,e,o){t.setComplexData(n+(o==null?"":"-"+o),e)},getInstanceSessionData:function(t,e){return this.getSessionData(t,e.getId())},setInstanceSessionData:function(t,e,o){this.setSessionData(t,o,e.getId())},scrollVertically:e.throttle(function(t,e,o,n){const s=t._getScrollExtension().getVerticalScrollbar();s.scrollTop+=this.calculateScrollDistance(o,n)*(e?1:-1)},50),scrollHorizontally:e.throttle(function(t,e,o,n){const s=t._getScrollExtension().getHorizontalScrollbar();s.scrollLeft+=this.calculateScrollDistance(o,n)*(e?1:-1)},50),calculateScrollDistance:function(t,e){const o=2;const n=50;const s=e/t;return Math.max(o,Math.round(n*s))}};const l={ondragstart:function(t){const e=t.dragSession;if(!e||!e.getDragControl()){return}const o=e.getDragControl();const n={};if(o.isA("sap.ui.table.Row")){if(o.isEmpty()||o.isGroupHeader()||o.isSummary()){t.preventDefault();return}else{n.draggedRowContext=o.getRowBindingContext()}}i.setInstanceSessionData(e,this,n)},ondragenter:function(t){const o=t.dragSession;if(!o||!o.getDropControl()){return}let n=i.getInstanceSessionData(o,this);const l=o.getDragControl();const r=o.getDropControl();if(!n){n={}}if(r.isA("sap.ui.table.Row")){const i=n.draggedRowContext;const l=r.getRowBindingContext();const a=o.getDropInfo().getDropPosition();if(r.isEmpty()&&a===s.On&&e.hasData(this)||i&&i===l||r.isGroupHeader()||r.isSummary()){t.setMarked("NonDroppable")}else{if(!l){const t=this.getRows()[e.getNonEmptyRowCount(this)-1];o.setDropControl(t||this)}if(o.getDropControl()!==this){const t=this.getDomRef().classList.contains("sapUiTableVScr");const e=this.getDomRef("sapUiTableCnt").getBoundingClientRect();o.setIndicatorConfig({width:e.width-(t?16:0),left:e.left+(this._bRtlMode&&t?16:0)})}}}else if(r.isA("sap.ui.table.Column")){const n=e.getCellInfo(e.getCell(this,t.target)).columnIndex;if(l.isA("sap.ui.table.Column")&&!e.Column.isColumnMovableTo(l,n,true)){t.setMarked("NonDroppable");return}const s=this.getDomRef("sapUiTableCnt").getBoundingClientRect();o.setIndicatorConfig({height:s.height-(this._getScrollExtension().isHorizontalScrollbarVisible()?16:0)})}else if(l===r){t.setMarked("NonDroppable")}if(!n.verticalScrollEdge){const t=window.pageYOffset;const e=this.getDomRef("table").getBoundingClientRect();n.verticalScrollEdge={bottom:e.bottom+t,top:e.top+t}}const a=window.pageXOffset;const c=this.getDomRef("sapUiTableCtrlScr").getBoundingClientRect();n.horizontalScrollEdge={left:c.left+a,right:c.right+a};i.setInstanceSessionData(o,this,n)},ondragover:function(t){const e=t.dragSession;if(!e){return}const o=i.getInstanceSessionData(e,this);if(!o){return}const n=50;const s=e.getDropControl();const l=this._getScrollExtension();const r=l.getVerticalScrollbar();const a=l.getHorizontalScrollbar();const c=o.verticalScrollEdge;const g=o.horizontalScrollEdge;if(c&&r&&s!==this){const e=t.pageY;if(e>=c.top-n&&e<=c.top+n){i.scrollVertically(this,false,n*2,c.top+n-e)}else if(e<=c.bottom+n&&e>=c.bottom-n){i.scrollVertically(this,true,n*2,e-c.bottom+n)}}if(g&&a&&s!==this){const e=t.pageX;if(e>=g.left-n&&e<=g.left+n){i.scrollHorizontally(this,false,n*2,g.left+n-e)}else if(e<=g.right+n&&e>=g.right-n){i.scrollHorizontally(this,true,n*2,e-g.right+n)}}},onlongdragover:function(t){const o=t.dragSession;if(!o){return}const n=e.getCell(this,t.target);const s=e.getCellInfo(n).rowIndex;const i=s==null?null:this.getRows()[s];const l=o.getDropControl();if(i&&(l===i||!l)){i.expand()}},ondragend:function(t){i.scrollVertically.cancel();i.scrollHorizontally.cancel()}};const r=t.extend("sap.ui.table.extensions.DragAndDrop",{_init:function(t,o,n){this._oDelegate=l;e.addDelegate(t,this._oDelegate,t);return"DragAndDropExtension"},_debug:function(){this._ExtensionDelegate=l},destroy:function(){const e=this.getTable();if(e){e.removeEventDelegate(this._oDelegate)}i.scrollVertically.cancel();i.scrollHorizontally.cancel();this._oDelegate=null;t.prototype.destroy.apply(this,arguments)}});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/extensions/ExtensionBase", ["sap/ui/base/Object"],function(t){"use strict";const e=t.extend("sap.ui.table.extensions.ExtensionBase",{_table:null,_type:null,_settings:null,constructor:function(n,s){t.call(this);this._table=n;this._settings=s||{};this._type=e.TABLETYPES.STANDARD;if(n.isA("sap.ui.table.TreeTable")){this._type=e.TABLETYPES.TREE}else if(n.isA("sap.ui.table.AnalyticalTable")){this._type=e.TABLETYPES.ANALYTICAL}const i=this._init(this._table,this._type,this._settings);if(i){const t=this;n["_get"+i]=function(){return t}}},destroy:function(){this._table=null;this._type=null;this.bIsDestroyed=true;t.prototype.destroy.apply(this,arguments)},getInterface:function(){return this}});e.TABLETYPES={TREE:"TREE",ANALYTICAL:"ANALYTICAL",STANDARD:"STANDARD"};e.prototype.getTable=function(){return this._table};e.prototype._init=function(t,e,n){return null};e.prototype._attachEvents=function(){};e.prototype._detachEvents=function(){};e.attachEvents=function(t){if(!t._aExtensions){return}for(let e=0;e<t._aExtensions.length;e++){t._aExtensions[e]._attachEvents()}};e.detachEvents=function(t){if(!t._aExtensions){return}for(let e=0;e<t._aExtensions.length;e++){t._aExtensions[e]._detachEvents()}};e.enrich=function(t,n,s){if(!n||!(n.prototype instanceof e)){return null}const i=new n(t,s);if(!t._aExtensions){t._aExtensions=[]}t._aExtensions.push(i);return i};e.cleanup=function(t){if(!t._bExtensionsInitialized||!t._aExtensions){return}for(let e=0;e<t._aExtensions.length;e++){t._aExtensions[e].destroy()}delete t._aExtensions;delete t._bExtensionsInitialized};e.isEnrichedWith=function(t,e){if(!t||!t._aExtensions){return false}for(let n=0;n<t._aExtensions.length;n++){if(t._aExtensions[n].getMetadata().getName()===e){return true}}return false};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/extensions/Keyboard", ["./ExtensionBase","./KeyboardDelegate","../utils/TableUtils","sap/ui/core/delegate/ItemNavigation","sap/ui/Device","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery"],function(t,e,i,o,n,a,jQuery){"use strict";const s={_forward:function(t,e){const i=t._getItemNavigation();if(i!=null&&!t._getKeyboardExtension().isItemNavigationSuspended()&&!e.isMarked("sapUiTableSkipItemNavigation")){i["on"+e.type](e)}},onfocusin:function(t){s._forward(this,t)},onsapfocusleave:function(t){s._forward(this,t)},onmousedown:function(t){s._forward(this,t)},onsapnext:function(t){s._forward(this,t)},onsapnextmodifiers:function(t){s._forward(this,t)},onsapprevious:function(t){s._forward(this,t)},onsappreviousmodifiers:function(t){s._forward(this,t)},onsappageup:function(t){s._forward(this,t)},onsappagedown:function(t){s._forward(this,t)},onsaphome:function(t){s._forward(this,t)},onsaphomemodifiers:function(t){s._forward(this,t)},onsapend:function(t){s._forward(this,t)},onsapendmodifiers:function(t){s._forward(this,t)},onsapkeyup:function(t){s._forward(this,t)}};const l={onBeforeRendering:function(t){this._oStoredFocusInfo=this.getFocusInfo()},onAfterRendering:function(t){const e=t&&t.isMarked("renderRows");this._getKeyboardExtension().invalidateItemNavigation();if(this._oStoredFocusInfo&&this._oStoredFocusInfo.customId){if(e){this.applyFocusInfo(this._oStoredFocusInfo)}else{f.initItemNavigation(this._getKeyboardExtension(),true)}}delete this._oStoredFocusInfo},onfocusin:function(t){const e=this._getKeyboardExtension();if(!e._bIgnoreFocusIn){f.initItemNavigation(this._getKeyboardExtension())}else{t.setMarked("sapUiTableIgnoreFocusIn")}if(t.target&&t.target.id===this.getId()+"-rsz"){t.preventDefault();t.setMarked("sapUiTableSkipItemNavigation")}}};const f={initItemNavigation:function(t,e){if(f.isItemNavigationInvalid(t)){f._initItemNavigation(t,e)}},_initItemNavigation:function(t,e){const n=t.getTable();if(!n){return}const a=n.$();const s=n.getRows().length;let l=i.getVisibleColumnCount(n);const d=i.hasRowHeader(n);const r=i.hasRowActions(n);const c=i.hasFixedColumns(n);let u;let g=[];let p;let h;let m;let _;let b;if(c){m=a.find(".sapUiTableCtrlFixed.sapUiTableCtrlRowFixed:not(.sapUiTableCHT)");_=a.find(".sapUiTableCtrlFixed.sapUiTableCtrlRowScroll:not(.sapUiTableCHT)");b=a.find(".sapUiTableCtrlFixed.sapUiTableCtrlRowFixedBottom:not(.sapUiTableCHT)")}const v=a.find(".sapUiTableCtrlScroll.sapUiTableCtrlRowFixed:not(.sapUiTableCHT)");const I=a.find(".sapUiTableCtrlScroll.sapUiTableCtrlRowScroll:not(.sapUiTableCHT)");const C=a.find(".sapUiTableCtrlScroll.sapUiTableCtrlRowFixedBottom:not(.sapUiTableCHT)");if(d){p=a.find(".sapUiTableRowSelectionCell").get();l++}if(r){h=a.find(".sapUiTableRowActionCell").get();l++}for(u=0;u<s;u++){if(d){g.push(p[u])}if(c){g=g.concat(m.find('tr[data-sap-ui-rowindex="'+u+'"]').find("td[tabindex]").get())}g=g.concat(v.find('tr[data-sap-ui-rowindex="'+u+'"]').find("td[tabindex]").get());if(c){g=g.concat(_.find('tr[data-sap-ui-rowindex="'+u+'"]').find("td[tabindex]").get())}g=g.concat(I.find('tr[data-sap-ui-rowindex="'+u+'"]').find("td[tabindex]").get());if(c){g=g.concat(b.find('tr[data-sap-ui-rowindex="'+u+'"]').find("td[tabindex]").get())}g=g.concat(C.find('tr[data-sap-ui-rowindex="'+u+'"]').find("td[tabindex]").get());if(r){g.push(h[u])}}if(n.getColumnHeaderVisible()){let t=[];const e=a.find(".sapUiTableCHT.sapUiTableCtrlFixed>tbody>tr");const o=a.find(".sapUiTableCHT.sapUiTableCtrlScroll>tbody>tr");const s=i.getHeaderRowCount(n);for(u=0;u<s;u++){if(d){t.push(n.getDomRef("selall"))}if(e.length){t=t.concat(jQuery(e.get(u)).find(".sapUiTableHeaderCell").get())}if(o.length){t=t.concat(jQuery(o.get(u)).find(".sapUiTableHeaderCell").get())}if(r){t.push(n.getDomRef("rowacthdr"))}}g=t.concat(g)}if(!t._itemNavigation){t._itemNavigation=new o;t._itemNavigation.setTableMode(true);t._itemNavigation.attachEvent(o.Events.AfterFocus,function(e){const o=i.getFocusedItemInfo(n);o.header=i.getHeaderRowCount(n);o.domRef=null;if(o.row>=o.header){t._oLastFocusedCellInfo=o}},n)}t._itemNavigation.setColumns(l);t._itemNavigation.setRootDomRef(a.find(".sapUiTableCnt").get(0));t._itemNavigation.setItemDomRefs(g);if(!e){t._itemNavigation.setFocusedIndex(f.getInitialItemNavigationIndex(t))}t._itemNavigationInvalidated=false},getInitialItemNavigationIndex:function(t){return i.hasRowHeader(t.getTable())?1:0},isItemNavigationInvalid:function(t){return!t._itemNavigation||t._itemNavigationInvalidated}};const d=t.extend("sap.ui.table.extensions.Keyboard",{_init:function(t,o,n){this._itemNavigation=null;this._itemNavigationInvalidated=false;this._itemNavigationSuspended=false;this._delegate=new e(o);this._actionMode=false;i.addDelegate(t,l,t);i.addDelegate(t,this._delegate,t);i.addDelegate(t,s,t);t._getItemNavigation=function(){return this._itemNavigation}.bind(this);return"KeyboardExtension"},_debug:function(){this._ExtensionHelper=f;this._ItemNavigationDelegate=s;this._ExtensionDelegate=l},destroy:function(){const e=this.getTable();if(e){e.removeEventDelegate(l);e.removeEventDelegate(this._delegate);e.removeEventDelegate(s)}if(this._itemNavigation){this._itemNavigation.destroy();this._itemNavigation=null}if(this._delegate){this._delegate.destroy();this._delegate=null}t.prototype.destroy.apply(this,arguments)}});d.prototype.initItemNavigation=function(){f.initItemNavigation(this)};d.prototype.invalidateItemNavigation=function(){this._itemNavigationInvalidated=true};d.prototype.setActionMode=function(t,e){if(!this._delegate){return}if(t===true&&!this._actionMode&&this._delegate.enterActionMode){this._actionMode=this._delegate.enterActionMode.call(this.getTable())===true}else if(t===false&&this._actionMode&&this._delegate.leaveActionMode){this._actionMode=false;this._delegate.leaveActionMode.call(this.getTable(),e===true)}};d.prototype.isInActionMode=function(){return this._actionMode};d.prototype.updateNoDataAndOverlayFocus=function(){const t=this.getTable();const e=document.activeElement;if(!t||!t.getDomRef()){return}if(t.getShowOverlay()){if(a(t.getDomRef(),e)&&t.$("overlay")[0]!==e){this._oLastFocus={Ref:e,Pos:"overlay"};t.getDomRef("overlay").focus()}}else if(i.isNoDataVisible(t)){if(t.$("noDataCnt")[0]===e){return}if(a(t.getDomRef("tableCCnt"),e)){this._oLastFocus={Ref:e,Pos:"table content"};if(n.browser.safari){t.getDomRef("noDataCnt").getBoundingClientRect()}t.getDomRef("noDataCnt").focus()}else if(t.$("overlay")[0]===e){c(t,this)}else if(t._bApplyFocusInfoFailed){this._oLastFocus={Ref:e,Pos:"table content"};delete t._bApplyFocusInfoFailed;t.getDomRef("noDataCnt").focus()}}else if(this._oLastFocus){if(this._oLastFocus.Pos==="table content"){if(a(t.getDomRef("tableCCnt"),this._oLastFocus.Ref)){r(t,this)}else if(t.getRows()[0]&&t.getRows()[0].getDomRef("col0")){t.getRows()[0].getDomRef("col0").focus();this._oLastFocus=null}}else if(this._oLastFocus.Pos==="overlay"){if(a(t.getDomRef(),this._oLastFocus.Ref)){r(t,this)}else{c(t,this)}}}};function r(t,e){if(!jQuery(e._oLastFocus.Ref).hasClass("sapUiTableCell")){const o=i.getParentCell(t,e._oLastFocus.Ref);if(o&&o[0]&&jQuery(o[0]).hasClass("sapUiTableCell")){o[0].focus()}else{e._oLastFocus.Ref.focus()}}else{e._oLastFocus.Ref.focus()}e._oLastFocus=null}function c(t,e){if(t.getColumnHeaderVisible()){i.focusItem(t,f.getInitialItemNavigationIndex(e));e._oLastFocus=null}else if(i.isNoDataVisible(t)){t.getDomRef("noDataCnt").focus();e._oLastFocus=null}else if(t.getRows()[0]&&t.getRows()[0].getDomRef("col0")){t.getRows()[0].getDomRef("col0").focus();e._oLastFocus=null}}d.prototype.suspendItemNavigation=function(){this._itemNavigationSuspended=true};d.prototype.resumeItemNavigation=function(){this._itemNavigationSuspended=false};d.prototype.isItemNavigationSuspended=function(){return this._itemNavigationSuspended};d.prototype.getLastFocusedCellInfo=function(){const t=i.getHeaderRowCount(this.getTable());if(!this._oLastFocusedCellInfo||this._oLastFocusedCellInfo.header!==t){const e=i.getFocusedItemInfo(this.getTable());const o=f.getInitialItemNavigationIndex(this);return{cellInRow:o,row:t,header:t,cellCount:e.cellCount,columnCount:e.columnCount,cell:e.columnCount*t+o}}return this._oLastFocusedCellInfo};d.prototype.setSilentFocus=function(t){this._bIgnoreFocusIn=true;this.setFocus(t);this._bIgnoreFocusIn=false};d.prototype.setFocus=function(t){if(!t){return}const e=this.getTable();const o=i.getCellInfo(t);if(o.isOfType(i.CELLTYPE.ANY)&&e){const i=jQuery(t);if(i.attr("tabindex")!=="0"){const t=e._getItemNavigation();if(t&&t.aItemDomRefs){for(let e=0;e<t.aItemDomRefs.length;e++){if(t.aItemDomRefs[e]){t.aItemDomRefs[e].setAttribute("tabindex","-1")}}}i.attr("tabindex","0")}}if(t instanceof HTMLElement){t.focus()}else{t.trigger("focus")}};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/extensions/KeyboardDelegate", ["../utils/TableUtils","../library","sap/base/i18n/Localization","sap/ui/base/Object","sap/ui/Device","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(e,t,n,o,i,s,jQuery){"use strict";const l=e.CELLTYPE;const r=t.SelectionMode;const f={CTRL:1,SHIFT:2,ALT:4};const c=5;const a="1rem";function u(e,t){e.setMarked("sapUiTableSkipItemNavigation",t!==false)}function g(t){if(e.getCellInfo(t.target).isOfType(l.ANY)){t.preventDefault();t.stopPropagation()}}const d=o.extend("sap.ui.table.extensions.KeyboardDelegate",{constructor:function(e){o.call(this)},destroy:function(){o.prototype.destroy.apply(this,arguments)},getInterface:function(){return this}});function h(t,n){if(!E(t,n)){return}const o=e.getCellInfo(e.getCell(t,n.target));if(o.isOfType(l.ANYCOLUMNHEADER)){C(t,o,n)}else if(o.isOfType(l.ANYCONTENTCELL)){p(t,o,n)}}function C(t,n,o){const i=e.getHeaderRowCount(t);if(e.isNoDataVisible(t)){const n=e.getFocusedItemInfo(t);if(n.row-i<=1){u(o)}}else if(n.isOfType(l.COLUMNROWHEADER)&&i>1){u(o);e.focusItem(t,i*(e.getVisibleColumnCount(t)+1),o)}}function p(t,n,o){const i=t._getKeyboardExtension();const s=i.isInActionMode();const l=d._isKeyCombination(o,null,f.CTRL);const r=l||s;const c=e.getParentCell(t,o.target);if(!r&&c){c.trigger("focus");return}u(o);if(e.isLastScrollableRow(t,n.cell)){const e=R(t,o);if(e){o.preventDefault();return}}if(n.rowIndex===t.getRows().length-1||e.isVariableRowHeightEnabled(t)&&n.rowIndex===t.getRows().length-2&&t.getRows()[n.rowIndex+1].getRowBindingContext()===null){if(!s&&c){c.trigger("focus")}else{const e=t.getCreationRow();if(!e||!e._takeOverKeyboardHandling(o)){i.setActionMode(false)}}return}v(t,n.type,n.rowIndex+1,n.columnIndex,r);o.preventDefault()}function m(t,n){const o=e.getCellInfo(e.getCell(t,n.target));if(!o.isOfType(l.ANYCONTENTCELL)||!E(t,n)){return}const i=d._isKeyCombination(n,null,f.CTRL);const s=t._getKeyboardExtension();const r=s.isInActionMode();const c=i||r;const a=e.getParentCell(t,n.target);if(!c&&a){a.trigger("focus");return}u(n);if(e.isFirstScrollableRow(t,o.cell)){const e=y(t,n);if(e){n.preventDefault();return}}if(o.rowIndex===0){u(n,c);if(!r&&a){a.trigger("focus")}else{s.setActionMode(false)}return}v(t,o.type,o.rowIndex-1,o.columnIndex,c);n.preventDefault()}function E(e,t){const n=d._isKeyCombination(t,null,f.CTRL);return!t.isMarked()&&(n||!(t.target instanceof window.HTMLInputElement)&&!(t.target instanceof window.HTMLTextAreaElement))}function I(e){return new Promise(function(t){e.attachEventOnce("_rowsUpdated",t)})}function T(e){if(e._isWaitingForData()){return I(e).then(function(){return T(e)})}return Promise.resolve()}function R(e,t,n,o){const i=e._getFirstRenderedRowIndex()===e._getMaxFirstRenderedRowIndex();if(i){return null}return A(e,t,true,n,o)}function y(e,t,n,o){const i=e._getFirstRenderedRowIndex()===0;if(i){return null}return A(e,t,false,n,o)}function A(t,n,o,i,s){const r=e.getCellInfo(e.getCell(t,n.target));const c=t._getKeyboardExtension().isInActionMode();const a=d._isKeyCombination(n,null,f.CTRL);const u=a||c;const g=c&&r.isOfType(l.DATACELL);if(g){t._getKeyboardExtension().setSilentFocus(t.getDomRef("focusDummy"));setTimeout(function(){t._getScrollExtension().scrollVertically(o===true,i)},0)}else{t._getScrollExtension().scrollVertically(o===true,i)}return I(t).then(function(){if(s){s()}else if(u){v(t,r.type,r.rowIndex,r.columnIndex,true)}})}function x(e,t){const n=e._getRowCounts();const o=R(e,t,false,function(){O(e,n.fixedTop+n.scrollable-1)});if(o){return}if(n.fixedBottom>0){O(e,n.fixedTop+n.scrollable)}else{e._getKeyboardExtension().setActionMode(false)}}function O(t,n){const o=t.getRows()[n];const i=o.isGroupHeader()||e.isRowSelectorSelectionAllowed(t);if(i){v(t,l.ROWHEADER,n)}else{const e=d._getFirstInteractiveElement(o);if(e){d._focusElement(t,e[0])}else{v(t,l.DATACELL,n,0,false,true);if(o.getIndex()===t._getTotalRowCount()-1){t._getKeyboardExtension().setActionMode(false)}}}}function _(e,t){const n=e._getRowCounts();const o=y(e,t,false,function(){b(e,n.fixedTop)});if(o){return}if(n.fixedTop>0){b(e,n.fixedTop-1)}else{e._getKeyboardExtension().setActionMode(false)}}function b(t,n){const o=t.getRows()[n];const i=o.isGroupHeader()||e.isRowSelectorSelectionAllowed(t);const s=d._getLastInteractiveElement(o);if(s){d._focusElement(t,s[0])}else if(i){v(t,l.ROWHEADER,n)}else{v(t,l.DATACELL,n,0,false,true);if(o.getIndex()===0){t._getKeyboardExtension().setActionMode(false)}}}function w(t,n){const o=e.getFocusedItemInfo(t);const i=t._getKeyboardExtension().getLastFocusedCellInfo();e.focusItem(t,o.cellInRow+o.columnCount*i.row,n)}function L(t,n){const o=e.getFocusedItemInfo(t);e.focusItem(t,o.cellInRow,n)}function S(e,t){e._getKeyboardExtension().setSilentFocus(e.$().find("."+t))}d._isKeyCombination=function(e,t,n){if(n==null){n=0}const o=typeof t==="string"?String.fromCharCode(e.charCode):e.keyCode;let l=0;l|=(i.os.macintosh?e.metaKey:e.ctrlKey)&&t!==s.CONTROL?f.CTRL:0;l|=e.shiftKey&&t!==s.SHIFT?f.SHIFT:0;l|=e.altKey&&t!==s.ALT?f.ALT:0;const r=t==null||o===t;const c=n===l;return r&&c};function N(t,n){const o=e.getCell(t,n);const i=e.getCellInfo(o);return t.getRows()[i.rowIndex]}function D(t,n){const o=e.getCellInfo(n.target);if(o.isOfType(l.COLUMNROWHEADER)){t._getSelectionPlugin().onHeaderSelectorPress()}else if(d._allowsToggleExpandedState(t,n.target)){N(t,n.target).toggleExpandedState()}else if(o.isOfType(l.ROWHEADER)){i()}else if(o.isOfType(l.DATACELL|l.ROWACTION)){let o=!t.hasListeners("cellClick");if(!t._findAndfireCellEvent(t.fireCellClick,n)){if(e.isRowSelectionAllowed(t)){i();o=false}}if(o){const o=e.getInteractiveElements(n.target);if(o){t._getKeyboardExtension().setActionMode(true)}}}function i(){let o=null;if(t._legacyMultiSelection){o=function(e){t._legacyMultiSelection(e.getIndex(),n)}}e.toggleRowSelection(t,n.target,null,o)}}function M(t,n){const o=t.getParent();const i=o._getVisibleColumns();const s=i.indexOf(t);let l;if(n&&s<i.length-1){l=o.indexOfColumn(i[s+1])+1}else if(!n&&s>0){l=o.indexOfColumn(i[s-1])}if(l!=null){e.Column.moveColumnTo(t,l)}}function K(e,t){const n=e.getColumns().filter(function(e){return e.getVisible()||(e.getGrouped?e.getGrouped():false)});for(let e=0;e<n.length;e++){const o=n[e];if(o===t){return e}}return-1}function H(t,n,o){if(!o){if(t._oRangeSelection.selected){e.toggleRowSelection(t,n,true)}else{e.toggleRowSelection(t,n,false)}}else{e.toggleRowSelection(t,n,false)}}d._focusElement=function(e,t,n){if(!e||!t){return}if(n==null){n=false}if(n){e._getKeyboardExtension().setSilentFocus(t)}else{t.focus()}if(t instanceof window.HTMLInputElement){t.select()}};function v(t,n,o,i,s,r){if(!t||n==null||o==null||o<0||o>=t.getRows().length){return}const f=t.getRows()[o];let c;if(n===l.ROWHEADER){t._getKeyboardExtension().setFocus(t.getDomRef("rowsel"+o));return}else if(n===l.ROWACTION){c=t.getDomRef("rowact"+o)}else if(n===l.DATACELL&&(i!=null&&i>=0)){const e=t.getColumns()[i];const n=K(t,e);if(n>=0){c=f.getDomRef("col"+n)}}if(!c){return}if(s){const n=e.getInteractiveElements(c);if(n){d._focusElement(t,n[0]);return}}if(r){t._getKeyboardExtension()._bStayInActionMode=true}c.focus()}function F(e){return e.classList.contains("sapUiTableTreeIconNodeOpen")||e.classList.contains("sapUiTableTreeIconNodeClosed")}d._allowsToggleExpandedState=function(t,n){return e.Grouping.isInGroupHeaderRow(n)||e.Grouping.isInTreeMode(t)&&n.classList.contains("sapUiTableCellFirst")&&(n.querySelector(".sapUiTableTreeIconNodeOpen")||n.querySelector(".sapUiTableTreeIconNodeClosed"))||F(n)};d._isElementInteractive=function(t){if(!t){return false}return jQuery(t).is(e.INTERACTIVE_ELEMENT_SELECTORS)};d._getFirstInteractiveElement=function(t){const n=e.getFirstInteractiveElement(t,true);if(!n){return null}return jQuery(n)};d._getLastInteractiveElement=function(t){if(!t){return null}const n=t.getParent();const o=t.getCells();let i;let s;if(e.hasRowActions(n)){o.push(t.getRowAction())}for(let t=o.length-1;t>=0;t--){i=e.getParentCell(n,o[t].getDomRef());s=e.getInteractiveElements(i);if(s){return s.last()}}return null};d._getPreviousInteractiveElement=function(t,n){if(!t||!n){return null}const o=jQuery(n);if(!this._isElementInteractive(o)){return null}let i=e.getParentCell(t,n);let s;let r;let f;let c;let a;s=e.getInteractiveElements(i);if(s[0]!==o[0]){return s.eq(s.index(n)-1)}const u=e.getCellInfo(i);const g=t.getRows()[u.rowIndex].getCells();if(u.isOfType(l.ROWACTION)){a=g.length-1}else{f=t.getColumns()[u.columnIndex];c=K(t,f);a=c-1}for(let n=a;n>=0;n--){r=g[n].getDomRef();i=e.getParentCell(t,r);s=e.getInteractiveElements(i);if(s){return s.last()}}return null};d._getNextInteractiveElement=function(t,n){if(!t||!n){return null}const o=jQuery(n);if(!this._isElementInteractive(o)){return null}let i=e.getParentCell(t,n);let s;let r;s=e.getInteractiveElements(i);if(s.get(-1)!==o[0]){return s.eq(s.index(n)+1)}const f=e.getCellInfo(i);if(f.isOfType(l.ROWACTION)){return null}const c=t.getRows()[f.rowIndex];const a=c.getCells();const u=t.getColumns()[f.columnIndex];const g=K(t,u);for(let n=g+1;n<a.length;n++){r=a[n].getDomRef();i=e.getParentCell(t,r);s=e.getInteractiveElements(i);if(s){return s.first()}}if(e.hasRowActions(t)){i=e.getParentCell(t,c.getRowAction().getDomRef());s=e.getInteractiveElements(i);if(s.get(-1)!==o[0]){return s.eq(s.index(n)+1)}}return null};function U(t){const n=e.getRowIndexOfFocusedCell(t);const o=t.getRows()[n];const i=o.getIndex();t._oRangeSelection={startIndex:i,selected:o._isSelected()}}d.prototype.enterActionMode=function(){const t=this._getKeyboardExtension();const n=document.activeElement;const o=e.getInteractiveElements(n);const i=e.getParentCell(this,n);const s=e.getCellInfo(i);if(s.isOfType(l.ANYCOLUMNHEADER)){return false}if(o){t.suspendItemNavigation();n.tabIndex=-1;d._focusElement(this,o[0],true);return true}else if(i){this._getKeyboardExtension().suspendItemNavigation();return true}return false};d.prototype.leaveActionMode=function(t){const n=this._getKeyboardExtension();const o=document.activeElement;const i=e.getParentCell(this,o);n.resumeItemNavigation();if(t){return}if(i){d._focusElement(this,i[0],true)}else{const e=this._getItemNavigation();if(e){const t=e.aItemDomRefs;const n=t.indexOf(o);if(n>-1){e.setFocusedIndex(n)}}n.setSilentFocus(o)}};d.prototype.onfocusout=function(e){if(this.getRows().length||this.getColumnHeaderVisible()){this.$().find(".sapUiTableCtrlBefore").attr("tabindex","0");this.$().find(".sapUiTableCtrlAfter").attr("tabindex","0")}};d.prototype.onfocusin=function(t){if(this.getDomRef("sapUiTableCnt").contains(t.target)){this.$().find(".sapUiTableCtrlBefore").attr("tabindex","-1");this.$().find(".sapUiTableCtrlAfter").attr("tabindex","-1")}if(t.isMarked("sapUiTableIgnoreFocusIn")){return}const n=jQuery(t.target);if(n.hasClass("sapUiTableOuterBefore")||n.hasClass("sapUiTableOuterAfter")||t.target!==this.getDomRef("overlay")&&this.getShowOverlay()){this.$("overlay").trigger("focus")}else if(n.hasClass("sapUiTableCtrlBefore")){const n=e.isNoDataVisible(this);const o=this.getDomRef("busyIndicator");if(o){this._getKeyboardExtension().setSilentFocus(o)}else if(this.getColumnHeaderVisible()&&(e.getVisibleColumnCount(this)||e.hasRowHeader(this))){L(this,t)}else if(n){this._getKeyboardExtension().setSilentFocus(this.$("noDataCnt"))}}else if(n.hasClass("sapUiTableCtrlAfter")){const n=this.getDomRef("busyIndicator");if(n){this._getKeyboardExtension().setSilentFocus(n)}else if(this.getRows().length&&!e.isNoDataVisible(this)){w(this,t)}else if(this.getColumnHeaderVisible()&&(e.getVisibleColumnCount(this)||e.hasRowHeader(this))){L(this,t)}}const o=e.getCellInfo(t.target);const i=o.isOfType(l.ROWHEADER)&&e.Grouping.isInGroupHeaderRow(t.target);const s=o.isOfType(l.ROWHEADER)&&!i&&e.isRowSelectorSelectionAllowed(this);const r=o.isOfType(l.DATACELL)&&this._getKeyboardExtension()._bStayInActionMode;const f=e.getCellInfo(e.getParentCell(this,t.target)).isOfType(l.ANYCONTENTCELL);const c=d._isElementInteractive(t.target);const a=this._getKeyboardExtension().isInActionMode();const u=a&&(i||s||r)||c&&f;if(r){this._getKeyboardExtension()._bStayInActionMode=false}this._getKeyboardExtension().setActionMode(u,true)};d.prototype.onkeydown=function(t){if(t.isMarked()){return}const n=this._getKeyboardExtension();let o=e.getCellInfo(t.target);const i=this.getSelectionMode();const c=this._getSelectionPlugin();if(d._isKeyCombination(t,s.F2)){const i=n.isInActionMode();const s=e.getCell(this,t.target);const r=e.getParentCell(this,t.target)!=null;o=e.getCellInfo(s);if(!i&&r){s.trigger("focus")}else if(o.isOfType(l.ANYCOLUMNHEADER)){const t=e.getInteractiveElements(s);if(t){t[0].focus()}}else{n.setActionMode(!i)}return}if(d._isKeyCombination(t,s.F4)&&d._allowsToggleExpandedState(this,t.target)){N(this,t.target).toggleExpandedState();return}if(d._isKeyCombination(t,s.SPACE)&&F(t.target)){t.preventDefault();return}if(this._getKeyboardExtension().isInActionMode()||!o.isOfType(l.ANY)){return}if(d._isKeyCombination(t,s.SPACE)){t.preventDefault()}if(d._isKeyCombination(t,s.SHIFT)&&i===r.MultiToggle&&(o.isOfType(l.ROWHEADER)&&e.isRowSelectorSelectionAllowed(this)||o.isOfType(l.DATACELL|l.ROWACTION))){U(this)}else if(d._isKeyCombination(t,s.A,f.CTRL)){t.preventDefault();if(o.isOfType(l.ANYCONTENTCELL|l.COLUMNROWHEADER)){c.onKeyboardShortcut("toggle",t)}}else if(d._isKeyCombination(t,s.A,f.CTRL+f.SHIFT)){if(o.isOfType(l.ANYCONTENTCELL|l.COLUMNROWHEADER)){t.preventDefault();c.onKeyboardShortcut("clear",t)}}else if(d._isKeyCombination(t,s.F4)){if(o.isOfType(l.DATACELL)){n.setActionMode(true)}}};d.prototype.onkeypress=function(t){if(t.isMarked()){return}const n=this._getKeyboardExtension();const o=e.getCellInfo(t.target);if(d._isKeyCombination(t,"+")){if(d._allowsToggleExpandedState(this,t.target)){N(this,t.target).expand()}else if(o.isOfType(l.DATACELL|l.ROWACTION)){n.setActionMode(true)}}else if(d._isKeyCombination(t,"-")){if(d._allowsToggleExpandedState(this,t.target)){N(this,t.target).collapse()}else if(o.isOfType(l.DATACELL|l.ROWACTION)){n.setActionMode(true)}}};d.prototype.oncontextmenu=function(t){if(t.isMarked("sapUiTableHandledByPointerExtension")){return}const n=e.getCellInfo(document.activeElement);if(n.isOfType(l.ANY)){e.Menu.openContextMenu(this,t)}};d.prototype.onkeyup=function(t){if(t.isMarked()){return}const n=e.getCellInfo(t.target);if(d._isKeyCombination(t,s.SHIFT)){delete this._oRangeSelection}if(n.isOfType(l.COLUMNHEADER)){if(d._isKeyCombination(t,s.SPACE)||d._isKeyCombination(t,s.ENTER)){e.Menu.openContextMenu(this,t)}}else if(d._isKeyCombination(t,s.SPACE)){D(this,t)}else if(d._isKeyCombination(t,s.SPACE,f.SHIFT)){e.toggleRowSelection(this,n.rowIndex);U(this)}else if(this._legacyMultiSelection&&!n.isOfType(l.COLUMNROWHEADER)&&(d._isKeyCombination(t,s.SPACE,f.CTRL)||d._isKeyCombination(t,s.ENTER,f.CTRL))){D(this,t)}};d.prototype.onsaptabnext=function(t){const n=this._getKeyboardExtension();let o=e.getCellInfo(t.target);let i;if(n.isInActionMode()){let s;i=e.getCell(this,t.target);o=e.getCellInfo(i);if(!o.isOfType(l.ANYCONTENTCELL)){return}let r=this.getRows()[o.rowIndex];const f=d._getLastInteractiveElement(r);const c=f===null||f[0]===t.target;if(c){const f=r.getIndex();const c=e.isLastScrollableRow(this,i);const a=this._getTotalRowCount()-1===f;const u=e.isRowSelectorSelectionAllowed(this);t.preventDefault();if(a){n.setActionMode(false)}else if(c){x(this,t)}else{let e=o.rowIndex;if(u){v(this,l.ROWHEADER,e+1)}else{const n=this.getRows().length;let i=false;for(let t=o.rowIndex+1;t<n;t++){e=t;r=this.getRows()[e];s=d._getFirstInteractiveElement(r);i=r.isGroupHeader();if(s||i){break}}if(s){d._focusElement(this,s[0])}else if(i){v(this,l.ROWHEADER,e)}else{x(this,t)}}}}else if(o.isOfType(l.ROWHEADER)){t.preventDefault();s=d._getFirstInteractiveElement(r);d._focusElement(this,s[0])}else{t.preventDefault();s=d._getNextInteractiveElement(this,t.target);d._focusElement(this,s[0])}}else if(o.isOfType(l.ANYCOLUMNHEADER)){if(this.getCreationRow()&&this.getCreationRow().getVisible()&&!e.hasData(this)){S(this,"sapUiTableCtrlAfter")}else if(e.isNoDataVisible(this)){this.$("noDataCnt").trigger("focus");t.preventDefault()}else if(this.getRows().length>0){w(this,t);t.preventDefault()}}else if(o.isOfType(l.ANYCONTENTCELL)){S(this,"sapUiTableCtrlAfter")}else if(t.target===this.getDomRef("overlay")){n.setSilentFocus(this.$().find(".sapUiTableOuterAfter"))}else if(!o.isOfType(l.ANY)){i=e.getParentCell(this,t.target);if(i){t.preventDefault();i.trigger("focus")}}};d.prototype.onsaptabprevious=function(t){const n=this._getKeyboardExtension();let o=e.getCellInfo(t.target);let i;if(n.isInActionMode()){let s;i=e.getCell(this,t.target);o=e.getCellInfo(i);if(!o.isOfType(l.ANYCONTENTCELL)){return}let r=this.getRows()[o.rowIndex];const f=r.getIndex();const c=d._getFirstInteractiveElement(r);const a=c!==null&&c[0]===t.target;const u=e.isRowSelectorSelectionAllowed(this);const g=u||r.isGroupHeader();if(a&&g){t.preventDefault();v(this,l.ROWHEADER,o.rowIndex)}else if(a&&!g||o.isOfType(l.ROWHEADER)||c===null){const c=e.isFirstScrollableRow(this,i);const a=f===0;t.preventDefault();if(a){n.setActionMode(false)}else if(c){_(this,t)}else{let e=o.rowIndex;let n=false;for(let t=o.rowIndex-1;t>=0;t--){e=t;r=this.getRows()[e];s=d._getLastInteractiveElement(r);n=r.isGroupHeader();if(s||g||n){break}}if(s){d._focusElement(this,s[0])}else if(n||g){v(this,l.ROWHEADER,e)}else{_(this,t)}}}else{t.preventDefault();s=d._getPreviousInteractiveElement(this,t.target);d._focusElement(this,s[0])}}else if(o.isOfType(l.ANYCONTENTCELL)||t.target===this.getDomRef("noDataCnt")){if(this.getColumnHeaderVisible()&&(e.getVisibleColumnCount(this)||this.getSelectionMode()!==r.None)){L(this,t);t.preventDefault()}else{S(this,"sapUiTableCtrlBefore")}}else if(t.target===this.getDomRef("overlay")){this._getKeyboardExtension().setSilentFocus(this.$().find(".sapUiTableOuterBefore"))}else if(!o.isOfType(l.ANY)){i=e.getParentCell(this,t.target);if(i){t.preventDefault();i.trigger("focus")}}};d.prototype.onsapdown=function(e){g(e);h(this,e)};d.prototype.onsapdownmodifiers=function(t){if(t.isMarked()||d._isKeyCombination(t,null,f.CTRL+f.ALT)){u(t);return}g(t);if(d._isKeyCombination(t,null,f.CTRL)){h(this,t);return}const n=this._getKeyboardExtension();if(d._isKeyCombination(t,null,f.ALT)&&d._allowsToggleExpandedState(this,t.target)){u(t);N(this,t.target).expand();return}if(n.isInActionMode()){return}const o=e.getCellInfo(t.target);if(d._isKeyCombination(t,null,f.SHIFT)){if(o.isOfType(l.ANYCONTENTCELL)){if(!this._oRangeSelection){u(t);return}const n=e.getRowIndexOfFocusedCell(this);const o=this.getRows()[n].getIndex();const i=this._oRangeSelection.startIndex>o;let s;if(o===this._getTotalRowCount()-1){return}if(e.isLastScrollableRow(this,t.target)){if(this._oRangeSelection.pScroll){u(t);return}else{s=R(this,t);this._oRangeSelection.pScroll=s}}if(s){u(t);s.then(function(){return T(this)}.bind(this)).then(function(){H(this,n-(i?1:0),i);delete this._oRangeSelection.pScroll}.bind(this))}else{H(this,n+(i?0:1),i)}}else{u(t)}}if(d._isKeyCombination(t,null,f.ALT)){if(o.isOfType(l.DATACELL)){n.setActionMode(true)}u(t)}};d.prototype.onsapup=function(e){g(e);m(this,e)};d.prototype.onsapupmodifiers=function(t){if(t.isMarked()||d._isKeyCombination(t,null,f.CTRL+f.ALT)){u(t);return}g(t);if(d._isKeyCombination(t,null,f.CTRL)){m(this,t);return}if(d._isKeyCombination(t,null,f.ALT)&&d._allowsToggleExpandedState(this,t.target)){u(t);N(this,t.target).collapse();return}const n=this._getKeyboardExtension();if(n.isInActionMode()){return}const o=e.getCellInfo(t.target);if(d._isKeyCombination(t,null,f.SHIFT)){if(o.isOfType(l.ANYCONTENTCELL)){if(!this._oRangeSelection){u(t);return}const n=e.getRowIndexOfFocusedCell(this);const o=this.getRows()[n].getIndex();const i=this._oRangeSelection.startIndex<o;let s;if(o===0){u(t);return}if(e.isFirstScrollableRow(this,t.target)){if(this._oRangeSelection.pScroll){u(t);return}else{s=y(this,t);this._oRangeSelection.pScroll=s}}if(s){u(t);s.then(function(){return T(this)}.bind(this)).then(function(){H(this,i?1:0,i);delete this._oRangeSelection.pScroll}.bind(this))}else{H(this,n-(i?0:1),i)}}else{u(t)}}if(d._isKeyCombination(t,null,f.ALT)){if(o.isOfType(l.DATACELL)){n.setActionMode(true)}u(t)}};d.prototype.onsapleft=function(e){g(e)};d.prototype.onsapleftmodifiers=function(t){if(t.isMarked()){u(t);return}g(t);if(this._getKeyboardExtension().isInActionMode()){return}const o=e.getCellInfo(t.target);const i=n.getRTL();if(d._isKeyCombination(t,null,f.SHIFT)){if(o.isOfType(l.DATACELL)){if(!this._oRangeSelection){u(t);return}const n=e.getFocusedItemInfo(this);const o=e.hasRowHeader(this)&&n.cellInRow===1;if(o&&!e.isRowSelectorSelectionAllowed(this)){u(t)}}else if(o.isOfType(l.ROWACTION)){if(!this._oRangeSelection){u(t)}}else if(o.isOfType(l.ROWHEADER)&&i){if(!e.isRowSelectionAllowed(this)){u(t)}}else if(o.isOfType(l.COLUMNROWHEADER)&&i){u(t)}else if(o.isOfType(l.COLUMNHEADER)){let n=-e.convertCSSSizeToPixel(a);let s=0;if(i){n=n*-1}for(let t=o.columnIndex;t<o.columnIndex+o.columnSpan;t++){s+=e.Column.getColumnWidth(this,t)}const l=this.getColumns()[o.columnIndex];e.Column.resizeColumn(this,l,s+n,true,o.columnSpan);u(t)}}else if(d._isKeyCombination(t,null,f.CTRL)){if(o.isOfType(l.COLUMNHEADER)){u(t);M(this.getColumns()[o.columnIndex],i)}}else if(d._isKeyCombination(t,null,f.ALT)){u(t)}};d.prototype.onsaprightmodifiers=function(t){if(t.isMarked()){u(t);return}g(t);if(this._getKeyboardExtension().isInActionMode()){return}const o=e.getCellInfo(t.target);const i=n.getRTL();if(d._isKeyCombination(t,null,f.SHIFT)){if(o.isOfType(l.DATACELL)){if(!this._oRangeSelection){u(t)}}else if(o.isOfType(l.ROWHEADER)){if(!e.isRowSelectionAllowed(this)){u(t)}}else if(o.isOfType(l.ROWACTION)&&i){if(!this._oRangeSelection){u(t)}}else if(o.isOfType(l.COLUMNHEADER)){let n=e.convertCSSSizeToPixel(a);let s=0;if(i){n=n*-1}for(let t=o.columnIndex;t<o.columnIndex+o.columnSpan;t++){s+=e.Column.getColumnWidth(this,t)}const l=this.getColumns()[o.columnIndex];e.Column.resizeColumn(this,l,s+n,true,o.columnSpan);u(t)}else if(o.isOfType(l.COLUMNROWHEADER)){u(t)}}else if(d._isKeyCombination(t,null,f.CTRL)){if(o.isOfType(l.COLUMNHEADER)){u(t);M(this.getColumns()[o.columnIndex],!i)}}else if(d._isKeyCombination(t,null,f.ALT)){u(t)}};d.prototype.onsaphome=function(t){g(t);if(this._getKeyboardExtension().isInActionMode()){return}if(e.Grouping.isInGroupHeaderRow(t.target)){u(t);return}const n=e.getCellInfo(t.target);if(n.isOfType(l.DATACELL|l.ROWACTION|l.COLUMNHEADER|l.ROWACTIONCOLUMNHEADER)){const n=e.getFocusedItemInfo(this);const o=n.cell;const i=n.cellInRow;const s=this.getComputedFixedColumnCount();const l=e.hasRowHeader(this);const r=l?1:0;if(e.hasFixedColumns(this)&&i>s+r){u(t);e.focusItem(this,o-i+s+r,null)}else if(l&&i>1){u(t);e.focusItem(this,o-i+r,null)}}};d.prototype.onsapend=function(t){g(t);if(this._getKeyboardExtension().isInActionMode()){return}if(e.Grouping.isInGroupHeaderRow(t.target)){u(t);return}const n=e.getCellInfo(t.target);if(n.isOfType(l.ANY)){const o=e.getFocusedItemInfo(this);const i=o.cell;const s=o.columnCount;const r=this.getComputedFixedColumnCount();const f=o.cellInRow;const c=e.hasRowHeader(this);const a=c?1:0;let g=false;if(n.isOfType(l.COLUMNHEADER)&&e.hasFixedColumns(this)){const e=parseInt(n.cell.getAttribute("colspan")||1);if(e>1&&f+e-a===r){g=true}}if(c&&f===0){u(t);e.focusItem(this,i+1,null)}else if(e.hasFixedColumns(this)&&f<r-1+a&&!g){u(t);e.focusItem(this,i+r-f,null)}else if(e.hasRowActions(this)&&f<s-2){u(t);e.focusItem(this,i-f+s-2,null)}}};d.prototype.onsaphomemodifiers=function(t){g(t);if(this._getKeyboardExtension().isInActionMode()){return}if(d._isKeyCombination(t,null,f.CTRL)){const n=e.getCellInfo(t.target);if(n.isOfType(l.ANYCONTENTCELL|l.COLUMNHEADER)){u(t);const n=e.getFocusedItemInfo(this);const o=n.row;if(o>0){const i=n.cell;const s=n.columnCount;const l=e.getHeaderRowCount(this);const r=this._getRowCounts();if(o<l+r.fixedTop){e.focusItem(this,i-s*o,t)}else if(o>=l+r.fixedTop&&o<l+e.getNonEmptyRowCount(this)-r.fixedBottom){this._getScrollExtension().scrollVerticallyMax(false);if(r.fixedTop>0){e.focusItem(this,i-s*(o-l),t)}else{e.focusItem(this,i-s*o,t)}}else{this._getScrollExtension().scrollVerticallyMax(false);e.focusItem(this,i-s*(o-l-r.fixedTop),t)}}}}};d.prototype.onsapendmodifiers=function(t){g(t);if(this._getKeyboardExtension().isInActionMode()){return}if(d._isKeyCombination(t,null,f.CTRL)){const n=e.getCellInfo(t.target);if(n.isOfType(l.ANY)){const n=e.getFocusedItemInfo(this);const o=n.row;const i=e.getHeaderRowCount(this);const s=e.getNonEmptyRowCount(this);const l=this._getRowCounts();u(t);if(l.fixedBottom===0||o<i+s-1||e.isNoDataVisible(this)&&o<i-1){const r=n.cell;const f=n.columnCount;if(e.isNoDataVisible(this)){e.focusItem(this,r+f*(i-o-1),t)}else if(o<i){if(l.fixedTop>0){e.focusItem(this,r+f*(i+l.fixedTop-o-1),t)}else{this._getScrollExtension().scrollVerticallyMax(true);e.focusItem(this,r+f*(i+s-l.fixedBottom-o-1),t)}}else if(o>=i&&o<i+l.fixedTop){this._getScrollExtension().scrollVerticallyMax(true);e.focusItem(this,r+f*(i+s-l.fixedBottom-o-1),t)}else if(o>=i+l.fixedTop&&o<i+s-l.fixedBottom){this._getScrollExtension().scrollVerticallyMax(true);e.focusItem(this,r+f*(i+s-o-1),t)}else{e.focusItem(this,r+f*(i+s-o-1),t)}}}}};d.prototype.onsappageup=function(t){g(t);if(this._getKeyboardExtension().isInActionMode()){return}const n=e.getCellInfo(t.target);if(n.isOfType(l.ANYCONTENTCELL|l.COLUMNHEADER)){const o=e.getFocusedItemInfo(this);const i=o.row;const s=e.getHeaderRowCount(this);const r=this._getRowCounts();if(r.fixedTop===0&&i>=s||r.fixedTop>0&&i>s){u(t);const f=o.cell;const c=o.columnCount;if(i<s+r.fixedTop){e.focusItem(this,f-c*(i-s),t)}else if(i===s+r.fixedTop){const o=e.getNonEmptyRowCount(this)-r.fixedTop-r.fixedBottom;const a=this.getFirstVisibleRow();y(this,t,true);if(a<o){if(r.fixedTop>0||n.isOfType(l.ROWACTION)){e.focusItem(this,f-c*(i-s),t)}else{e.focusItem(this,f-c*s,t)}}}else if(i>s+r.fixedTop&&i<s+e.getNonEmptyRowCount(this)){e.focusItem(this,f-c*(i-s-r.fixedTop),t)}else{e.focusItem(this,f-c*(i-s-e.getNonEmptyRowCount(this)+1),t)}}if(n.isOfType(l.ROWACTION)&&i===s&&r.fixedTop>0){u(t)}}};d.prototype.onsappagedown=function(t){g(t);if(this._getKeyboardExtension().isInActionMode()){return}const n=e.getCellInfo(t.target);if(n.isOfType(l.ANY)){const o=e.getFocusedItemInfo(this);const i=o.row;const s=e.getHeaderRowCount(this);const r=e.getNonEmptyRowCount(this);const f=this._getRowCounts();u(t);if(e.isNoDataVisible(this)&&i<s-1||f.fixedBottom===0||i<s+r-1){const c=o.cell;const a=o.columnCount;if(i<s-1&&!n.isOfType(l.COLUMNROWHEADER)){e.focusItem(this,c+a*(s-i-1),t)}else if(i<s){if(!e.isNoDataVisible(this)){e.focusItem(this,c+a*(s-i),t)}}else if(i>=s&&i<s+r-f.fixedBottom-1){e.focusItem(this,c+a*(s+r-f.fixedBottom-i-1),t)}else if(i===s+r-f.fixedBottom-1){const n=e.getNonEmptyRowCount(this)-f.fixedTop-f.fixedBottom;const o=this._getTotalRowCount()-f.fixedBottom-this.getFirstVisibleRow()-n*2;R(this,t,true);if(o<n&&f.fixedBottom>0){e.focusItem(this,c+a*(s+r-i-1),t)}}else{e.focusItem(this,c+a*(s+r-i-1),t)}}}};d.prototype.onsappageupmodifiers=function(t){g(t);if(this._getKeyboardExtension().isInActionMode()){return}if(d._isKeyCombination(t,null,f.ALT)){const n=e.getCellInfo(t.target);const o=e.getFocusedItemInfo(this);if(n.isOfType(l.DATACELL|l.COLUMNHEADER)){const n=o.cell;const i=o.cellInRow;const s=e.hasRowHeader(this);const l=s?1:0;const r=c;u(t);if(s&&(e.Grouping.isInGroupHeaderRow(t.target)||i===1)){e.focusItem(this,n-i,null)}else if(i-l<r){e.focusItem(this,n-i+l,null)}else{e.focusItem(this,n-r,null)}}else if(n.isOfType(l.ROWACTION)){e.focusItem(this,o.cell-1,null)}}};d.prototype.onsappagedownmodifiers=function(t){g(t);if(this._getKeyboardExtension().isInActionMode()){return}if(d._isKeyCombination(t,null,f.ALT)){const n=e.getCellInfo(t.target);if(n.isOfType(l.DATACELL|l.ROWHEADER|l.ANYCOLUMNHEADER)){const o=e.getFocusedItemInfo(this);const i=o.cellInRow;const s=e.hasRowHeader(this);const r=s?1:0;const f=e.getVisibleColumnCount(this);const a=parseInt(n.cell.getAttribute("colspan")||1);u(t);if(i+a-r<f){const n=o.cell;const l=c;if(s&&i===0){e.focusItem(this,n+1,null)}else if(a>l){e.focusItem(this,n+a,null)}else if(i+a-r+l>f){e.focusItem(this,n+f-i-1+r,null)}else if(!e.Grouping.isInGroupHeaderRow(t.target)){e.focusItem(this,n+l,null)}}else if(n.isOfType(l.DATACELL)&&e.hasRowActions(this)&&i===o.columnCount-2){e.focusItem(this,o.cell+1,null)}}}};d.prototype.onsapenter=function(e){D(this,e)};return d});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/extensions/Pointer", ["./ExtensionBase","../utils/TableUtils","../library","sap/ui/Device","sap/ui/core/Element","sap/ui/core/Popup","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/scrollLeftRTL","sap/ui/dom/jquery/control"],function(e,t,o,i,n,s,l,jQuery){"use strict";const r=o.SelectionMode;const a=o.SelectionBehavior;const d=["sapMBtnBase","sapMInputBase","sapMLnk","sapMSlt","sapMCb","sapMRI","sapMSegBBtn","sapUiIconPointer","sapMBtnIcon","sapMObjStatusActive"];const u={_skipClick:function(e,o,i){if(!i.isOfType(t.CELLTYPE.DATACELL|t.CELLTYPE.ROWACTION)){return false}if(e.isMarked()){return true}const s=n.closestTo(o[0]);if(s){const e=s.$();if(e.length){for(let t=0;t<d.length;t++){if(e.hasClass(d[t])){return typeof s.getEnabled==="function"?s.getEnabled():true}}}}return false},_handleClickSelection:function(e,o,i){t.toggleRowSelection(i,o,null,function(t){if(e.shiftKey){i._getSelectionPlugin().setSelected(t,true,{range:true})}else if(i._legacyMultiSelection){i._legacyMultiSelection(t.getIndex(),e)}else{t._setSelected(!t._isSelected())}})}};const c={initColumnResizing:function(e,o){if(e._bIsColumnResizerMoving){return}e._bIsColumnResizerMoving=true;e._bColumnResizerMoved=false;e._iColumnResizeStart=t.getEventPosition(o,e).x;e.$().toggleClass("sapUiTableResizing",true);const i=jQuery(document);const n=e._isTouchEvent(o);e._$colResize=e.$("rsz");i.on((n?"touchend":"mouseup")+".sapUiTableColumnResize",c.exitColumnResizing.bind(e));i.on((n?"touchmove":"mousemove")+".sapUiTableColumnResize",c.onMouseMoveWhileColumnResizing.bind(e));e._disableTextSelection()},exitColumnResizing:function(e){const o=t.getEventPosition(e,this).x;const i=this._getVisibleColumns()[this._iLastHoveredVisibleColumnIndex];const n=this.$().find('th[data-sap-ui-colid="'+i.getId()+'"]');const s=n[0].offsetWidth;const l=n.width();const r=s-l;const a=o-(n.offset().left+(this._bRtlMode?0:s));const d=Math.round(s+a*(this._bRtlMode?-1:1))-r;const u=Math.max(d,t.Column.getMinColumnWidth());c._cleanupColumResizing(this);t.Column.resizeColumn(this,i,this._bColumnResizerMoved?u:null)},onMouseMoveWhileColumnResizing:function(e){const o=t.getEventPosition(e,this).x;const i=this.$().find(".sapUiTableCnt").offset().left;const n=Math.floor(o-i);if(!this._bColumnResizerMoved&&Math.abs(o-this._iColumnResizeStart)>=5){this._bColumnResizerMoved=true}this._$colResize.css("left",n+"px");this._$colResize.toggleClass("sapUiTableColRszActive",true);if(this._isTouchEvent(e)){e.stopPropagation();e.preventDefault()}},_cleanupColumResizing:function(e){if(e._$colResize){e._$colResize.toggleClass("sapUiTableColRszActive",false);e._$colResize=null}e._bIsColumnResizerMoving=false;e.$().toggleClass("sapUiTableResizing",false);e._enableTextSelection();const t=jQuery(document);t.off("touchmove.sapUiTableColumnResize");t.off("touchend.sapUiTableColumnResize");t.off("mousemove.sapUiTableColumnResize");t.off("mouseup.sapUiTableColumnResize")},initColumnTracking:function(e){e.$().find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed").on("mousemove",function(e){const t=this.getDomRef("sapUiTableCnt");if(!t||this._bIsColumnResizerMoving){return}const o=e.clientX;const i=t.getBoundingClientRect();let n=0;let s=this._bRtlMode?1e4:-1e4;for(let e=0;e<this._aTableHeaders.length;e++){const t=this._aTableHeaders[e].getBoundingClientRect();if(this._bRtlMode){if(o<t.right-5&&o>=t.left){n=e;s=t.left-i.left;break}}else{if(o>t.left+5&&o<=t.right){n=e;s=t.right-i.left;break}}}const l=this._getVisibleColumns()[n];if(l&&l.getResizable()){this.$("rsz").css("left",s+"px");this._iLastHoveredVisibleColumnIndex=n}}.bind(e))}};const f={initReordering:function(e,o,i){const n=e.getColumns()[o];const l=n.$();const r=e.$();e._disableTextSelection();r.addClass("sapUiTableDragDrop");const a=l.clone();a.find("*").addBack(a).removeAttr("id").removeAttr("data-sap-ui").removeAttr("tabindex");a.attr("id",e.getId()+"-roghost").addClass("sapUiTableColReorderGhost").css({left:-1e4,top:-1e4,"z-index":s.getNextZIndex()});a.toggleClass(t.getContentDensity(e),true);a.appendTo(document.body);e._$ReorderGhost=e.getDomRef("roghost");r.find("td[data-sap-ui-colid='"+n.getId()+"']").toggleClass("sapUiTableColReorderFade",true);const d=jQuery("<div id='"+e.getId()+"-roind' class='sapUiTableColReorderIndicator'><div class='sapUiTableColReorderIndicatorArrow'></div><div class='sapUiTableColReorderIndicatorInner'></div></div>");d.appendTo(e.getDomRef("sapUiTableCnt"));e._$ReorderIndicator=e.getDomRef("roind");e._iDnDColIndex=o;const u=jQuery(document);const c=e._isTouchEvent(i);u.on((c?"touchend":"mouseup")+".sapUiColumnMove",f.exitReordering.bind(e));u.on((c?"touchmove":"mousemove")+".sapUiColumnMove",f.onMouseMoveWhileReordering.bind(e))},onMouseMoveWhileReordering:function(e){const o=t.getEventPosition(e,this);const i=o.x;const n=o.y;const s=this._iNewColPos;this._iNewColPos=this._iDnDColIndex;e.preventDefault();const l=f.findColumnForPosition(this,i);if(!l||!l.id){this._iNewColPos=s;return}const r=40;const a=this.getDomRef("sapUiTableColHdrScr");const d=jQuery(a);const u=a.getBoundingClientRect();const c=d.outerWidth();const h=this._bRtlMode?d.scrollLeftRTL():d.scrollLeft();this._bReorderScroll=false;if(i>u.left+c-r&&h+c<a.scrollWidth){this._bReorderScroll=true;f.doScroll(this,!this._bRtlMode);f.adaptReorderMarkerPosition(this,l,false)}else if(i<u.left+r&&h>0){this._bReorderScroll=true;f.doScroll(this,this._bRtlMode);f.adaptReorderMarkerPosition(this,l,false)}jQuery(this._$ReorderGhost).css({left:i+5,top:n+5});if(this._bReorderScroll||!l){return}if(l.before||l.after&&l.index===this._iDnDColIndex){this._iNewColPos=l.index}else if(l.after&&l.index!==this._iDnDColIndex){this._iNewColPos=l.index+1}if(!t.Column.isColumnMovableTo(this.getColumns()[this._iDnDColIndex],this._iNewColPos)){this._iNewColPos=s}else{f.adaptReorderMarkerPosition(this,l,true)}},exitReordering:function(e){const o=this._iDnDColIndex;const i=this._iNewColPos;const n=jQuery(document);n.off("touchmove.sapUiColumnMove");n.off("touchend.sapUiColumnMove");n.off("mousemove.sapUiColumnMove");n.off("mouseup.sapUiColumnMove");this._bReorderScroll=false;this.$().removeClass("sapUiTableDragDrop");delete this._iDnDColIndex;delete this._iNewColPos;jQuery(this._$ReorderGhost).remove();delete this._$ReorderGhost;jQuery(this._$ReorderIndicator).remove();delete this._$ReorderIndicator;this.$().find(".sapUiTableColReorderFade").removeClass("sapUiTableColReorderFade");this._enableTextSelection();t.Column.moveColumnTo(this.getColumns()[o],i)},findColumnForPosition:function(e,t){let o;let i;let n;let s;let l;let r;let a;for(let d=0;d<e._aTableHeaders.length;d++){o=e._aTableHeaders[d];i=jQuery(o);n=o.getBoundingClientRect();s=i.outerWidth();l={left:n.left,center:n.left+s/2,right:n.left+s,width:s,index:parseInt(i.attr("data-sap-ui-headcolindex")),id:i.attr("data-sap-ui-colid")};r=t>=l.left&&t<=l.center;a=t>=l.center&&t<=l.right;if(r||a){l.before=e._bRtlMode?a:r;l.after=e._bRtlMode?r:a;return l}}return null},doScroll:function(e,t){if(e._mTimeouts.horizontalReorderScrollTimerId){window.clearTimeout(e._mTimeouts.horizontalReorderScrollTimerId);e._mTimeouts.horizontalReorderScrollTimerId=null}if(e._bReorderScroll){let o=t?30:-30;if(e._bRtlMode){o=-1*o}e._mTimeouts.horizontalReorderScrollTimerId=setTimeout(f.doScroll.bind(e,e,t),60);const i=e.$("sapUiTableColHdrScr");const n=e._bRtlMode?"scrollLeftRTL":"scrollLeft";i[n](i[n]()+o)}},adaptReorderMarkerPosition:function(e,t,o){if(!t||!e._$ReorderIndicator){return}let i=t.left-e.getDomRef().getBoundingClientRect().left;if(e._bRtlMode&&t.before||!e._bRtlMode&&t.after){i=i+t.width}jQuery(e._$ReorderIndicator).css({left:i+"px"}).toggleClass("sapUiTableColReorderIndicatorActive",o)}};const h={ROWAREAS:[".sapUiTableRowSelectionCell",".sapUiTableRowActionCell",".sapUiTableCtrlFixed > tbody > .sapUiTableTr",".sapUiTableCtrlScroll > tbody > .sapUiTableTr"],initRowHovering:function(e){const t=e.$();h.ROWAREAS.forEach(function(o){h._initRowHoveringForArea(e,t,o)})},_initRowHoveringForArea:function(e,t,o){t.find(o).on("mouseenter",function(){h._onHover(e,t,o,this)}).on("mouseleave",function(){h._onUnhover(e,t,o,this)})},_onHover:function(e,t,o,i){if(e.getSelectionMode()!==r.None&&e.getSelectionBehavior()!==a.RowSelector||e.hasListeners("cellClick")){const n=t.find(o).index(i);const s=e.getRows()[n];if(s){s._setHovered(true)}}},_onUnhover:function(e,t,o,i){const n=t.find(o).index(i);const s=e.getRows()[n];if(s){s._setHovered(false)}}};const C={onmousedown:function(e){const o=this._getPointerExtension();const n=t.getCell(this,e.target);const s=t.getCellInfo(n);const l=jQuery(e.target);let r;let a;let d;this._getKeyboardExtension().initItemNavigation();if(e.button===0){if(e.target===this.getDomRef("rsz")){e.preventDefault();e.stopPropagation();c.initColumnResizing(this,e)}else if(l.hasClass("sapUiTableColResizer")){const t=l.closest(".sapUiTableHeaderCell").attr("data-sap-ui-colindex");this._iLastHoveredVisibleColumnIndex=this._getVisibleColumns().indexOf(this.getColumns()[t]);c.initColumnResizing(this,e)}else if(s.isOfType(t.CELLTYPE.COLUMNHEADER)){r=this.getColumns()[s.columnIndex];a=r.getAggregation("menu");d=a&&a.isOpen();if(!d){o._bShowMenu=true;this._mTimeouts.delayedMenuTimerId=setTimeout(function(){delete o._bShowMenu},200)}if(this.getEnableColumnReordering()&&!(this._isTouchEvent(e)&&l.hasClass("sapUiTableColDropDown"))){this._getPointerExtension().doReorderColumn(s.columnIndex,e)}}if(i.browser.firefox&&(e.metaKey||e.ctrlKey)||l.closest(".sapUiTableHSb",this.getDomRef()).length===1||l.closest(".sapUiTableVSb",this.getDomRef()).length===1){e.preventDefault()}}if(e.button===2){if(u._skipClick(e,l,s)){o._bShowDefaultMenu=true;return}if(s.isOfType(t.CELLTYPE.COLUMNHEADER)){r=this.getColumns()[s.columnIndex];a=r.getAggregation("menu");d=a&&a.isOpen();if(!d){o._bShowMenu=true}else{o._bHideMenu=true}}else if(s.isOfType(t.CELLTYPE.ANYCONTENTCELL)){o._bShowMenu=true}else{o._bShowDefaultMenu=true}}},onmouseup:function(e){clearTimeout(this._mTimeouts.delayedColumnReorderTimerId)},ondblclick:function(e){if(i.system.desktop&&e.target===this.getDomRef("rsz")){e.preventDefault();c._cleanupColumResizing(this);const t=this._getVisibleColumns()[this._iLastHoveredVisibleColumnIndex];if(t.getAutoResizable()){t.autoResize()}}},ontap:function(e){clearTimeout(this._mTimeouts.delayedColumnReorderTimerId);if(e.isMarked()){return}const o=jQuery(e.target);const i=t.getCell(this,e.target);const n=t.getCellInfo(i);const s=this.getRows()[n.rowIndex];if(!n.isOfType(t.CELLTYPE.ANY)){return}if(n.isOfType(t.CELLTYPE.COLUMNHEADER)){const o=this._getPointerExtension();if(o._bShowMenu){t.Menu.openContextMenu(this,e);delete o._bShowMenu}}else if(n.isOfType(t.CELLTYPE.COLUMNROWHEADER)){this._getSelectionPlugin().onHeaderSelectorPress()}else if(s&&s.isSummary()){e.preventDefault()}else if(o.hasClass("sapUiTableGroupIcon")||o.hasClass("sapUiTableTreeIcon")){s.toggleExpandedState()}else{if(u._skipClick(e,o,n)){return}const t=window.getSelection().toString();if(!e.shiftKey&&t.length>0&&t!=="\n"){l.debug("DOM Selection detected -> Click event on table skipped, Target: "+e.target);return}if(!this._findAndfireCellEvent(this.fireCellClick,e)){u._handleClickSelection(e,i,this)}else{e.preventDefault()}}},oncontextmenu:function(e){const o=this._getPointerExtension();if(o._bShowDefaultMenu){e.setMarked("sapUiTableHandledByPointerExtension");delete o._bShowDefaultMenu}else if(o._bShowMenu){t.Menu.openContextMenu(this,e);e.setMarked("sapUiTableHandledByPointerExtension");delete o._bShowMenu}else if(o._bHideMenu){e.setMarked("sapUiTableHandledByPointerExtension");e.preventDefault();delete o._bHideMenu}}};const g=e.extend("sap.ui.table.extensions.Pointer",{_init:function(o,i,n){this._delegate=C;t.addDelegate(o,this._delegate,o);o._iLastHoveredVisibleColumnIndex=0;o._bIsColumnResizerMoving=false;o._iFirstReorderableIndex=i===e.TABLETYPES.TREE?1:0;return"PointerExtension"},_attachEvents:function(){const e=this.getTable();if(e){c.initColumnTracking(e);h.initRowHovering(e)}},_detachEvents:function(){const e=this.getTable();if(e){const t=e.$();t.find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed").off();t.find(".sapUiTableCtrl > tbody > tr").off();t.find(".sapUiTableRowSelectionCell").off()}},_debug:function(){this._ExtensionHelper=u;this._ColumnResizeHelper=c;this._ReorderHelper=f;this._ExtensionDelegate=C;this._RowHoverHandler=h;this._KNOWNCLICKABLECONTROLS=d},doReorderColumn:function(e,o){const i=this.getTable();if(i&&t.Column.isColumnMovable(i.getColumns()[e])){i._mTimeouts.delayedColumnReorderTimerId=setTimeout(function(){f.initReordering(this,e,o)}.bind(i),200)}},destroy:function(){const t=this.getTable();if(t){t.removeEventDelegate(this._delegate)}this._delegate=null;e.prototype.destroy.apply(this,arguments)}});return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/extensions/Scrolling", ["./ExtensionBase","../utils/TableUtils","../library","sap/ui/Device","sap/ui/performance/trace/Interaction","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/scrollLeftRTL"],function(e,t,o,l,r,i,jQuery){"use strict";const n=o.SharedDomRef;const s=t.Hook.Keys;const c=t.createWeakMapFacade();const a=1e6;const f=2;const d=500;const u={HORIZONAL:"HORIZONTAL",VERTICAL:"VERTICAL",BOTH:"BOTH"};function p(e,t){i.debug("sap.ui.table.extensions.Scrolling",e,t)}function g(e,t){let o=true;let l=false;const r=[];const i={cancel:function(){if(this.isCancelled()||!this.isRunning()){return}l=true;for(let e=0;e<r.length;e++){r[e]()}p("Process cancelled: "+t.id)},isCancelled:function(){return l},addCancelListener:function(e){r.push(e)},isRunning:function(){return o},getInfo:function(){return t},onPromiseCreated:function(e){}};let n;p("Process started: "+t.id);if(typeof e==="function"){n=new Promise(function(){e.apply(this,Array.prototype.slice.call(arguments).concat(i))})}else{n=Promise.resolve()}Object.assign(n,i);n.then(function(){if(i.isCancelled()){p("Process finished due to cancellation: "+t.id)}else{p("Process finished: "+t.id)}o=false});i.onPromiseCreated(n);return n}function S(){this.iIndex=0;this.nOffset=0;this.sOffsetType=S.OffsetType.Pixel;this.bIsInitial=true}S.OffsetType={Pixel:"Pixel",Percentage:"Percentage",PercentageOfViewport:"PercentageOfViewport"};S.prototype.getIndex=function(){return this.iIndex};S.prototype.getOffset=function(){return this.nOffset};S.prototype.getOffsetType=function(){return this.sOffsetType};S.prototype.isOffsetInPixel=function(){return this.sOffsetType===S.OffsetType.Pixel};S.prototype.isInitial=function(){return this.bIsInitial};S.prototype.setPosition=function(e,t,o){p("ScrollPosition#setPosition(index: "+e+", offset: "+t+", offsetType: "+o+")");if(!S._isPositiveNumber(e)){return}if(!S._isPositiveNumber(t)){this.nOffset=0}this.setIndex(e);this.setOffset(t,o)};S.prototype.setIndex=function(e){p("ScrollPosition#setIndex(index: "+e+")");if(!S._isPositiveNumber(e)){return}this.bIsInitial=false;this.iIndex=e};S.prototype.setOffset=function(e,t){p("ScrollPosition#setOffset(offset: "+e+", offsetType: "+t+")");if(!S._isPositiveNumber(e)){return}this.bIsInitial=false;this.sOffsetType=t in S.OffsetType?t:S.OffsetType.Pixel;if(this.isOffsetInPixel()){this.nOffset=Math.round(e)}else{this.nOffset=Math.min(e,1)}};S.prototype.scrollRows=function(e){const t=this.getIndex()+e;let o=this.getOffset();if(!this.isOffsetInPixel()||t<0){o=0}this.setPosition(Math.max(0,t),o)};S._isPositiveNumber=function(e){return typeof e==="number"&&!isNaN(e)&&e>=0};const h={UpdateFromFirstVisibleRow:{id:"UpdateFromFirstVisibleRow",rank:6},UpdateFromScrollPosition:{id:"UpdateFromScrollPosition",rank:5},RestoreScrollPosition:{id:"RestoreScrollPosition",rank:4},AdjustToTotalRowCount:{id:"AdjustToTotalRowCount",rank:3},OnRowsUpdated:{id:"OnRowsUpdated",rank:3},UpdateFromScrollbar:{id:"UpdateFromScrollbar",rank:2},UpdateFromViewport:{id:"UpdateFromViewport",rank:1},canStart:function(e,t){const o=c(e).pVerticalScrollUpdateProcess;const l=o?o.getInfo():null;if(o&&o.isRunning()&&l.rank>t.rank){p("Cannot start update process "+t.id+" - A higher-ranked update process is currently running ("+l.id+")",e);return false}return true},start:function(e,t,o){if(!h.canStart(e,t)){return}if(c(e).pVerticalScrollUpdateProcess){c(e).pVerticalScrollUpdateProcess.cancel()}c(e).pVerticalScrollUpdateProcess=new g(o,t)}};const b={onScrollbarScroll:function(e){const t=e.target.scrollLeft;const o=e.target._scrollLeft;r.notifyScrollEvent&&r.notifyScrollEvent(e);if(t!==o){const o=b.getScrollAreas(this);e.target._scrollLeft=t;for(let l=0;l<o.length;l++){const r=o[l];if(r!==e.target&&r.scrollLeft!==t){r.scrollLeft=t;r._scrollLeft=t}}c(this).iHorizontalScrollPosition=t}},restoreScrollPosition:function(e){const t=e._getScrollExtension();const o=t.getHorizontalScrollbar();if(o&&c(e).iHorizontalScrollPosition!==null){const t=b.getScrollAreas(e);for(let e=0;e<t.length;e++){const o=t[e];delete o._scrollLeft}if(o.scrollLeft!==c(e).iHorizontalScrollPosition){o.scrollLeft=c(e).iHorizontalScrollPosition}else{const t=jQuery.Event("scroll");t.target=o;b.onScrollbarScroll.call(e,t)}}},updateScrollbar:function(e){const t=e._getScrollExtension();const o=t.getHorizontalScrollbar();if(!o){return}const r=e._collectTableSizes();const i=e.$();let n=r.tableCtrlScrollWidth;if(l.browser.safari){n=Math.max(n,e._getColumnsWidth(e.getComputedFixedColumnCount()))}const s=n>r.tableCtrlScrWidth;if(s){if(!t.isHorizontalScrollbarVisible()){i.addClass("sapUiTableHScr");o.classList.remove("sapUiTableHidden");if(l.browser.safari){const e=i.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");e.outerWidth(n)}}let s=r.tableCtrlFixedWidth;if(i.find(".sapUiTableRowHdrScr").length>0){s+=r.tableRowHdrScrWidth}if(e._bRtlMode){o.style.marginRight=s+"px";o.style.marginLeft=""}else{o.style.marginLeft=s+"px";o.style.marginRight=""}const c=e.getDomRef("hsb-content");if(c){c.style.width=n+"px"}}if(!s&&t.isHorizontalScrollbarVisible()){i.removeClass("sapUiTableHScr");o.classList.add("sapUiTableHidden");if(l.browser.safari){i.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width","")}}},onScrollbarMouseDown:function(e){this._getKeyboardExtension().setActionMode(false)},addEventListeners:function(e){const t=e._getScrollExtension();const o=t.getHorizontalScrollbar();const l=b.getScrollAreas(e);if(!t._onHorizontalScrollEventHandler){t._onHorizontalScrollEventHandler=b.onScrollbarScroll.bind(e)}for(let e=0;e<l.length;e++){l[e].addEventListener("scroll",t._onHorizontalScrollEventHandler)}if(o){if(!t._onHorizontalScrollbarMouseDownEventHandler){t._onHorizontalScrollbarMouseDownEventHandler=b.onScrollbarMouseDown.bind(e)}o.addEventListener("mousedown",t._onHorizontalScrollbarMouseDownEventHandler)}},removeEventListeners:function(e){const t=e._getScrollExtension();const o=t.getHorizontalScrollbar();const l=b.getScrollAreas(e);if(t._onHorizontalScrollEventHandler){for(let e=0;e<l.length;e++){l[e].removeEventListener("scroll",t._onHorizontalScrollEventHandler);delete l[e]._scrollLeft}delete t._onHorizontalScrollEventHandler}if(o&&t._onHorizontalScrollbarMouseDownEventHandler){o.removeEventListener("mousedown",t._onHorizontalScrollbarMouseDownEventHandler);delete t._onHorizontalScrollbarMouseDownEventHandler}},getScrollAreas:function(e){const t=e.getDomRef();let o;if(t){o=Array.prototype.slice.call(e.getDomRef().querySelectorAll(".sapUiTableCtrlScr"))}const l=[e._getScrollExtension().getHorizontalScrollbar()].concat(o);return l.filter(function(e){return e!=null})}};const T={performUpdateFromFirstVisibleRow:function(e,o){p("VerticalScrollingHelper.performUpdateFromFirstVisibleRow",e);h.start(e,h.UpdateFromFirstVisibleRow,function(l,r,i){t.Hook.call(e,s.Signal,"StartTableUpdate");i.onPromiseCreated=function(o){o.finally(function(){t.Hook.call(e,s.Signal,"EndTableUpdate")})};if(o===true){const t=function(){p("VerticalScrollingHelper.performUpdateFromFirstVisibleRow (async: rows update)",e);T._performUpdateFromFirstVisibleRow(e,i).then(l);return false};T.addOnRowsUpdatedPreprocessor(e,t);i.addCancelListener(function(){const o=T.removeOnRowsUpdatedPreprocessor(e,t);if(o){l()}})}else{T._performUpdateFromFirstVisibleRow(e,i).then(l)}})},_performUpdateFromFirstVisibleRow:function(e,t){return T.adjustScrollPositionToFirstVisibleRow(e,t).then(function(){return T.fixTemporaryFirstVisibleRow(e,null,t)}).then(function(){return T.fixScrollPosition(e,t)}).then(function(){return Promise.all([T.scrollViewport(e,t),T.scrollScrollbar(e,t)])})},performUpdateFromScrollPosition:function(e){p("VerticalScrollingHelper.performUpdateFromScrollPosition",e);h.start(e,h.UpdateFromScrollPosition,function(o,l,r){t.Hook.call(e,s.Signal,"StartTableUpdate");r.onPromiseCreated=function(o){o.finally(function(){t.Hook.call(e,s.Signal,"EndTableUpdate")})};T.adjustFirstVisibleRowToScrollPosition(e,null,r).then(function(){if(r.isCancelled()){return}const o=c(e).oVerticalScrollPosition;p("VerticalScrollingHelper.performUpdateFromScrollPosition (async: firstVisibleRow update)",e);if(o.getIndex()>e.getFirstVisibleRow()){o.setIndex(e.getFirstVisibleRow());if(t.isVariableRowHeightEnabled(e)){o.setOffset(1,S.OffsetType.Percentage)}else{o.setOffset(0)}}}).then(function(){return T.fixScrollPosition(e,r)}).then(function(){return Promise.all([T.scrollViewport(e,r),T.scrollScrollbar(e,r)])}).then(o)})},performUpdateFromScrollbar:function(e){p("VerticalScrollingHelper.performUpdateFromScrollbar",e);clearTimeout(c(e).mTimeouts.largeDataScrolling);delete c(e).mTimeouts.largeDataScrolling;h.start(e,h.UpdateFromScrollbar,function(o,l,r){t.Hook.call(e,s.Signal,"StartTableUpdate");r.onPromiseCreated=function(o){o.finally(function(){t.Hook.call(e,s.Signal,"EndTableUpdate")})};e._getKeyboardExtension().setActionMode(false);if(e._bLargeDataScrolling){c(e).mTimeouts.largeDataScrolling=setTimeout(function(){delete c(e).mTimeouts.largeDataScrolling;if(e._getScrollExtension().getVerticalScrollbar()!=null){p("VerticalScrollingHelper.performUpdateFromScrollbar (async: large data scrolling)",e);T._performUpdateFromScrollbar(e,r).then(o)}else{p("VerticalScrollingHelper.performUpdateFromScrollbar (async: large data scrolling): No scrollbar",e)}},300);r.addCancelListener(function(){if(c(e).mTimeouts.largeDataScrolling!=null){clearTimeout(c(e).mTimeouts.largeDataScrolling);delete c(e).mTimeouts.largeDataScrolling;o()}})}else{T._performUpdateFromScrollbar(e,r).then(o)}})},_performUpdateFromScrollbar:function(e,t){return T.adjustScrollPositionToScrollbar(e,t).then(function(){return T.adjustFirstVisibleRowToScrollPosition(e,null,t)}).then(function(){return T.fixScrollPosition(e,t)}).then(function(){return T.scrollViewport(e,t)})},performUpdateFromViewport:function(e){p("VerticalScrollingHelper.performUpdateFromViewport",e);h.start(e,h.UpdateFromViewport,function(o,l,r){t.Hook.call(e,s.Signal,"StartTableUpdate");r.onPromiseCreated=function(o){o.finally(function(){t.Hook.call(e,s.Signal,"EndTableUpdate")})};T.adjustScrollPositionToViewport(e,r).then(function(){return T.adjustFirstVisibleRowToScrollPosition(e,true,r)}).then(function(){return T.scrollScrollbar(e,r)}).then(o)})},onScrollbarScroll:function(e){r.notifyScrollEvent&&r.notifyScrollEvent(e);const t=e.target.scrollTop;const o=e.target._scrollTop;const l=t!==o;delete e.target._scrollTop;if(t===0&&!e.target.isConnected){p("VerticalScrollingHelper.onScrollbarScroll: Scrollbar is not connected with the DOM",this)}else if(l){p("VerticalScrollingHelper.onScrollbarScroll: Scroll position changed to "+t+" by interaction",this);T.performUpdateFromScrollbar(this)}else{p("VerticalScrollingHelper.onScrollbarScroll: Scroll position changed to "+t+" by API",this)}},onViewportScroll:function(e){if(!h.canStart(this,h.UpdateFromViewport)){return}const t=e.target.scrollTop;const o=e.target._scrollTop;delete e.target._scrollTop;if(t!==o){p("VerticalScrollingHelper.onViewportScroll: Scroll position changed to "+t+" by interaction",this);T.performUpdateFromViewport(this)}else{p("VerticalScrollingHelper.onViewportScroll: Scroll position changed to "+t+" by API",this)}},adjustFirstVisibleRowToScrollPosition:function(e,t,o){if(o&&o.isCancelled()){return Promise.resolve()}t=t===true;const l=c(e).oVerticalScrollPosition;const r=l.getOffsetType()===S.OffsetType.PercentageOfViewport;const i=l.getIndex();const n=e.getFirstVisibleRow();const s=T.isIndexInBuffer(e,i);const a=s||r;p("VerticalScrollingHelper.adjustFirstVisibleRowToScrollPosition:"+' Set "firstVisibleRow" from '+n+" to "+i,e);const f=e._setFirstVisibleRowIndex(i,{onScroll:true,suppressEvent:a,suppressRendering:t});if(!f){if(a){return T.fixTemporaryFirstVisibleRow(e,true,o)}return Promise.resolve()}return new Promise(function(t){const l=function(l){p("VerticalScrollingHelper.adjustFirstVisibleRowToScrollPosition (async: rows updated):"+" Reason "+l.getParameters().reason,this);if(a){T.fixTemporaryFirstVisibleRow(e,true,o).then(t)}else{t()}return false};T.addOnRowsUpdatedPreprocessor(e,l);if(o){o.addCancelListener(function(){const o=T.removeOnRowsUpdatedPreprocessor(e,l);if(o){t()}})}})},fixTemporaryFirstVisibleRow:function(e,t,o){if(o&&o.isCancelled()){return Promise.resolve()}t=t===true;const l=c(e).oVerticalScrollPosition;const r=l.getOffsetType()===S.OffsetType.PercentageOfViewport;const i=l.getIndex();const n=T.isIndexInBuffer(e,i);const s=n||r;if(!s){p("VerticalScrollingHelper.fixTemporaryFirstVisibleRow: Aborted - The index is already final",e);return Promise.resolve()}let a=i;const f=T.getScrollRangeOfViewport(e);const d=e._getMaxFirstRenderedRowIndex();const u=e._aRowHeights;let g;p("VerticalScrollingHelper.fixTemporaryFirstVisibleRow",e);if(r){let e=f*l.getOffset();if(n){a=d}for(g=0;g<u.length;g++){const t=e-u[g];if(t>=0){e=t;a++}else{break}}}else if(n){const e=Math.max(0,Math.min(u.length-1,i-d));let t=0;for(g=0;g<e;g++){t+=u[g];if(t>f){a=d+g;break}}}if(i!==a||t){p('VerticalScrollingHelper.fixTemporaryFirstVisibleRow: Set "firstVisibleRow" to '+a,e);e._setFirstVisibleRowIndex(a,{onScroll:true,forceEvent:t,suppressRendering:true})}return Promise.resolve()},adjustScrollPositionToFirstVisibleRow:function(e,t){if(t&&t.isCancelled()){return Promise.resolve()}p("VerticalScrollingHelper.adjustScrollPositionToFirstVisibleRow",e);c(e).oVerticalScrollPosition.setPosition(e.getFirstVisibleRow());return Promise.resolve()},adjustScrollPositionToScrollbar:function(e,o){if(o&&o.isCancelled()){return Promise.resolve()}const l=c(e).oVerticalScrollPosition;const r=T.getScrollPositionOfScrollbar(e);const i=T.getScrollRange(e);const n=T.getScrollRangeRowFraction(e);let s=0;let a=0;let f=S.OffsetType.Percentage;let d;p("VerticalScrollingHelper.adjustScrollPositionToScrollbar",e);if(t.isVariableRowHeightEnabled(e)){if(T.isScrollPositionOfScrollbarInBuffer(e)){const t=T.getScrollRangeBuffer(e);const o=i-t;const n=r-o;const c=n/t;s=e._getMaxFirstRenderedRowIndex();if(T.isIndexInBuffer(e,l.getIndex())){const t=T.getScrollRangeOfViewport(e);let o=t*c;const l=e._aRowHeights;for(let e=0;e<l.length;e++){const t=o-l[e];if(t>=0){o=t;s++}else{a=Math.round(o);f=S.OffsetType.Pixel;break}}}else{a=c;f=S.OffsetType.PercentageOfViewport}}else{d=r/n;s=Math.floor(d);a=d-s}}else{const t=i-r;const o=t<1;if(o){s=e._getMaxFirstVisibleRowIndex();a=0;f=S.OffsetType.Pixel}else{d=r/n;s=Math.floor(d);a=d-s}}l.setPosition(s,a,f);return Promise.resolve()},adjustScrollPositionToViewport:function(e,t){if(t&&t.isCancelled()){return Promise.resolve()}const o=c(e).oVerticalScrollPosition;const l=e._aRowHeights;let r=e._getFirstRenderedRowIndex();let i=0;let n=T.getScrollPositionOfViewport(e);p("VerticalScrollingHelper.adjustScrollPositionToViewport",e);for(let e=0;e<l.length;e++){const t=n-l[e];if(t>=0){n=t;r++}else{i=Math.round(n);break}}o.setPosition(r,i);return Promise.resolve()},fixScrollPosition:function(e,o){if(o&&o.isCancelled()){return Promise.resolve()}const l=c(e).oVerticalScrollPosition;const r=e.getDomRef("tableCCnt");const i=T.getScrollRangeOfViewport(e);const n=e._aRowHeights;if(!r||!e.getBinding()){p("VerticalScrollingHelper.fixScrollPosition: Aborted - Viewport or binding not available",e);return Promise.resolve()}p("VerticalScrollingHelper.fixScrollPosition",e);let s=l.getIndex();let a=l.getOffset();let f=0;let d;const u=e._getFirstRenderedRowIndex();switch(l.getOffsetType()){case S.OffsetType.Pixel:case S.OffsetType.Percentage:{const o=l.getIndex();let r=0;let c=l.getOffsetType();if(T.isIndexInBuffer(e,o)){let e=0;f=Math.max(0,Math.min(n.length-1,o-u));for(d=0;d<f;d++){e+=n[d];if(e>i){s=u+d;a=i-r;c=S.OffsetType.Pixel;f=d;break}else{r=e}}}if(c===S.OffsetType.Pixel){a=Math.min(a,n[f])}else{a=n[f]*a}r+=a;if(r>i&&t.isVariableRowHeightEnabled(e)){a-=r-i}break}case S.OffsetType.PercentageOfViewport:{let e=i*l.getOffset();for(d=0;d<n.length;d++){const t=e-n[d];if(t>=0){e=t;f++}else{s=u+f;a=Math.round(e);break}}break}default:}l.setPosition(s,a);return Promise.resolve()},scrollViewport:function(e,o){if(o&&o.isCancelled()){return Promise.resolve()}if(!t.isVariableRowHeightEnabled(e)){p("VerticalScrollingHelper.scrollViewport: Aborted - Variable row height not enabled",e);return Promise.resolve()}const l=c(e).oVerticalScrollPosition;const r=e.getDomRef("tableCCnt");const i=T.getScrollRangeOfViewport(e);const n=e._aRowHeights;let s=0;if(i===0){p("VerticalScrollingHelper.scrollViewport: Aborted - No overflow in viewport",e);r.scrollTop=s;r._scrollTop=r.scrollTop;return Promise.resolve()}p("VerticalScrollingHelper.scrollViewport",e);switch(l.getOffsetType()){case S.OffsetType.Pixel:{const t=l.getIndex();const o=Math.max(0,Math.min(n.length-1,t-e._getFirstRenderedRowIndex()));for(let e=0;e<o;e++){s+=n[e]}s+=l.getOffset();break}default:p("VerticalScrollingHelper.scrollViewport: The viewport can only be scrolled if the offset is in pixel",e);return Promise.resolve()}p("VerticalScrollingHelper.scrollViewport: Scroll from "+r.scrollTop+" to "+s,e);r.scrollTop=s;r._scrollTop=r.scrollTop;return Promise.resolve()},scrollScrollbar:function(e,t){if(t&&t.isCancelled()){return Promise.resolve()}const o=c(e).oVerticalScrollPosition;const l=o.getIndex();const r=T.getScrollRangeBuffer(e);const i=T.getScrollRange(e);const n=i-r;let s=0;let a=0;const f=T.getScrollRangeOfViewport(e);const u=e._aRowHeights;let g;p("VerticalScrollingHelper.scrollScrollbar",e);if(i===0||u.length===0){p("VerticalScrollingHelper.scrollScrollbar: No scrollable content",e);return Promise.resolve()}switch(o.getOffsetType()){case S.OffsetType.Pixel:if(T.isIndexInBuffer(e,l)){let t=0;g=Math.max(0,Math.min(u.length-1,l-e._getMaxFirstRenderedRowIndex()));for(let e=0;e<g;e++){t+=u[e]}t+=Math.min(u[g],o.getOffset());const i=Math.min(t/f,1);const c=r*i;s=n+c}else{const t=T.getScrollRangeRowFraction(e);s=l*t;g=Math.max(0,Math.min(u.length-1,l-e._getFirstRenderedRowIndex()));s+=t*Math.min(o.getOffset()/u[g],1)}break;default:p("VerticalScrollingHelper.scrollViewport: The scrollbar can only be scrolled if the offset is in pixel",e);return Promise.resolve()}if(s>0&&s<.5){a=1}else if(s>=i-.5&&s<i){a=i-1}else{a=Math.round(s)}const h=e._getScrollExtension().getVerticalScrollbar();const b=a>h.scrollTop;if(h){p("VerticalScrollingHelper.scrollScrollbar: Scroll from "+h.scrollTop+" to "+a,e);h.scrollTop=a;h._scrollTop=h.scrollTop}else{p("VerticalScrollingHelper.scrollScrollbar: Not scrolled - No scrollbar available",e)}let m=false;if(b){m=Math.round(h.scrollTop)===h.scrollHeight-h.offsetHeight}else{m=h.scrollTop===0}if(m&&!h._unblockScrolling){if(!h._timeoutBlock){h._timeoutBlock=setTimeout(function(){h._unblockScrolling=true;h._timeoutBlock=null},d)}}else{h._unblockScrolling=false}return Promise.resolve()},getScrollRange:function(e){const t=e._getScrollExtension();const o=t.getVerticalScrollHeight()-t.getVerticalScrollbarHeight();return Math.max(0,o)},getScrollRangeBuffer:function(e){if(!t.isVariableRowHeightEnabled(e)){return 0}return f*e._getBaseRowHeight()},getScrollPositionOfScrollbar:function(e){const t=e._getScrollExtension();if(t.isVerticalScrollbarVisible()){return t.getVerticalScrollbar().scrollTop}else{return 0}},getScrollPositionOfViewport:function(e){const t=e?e.getDomRef("tableCCnt"):null;return t?t.scrollTop:0},getScrollRangeRowFraction:function(e){const o=e._getScrollExtension();const l=e._getTotalRowCount()-e._getRowCounts()._fullsize;let r;if(t.isVariableRowHeightEnabled(e)){r=T.getScrollRange(e)-T.getScrollRangeBuffer(e);const t=o.getVerticalScrollHeight()===a;if(!t){r+=e._getBaseRowHeight()}}else{r=T.getScrollRange(e)}return r/Math.max(1,l)},isScrollPositionOfScrollbarInBuffer:function(e){if(!t.isVariableRowHeightEnabled(e)){return false}const o=T.getScrollRange(e);const l=T.getScrollPositionOfScrollbar(e);const r=T.getScrollRangeBuffer(e);return o-l<=r},isIndexInBuffer:function(e,o){if(!t.isVariableRowHeightEnabled(e)){return false}return o>=e._getMaxFirstRenderedRowIndex()},getScrollRangeOfViewport:function(e){if(!e||!e._aRowHeights){return 0}let t=e._aRowHeights;const o=e._getBaseRowHeight()*e._getRowCounts()._fullsize;if(e._getRowCounts()._fullsize>=e._getTotalRowCount()){t=t.slice(0,e._getTotalRowCount())}let l=t.reduce(function(e,t){return e+t},0)-o;if(l>0){l=Math.ceil(l)}return Math.max(0,l)},addOnRowsUpdatedPreprocessor:function(e,t){c(e).aOnRowsUpdatedPreprocessors.push(t)},removeOnRowsUpdatedPreprocessor:function(e,t){if(!t){c(e).aOnRowsUpdatedPreprocessors=[];return false}const o=c(e).aOnRowsUpdatedPreprocessors.indexOf(t);if(o>-1){c(e).aOnRowsUpdatedPreprocessors.splice(o,1);return true}return false},onRowsUpdated:function(e){p("VerticalScrollingHelper.onRowsUpdated: Reason "+e.getParameters().reason,this);T.updateScrollbarVisibility(this);if(c(this).aOnRowsUpdatedPreprocessors.length>0){p("VerticalScrollingHelper.onRowsUpdated (preprocessors)",this);const t=c(this).aOnRowsUpdatedPreprocessors.reduce(function(t,o){const l=o.call(this,e);return!(t&&!l)},true);T.removeOnRowsUpdatedPreprocessor(this);if(!t){p("VerticalScrollingHelper.onRowsUpdated (preprocessors): Default prevented",this);return}}if(!t.isVariableRowHeightEnabled(this)){p("VerticalScrollingHelper.onRowsUpdated: Aborted - Variable row heights not enabled",this);return}const o=this;h.start(this,h.OnRowsUpdated,function(e,l,r){t.Hook.call(o,s.Signal,"StartTableUpdate");r.onPromiseCreated=function(e){e.finally(function(){t.Hook.call(o,s.Signal,"EndTableUpdate")})};T.fixScrollPosition(o,r).then(function(){return Promise.all([T.adjustFirstVisibleRowToScrollPosition(o,true,r),T.scrollViewport(o,r),T.scrollScrollbar(o,r)])}).then(e)})},restoreScrollPosition:function(e,o){p("VerticalScrollingHelper.restoreScrollPosition",e);h.start(e,h.RestoreScrollPosition,function(l,r,i){t.Hook.call(e,s.Signal,"StartTableUpdate");i.onPromiseCreated=function(o){o.then(function(){if(!i.isCancelled()){T._restoreScrollPosition(e)}}).finally(function(){t.Hook.call(e,s.Signal,"EndTableUpdate")})};if(o!==true){l();return}const n=function(){p("VerticalScrollingHelper.restoreScrollPosition (async: rows updated)",e);l();return false};T.addOnRowsUpdatedPreprocessor(e,n);i.addCancelListener(function(){const t=T.removeOnRowsUpdatedPreprocessor(e,n);if(t){l()}})})},_restoreScrollPosition:function(e){const t=c(e).oVerticalScrollPosition;const o=t.isInitial();p("VerticalScrollingHelper.restoreScrollPosition: "+"Scroll position is"+(o?" ":" not ")+"initial",e);if(o){T.performUpdateFromFirstVisibleRow(e)}else{T.performUpdateFromScrollPosition(e)}},onTotalRowCountChanged:function(){T.adjustToTotalRowCount(this)},adjustToTotalRowCount:function(e){const o=e._getScrollExtension();p("VerticalScrollingHelper.adjustToTotalRowCount",e);T.updateScrollbarVisibility(e);b.updateScrollbar(e);o.updateVerticalScrollHeight();h.start(e,h.AdjustToTotalRowCount,function(o,l,r){t.Hook.call(e,s.Signal,"StartTableUpdate");r.onPromiseCreated=function(o){o.then(function(){if(r.isCancelled()||c(e).oVerticalScrollPosition.isInitial()){return}T.performUpdateFromScrollPosition(e)}).finally(function(){t.Hook.call(e,s.Signal,"EndTableUpdate")})};if(c(e).oVerticalScrollPosition.isInitial()){o()}else{const t=function(){p("VerticalScrollingHelper.adjustToTotalRowCount (async: rows updated)",e);o();return false};T.addOnRowsUpdatedPreprocessor(e,t);r.addCancelListener(function(){const l=T.removeOnRowsUpdatedPreprocessor(e,t);if(l){o()}})}})},onUpdateTableSizes:function(e){T.updateScrollbarVisibility(this);b.updateScrollbar(this)},updateScrollbarVisibility:function(e){const t=e._getScrollExtension();const o=t.getVerticalScrollbar();const l=e?e.getDomRef():null;if(!o||!l){return}const r=t.isVerticalScrollbarRequired();l.classList.toggle("sapUiTableVScr",r&&!t.isVerticalScrollbarExternal());o.parentElement.classList.toggle("sapUiTableHidden",!r)},addEventListeners:function(e){const t=e._getScrollExtension();const o=T.getScrollAreas(e);const l=e.getDomRef("tableCCnt");if(!t._onVerticalScrollEventHandler){t._onVerticalScrollEventHandler=T.onScrollbarScroll.bind(e)}for(let e=0;e<o.length;e++){o[e].addEventListener("scroll",t._onVerticalScrollEventHandler)}if(l){if(!t._onViewportScrollEventHandler){t._onViewportScrollEventHandler=T.onViewportScroll.bind(e)}l.addEventListener("scroll",t._onViewportScrollEventHandler)}e.attachEvent("_rowsUpdated",T.onRowsUpdated)},removeEventListeners:function(e){const t=e._getScrollExtension();const o=T.getScrollAreas(e);const l=e.getDomRef("tableCCnt");if(t._onVerticalScrollEventHandler){for(let e=0;e<o.length;e++){o[e].removeEventListener("scroll",t._onVerticalScrollEventHandler)}delete t._onVerticalScrollEventHandler}if(l&&t._onViewportScrollEventHandler){l.removeEventListener("scroll",t._onViewportScrollEventHandler);delete t._onViewportScrollEventHandler}e.detachEvent("_rowsUpdated",T.onRowsUpdated)},getScrollAreas:function(e){const t=[e._getScrollExtension().getVerticalScrollbar()];return t.filter(function(e){return e!=null})}};const m={onMouseWheelScrolling:function(e,o){const l=this._getScrollExtension();const r=Math.abs(o.deltaY)>Math.abs(o.deltaX);let i=r?o.deltaY:o.deltaX;const n=r&&o.shiftKey||!r;const s=i>0;let a=false;if(i===0){return}if(n&&(e.scrollDirection===u.HORIZONAL||e.scrollDirection===u.BOTH)){const e=l.getHorizontalScrollbar();if(o.deltaMode!==window.WheelEvent.DOM_DELTA_PIXEL){const e=t.Column.getMinColumnWidth();i=s?e:-e}if(s){a=e.scrollLeft===e.scrollWidth-e.offsetWidth}else{a=e.scrollLeft===0}if(l.isHorizontalScrollbarVisible()&&!a){o.preventDefault();o.stopPropagation();this._getKeyboardExtension().setActionMode(false);e.scrollLeft=e.scrollLeft+i}}else if(!n&&(e.scrollDirection===u.VERTICAL||e.scrollDirection===u.BOTH)){if(o.target instanceof window.HTMLTextAreaElement){const e=o.target;if(e.clientHeight<e.scrollHeight){return}}const e=l.getVerticalScrollbar();const t=c(this).oVerticalScrollPosition;if(s){a=Math.round(e.scrollTop)===e.scrollHeight-e.offsetHeight}else{a=e.scrollTop===0}if(!l.isVerticalScrollbarVisible()||a&&e._unblockScrolling){return}o.preventDefault();o.stopPropagation();if(o.deltaMode===window.WheelEvent.DOM_DELTA_PIXEL){const e=i/this._getDefaultRowHeight();if(e>=0){t.scrollRows(Math.max(1,Math.floor(e)))}else{t.scrollRows(Math.min(-1,Math.ceil(e)))}}else if(o.deltaMode===window.WheelEvent.DOM_DELTA_LINE){t.scrollRows(i)}else if(o.deltaMode===window.WheelEvent.DOM_DELTA_PAGE){t.scrollRows(i*this._getRowCounts()._scrollSize)}this._getKeyboardExtension().setActionMode(false);T.performUpdateFromScrollPosition(this)}},onTouchStart:function(e,t){if(t.type==="touchstart"||t.pointerType==="touch"){const e=this._getScrollExtension();const o=e.getHorizontalScrollbar();const l=e.getVerticalScrollbar();const r=t.touches?t.touches[0]:t;c(this).mTouchSessionData={initialPageX:r.pageX,initialPageY:r.pageY,initialScrollTop:l?l.scrollTop:0,initialScrollLeft:o?o.scrollLeft:0,initialScrolledToEnd:null,touchMoveDirection:null}}},onTouchMoveScrolling:function(e,t){if(t.type!=="touchmove"&&t.pointerType!=="touch"){return}const o=this._getScrollExtension();const l=c(this).mTouchSessionData;if(!l){return}const r=t.touches?t.touches[0]:t;const i=r.pageX-l.initialPageX;const n=r.pageY-l.initialPageY;let s=false;if(!l.touchMoveDirection){if(i===0&&n===0){return}l.touchMoveDirection=Math.abs(i)>Math.abs(n)?"horizontal":"vertical"}switch(l.touchMoveDirection){case"horizontal":{const t=o.getHorizontalScrollbar();if(t&&(e.scrollDirection===u.HORIZONAL||e.scrollDirection===u.BOTH)){this._getKeyboardExtension().setActionMode(false);if(l.initialScrolledToEnd==null){if(i<0){l.initialScrolledToEnd=t.scrollLeft===t.scrollWidth-t.offsetWidth}else{l.initialScrolledToEnd=t.scrollLeft===0}}if(!l.initialScrolledToEnd){t.scrollLeft=l.initialScrollLeft-i;s=true}}break}case"vertical":{const t=o.getVerticalScrollbar();if(t&&(e.scrollDirection===u.VERTICAL||e.scrollDirection===u.BOTH)){this._getKeyboardExtension().setActionMode(false);if(l.initialScrolledToEnd==null){if(n<0){l.initialScrolledToEnd=t.scrollTop===t.scrollHeight-t.offsetHeight}else{l.initialScrolledToEnd=t.scrollTop===0}}if(!l.initialScrolledToEnd){t.scrollTop=l.initialScrollTop-n;s=true}}break}default:}if(s){t.preventDefault()}},addEventListeners:function(e){const t=e._getScrollExtension();const o=m.getEventListenerTargets(e);t._mMouseWheelEventListener=this.addMouseWheelEventListener(o,e,{scrollDirection:u.BOTH});t._mTouchEventListener=this.addTouchEventListener(o,e,{scrollDirection:u.BOTH})},addMouseWheelEventListener:function(e,t,o){const l=m.onMouseWheelScrolling.bind(t,o);for(let t=0;t<e.length;t++){e[t].addEventListener("wheel",l)}return{wheel:l}},addTouchEventListener:function(e,t,o){const r=m.onTouchStart.bind(t,o);const i=m.onTouchMoveScrolling.bind(t,o);let n={};for(let t=0;t<e.length;t++){if(l.support.pointer&&l.system.desktop){e[t].addEventListener("pointerdown",r);e[t].addEventListener("pointermove",i,l.browser.chrome?{passive:true}:false)}else if(l.support.touch){e[t].addEventListener("touchstart",r);e[t].addEventListener("touchmove",i)}}if(l.support.pointer&&l.system.desktop){n={pointerdown:r,pointermove:i}}else if(l.support.touch){n={touchstart:r,touchmove:i}}return n},removeEventListeners:function(e){const t=e._getScrollExtension();const o=m.getEventListenerTargets(e);function l(e,t){for(const o in t){const l=t[o];if(l){e.removeEventListener(o,l)}}}for(let e=0;e<o.length;e++){l(o[e],t._mMouseWheelEventListener);l(o[e],t._mTouchEventListener)}delete t._mMouseWheelEventListener;delete t._mTouchEventListener},getEventListenerTargets:function(e){const t=[e.getDomRef("tableCCnt")];return t.filter(function(e){return e!=null})}};const w={onBeforeRendering:function(e){this._getScrollExtension()._clearCache()},onAfterRendering:function(e){const t=this._getScrollExtension();const o=e!=null&&e.isMarked("renderRows");if(o){t.updateVerticalScrollbarHeight();t.updateVerticalScrollHeight()}T.restoreScrollPosition(this,this.getBinding()!=null);b.restoreScrollPosition(this)},onfocusin:function(e){let o;const r=t.getCellInfo(e.target);const i=this._getScrollExtension().getHorizontalScrollbar();if(r.isOfType(t.CELLTYPE.DATACELL)){o=this.getDomRef("sapUiTableCtrlScr")}else if(r.isOfType(t.CELLTYPE.COLUMNHEADER)){o=this.getDomRef("sapUiTableColHdrScr")}if(o&&i&&r.columnIndex>=this.getComputedFixedColumnCount()){const e=jQuery(i);const t=r.cell;const l=this._bRtlMode?e.scrollLeftRTL():i.scrollLeft;const n=o.clientWidth;const s=t.offsetLeft;const c=s+t.offsetWidth;const a=s-l;const f=c-n-l;let d;if(a<0&&f<0){d=l+a}else if(f>0&&a>0){d=l+f}if(d!=null){if(this._bRtlMode){e.scrollLeftRTL(d)}else{i.scrollLeft=d}}}const n=t.getParentCell(this,e.target);if(n){const e=this;const o=function(){const o=n.find(".sapUiTableCellInner");if(o.length>0){if(e._bRtlMode){o.scrollLeftRTL(o[0].scrollWidth-o[0].clientWidth)}else{o[0].scrollLeft=0}o[0].scrollTop=0}t.Hook.call(e,s.Signal,"EndFocusHandling");t.Hook.call(e,s.Signal,"EndTableUpdate")};t.Hook.call(this,s.Signal,"StartTableUpdate");t.Hook.call(this,s.Signal,"StartFocusHandling");Promise.resolve().then(function(){if(l.browser.safari){window.setTimeout(o,0)}else{o()}})}}};const V=e.extend("sap.ui.table.extensions.Scrolling",{_init:function(e,o,l){const r=c(e);r.oHorizontalScrollbar=null;r.iHorizontalScrollPosition=null;r.oVerticalScrollbar=null;r.oVerticalScrollPosition=new S(e);r.pVerticalScrollUpdateProcess=null;r.oExternalVerticalScrollbar=null;r.bIsVerticalScrollbarExternal=false;r.mTimeouts={};r.mAnimationFrames={};r.mTouchSessionData=null;r.aOnRowsUpdatedPreprocessors=[];t.addDelegate(e,w,e);return"ScrollExtension"},_attachEvents:function(){const e=this.getTable();b.addEventListeners(e);T.addEventListeners(e);m.addEventListeners(e);t.Hook.register(e,t.Hook.Keys.Table.TotalRowCountChanged,T.onTotalRowCountChanged,e);t.Hook.register(e,t.Hook.Keys.Table.UpdateSizes,T.onUpdateTableSizes,e)},_detachEvents:function(){const e=this.getTable();b.removeEventListeners(e);T.removeEventListeners(e);m.removeEventListeners(e);t.Hook.deregister(e,t.Hook.Keys.Table.TotalRowCountChanged,T.onTotalRowCountChanged,e);t.Hook.deregister(e,t.Hook.Keys.Table.UpdateSizes,T.onUpdateTableSizes,e)},destroy:function(){const o=this.getTable();this._clearCache();if(o){t.removeDelegate(o,w);if(c(o).pVerticalScrollUpdateProcess){c(o).pVerticalScrollUpdateProcess.cancel();c(o).pVerticalScrollUpdateProcess=null}}e.prototype.destroy.apply(this,arguments)}});V.prototype.scrollVertically=function(e,t){const o=this.getTable();if(!o){return}const l=o._getRowCounts();const r=o._getFirstRenderedRowIndex();const i=t===true?l.scrollable:1;if(e===true){c(o).oVerticalScrollPosition.setPosition(r+i,1,S.OffsetType.PercentageOfViewport)}else{c(o).oVerticalScrollPosition.setPosition(Math.max(0,r-i))}T.performUpdateFromScrollPosition(o)};V.prototype.scrollVerticallyMax=function(e){const t=this.getTable();if(!t){return}if(e===true){c(t).oVerticalScrollPosition.setPosition(t._getMaxFirstRenderedRowIndex(),1,S.OffsetType.PercentageOfViewport)}else{c(t).oVerticalScrollPosition.setPosition(0)}T.performUpdateFromScrollPosition(t)};V.prototype.getHorizontalScrollbar=function(){const e=this.getTable();if(!e){return null}if(!e._bInvalid&&!c(e).oHorizontalScrollbar){c(e).oHorizontalScrollbar=e.getDomRef(n.HorizontalScrollBar)}return c(e).oHorizontalScrollbar};V.prototype.getVerticalScrollbar=function(){const e=this.getTable();const t=this.isVerticalScrollbarExternal();if(!e){return null}if(!e._bInvalid&&!c(e).oVerticalScrollbar){c(e).oVerticalScrollbar=e.getDomRef(n.VerticalScrollBar);if(!c(e).oVerticalScrollbar&&t){c(e).oVerticalScrollbar=c(e).oExternalVerticalScrollbar}}const o=c(e).oVerticalScrollbar;if(o&&!t&&!o.isConnected){return null}return o};V.prototype.isHorizontalScrollbarVisible=function(){const e=this.getHorizontalScrollbar();return e!=null&&!e.classList.contains("sapUiTableHidden")};V.prototype.isVerticalScrollbarVisible=function(){const e=this.getVerticalScrollbar();return e!=null&&!e.parentElement.classList.contains("sapUiTableHidden")};V.prototype.isVerticalScrollbarExternal=function(){const e=this.getTable();return e?c(e).bIsVerticalScrollbarExternal:false};V.prototype.markVerticalScrollbarAsExternal=function(e){const t=this.getTable();if(t&&e){c(t).bIsVerticalScrollbarExternal=true;c(t).oExternalVerticalScrollbar=e}};V.prototype.updateVerticalScrollbarHeight=function(){const e=this.getTable();const t=this.getVerticalScrollbar();if(!e||!t){return}t.style.maxHeight=this.getVerticalScrollbarHeight()+"px";t._scrollTop=t.scrollTop};V.prototype.getVerticalScrollbarHeight=function(){const e=this.getTable();if(!e){return 0}return e._getRowCounts()._scrollSize*e._getBaseRowHeight()};V.prototype.updateVerticalScrollPosition=function(e){const t=this.getTable();if(!t){return}e=e===true;if(e||t.getBinding()){T.performUpdateFromFirstVisibleRow(t,e)}else{T.adjustScrollPositionToFirstVisibleRow(t)}};V.prototype.restoreVerticalScrollPosition=function(){T.restoreScrollPosition(this.getTable())};V.prototype.updateVerticalScrollHeight=function(){const e=this.getVerticalScrollbar();const t=e?e.firstChild:null;if(!t){return}t.style.height=this.getVerticalScrollHeight()+"px";e._scrollTop=e.scrollTop};V.prototype.getVerticalScrollHeight=function(e){const o=this.getTable();if(!o){return 0}const l=o._getTotalRowCount();const r=o._getRowCounts();const i=Math.max(l,r.count);const n=o._getBaseRowHeight();let s;if(t.isVariableRowHeightEnabled(o)){s=n*(i-1)+T.getScrollRangeBuffer(o)}else{s=n*i}if(e===true){return s}else{return Math.min(a,s)}};V.prototype.isVerticalScrollbarRequired=function(){const e=this.getTable();if(!e){return false}return t.isVariableRowHeightEnabled(e)&&T.getScrollRangeOfViewport(e)>0||e._getTotalRowCount()>e._getRowCounts()._fullsize};V.prototype.registerForMouseWheel=function(t,o){const l=this.getTable();if(e.isEnrichedWith(l,"sap.ui.table.extensions.Synchronization")){return m.addMouseWheelEventListener(t,l,o)}else{i.error("This method can only be used with synchronization enabled.",l,"sap.ui.table.extensions.Scrolling#registerForMouseWheel");return null}};V.prototype.registerForTouch=function(t,o){const l=this.getTable();if(e.isEnrichedWith(l,"sap.ui.table.extensions.Synchronization")){return m.addTouchEventListener(t,l,o)}else{i.error("This method can only be used with synchronization enabled.",l,"sap.ui.table.extensions.Scrolling#registerForTouch");return null}};V.prototype._clearCache=function(){const e=this.getTable();if(!e){return}c(e).oVerticalScrollbar=null;c(e).oHorizontalScrollbar=null};V.ScrollDirection=u;return V});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/extensions/ScrollingIOS", ["./ExtensionBase","../utils/TableUtils"],function(t,e){"use strict";const o={onAfterRendering:function(){this.attachScrollbar()}};const l=t.extend("sap.ui.table.extensions.ScrollingIOS",{_init:function(t){e.addDelegate(t,o,this);this.attachScrollbar();return"ScrollIOSExtension"},destroy:function(){const l=this.getTable();e.removeDelegate(l,o);clearTimeout(this._iUpdateDefaultScrollbarPositionTimeoutId);t.prototype.destroy.apply(this,arguments)},_attachEvents:function(){const t=this.getTable();e.Hook.register(t,e.Hook.Keys.Table.TotalRowCountChanged,this.onTotalRowCountChanged,this);e.Hook.register(t,e.Hook.Keys.Table.UpdateSizes,this.onUpdateTableSizes,this)},_detachEvents:function(){const t=this.getTable();const o=t._getScrollExtension().getVerticalScrollbar();if(o){o.removeEventListener("scroll",this._onVerticalScrollEventHandler)}delete this._onVerticalScrollEventHandler;const l=this.getVerticalScrollbar();if(l){l.removeEventListener("pointerdown",this._onPointerDownEventHandler)}delete this._onPointerDownEventHandler;const i=this.getVerticalScrollbarThumb();if(i){i.removeEventListener("touchmove",this._onTouchMoveEventHandler)}delete this._onTouchMoveEventHandler;e.Hook.deregister(t,e.Hook.Keys.Table.TotalRowCountChanged,this.onTotalRowCountChanged,this);e.Hook.deregister(t,e.Hook.Keys.Table.UpdateSizes,this.onUpdateTableSizes,this)}});l.prototype.onUpdateTableSizes=function(){this.updateVerticalScrollbarThumbHeight();this.updateVerticalScrollbarThumbPosition()};l.prototype.onTotalRowCountChanged=function(){this.updateVerticalScrollbarThumbHeight()};l.prototype.attachScrollbar=function(){const t=this.getTable();const e=t._getScrollExtension().getVerticalScrollbar();let o=this.getVerticalScrollbar();let l=this.getVerticalScrollbarThumb();if(!e||!e.isConnected){return}if(!o){o=document.createElement("div");o.setAttribute("id",t.getId()+"-vsb-ios");o.classList.add("sapUiTableVSbIOS");l=document.createElement("div");l.classList.add("sapUiTableVSbIOSThumb");o.append(l);e.after(o)}if(!this._onPointerDownEventHandler){this._onPointerDownEventHandler=this.onPointerDown.bind(this);o.addEventListener("pointerdown",this._onPointerDownEventHandler);this._onTouchMoveEventHandler=this.onTouchMove.bind(this);l.addEventListener("touchmove",this._onTouchMoveEventHandler);this._onVerticalScrollEventHandler=this.updateVerticalScrollbarThumbPosition.bind(this);e.addEventListener("scroll",this._onVerticalScrollEventHandler)}this.updateVerticalScrollbar()};l.prototype.getVerticalScrollbar=function(){const t=this.getTable();return t?t.getDomRef("vsb-ios"):null};l.prototype.getVerticalScrollbarThumb=function(){const t=this.getVerticalScrollbar();return t?t.firstElementChild:null};l.prototype.updateVerticalScrollbar=function(){const t=this.getTable();const e=this.getVerticalScrollbar();e.style.height=t._getScrollExtension().getVerticalScrollbarHeight()+"px";e.style.top=Math.max(0,t._getRowCounts().fixedTop*t._getBaseRowHeight()-1)+"px";this.updateVerticalScrollbarThumbPosition();this.updateVerticalScrollbarThumbHeight()};l.prototype.updateVerticalScrollbarThumbPosition=function(){const t=this.getVerticalScrollbarThumb();if(t){t.style.top=this.getCalculateThumbOffset()+"px"}};l.prototype.updateVerticalScrollbarThumbHeight=function(){const t=this.getTable();const e=t._getScrollExtension();const o=this.getVerticalScrollbarThumb();if(o){if(e.isVerticalScrollbarRequired()){o.style.height=this.getCalculateThumbHeight()+"px"}else{o.style.height="0"}}};l.prototype.getCalculateThumbHeight=function(){const t=this.getTable();const e=t._getScrollExtension();const o=e.getVerticalScrollbarHeight();const l=e.getVerticalScrollHeight();return Math.round(Math.pow(o,2)/l)};l.prototype.getCalculateThumbOffset=function(){const t=this.getTable();const e=t._getScrollExtension();const o=e.getVerticalScrollbarHeight();const l=e.getVerticalScrollHeight();const i=e.getVerticalScrollbar();const n=i?e.getVerticalScrollbar().scrollTop:0;return Math.round(n*o/l)};l.prototype.onTouchMove=function(t){const e=this.getTable();const o=e._getScrollExtension();const l=this.getVerticalScrollbarThumb();const i=l.getBoundingClientRect().y;const n=this.getCalculateThumbHeight();const r=l.offsetTop+t.touches[0].pageY-i-n/2;const a=Math.min(o.getVerticalScrollbarHeight()-n,Math.max(0,r));t.preventDefault();t.stopPropagation();l.style.top=a+"px";clearTimeout(this._iUpdateDefaultScrollbarPositionTimeoutId);this._iUpdateDefaultScrollbarPositionTimeoutId=setTimeout(function(){this.updateDefaultScrollbarPosition(a,n);delete this._iUpdateDefaultScrollbarPositionTimeoutId}.bind(this),30)};l.prototype.onPointerDown=function(t){const e=this.getTable();const o=e._getScrollExtension();const l=this.getVerticalScrollbarThumb();const i=l.getBoundingClientRect().y;const n=this.getCalculateThumbHeight();const r=l.offsetTop+t.clientY-i-n/2;const a=Math.min(o.getVerticalScrollbarHeight()-n,Math.max(0,r));t.preventDefault();t.stopPropagation();l.style.top=a+"px";this.updateDefaultScrollbarPosition(a,n)};l.prototype.updateDefaultScrollbarPosition=function(t,e){const o=this.getTable();if(!o){return}const l=o._getScrollExtension();const i=l.getVerticalScrollbarHeight();if(t+e>=i){l.scrollVerticallyMax(true)}else{const e=t*l.getVerticalScrollHeight()/i;const o=l.getVerticalScrollbar();o.scrollTop=e}};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/extensions/Synchronization", ["./ExtensionBase","../utils/TableUtils","../library","sap/base/Log","sap/ui/core/RenderManager"],function(e,t,n,o,r){"use strict";const l={setRowSelection:function(e,n){const o=this.getTable();const r=o.getRows()[e];if(r&&n!=null){t.toggleRowSelection(o,r,n)}},setRowHover:function(e,t){const n=this.getTable();const o=n.getRows()[e];if(o&&t!=null){o._setHovered(t)}},addVerticalScrollingListener:function(e){const t=this.getTable();const n=t._getSyncExtension();const o=t._getScrollExtension();const r={scrollDirection:o.constructor.ScrollDirection.VERTICAL};l.removeVerticalScrollingListener.call(this);if(!e){return}if(e.wheelAreas){n._mMouseWheelEventListener=o.registerForMouseWheel(e.wheelAreas,r);n._mMouseWheelEventListener.areas=e.wheelAreas}if(e.touchAreas){n._mTouchEventListener=o.registerForTouch(e.touchAreas,r);n._mTouchEventListener.areas=e.touchAreas}},removeVerticalScrollingListener:function(){const e=this.getTable();const t=e._getSyncExtension();function n(e,t){for(const n in t){const o=t[n];if(o){for(let t=0;t<e.length;t++){e[t].removeEventListener(n,o)}}}}if(t._mMouseWheelEventListener){n(t._mMouseWheelEventListener.areas,t._mMouseWheelEventListener);delete t._mMouseWheelEventListener}if(t._mTouchEventListener){n(t._mTouchEventListener.areas,t._mTouchEventListener);delete t._mTouchEventListener}},placeVerticalScrollbarAt:function(e){const t=this.getTable();const o=t._getScrollExtension();if(!e){throw new Error("The HTMLElement in which the vertical scrollbar should be placed must be specified.")}if(!o.isVerticalScrollbarExternal()){const l=(new r).getInterface();t.getRenderer().renderVSbExternal(l,t);l.flush(e);const i=t.getId()+"-"+n.SharedDomRef.VerticalScrollBar;const c=e.querySelector('[id="'+i+'"]');o.markVerticalScrollbarAsExternal(c);t.invalidate()}else{e.appendChild(o.getVerticalScrollbar().parentElement);o.restoreVerticalScrollPosition()}},renderHorizontalScrollbar:function(e,t,n){const o=this.getTable();if(t==null){throw new Error("The id must be specified.")}o.getRenderer().renderHSbExternal(e,o,t,n)}};const i={onBeforeRendering:function(e){const t=this._getSyncExtension();const n=e&&e.isMarked("renderRows");const o=this.getDomRef("tableCCnt");if(!n&&o&&t._onTableContainerScrollEventHandler){o.removeEventListener("scroll",t._onTableContainerScrollEventHandler);delete t._onTableContainerScrollEventHandler}},onAfterRendering:function(e){const t=this._getScrollExtension();const n=e&&e.isMarked("renderRows");const o=this.getDomRef("tableCCnt");if(t.isVerticalScrollbarExternal()&&!n){t.updateVerticalScrollbarHeight();t.updateVerticalScrollHeight()}if(!n){const e=this._getSyncExtension();e.syncInnerVerticalScrollPosition(o.scrollTop);if(!e._onTableContainerScrollEventHandler){e._onTableContainerScrollEventHandler=function(t){e.syncInnerVerticalScrollPosition(t.target.scrollTop)}}o.addEventListener("scroll",e._onTableContainerScrollEventHandler)}}};const c=e.extend("sap.ui.table.extensions.Synchronization",{_init:function(e,n,o){this._delegate=i;this._oPublicInterface={syncRowSelection:l.setRowSelection.bind(this),syncRowHover:l.setRowHover.bind(this),registerVerticalScrolling:l.addVerticalScrollingListener.bind(this),deregisterVerticalScrolling:l.removeVerticalScrollingListener.bind(this),placeVerticalScrollbarAt:l.placeVerticalScrollbarAt.bind(this),renderHorizontalScrollbar:l.renderHorizontalScrollbar.bind(this)};t.addDelegate(e,this._delegate,e);return"SyncExtension"},destroy:function(){const t=this.getTable();if(t){t.removeEventDelegate(this._delegate)}l.removeVerticalScrollingListener.call(this);this._delegate=null;this._oPublicInterface=null;e.prototype.destroy.apply(this,arguments)}});c.prototype.syncRowCount=function(e){this.callInterfaceHook("rowCount",arguments)};c.prototype.syncRowSelection=function(e,t){this.callInterfaceHook("rowSelection",arguments)};c.prototype.syncRowHover=function(e,t){this.callInterfaceHook("rowHover",arguments)};c.prototype.syncRowHeights=function(e){return this.callInterfaceHook("rowHeights",arguments)};c.prototype.syncInnerVerticalScrollPosition=function(e){this.callInterfaceHook("innerVerticalScrollPosition",arguments)};c.prototype.syncLayout=function(e){this.callInterfaceHook("layout",arguments)};c.prototype.callInterfaceHook=function(e,n){const r={};r[e]=Array.prototype.slice.call(n);o.debug("sap.ui.table.extensions.Synchronization","Sync "+e+"("+r[e]+")",this.getTable());return t.dynamicCall(this._oPublicInterface,r)};c.prototype.getInterface=function(){return this._oPublicInterface};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/library", ["sap/ui/core/Lib","sap/ui/base/DataType","sap/ui/model/TreeAutoExpandMode","sap/ui/core/library","sap/ui/unified/library"],function(e,i,o){"use strict";const a=e.init({name:"sap.ui.table",apiVersion:2,version:"1.135.0",dependencies:["sap.ui.core","sap.ui.unified"],designtime:"sap/ui/table/designtime/library.designtime",types:["sap.ui.table.NavigationMode","sap.ui.table.RowActionType","sap.ui.table.SelectionBehavior","sap.ui.table.SelectionMode","sap.ui.table.SortOrder","sap.ui.table.VisibleRowCountMode","sap.ui.table.TreeAutoExpandMode"],interfaces:[],controls:["sap.ui.table.AnalyticalColumnMenu","sap.ui.table.AnalyticalTable","sap.ui.table.ColumnMenu","sap.ui.table.CreationRow","sap.ui.table.Table","sap.ui.table.TreeTable","sap.ui.table.RowAction"],elements:["sap.ui.table.AnalyticalColumn","sap.ui.table.Column","sap.ui.table.Row","sap.ui.table.RowActionItem","sap.ui.table.RowSettings","sap.ui.table.rowmodes.RowMode","sap.ui.table.rowmodes.Fixed","sap.ui.table.rowmodes.Interactive","sap.ui.table.rowmodes.Auto","sap.ui.table.plugins.SelectionPlugin","sap.ui.table.plugins.MultiSelectionPlugin","sap.ui.table.plugins.ODataV4Selection"],extensions:{flChangeHandlers:{},"sap.ui.support":{publicRules:true}}});a.NavigationMode={Scrollbar:"Scrollbar",Paginator:"Paginator"};i.registerEnum("sap.ui.table.NavigationMode",a.NavigationMode);a.RowActionType={Custom:"Custom",Navigation:"Navigation",Delete:"Delete"};i.registerEnum("sap.ui.table.RowActionType",a.RowActionType);a.SelectionBehavior={Row:"Row",RowSelector:"RowSelector",RowOnly:"RowOnly"};i.registerEnum("sap.ui.table.SelectionBehavior",a.SelectionBehavior);a.SelectionMode={MultiToggle:"MultiToggle",Multi:"Multi",Single:"Single",None:"None"};i.registerEnum("sap.ui.table.SelectionMode",a.SelectionMode);a.SortOrder={Ascending:"Ascending",Descending:"Descending"};i.registerEnum("sap.ui.table.SortOrder",a.SortOrder);a.VisibleRowCountMode={Fixed:"Fixed",Interactive:"Interactive",Auto:"Auto"};i.registerEnum("sap.ui.table.VisibleRowCountMode",a.VisibleRowCountMode);a.SharedDomRef={HorizontalScrollBar:"hsb",VerticalScrollBar:"vsb"};a.GroupEventType={group:"group",ungroup:"ungroup",ungroupAll:"ungroupAll",moveUp:"moveUp",moveDown:"moveDown",showGroupedColumn:"showGroupedColumn",hideGroupedColumn:"hideGroupedColumn"};a.ResetAllMode={Default:"Default",ServiceDefault:"ServiceDefault",ServiceReset:"ServiceReset"};i.registerEnum("sap.ui.table.ResetAllMode",a.ResetAllMode);a.ColumnHeader=a.Column;a.TreeAutoExpandMode=o;if(!a.plugins){a.plugins={}}if(!a.TableHelper){a.TableHelper={addTableClass:function(){return""},createLabel:function(e){throw new Error("no Label control available!")},createTextView:function(e){throw new Error("no TextView control available!")},bFinal:false}}return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/menus/AnalyticalTableContextMenu", ["./ContextMenu","../library","../utils/TableUtils","sap/ui/core/library","sap/ui/unified/Menu","sap/ui/unified/MenuItem"],function(e,t,o,s,n,i){"use strict";const u=s.SortOrder;const r=t.GroupEventType;const l=["ungroup","collapse","expand"];const p=e.extend("sap.ui.table.menus.AnalyticalTableContextMenu",{metadata:{library:"sap.ui.table"}});p.prototype.init=function(){n.prototype.init.apply(this,arguments);this._mItems=new Map};p.prototype.initContent=function(t,s){e.prototype.initContent.apply(this,arguments);const n=this.getMenu();const i=this.getTable();const u=!!i.getProperty("extendedGroupHeaderMenu");if(!t.isGroupHeader()){this._mItems.values().forEach(e=>e.setVisible(false));return}this._iGroupLevel=t.getLevel();if(this._mItems.size===0){this._createItems(i)}for(const[e,t]of this._mItems.entries()){t.setVisible(l.includes(e)?true:u);if(!n.getItems().includes(t)){n.addItem(t)}}if(!u){return}const r=c(i,this._iGroupLevel);const[p,a]=this._mItems.get("move").getSubmenu().getItems();const m=this._mItems.get("visibility");if(r){if(r.getShowIfGrouped()){m.setText(o.getResourceText("TBL_HIDE_COLUMN"))}else{m.setText(o.getResourceText("TBL_SHOW_COLUMN"))}p.setEnabled(this._iGroupLevel>1);a.setEnabled(this._iGroupLevel<i._aGroupedColumns.length)}else{p.setEnabled(true);a.setEnabled(true)}};p.prototype._createItems=function(e){this._mItems.set("ungroup",this._createUngroupItem(e));this._mItems.set("collapse",this._createCollapseItem(e));this._mItems.set("expand",this._createExpandItem(e));this._mItems.set("visibility",this._createVisibilityItem(e));this._mItems.set("move",this._createMoveItem(e));this._mItems.set("sort",this._createSortItem(e))};p.prototype._createUngroupItem=function(e){return new i({text:o.getResourceText("TBL_UNGROUP"),submenu:new n({items:[new i({text:o.getResourceText("TBL_UNGROUP_LEVEL"),select:()=>{const t=c(e,this._iGroupLevel);t.setGrouped(false);e.fireGroup({column:t,groupedColumns:e._aGroupedColumns,type:r.ungroup})}}),new i({text:o.getResourceText("TBL_UNGROUP_ALL"),select:()=>{e.suspendUpdateAnalyticalInfo();for(const t of e.getColumns()){t.setGrouped(false)}e.resumeUpdateAnalyticalInfo();e.fireGroup({column:undefined,groupedColumns:[],type:r.ungroupAll})}})]})})};p.prototype._createCollapseItem=function(e){return new i({text:o.getResourceText("TBL_COLLAPSE"),icon:"sap-icon://collapse-all",submenu:new n({items:[new i({text:o.getResourceText("TBL_COLLAPSE_LEVEL"),select:()=>{e.getBinding().collapseToLevel(this._iGroupLevel-1);e.setFirstVisibleRow(0);e._getSelectionPlugin().clearSelection()}}),new i({text:o.getResourceText("TBL_COLLAPSE_ALL"),select:()=>{e.getBinding().collapseToLevel(0);e.setFirstVisibleRow(0);e._getSelectionPlugin().clearSelection()}})]})})};p.prototype._createExpandItem=function(e){return new i({text:o.getResourceText("TBL_EXPAND"),icon:"sap-icon://expand-all",submenu:new n({items:[new i({text:o.getResourceText("TBL_EXPAND_LEVEL"),select:()=>{e.getBinding().expandToLevel(this._iGroupLevel);e.setFirstVisibleRow(0);e._getSelectionPlugin().clearSelection()}}),new i({text:o.getResourceText("TBL_EXPAND_ALL"),select:()=>{e.expandAll()}})]})})};p.prototype._createVisibilityItem=function(e){return new i({text:o.getResourceText("TBL_SHOW_COLUMN"),select:()=>{const t=c(e,this._iGroupLevel);const o=t.getShowIfGrouped();t.setShowIfGrouped(!o);e.fireGroup({column:t,groupedColumns:e._aGroupedColumns,type:!o?r.showGroupedColumn:r.hideGroupedColumn})}})};p.prototype._createMoveItem=function(e){return new i({text:o.getResourceText("TBL_MOVE"),submenu:new n({items:[new i({text:o.getResourceText("TBL_MOVE_UP"),icon:"sap-icon://arrow-top",select:()=>{const t=c(e,this._iGroupLevel);const o=this._iGroupLevel-1;if(o>0){e._aGroupedColumns[o]=e._aGroupedColumns.splice(o-1,1,e._aGroupedColumns[o])[0];e.updateAnalyticalInfo();e.fireGroup({column:t,groupedColumns:e._aGroupedColumns,type:r.moveUp})}}}),new i({text:o.getResourceText("TBL_MOVE_DOWN"),icon:"sap-icon://arrow-bottom",select:()=>{const t=c(e,this._iGroupLevel);const o=this._iGroupLevel-1;if(o<e._aGroupedColumns.length){e._aGroupedColumns[o]=e._aGroupedColumns.splice(o+1,1,e._aGroupedColumns[o])[0];e.updateAnalyticalInfo();e.fireGroup({column:t,groupedColumns:e._aGroupedColumns,type:r.moveDown})}}})]})})};p.prototype._createSortItem=function(e){return new i({text:o.getResourceText("TBL_SORT"),icon:"sap-icon://sort",submenu:new n({items:[new i({text:o.getResourceText("TBL_SORT_ASC"),icon:"sap-icon://sort-ascending",select:()=>{e.sort(c(e,this._iGroupLevel),u.Ascending)}}),new i({text:o.getResourceText("TBL_SORT_DESC"),icon:"sap-icon://sort-descending",select:()=>{e.sort(c(e,this._iGroupLevel),u.Descending)}})]})})};function c(e,t){return e.getColumns().find(o=>e._aGroupedColumns[t-1]===o.getId())}return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/menus/ColumnHeaderMenuAdapter", ["../utils/TableUtils","sap/ui/base/Object","sap/ui/base/EventProvider","sap/ui/base/ManagedObjectObserver"],function(e,t,n,o){"use strict";const i=new window.Map;const r={default:"LegacyColumnMenuAdapter","sap.m.table.columnmenu.Menu":"MobileColumnHeaderMenuAdapter","sap.ui.table.test.Menu":"test/TestAdapter"};const s=t.extend("sap.ui.table.menus.ColumnHeaderMenuAdapter",{constructor:function(){t.apply(this,arguments);this._mInjectionTarget=null;this._oColumnHeaderMenuObserver=new o(function(e){this.onAfterMenuDestroyed(e.object)}.bind(this))}});s.activateFor=function(t){const n=t.getHeaderMenuInstance();const o=a(n);let r;if(!o||!t._getTable()){return Promise.resolve()}i.forEach(function(e,n){if(n!==o){c(t,n)}});if(!i.has(o)){r={adapter:u(o).then(function(n){r=i.get(o);r.adapter=new n;r.adapter._injectMenuItems(r.activeFor.getHeaderMenuInstance(),r.activeFor);if(o==="LegacyColumnMenuAdapter"){e.Hook.register(t._getTable(),e.Hook.Keys.Table.InvalidateColumnMenus,r.adapter._invalidateAllMenus,r.adapter)}}),columns:[t],activeFor:t};i.set(o,r)}else{r=i.get(o);r.activeFor=t;if(!r.columns.includes(t)){r.columns.push(t)}}if(r.adapter instanceof Promise){return r.adapter}r.adapter._injectMenuItems(n,t);return Promise.resolve()};s.unlink=function(e){c(e)};s.prototype._injectMenuItems=function(e,t){this._removeMenuItems();this._oColumnHeaderMenuObserver.observe(e,{destroy:true});this.injectMenuItems(e,t);this._mInjectionTarget={column:t,menu:e}};s.prototype._removeMenuItems=function(){if(!this._mInjectionTarget){return}this.removeMenuItems(this._mInjectionTarget.menu);this._mInjectionTarget=null};s.prototype.injectMenuItems=function(e,t){};s.prototype.removeMenuItems=function(e){};s.prototype.onAfterMenuDestroyed=function(e){};s.prototype.destroy=function(){t.prototype.destroy.apply(this,arguments);this._removeMenuItems();this._oColumnHeaderMenuObserver.disconnect();delete this._oColumnHeaderMenuObserver};function u(e){return new Promise(function(t,n){sap.ui.require(["sap/ui/table/menus/"+e],function(e){t(e)},function(e){n(e)})})}function a(t){for(const n in r){if(e.isA(t,n)){return r[n]}}return r.default}function c(e,t){let n;if(t){n=i.get(t)}else{i.forEach(function(o,i){if(o.columns.includes(e)){n=o;t=i}})}if(!n){return}if(n.adapter instanceof Promise){n.adapter.then(function(){c(e,t)})}else{if(n.columns.includes(e)){n.columns.splice(n.columns.indexOf(e),1)}if(n.columns.length===0){n.adapter.destroy();i.delete(t)}}}return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/menus/ContextMenu", ["../utils/TableUtils","sap/ui/core/Element","sap/ui/unified/Menu","sap/ui/unified/MenuItem"],function(e,t,i,n){"use strict";const o=t.extend("sap.ui.table.menus.ContextMenu",{metadata:{library:"sap.ui.table",aggregations:{menu:{type:"sap.ui.unified.Menu",multiple:false}}}});o.prototype.init=function(){t.prototype.init.apply(this,arguments);this.oCellFilterMenuItem=null};o.prototype.exit=function(){t.prototype.exit.apply(this,arguments);delete this.oCellFilterMenuItem};o.prototype.invalidate=function(){};o.prototype.open=function(e,t){this.getMenu().openAsContextMenu(e,t)};o.prototype.close=function(){this.getMenu()?.close()};o.prototype.getTable=function(){const t=this.getParent();return e.isA(t,"sap.ui.table.Table")?t:null};o.prototype.initContent=function(e,t){if(!this.getMenu()){this.setMenu(new i)}this._initMenuItems(e,t)};o.prototype.isEmpty=function(){return!this.getMenu()?.getItems().some(e=>e.getVisible())};o.prototype._initMenuItems=function(t,i){const o=this.getMenu();const s=this.getTable();if(s.getEnableCellFilter()&&i?.isFilterableByMenu()&&!t.isGroupHeader()&&!t.isSummary()){if(!this.oCellFilterMenuItem){this.oCellFilterMenuItem=new n({text:e.getResourceText("TBL_FILTER")});o.insertItem(this.oCellFilterMenuItem,0)}this.oCellFilterMenuItem.detachSelect(l,this);this.oCellFilterMenuItem.attachSelect({row:t,column:i},l,this);this.oCellFilterMenuItem.setVisible(true)}else{this.oCellFilterMenuItem?.setVisible(false)}};function l(e,{row:t,column:i}){const n=this.getTable();const o=t.getRowBindingContext();const l=i.getFilterProperty();let s=o.getProperty(l);if(s!=null&&typeof s!=="string"){s=s.toString()}if(n.getEnableCustomFilter()){n.fireCustomFilter({column:i,value:s})}else{n.filter(i,s)}}o.prototype.onLocalizationChanged=function(e){if("language"in e.changes){this.destroyMenu()}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/menus/LegacyColumnMenuAdapter", ["./ColumnHeaderMenuAdapter","sap/ui/table/ColumnMenu","sap/ui/table/AnalyticalColumnMenu","sap/ui/table/utils/TableUtils","sap/ui/core/Popup","sap/ui/Device","sap/ui/base/ManagedObjectObserver"],function(e,t,n,o,l,s,u){"use strict";const i=["sortProperty","filterProperty","showSortMenuEntry","showFilterMenuEntry"];const a=["filterValue"];const r=["enableCustomFilter","enableGrouping","enableColumnFreeze","showColumnVisibilityMenu"];const c=e.extend("sap.ui.table.menus.LegacyColumnMenuAdapter",{constructor:function(){e.apply(this,arguments);this._oLegacyMenuObserver=new u(function(e){if(e.old!==e.current){if(i.indexOf(e.name)>-1){this._invalidateMenu(e.object)}else if(a.indexOf(e.name)>-1){this._setFilterValue(e.object,e.current)}else if(r.indexOf(e.name)>-1){this._invalidateAllMenus()}}}.bind(this))}});c.prototype.injectMenuItems=function(e,t){const n=t._getTable();const o=t.getDomRef();const l=o.querySelector(".sapUiTableColDropDown")!==null;if(!s.system.desktop&&!l){return this._applyColumnHeaderCellMenu(t)}this._removeColumnHeaderCellMenu(n);const u=n.fireColumnSelect({column:t});if(u){this._openColumnContextMenu(t)}};c.prototype._invalidateMenu=function(e){const t=e.getMenu();if(o.isA(t,"sap.ui.table.ColumnMenu")){t._invalidate()}};c.prototype._invalidateAllMenus=function(e){const t=e.getColumns();for(let e=0,n=t.length;e<n;e++){this._invalidateMenu(t[e])}};c.prototype._setFilterValue=function(e,t){const n=e.getMenu();if(o.isA(n,"sap.ui.table.ColumnMenu")){n._setFilterValue(t)}};c.prototype._setFilterState=function(e,t){const n=e.getMenu();if(o.isA(n,"sap.ui.table.ColumnMenu")){n._setFilterState(t)}};c.prototype._applyColumnHeaderCellMenu=function(e){const t=e._getTable();const n=e.getDomRef();const o=n.getAttribute("colspan");const l=n.querySelector(".sapUiTableCellInner");const s=n.querySelector(".sapUiTableCellTouchMenu")!==null;if(o&&o!=="1"||s||!e.getResizable()&&!e._menuHasItems()){return false}const u=document.createElement("div");this._removeColumnHeaderCellMenu(t);l.style.display="none";if(e._menuHasItems()){const e=document.createElement("div");e.classList.add("sapUiTableColDropDown");e.textContent="";u.appendChild(e)}if(e.getResizable()){const e=document.createElement("div");e.classList.add("sapUiTableColResizer");e.textContent="";u.appendChild(e)}u.classList.add("sapUiTableCellTouchMenu");n.appendChild(u);const i=function(){this._removeColumnHeaderCellMenu(t);n.removeEventListener("focusout",i)}.bind(this);n.addEventListener("focusout",i);return true};c.prototype._removeColumnHeaderCellMenu=function(e){const t=e&&e.$().find(".sapUiTableCHT .sapUiTableCellTouchMenu");if(t.length){t.parent().find(".sapUiTableCellInner").show();t.remove()}};c.prototype._openColumnContextMenu=function(e){const t=e._getTable();const n=e._cellPressed;const o=t.getColumns();for(let t=0;t<o.length;t++){if(o[t]!==e){this._closeColumnContextMenu(o[t])}}const l=n.getAttribute("colspan");if(l&&l!=="1"){return false}return this._openMenu(e,n)};c.prototype._openMenu=function(e,t){const n=this._getMenu(e);if(!e._menuHasItems()){return false}const o=e.fireColumnMenuOpen({menu:n});if(o){const e=l.Dock;n.open(null,t,e.BeginTop,e.BeginBottom,t);return true}else{return true}};c.prototype._closeColumnContextMenu=function(e){const t=e.getMenu();if(t){t.close()}};c.prototype._getMenu=function(e){let t=e.getMenu();if(!t){t=this._createMenu(e);e.setAggregation("menu",t,true);const n=i.concat(a).concat(r);this._oLegacyMenuObserver.observe(e,{properties:n});o.Hook.register(e._getTable(),o.Hook.Keys.Column.SetFilterState,this._setFilterState,this)}return t};c.prototype._createMenu=function(e){const o=e.isA("sap.ui.table.AnalyticalColumn")?n:t;return new o(e.getId()+"-menu",{ariaLabelledBy:e})};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/menus/MobileColumnHeaderMenuAdapter", ["./ColumnHeaderMenuAdapter","../utils/TableUtils","sap/m/library","sap/m/table/columnmenu/QuickAction","sap/m/table/columnmenu/QuickSort","sap/m/table/columnmenu/QuickSortItem","sap/m/table/columnmenu/QuickGroup","sap/m/table/columnmenu/QuickGroupItem","sap/m/table/columnmenu/QuickTotal","sap/m/table/columnmenu/QuickTotalItem","sap/m/table/columnmenu/ItemContainer","sap/m/table/columnmenu/ActionItem","sap/m/Button","sap/m/Switch","sap/m/Input","sap/ui/core/Lib","sap/ui/core/library","sap/ui/Device"],function(e,t,i,o,s,u,r,n,c,l,a,_,p,h,m,k,Q,g){"use strict";const f=e.extend("sap.ui.table.menus.MobileColumnHeaderMenuAdapter",{});f.prototype.injectMenuItems=function(e,t){this._oColumn=t;this._oMenu=e;this._prepareQuickActions(t);this._oMenu.addAggregation("_quickActions",this._oQuickSort);this._oMenu.addAggregation("_quickActions",this._oQuickFilter);this._oMenu.addAggregation("_quickActions",this._oQuickGroup);this._oMenu.addAggregation("_quickActions",this._oQuickTotal);this._oMenu.addAggregation("_quickActions",this._oQuickFreeze);this._oMenu.addAggregation("_quickActions",this._oQuickResize);this._prepareItems(t);e.addAggregation("_items",this._oItemContainer)};f.prototype.removeMenuItems=function(e){delete this._oColumn;e.removeAggregation("_quickActions",this._oQuickSort);e.removeAggregation("_quickActions",this._oQuickFilter);e.removeAggregation("_quickActions",this._oQuickGroup);e.removeAggregation("_quickActions",this._oQuickTotal);e.removeAggregation("_quickActions",this._oQuickFreeze);e.removeAggregation("_quickActions",this._oQuickResize);e.removeAggregation("_items",this._oItemContainer)};f.prototype.onAfterMenuDestroyed=function(e){if(e!==this._oMenu){return}delete this._oQuickSort;delete this._oQuickFilter;delete this._oQuickGroup;delete this._oQuickTotal;delete this._oQuickFreeze;delete this._oQuickResize;delete this._oItemContainer;delete this._oCustomFilterItem};f.prototype.destroy=function(){e.prototype.destroy.apply(this,arguments);this._destroyQuickActions();this._destroyItems();delete this._oColumn};f.prototype._prepareQuickActions=function(e){const t=e._getTable();this._prepareQuickSort(e);if(!t.getEnableCustomFilter()){this._prepareQuickFilter(e)}this._prepareQuickGroup(e);this._prepareQuickTotal(e);this._prepareQuickFreeze(e);this._prepareQuickResize(e)};f.prototype._prepareItems=function(e){const t=e._getTable();if(t.getEnableCustomFilter()){this._prepareCustomFilterItem(e)}if(!this._oItemContainer){this._oItemContainer=new a}this._oItemContainer.addItem(this._oCustomFilterItem)};f.prototype._destroyQuickActions=function(){if(this._oQuickSort){this._oQuickSort.destroy()}if(this._oQuickFilter){this._oQuickFilter.destroy()}if(this._oQuickGroup){this._oQuickGroup.destroy()}if(this._oQuickTotal){this._oQuickTotal.destroy()}if(this._oQuickFreeze){this._oQuickFreeze.destroy()}if(this._oQuickResize){this._oQuickResize.destroy()}delete this._oQuickSort;delete this._oQuickFilter;delete this._oQuickGroup;delete this._oQuickTotal;delete this._oQuickFreeze;delete this._oQuickResize};f.prototype._destroyItems=function(){if(this._oItemContainer){this._oItemContainer.destroy()}delete this._oItemContainer;delete this._oCustomFilterItem};f.prototype._prepareQuickSort=function(e){if(e.isSortableByMenu()){if(!this._oQuickSort){this._oQuickSort=this._createQuickSort()}this._updateQuickSort(e);this._oQuickSort.setVisible(true)}else if(this._oQuickSort){this._oQuickSort.setVisible(false)}};f.prototype._createQuickSort=function(){return new s({items:new u,change:[function(e){const t=e.getParameter("item").getSortOrder();this._oColumn._sort(t,false)},this]})};f.prototype._updateQuickSort=function(e){const i=this._oQuickSort.getItems()[0];i.setLabel(t.Column.getHeaderText(e));i.setSortOrder(e.getSortOrder())};f.prototype._prepareQuickFilter=function(e){if(e.getShowFilterMenuEntry()&&e.isFilterableByMenu()){if(!this._oQuickFilter){this._oQuickFilter=this._createQuickFilter(e);this._oQuickFilter._bHideLabelColon=true}this._updateQuickFilter(e);this._oQuickFilter.setVisible(true)}else if(this._oQuickFilter){this._oQuickFilter.setVisible(false)}};f.prototype._createQuickFilter=function(){return new o({content:new m({submit:[function(e){this._oColumn.setFilterValue(e.getSource().getValue());const t=this._oColumn._getFilterState();if(t===Q.ValueState.None){this._oColumn.filter(e.getSource().getValue());this._oMenu.close()}e.getSource().setValueState(t)},this]}),category:i.table.columnmenu.Category.Filter})};f.prototype._updateQuickFilter=function(e){const i=this._oQuickFilter.getContent()[0];this._oQuickFilter.setLabel(t.Column.getHeaderText(e));i.setValue(e.getFilterValue());i.setValueState(e._getFilterState())};f.prototype._prepareQuickGroup=function(e){if(e._isGroupableByMenu()){if(!this._oQuickGroup){this._oQuickGroup=this._createQuickGroup()}this._updateQuickGroup(e);this._oQuickGroup.setVisible(true)}else if(this._oQuickGroup){this._oQuickGroup.setVisible(false)}};f.prototype._createQuickGroup=function(){return new r({items:new n,change:[function(e){const i=e.getParameter("item").getGrouped();const o=this._oColumn;const s=o._getTable();this._oMenu.attachEventOnce("afterClose",function(){if(i&&(!o.getShowIfGrouped||!o.getShowIfGrouped())){let e;if(t.isNoDataVisible(s)){e=s.getDomRef("noDataCnt")}else{e=s.getDomRef("rowsel0")}if(e){e.focus()}}o._setGrouped(i)})},this]})};f.prototype._updateQuickGroup=function(e){const i=this._oQuickGroup.getItems()[0];i.setLabel(t.Column.getHeaderText(e));i.setGrouped(e.getGrouped())};f.prototype._prepareQuickTotal=function(e){if(e._isAggregatableByMenu()){if(!this._oQuickTotal){this._oQuickTotal=this._createQuickTotal()}this._updateQuickTotal(e);this._oQuickTotal.setVisible(true)}else if(this._oQuickTotal){this._oQuickTotal.setVisible(false)}};f.prototype._createQuickTotal=function(){return new c({items:new l,change:[function(e){this._oColumn.setSummed(e.getParameter("item").getTotaled())},this]})};f.prototype._updateQuickTotal=function(e){const i=this._oQuickTotal.getItems()[0];i.setLabel(t.Column.getHeaderText(e));i.setTotaled(e.getSummed())};f.prototype._prepareQuickFreeze=function(e){if(e._getTable().getEnableColumnFreeze()){if(!this._oQuickFreeze){this._oQuickFreeze=this._createQuickFreeze()}this._updateQuickFreeze(e);this._oQuickFreeze.setVisible(true)}else if(this._oQuickFreeze){this._oQuickFreeze.setVisible(false)}};f.prototype._createQuickFreeze=function(){return new o({label:t.getResourceText("TBL_FREEZE"),content:new h({customTextOn:" ",customTextOff:" ",change:[function(e){const t=this._oColumn._getTable();const i=t.fireColumnFreeze({column:this._oColumn});if(i){if(e.getSource().getState()){t.setFixedColumnCount(this._oColumn.getIndex()+1)}else{t.setFixedColumnCount(this._oColumn.getIndex())}}this._oMenu.close()},this]})})};f.prototype._updateQuickFreeze=function(e){const i=e.getIndex()+t.Column.getHeaderSpan(e)<=e._getTable().getComputedFixedColumnCount();this._oQuickFreeze.getContent()[0].setState(i)};f.prototype._prepareQuickResize=function(e){if(!g.system.desktop&&e.getResizable()){if(!this._oQuickResize){this._oQuickResize=this._createQuickResize(e)}this._oQuickResize.setVisible(true)}else if(this._oQuickResize){this._oQuickResize.setVisible(false)}};f.prototype._createQuickResize=function(e){const t=k.getResourceBundleFor("sap.m");const i=t.getText("table.COLUMNMENU_RESIZE");return new o({label:i,content:new p({icon:"sap-icon://resize-horizontal",tooltip:i,press:[function(t){this._startColumnResize(e);this._oMenu.close()},this]})})};f.prototype._startColumnResize=function(e){const t=e._getTable();t.$().toggleClass("sapUiTableResizing",true);t._$colResize=t.$("rsz");t._$colResize.toggleClass("sapUiTableColRszActive",true)};f.prototype._removeHeaderCellColumnResizer=function(e){const t=e&&e.$().find(".sapUiTableCHT .sapUiTableCellTouchMenu");if(t.length){t.parent().find(".sapUiTableCellInner").show();t.remove()}};f.prototype._prepareCustomFilterItem=function(e){if(e.getShowFilterMenuEntry()){if(!this._oCustomFilterItem){this._oCustomFilterItem=this._createCustomFilterItem()}this._oCustomFilterItem.setVisible(true)}else if(this._oCustomFilterItem){this._oCustomFilterItem.setVisible(false)}};f.prototype._createCustomFilterItem=function(){return new _({label:t.getResourceText("TBL_FILTER_ITEM"),icon:"sap-icon://filter",press:[function(e){this._oColumn._getTable().fireCustomFilter({column:this._oColumn})},this]})};return f});
/*
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/plugins/BindingSelection", ["./SelectionPlugin","../utils/TableUtils","../library"],function(e,t,n){"use strict";const i=n.SelectionMode;const o=e.extend("sap.ui.table.plugins.BindingSelection",{metadata:{library:"sap.ui.table",properties:{selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:i.MultiToggle}},events:{selectionChange:{parameters:{indices:{type:"int[]"},selectAll:{type:"boolean"}}}}}});o.prototype.onActivate=function(n){e.prototype.onActivate.apply(this,arguments);c(this,n.getBinding());t.Hook.register(n,t.Hook.Keys.Table.RowsBound,s,this)};o.prototype.onDeactivate=function(n){e.prototype.onDeactivate.apply(this,arguments);r(this,n.getBinding());t.Hook.deregister(n,t.Hook.Keys.Table.RowsBound,s,this)};o.prototype.getTableBinding=function(){return this.getControl()?.getBinding()};o.prototype.setSelected=function(e,t,n){if(!this.isIndexSelectable(e.getIndex())){return}if(n&&n.range){const t=this.getSelectedIndex();if(t>=0){this.addSelectionInterval(t,e.getIndex())}}else if(t){this.addSelectionInterval(e.getIndex(),e.getIndex())}else{this.removeSelectionInterval(e.getIndex(),e.getIndex())}};o.prototype.isSelected=function(e){return this.isIndexSelected(e.getIndex())};o.prototype.getRenderConfig=function(){return{headerSelector:{type:"toggle",visible:t.hasSelectAll(this.getControl()),selected:this.getSelectableCount()>0&&this.getSelectableCount()===this.getSelectedCount()}}};function l(e){const t=e.getControl();let n;if(e.getSelectionMode()!==i.MultiToggle){return false}if(e.getSelectableCount()>e.getSelectedCount()){t._iSourceRowIndex=0;e.selectAll();n=true}else{t._iSourceRowIndex=-1;e.clearSelection();n=false}t._iSourceRowIndex=undefined;return n}o.prototype.onHeaderSelectorPress=function(){if(this.getRenderConfig().headerSelector.visible){l(this)}};o.prototype.onKeyboardShortcut=function(e,t){if(e==="toggle"&&l(this)===false){t.setMarked("sapUiTableClearAll")}else if(e==="clear"){this.clearSelection();t.setMarked("sapUiTableClearAll")}};o.prototype.addSelectionInterval=function(e,t){if(this.getSelectionMode()===i.None){return}const n=this.getTableBinding();if(n&&n.addSelectionInterval){if(this.getSelectionMode()===i.Single){e=t;this.setSelectionInterval(e,t)}else{n.addSelectionInterval(e,t)}}};o.prototype.clearSelection=function(){const e=this.getTableBinding();if(e&&e.clearSelection){e.clearSelection()}};o.prototype.getSelectedIndex=function(){const e=this.getTableBinding();if(e&&e.getSelectedIndex){return e.getSelectedIndex()}else{return-1}};o.prototype.getSelectedIndices=function(){const e=this.getTableBinding();if(this.getSelectionMode()===i.Single){const e=this.getSelectedIndex();if(e===-1){return[]}return[e]}if(e&&e.getSelectedIndices){return e.getSelectedIndices()}else{return[]}};o.prototype.getSelectableCount=function(){const e=this.getTableBinding();if(!e){return 0}else if(e.isA("sap.ui.model.analytics.AnalyticalBinding")){const t=e.getGrandTotalContextInfo();return t?t.totalNumberOfLeafs:0}else{return e.getLength()}};o.prototype.getSelectedCount=function(){const e=this.getTableBinding();if(e&&e.getSelectedNodesCount){return e.getSelectedNodesCount()}else{return 0}};o.prototype.isIndexSelectable=function(e){const t=this.getTableBinding();if(t&&t.isIndexSelectable){return t.isIndexSelectable(e)}else{return false}};o.prototype.isIndexSelected=function(e){const t=this.getTableBinding();if(this.getSelectionMode()===i.Single){if(e<0){return false}return e===this.getSelectedIndex()}if(t&&t.isIndexSelected){return t.isIndexSelected(e)}else{return false}};o.prototype.removeSelectionInterval=function(e,t){const n=this.getTableBinding();if(n&&n.removeSelectionInterval){n.removeSelectionInterval(e,t)}};o.prototype.selectAll=function(){if(this.getSelectionMode()!==i.MultiToggle){return}const e=this.getTableBinding();if(e&&e.selectAll){e.selectAll()}};o.prototype.setSelectedIndex=function(e){if(this.getSelectionMode()===i.None){return}if(e===-1){this.clearSelection()}else{const t=this.getTableBinding();if(t&&t.setSelectedIndex){t.setSelectedIndex(e)}}};o.prototype.setSelectionInterval=function(e,t){if(this.getSelectionMode()===i.None){return}const n=this.getTableBinding();if(n&&n.setSelectionInterval){if(this.getSelectionMode()===i.Single){e=t}n.setSelectionInterval(e,t)}};o.prototype.setSelectionMode=function(e){const t=this.getSelectionMode();this.setProperty("selectionMode",e);if(this.getSelectionMode()!==t){this.clearSelection()}return this};o.prototype._getHighestSelectableIndex=function(){const e=this.getTableBinding();if(!e){return-1}else if(e.isA("sap.ui.model.analytics.AnalyticalBinding")){const t=e.providesGrandTotal()&&e.hasTotaledMeasures();return e.getLength()-(t?2:1)}else{return e.getLength()-1}};function s(e){c(this,e)}function c(e,t){t?.attachChange(a,e);t?.attachSelectionChanged?.(d,e)}function r(e,t){t?.detachChange(a,e);t?.detachSelectionChanged?.(d,e)}function a(e){const t=typeof e==="object"?e.getParameter("reason"):e;if(t==="sort"||t==="filter"){this.clearSelection()}}function d(e){const t=e.getParameter("rowIndices");const n=e.getParameter("selectAll");this.fireSelectionChange({rowIndices:t,selectAll:n})}return o});
/*
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/plugins/MultiSelectionPlugin", ["./SelectionPlugin","./PluginBase","./SelectionModelSelection","./BindingSelection","../library","../utils/TableUtils","sap/ui/core/Icon","sap/ui/core/IconPool","sap/base/Log"],function(e,t,i,n,o,l,r,s,c){"use strict";const a=o.SelectionMode;const u=e.extend("sap.ui.table.plugins.MultiSelectionPlugin",{metadata:{library:"sap.ui.table",properties:{limit:{type:"int",group:"Behavior",defaultValue:200},enableNotification:{type:"boolean",group:"Behavior",defaultValue:false},showHeaderSelector:{type:"boolean",group:"Appearance",defaultValue:true},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:a.MultiToggle}},aggregations:{icon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{selectionChange:{parameters:{indices:{type:"int[]"},limitReached:{type:"boolean"},customPayload:{type:"object"}}}}}});u.findOn=t.findOn;u.prototype.init=function(){e.prototype.init.apply(this,arguments);this._bLimitReached=false;this._bLimitDisabled=this.getLimit()===0;this.oInnerSelectionPlugin=null};u.prototype.onActivate=function(t){e.prototype.onActivate.apply(this,arguments);this.oInnerSelectionPlugin=h(t);this.oInnerSelectionPlugin.attachSelectionChange(this._onSelectionChange,this);f(this,t.getBinding());t.addAggregation("_hiddenDependents",this.oInnerSelectionPlugin);t.setProperty("selectionMode",this.getSelectionMode());p(this);l.Hook.register(t,l.Hook.Keys.Table.RowsBound,S,this)};function h(e){if(e.isA(["sap.ui.table.TreeTable","sap.ui.table.AnalyticalTable"])){return new n}else{return new i}}u.prototype.onDeactivate=function(t){e.prototype.onDeactivate.apply(this,arguments);t.setProperty("selectionMode",a.None);m(this,t.getBinding());this.oInnerSelectionPlugin?.destroy();delete this.oInnerSelectionPlugin;l.Hook.deregister(t,l.Hook.Keys.Table.RowsBound,S,this)};u.prototype.setSelected=function(e,t,i){if(!this.isIndexSelectable(e.getIndex())){return}if(i&&i.range){const t=this.getSelectedIndex();if(t>=0){this.addSelectionInterval(t,e.getIndex())}}else if(t){this.addSelectionInterval(e.getIndex(),e.getIndex())}else{this.removeSelectionInterval(e.getIndex(),e.getIndex())}};u.prototype.isSelected=function(e){return this.isIndexSelected(e.getIndex())};u.prototype.getRenderConfig=function(){if(!this.isActive()){return e.prototype.getRenderConfig.apply(this,arguments)}return{headerSelector:{type:this._bLimitDisabled?"toggle":"custom",icon:this.getAggregation("icon"),visible:this.getSelectionMode()===a.MultiToggle&&this.getShowHeaderSelector(),enabled:this.getSelectableCount()>0,selected:this.getSelectableCount()>0&&this.getSelectableCount()===this.getSelectedCount(),tooltip:this.getSelectedCount()===0?l.getResourceText("TBL_SELECT_ALL"):l.getResourceText("TBL_DESELECT_ALL")}}};u.prototype.onHeaderSelectorPress=function(){const e=this.getRenderConfig();if(!e.headerSelector.visible||!e.headerSelector.enabled){return}if(e.headerSelector.type==="toggle"){d(this)}else if(e.headerSelector.type==="custom"){if(this.getSelectedCount()>0){this.clearSelection()}else{this.addSelectionInterval(0,this._getHighestSelectableIndex())}}};u.prototype.onKeyboardShortcut=function(e,t){if(e==="toggle"){if(this.getSelectionMode()!==a.MultiToggle){return}if(this._bLimitDisabled){if(!d(this)){t.setMarked("sapUiTableClearAll")}}else{this.addSelectionInterval(0,this._getHighestSelectableIndex())}}else if(e==="clear"){this.clearSelection();t.setMarked("sapUiTableClearAll")}};function d(e){if(e.getSelectableCount()>e.getSelectedCount()){e.selectAll();return true}else{e.clearSelection();return false}}u.prototype.setSelectionMode=function(e){const t=this.getParent();if(t){t.setProperty("selectionMode",e,true)}if(this.oInnerSelectionPlugin){this.oInnerSelectionPlugin.setSelectionMode(e)}this.setProperty("selectionMode",e);p(this);return this};u.prototype.setLimit=function(e){if(typeof e==="number"&&e<0){c.warning("The limit must be greater than or equal to 0",this);return this}this.setProperty("limit",e,!!this.getLimit()===!!e);this._bLimitDisabled=e===0;p(this);return this};u.prototype.setEnableNotification=function(e){this.setProperty("enableNotification",e,true);return this};u.prototype.isLimitReached=function(){return this._bLimitReached};u.prototype.setLimitReached=function(e){this._bLimitReached=e};u.prototype.selectAll=function(e){if(!this._bLimitDisabled){return Promise.reject(new Error("Not possible if the limit is enabled"))}const t=this.getSelectableCount();if(t===0){return Promise.reject(new Error("Nothing to select"))}return this.addSelectionInterval(0,this._getHighestSelectableIndex(),e)};function g(e,t,i,n){const o=e._getHighestSelectableIndex();if(t<0&&i<0||t>o&&i>o){return Promise.reject(new Error("Out of range"))}t=Math.min(Math.max(0,t),o);i=Math.min(Math.max(0,i),o);const r=e.getLimit();const s=i<t;let c=s?i:t;let a;if(n&&e.isIndexSelected(t)){if(s){t--}else if(t!==i){t++;c++}}a=Math.abs(i-t)+1;if(!e._bLimitDisabled){e.setLimitReached(a>r);if(e.isLimitReached()){if(s){i=t-r+1;c=i-1}else{i=t+r-1}a=r+1}}return l.loadContexts(e.getControl().getBinding(),c,a).then(function(){return{indexFrom:t,indexTo:i}})}u.prototype.setSelectionInterval=function(e,t,i){const n=this.getControl();const o=this.getSelectionMode();if(o===a.None){return Promise.reject(new Error("SelectionMode is '"+a.None+"'"))}if(o===a.Single){e=t}return g(this,e,t,false).then(function(e){this._oCustomEventPayloadTmp=i;this.oInnerSelectionPlugin.setSelectionInterval(e.indexFrom,e.indexTo);delete this._oCustomEventPayloadTmp;if(!this.isLimitReached()){return Promise.resolve()}return l.scrollTableToIndex(n,e.indexTo,e.indexFrom>e.indexTo).then(function(){if(!this.getEnableNotification()){return Promise.resolve()}return l.showNotificationPopoverAtIndex(n,e.indexTo,this.getLimit())}.bind(this))}.bind(this))};u.prototype.setSelectedIndex=function(e,t){return this.setSelectionInterval(e,e,t)};u.prototype.addSelectionInterval=function(e,t,i){const n=this.getControl();const o=this.getSelectionMode();if(o===a.None){return Promise.reject(new Error("SelectionMode is '"+a.None+"'"))}if(o===a.Single){return this.setSelectionInterval(t,t)}if(o===a.MultiToggle){return g(this,e,t,true).then(function(e){this._oCustomEventPayloadTmp=i;this.oInnerSelectionPlugin.addSelectionInterval(e.indexFrom,e.indexTo);delete this._oCustomEventPayloadTmp;if(!this.isLimitReached()){return Promise.resolve()}return l.scrollTableToIndex(n,e.indexTo,e.indexFrom>e.indexTo).then(function(){if(!this.getEnableNotification()){return Promise.resolve()}return l.showNotificationPopoverAtIndex(n,e.indexTo,this.getLimit())}.bind(this))}.bind(this))}};u.prototype.clearSelection=function(e){if(this.oInnerSelectionPlugin){this.setLimitReached(false);this._oCustomEventPayloadTmp=e;this.oInnerSelectionPlugin.clearSelection();delete this._oCustomEventPayloadTmp}};u.prototype.getSelectedIndex=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectedIndex()}return-1};u.prototype.getSelectedIndices=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectedIndices()}return[]};u.prototype.getSelectableCount=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectableCount()}return 0};u.prototype.getSelectedCount=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.getSelectedCount()}return 0};u.prototype.isIndexSelectable=function(e){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.isIndexSelectable(e)}return false};u.prototype.isIndexSelected=function(e){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin.isIndexSelected(e)}return false};u.prototype.removeSelectionInterval=function(e,t,i){if(this.oInnerSelectionPlugin){this.setLimitReached(false);this._oCustomEventPayloadTmp=i;this.oInnerSelectionPlugin.removeSelectionInterval(e,t);delete this._oCustomEventPayloadTmp}};function p(e){if(e.getSelectionMode()===a.MultiToggle&&!e._bLimitDisabled){if(!e.getAggregation("icon")){const t=new r({useIconTooltip:false});t.addStyleClass("sapUiTableSelectClear");e.setAggregation("icon",t,true)}const t=e.getAggregation("icon");const i=e.getSelectedCount();if(e.getSelectableCount()===i&&i!==0){t.setSrc(s.getIconURI(l.ThemeParameters.allSelectedIcon))}else if(i!==0){t.setSrc(s.getIconURI(l.ThemeParameters.clearSelectionIcon))}else{t.setSrc(s.getIconURI(l.ThemeParameters.checkboxIcon))}}else{e.destroyAggregation("icon")}}u.prototype._onSelectionChange=function(e){const t=e.getParameter("rowIndices");p(this);this.fireSelectionChange({rowIndices:t,limitReached:this.isLimitReached(),customPayload:typeof this._oCustomEventPayloadTmp==="object"?this._oCustomEventPayloadTmp:null,_internalTrigger:e.getParameter("_internalTrigger")})};u.prototype._getHighestSelectableIndex=function(){if(this.oInnerSelectionPlugin){return this.oInnerSelectionPlugin._getHighestSelectableIndex()}return 0};function S(e){f(this,e)}function f(e,t){t?.attachChange(I,e)}function m(e,t){t?.detachChange(I,e)}function I(e){p(this)}u.prototype.onThemeChanged=function(){p(this)};return u});
/*
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/plugins/ODataV4Selection", ["./SelectionPlugin","./SelectionMode","./PluginBase","../library","../utils/TableUtils","sap/ui/core/Icon","sap/ui/core/IconPool"],function(e,t,i,n,o,s,r){"use strict";const l=o.createWeakMapFacade();const c=e.extend("sap.ui.table.plugins.ODataV4Selection",{metadata:{library:"sap.ui.table",properties:{selectionMode:{type:"sap.ui.table.plugins.SelectionMode",group:"Behavior",defaultValue:t.MultiToggle},limit:{type:"int",group:"Behavior",defaultValue:200},enableNotification:{type:"boolean",group:"Behavior",defaultValue:false},hideHeaderSelector:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{icon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}}}});c.findOn=i.findOn;c.prototype.init=function(){e.prototype.init.apply(this,arguments);const t=new s({src:r.getIconURI(o.ThemeParameters.checkboxIcon),useIconTooltip:false});t.addStyleClass("sapUiTableSelectClear");this.setAggregation("icon",t,true);l(this).bLimitReached=false;l(this).oRangeSelectionStartContext=null};c.prototype.onActivate=function(t){const i=t.getBinding();f(this,i);e.prototype.onActivate.apply(this,arguments);t.setProperty("selectionMode",this.getSelectionMode());C(this,i);o.Hook.register(t,o.Hook.Keys.Table.RowsBound,S,this)};c.prototype.onDeactivate=function(t){e.prototype.onDeactivate.apply(this,arguments);t.setProperty("selectionMode",n.SelectionMode.None);clearTimeout(this.iSelectionChangeTimeout);delete this.iSelectionChangeTimeout;y(this,t.getBinding());o.Hook.deregister(t,o.Hook.Keys.Table.RowsBound,S,this)};c.prototype.setSelected=function(e,i,n){const o=e.getRowBindingContext();const s=this.getSelectionMode();if(!this.isActive()||!o||!b(o)){return}if(n?.range){a(this,e);return}if(this.isSelected(e)===i){return}if(s===t.Single&&i){this.clearSelection()}o.setSelected(i);l(this).oRangeSelectionStartContext=i&&s===t.MultiToggle?o:null};function a(e,t){if(!l(e).oRangeSelectionStartContext){return}let i=l(e).oRangeSelectionStartContext.getIndex();const n=t.getRowBindingContext();const o=n?n.getIndex():-1;if(i!==o){i+=o>i?1:-1}x(e,i,o)}c.prototype.isSelected=function(e){const t=e.getRowBindingContext();return t?this.isActive()&&t.isSelected():false};c.prototype.getSelectedCount=function(){return this.getSelectedContexts().length};function g(e){const t=e.getControl()?.getBinding();if(!t){return 0}if(!t.isLengthFinal()){return-1}const i=t.getAggregation();const n="hierarchyQualifier"in(i||{});const o=!n&&!!i;let s=-1;if(o){const i=e.aAllCurrentContexts??t.getAllCurrentContexts();if(t.getLength()===i.length){s=i.filter(b).length}}else{s=t.getLength()}return s}function u(e){if(e._isLimitDisabled()){return}let t=r.getIconURI(o.ThemeParameters.checkboxIcon);if(e.getSelectedCount()>0){if(h(e)){t=r.getIconURI(o.ThemeParameters.allSelectedIcon)}else{t=r.getIconURI(o.ThemeParameters.clearSelectionIcon)}}e.getAggregation("icon").setSrc(t)}c.prototype.getRenderConfig=function(){if(!this.isActive()){return e.prototype.getRenderConfig.apply(this,arguments)}this.aAllCurrentContexts=this.getControl().getBinding()?.getAllCurrentContexts();u(this);const i={headerSelector:{type:this._isLimitDisabled()?"toggle":"custom",icon:this.getAggregation("icon"),visible:this.getSelectionMode()===t.MultiToggle&&!this.getHideHeaderSelector(),enabled:g(this)!==0,selected:h(this),tooltip:this.getSelectedCount()===0?o.getResourceText("TBL_SELECT_ALL"):o.getResourceText("TBL_DESELECT_ALL")}};delete this.aAllCurrentContexts;return i};function d(e){if(h(e)){e.clearSelection();return false}else if(e._isLimitDisabled()){const t=e.getControl()?.getBinding();if(t?.getLength()){x(e,0,t.getLength()-1);return true}}return undefined}function h(e){const t=g(e);return t>0&&t===e.getSelectedCount()}c.prototype.onHeaderSelectorPress=function(){if(!this.isActive()){return}const e=this.getRenderConfig();if(!e.headerSelector.visible||!e.headerSelector.enabled){return}if(e.headerSelector.type==="toggle"){d(this)}else if(e.headerSelector.type==="custom"){if(this.getSelectedCount()>0){this.clearSelection()}else{const e=this.getControl()?.getBinding();if(e?.getLength()>0){x(this,0,e.getLength()-1)}}}};c.prototype.onKeyboardShortcut=function(e,i){if(!this.isActive()){return}if(e==="toggle"){if(this.getSelectionMode()!==t.MultiToggle){return}if(this._isLimitDisabled()){if(d(this)===false){i.setMarked("sapUiTableClearAll")}}else{const e=this.getControl()?.getBinding();if(e?.getLength()>0){x(this,0,e.getLength()-1)}}}else if(e==="clear"){this.clearSelection();i.setMarked("sapUiTableClearAll")}};c.prototype.setSelectionMode=function(e){const t=this.getControl();this.setProperty("selectionMode",e,true);l(this).oRangeSelectionStartContext=null;this.clearSelection();if(t){t.setProperty("selectionMode",this.getSelectionMode())}return this};c.prototype.setLimit=function(e){this.setProperty("limit",e);l(this).bLimitReached=false;return this};function f(e,t){if(!t){return}if(!t.getModel().isA("sap.ui.model.odata.v4.ODataModel")){throw new Error("Model must be sap.ui.model.odata.v4.ODataModel")}p(e,t)}function p(e,i,n){const o=[i.getHeaderContext(),...i.getAllCurrentContexts()].filter(e=>e?.isSelected());let s=o;if(n){s=n.isSelected()?[n]:[]}for(const e of s){if(e===i.getHeaderContext()){throw new Error("Header context must not be selected")}if(!b(e)){throw new Error(`Context ${e} is not allowed to be selected`)}}if(e.getSelectionMode()===t.Single&&o.length>1){throw new Error("Multiple contexts selected. Cannot select more than one context in selection mode 'Single'")}}function S(e){f(this,e);C(this,e)}function C(e,t){t?.attachEvent("selectionChanged",m,e)}function y(e,t){t?.detachEvent("selectionChanged",m,e)}function m(e){const t=e.getParameter("context");try{p(this,t.getBinding(),t)}catch(e){t.setSelected(false);throw e}if(this.iSelectionChangeTimeout){return}this.iSelectionChangeTimeout=setTimeout(()=>{this.fireSelectionChange();delete this.iSelectionChangeTimeout},0)}c.prototype._isLimitDisabled=function(){return this.getLimit()===0};function x(e,t,i){const n=e.getControl();const s=e.getLimit();const r=i<t;let c=r?i:t;let a=Math.abs(i-t)+1;if(!e._isLimitDisabled()){l(e).bLimitReached=a>s;if(l(e).bLimitReached){if(r){i=t-s+1;c=i}else{i=t+s-1}a=s+1}}o.loadContexts(n.getBinding(),c,a).then(function(t){t.forEach(function(t){if(!b(t)||t.isSelected()){return}if(r&&t.getIndex()>=i||t.getIndex()<=i){t.setSelected(true)}if(t.getIndex()===i){l(e).oRangeSelectionStartContext=t}});if(l(e).bLimitReached){o.scrollTableToIndex(n,i,r).then(function(){if(e.getEnableNotification()){o.showNotificationPopoverAtIndex(n,i,e.getLimit())}})}})}function b(e){const t=e.getBinding();const i=e===t.getHeaderContext();const n=e.getProperty("@$ui5.node.isExpanded")===undefined;const o=e.getProperty("@$ui5.node.isTotal");const s="hierarchyQualifier"in(t.getAggregation()||{});return!i&&(s||n&&!o)}c.prototype.clearSelection=function(){for(const e of this.getSelectedContexts()){e.setSelected(false)}};c.prototype.getSelectedContexts=function(){const e=this.getControl()?.getBinding();if(!this.isActive()||!e){return[]}const t=this.aAllCurrentContexts??e.getAllCurrentContexts();return t.filter(e=>e.isSelected())};c.prototype.onThemeChanged=function(){u(this)};return c});
/*
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/plugins/PluginBase", ["../utils/TableUtils","sap/ui/core/Element"],function(t,e){"use strict";const i=e.extend("sap.ui.table.plugins.PluginBase",{metadata:{abstract:true,library:"sap.ui.table",properties:{enabled:{type:"boolean",defaultValue:true}}}});i.getPlugin=function(t,e=i){if(!t){return}if(typeof e==="function"&&e.getMetadata){e=e.getMetadata().getName()}const n=function(t){return t.isA(e)&&t.isA(["sap.m.plugins.PluginBase","sap.ui.table.plugins.PluginBase"])};return t.getDependents().find(n)||t.findElements(false,n)[0]};i.findOn=function(t){return i.getPlugin(t,this)};i.prototype.setEnabled=function(t){const e=this.getEnabled();this.setProperty("enabled",t,true);if(this.getEnabled()!==e){if(e){this._deactivate()}else{this._activate()}}return this};i.prototype.onActivate=function(t){};i.prototype.onDeactivate=function(t){};i.prototype.isActive=function(){return!!this._bActive};i.prototype.isApplicable=function(e){return t.isA(e,"sap.ui.table.Table")};i.prototype.setParent=function(t){this._deactivate();e.prototype.setParent.apply(this,arguments);if(this.getEnabled()){this._activate()}return this};i.prototype.getControl=function(){return this.getParent()};i.prototype._activate=function(){if(this._bActive){return}const t=this.getControl();if(!t){return}if(!this.isApplicable(t)){throw new Error(this+" is not applicable to "+t)}this._bActive=true;this.onActivate(t)};i.prototype._deactivate=function(){if(!this._bActive){return}this._bActive=false;this.onDeactivate(this.getControl())};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/plugins/SelectionMode", ["sap/ui/base/DataType"],e=>{"use strict";const i={Single:"Single",MultiToggle:"MultiToggle"};e.registerEnum("sap.ui.table.plugins.SelectionMode",i);return i});
/*
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/plugins/SelectionModelSelection", ["sap/ui/model/SelectionModel","./SelectionPlugin","../utils/TableUtils","../library"],function(e,t,o,i){"use strict";const n=i.SelectionMode;const l=t.extend("sap.ui.table.plugins.SelectionModelSelection",{metadata:{library:"sap.ui.table",properties:{selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:n.MultiToggle}},events:{selectionChange:{parameters:{indices:{type:"int[]"},selectAll:{type:"boolean"}}}}}});l.prototype.init=function(){t.prototype.init.apply(this,arguments);this.oSelectionModel=new e(r(this.getSelectionMode()))};l.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this.oSelectionModel?.destroy();delete this.oSelectionModel};l.prototype.onActivate=function(e){t.prototype.onActivate.apply(this,arguments);this.oSelectionModel.attachSelectionChanged(a,this);h(this,e.getBinding());o.Hook.register(e,o.Hook.Keys.Table.TotalRowCountChanged,u,this);o.Hook.register(e,o.Hook.Keys.Table.UnbindRows,d,this);o.Hook.register(e,o.Hook.Keys.Table.RowsBound,c,this);this._iTotalRowCount=e._getTotalRowCount()};l.prototype.onDeactivate=function(e){t.prototype.onDeactivate.apply(this,arguments);this.oSelectionModel?.detachSelectionChanged(a,this);this.oSelectionModel?.clearSelection();g(this,e.getBinding());o.Hook.deregister(e,o.Hook.Keys.Table.TotalRowCountChanged,u,this);o.Hook.deregister(e,o.Hook.Keys.Table.UnbindRows,d,this);o.Hook.deregister(e,o.Hook.Keys.Table.RowsBound,c,this)};l.prototype.setSelected=function(e,t,o){if(!this.isIndexSelectable(e.getIndex())){return}if(o&&o.range){const t=this.getSelectedIndex();if(t>=0){this.addSelectionInterval(t,e.getIndex())}}else if(t){this.addSelectionInterval(e.getIndex(),e.getIndex())}else{this.removeSelectionInterval(e.getIndex(),e.getIndex())}};l.prototype.isSelected=function(e){return this.isIndexSelected(e.getIndex())};l.prototype.getRenderConfig=function(){return{headerSelector:{type:"toggle",visible:o.hasSelectAll(this.getControl()),selected:this.getSelectableCount()>0&&this.getSelectableCount()===this.getSelectedCount()}}};function s(e){const t=e.getControl();let o;if(e.getSelectionMode()!==n.MultiToggle){return false}if(e.getSelectableCount()>e.getSelectedCount()){t._iSourceRowIndex=0;e.selectAll();o=true}else{t._iSourceRowIndex=-1;e.clearSelection();o=false}t._iSourceRowIndex=undefined;return o}l.prototype.onHeaderSelectorPress=function(){if(this.getRenderConfig().headerSelector.visible){s(this)}};l.prototype.onKeyboardShortcut=function(e,t){if(e==="toggle"&&s(this)===false){t.setMarked("sapUiTableClearAll")}else if(e==="clear"){this.clearSelection();t.setMarked("sapUiTableClearAll")}};l.prototype.addSelectionInterval=function(e,t){if(!this.oSelectionModel||this.getSelectionMode()===n.None){return}this.oSelectionModel.addSelectionInterval(e,t)};l.prototype.clearSelection=function(){if(this.oSelectionModel){this.oSelectionModel.clearSelection()}};l.prototype.getSelectedIndex=function(){if(this.oSelectionModel){return this.oSelectionModel.getLeadSelectedIndex()}return-1};l.prototype.getSelectedIndices=function(){if(this.oSelectionModel){return this.oSelectionModel.getSelectedIndices()}return[]};l.prototype.getSelectableCount=function(){const e=this.getControl().getBinding();return e?e.getLength():0};l.prototype.getSelectedCount=function(){return this.getSelectedIndices().length};l.prototype.isIndexSelectable=function(e){return e>=0&&e<=this._getHighestSelectableIndex()};l.prototype.isIndexSelected=function(e){return this.getSelectedIndices().indexOf(e)!==-1};l.prototype.removeSelectionInterval=function(e,t){if(this.oSelectionModel){this.oSelectionModel.removeSelectionInterval(e,t)}};l.prototype.selectAll=function(){if(!this.oSelectionModel||this.getSelectionMode()!==n.MultiToggle){return}this.oSelectionModel.selectAll(this._getHighestSelectableIndex())};l.prototype.setSelectedIndex=function(e){if(this.getSelectionMode()===n.None){return}if(e===-1){this.clearSelection()}else{this.setSelectionInterval(e,e)}};l.prototype.setSelectionInterval=function(e,t){if(!this.oSelectionModel||this.getSelectionMode()===n.None){return}this.oSelectionModel.setSelectionInterval(e,t)};l.prototype.setSelectionMode=function(e){const t=this.getSelectionMode();this.setProperty("selectionMode",e);if(this.getSelectionMode()!==t){this.clearSelection()}if(this.oSelectionModel){this.oSelectionModel.setSelectionMode(r(this.getSelectionMode()))}return this};function r(t){return t===n.MultiToggle?e.MULTI_SELECTION:e.SINGLE_SELECTION}l.prototype._getHighestSelectableIndex=function(){const e=this.getControl().getBinding();return e?e.getLength()-1:-1};function c(e){h(this,e)}function d(){this._bSuppressSelectionChangeEvent=true;this.clearSelection();delete this._bSuppressSelectionChangeEvent}function a(e){const t=e.getParameter("rowIndices");const o=e.getParameter("selectAll");if(!this._bSuppressSelectionChangeEvent){this.fireSelectionChange({rowIndices:t,selectAll:o,_internalTrigger:this._bInternalTrigger})}}function h(e,t){t?.attachChange(S,e)}function g(e,t){t?.detachChange(S,e)}function S(e){const t=typeof e==="object"?e.getParameter("reason"):e;if(t==="sort"||t==="filter"){this._bInternalTrigger=true;this.clearSelection();delete this._bInternalTrigger}}function u(){const e=this.getControl()._getTotalRowCount();if(this._iTotalRowCount>0&&this._iTotalRowCount!==e){this._bInternalTrigger=true;this.clearSelection();delete this._bInternalTrigger}this._iTotalRowCount=e}return l});
/*
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/plugins/SelectionPlugin", ["./PluginBase"],function(e){"use strict";const t=e.extend("sap.ui.table.plugins.SelectionPlugin",{metadata:{abstract:true,library:"sap.ui.table",properties:{enabled:{type:"boolean",defaultValue:true}},events:{selectionChange:{}}}});t.findOn=e.findOn;t.prototype.exit=function(){e.prototype.exit.apply(this,arguments);this.getParent()?._onSelectionPluginChange()};t.prototype.setParent=function(t){const n=this.getParent();e.prototype.setParent.apply(this,arguments);n?._onSelectionPluginChange();if(n!==t){t?._onSelectionPluginChange()}return this};t.prototype.getRenderConfig=function(){return{headerSelector:{type:"none"}}};t.prototype.onHeaderSelectorPress=function(){};t.prototype.onKeyboardShortcut=function(e,t){};t.prototype.setSelected=function(e,t,n){throw new Error(this+" does not implement #setSelected")};t.prototype.isSelected=function(e){throw new Error(this+" does not implement #isSelected")};t.prototype.getSelectedCount=function(){throw new Error(this+" does not implement #getSelectedCount")};return t});
/*
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/plugins/V4Aggregation", ["./PluginBase","../utils/TableUtils"],function(e,t){"use strict";const o=e.extend("sap.ui.table.plugins.V4Aggregation",{metadata:{library:"sap.ui.table",properties:{enabled:{type:"boolean",defaultValue:true},groupHeaderFormatter:{type:"function"}}}});o.findOn=e.findOn;o.prototype.isApplicable=function(t){return e.prototype.isApplicable.apply(this,arguments)&&t.getMetadata().getName()==="sap.ui.table.Table"};o.prototype.onActivate=function(e){n(e.getBinding());t.Grouping.setToDefaultGroupMode(e);t.Hook.register(e,t.Hook.Keys.Table.RowsBound,n);t.Hook.register(e,t.Hook.Keys.Row.UpdateState,i,this);t.Hook.register(e,t.Hook.Keys.Row.Expand,s,this);t.Hook.register(e,t.Hook.Keys.Row.Collapse,r,this)};o.prototype.onDeactivate=function(e){for(const t of e.getColumns()){t._setCellContentVisibilitySettings()}t.Grouping.setToDefaultFlatMode(e);t.Hook.deregister(e,t.Hook.Keys.Table.RowsBound,n);t.Hook.deregister(e,t.Hook.Keys.Row.UpdateState,this.updateRowState,this);t.Hook.deregister(this,t.Hook.Keys.Row.Expand,s,this);t.Hook.deregister(this,t.Hook.Keys.Row.Collapse,r,this)};o.prototype.declareColumnsHavingTotals=function(e){const t=this.getControl()?.getColumns()??[];for(const o of t){const t=e.includes(o);o._setCellContentVisibilitySettings({groupHeader:t,summary:t})}};function n(e){if(!e){return}if(!e.getModel().isA("sap.ui.model.odata.v4.ODataModel")){throw new Error("Model must be sap.ui.model.odata.v4.ODataModel")}}function i(e){const t=e.context.getProperty("@$ui5.node.level");const o=e.context.getProperty("@$ui5.node.isTotal");const n=e.context.getProperty("@$ui5.node.isExpanded")===undefined;const i=t===0&&o;const s=t>0&&!n;const r=!s&&o;e.level=t;e.expandable=s;e.expanded=e.context.getProperty("@$ui5.node.isExpanded")===true;if(i||r){e.type=e.Type.Summary;e.level=t+1}else if(s){e.type=e.Type.GroupHeader}if(s){const o=e.context.getBinding().getAggregation().groupLevels[t-1];const n=this.getGroupHeaderFormatter();if(n){const t=n(e.context,o);if(typeof t!=="string"){throw new Error("The group header title must be a string")}e.title=t}else{e.title=e.context.getProperty(o,true)}}}function s(e){const t=e.getRowBindingContext();if(t){t.expand()}}function r(e){const t=e.getRowBindingContext();if(t){t.collapse()}}return o});
/*
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/rowmodes/Auto", ["../utils/TableUtils","./RowMode","sap/ui/Device","sap/ui/thirdparty/jquery"],function(t,e,o,jQuery){"use strict";const i=t.createWeakMapFacade();const s=e.extend("sap.ui.table.rowmodes.Auto",{metadata:{library:"sap.ui.table",properties:{minRowCount:{type:"int",defaultValue:5,group:"Appearance"},maxRowCount:{type:"int",defaultValue:-1,group:"Appearance"},fixedTopRowCount:{type:"int",defaultValue:0,group:"Appearance"},fixedBottomRowCount:{type:"int",defaultValue:0,group:"Appearance"},rowContentHeight:{type:"int",defaultValue:0,group:"Appearance"},hideEmptyRows:{type:"boolean",defaultValue:false,group:"Appearance",visibility:"hidden"}}},constructor:function(t){Object.defineProperty(this,"bLegacy",{value:typeof t==="boolean"?t:false});e.apply(this,arguments)}});const n={};function a(t){const e=t.getTable();const i=e?e.getDomRef("tableCCnt"):null;if(i&&o.browser.chrome&&window.devicePixelRatio!==1){const e=document.createElement("table");const o=e.insertRow();const s=t.getRowContentHeight();e.classList.add("sapUiTableCtrl");o.classList.add("sapUiTableTr");if(s>0){o.style.height=t.getBaseRowHeightOfTable()+"px"}i.appendChild(e);const n=o.getBoundingClientRect().height;i.removeChild(e);return n}else{return t.getBaseRowHeightOfTable()}}s.prototype.init=function(){e.prototype.init.apply(this,arguments);i(this).iPendingStartTableUpdateSignals=0;i(this).bRowCountAutoAdjustmentActive=false;i(this).iLastAvailableSpace=0;i(this).rowCount=-1;i(this).bTableIsFlexItem=false;i(this).adjustRowCountToAvailableSpaceAsync=t.throttleFrameWise(this.adjustRowCountToAvailableSpace.bind(this))};s.prototype.attachEvents=function(){e.prototype.attachEvents.apply(this,arguments);t.addDelegate(this.getTable(),n,this)};s.prototype.detachEvents=function(){e.prototype.detachEvents.apply(this,arguments);t.removeDelegate(this.getTable(),n)};s.prototype.cancelAsyncOperations=function(){e.prototype.cancelAsyncOperations.apply(this,arguments);this.stopAutoRowMode()};s.prototype.registerHooks=function(){e.prototype.registerHooks.apply(this,arguments);t.Hook.register(this.getTable(),t.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this);t.Hook.register(this.getTable(),t.Hook.Keys.Table.UpdateSizes,this._onUpdateTableSizes,this)};s.prototype.deregisterHooks=function(){e.prototype.deregisterHooks.apply(this,arguments);t.Hook.deregister(this.getTable(),t.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this);t.Hook.deregister(this.getTable(),t.Hook.Keys.Table.UpdateSizes,this._onUpdateTableSizes,this)};s.prototype.getFixedTopRowCount=function(){if(this.bLegacy){const t=this.getTable();return t?t.getFixedRowCount():0}return this.getProperty("fixedTopRowCount")};s.prototype.getFixedBottomRowCount=function(){if(this.bLegacy){const t=this.getTable();return t?t.getFixedBottomRowCount():0}return this.getProperty("fixedBottomRowCount")};s.prototype.getMinRowCount=function(){if(this.bLegacy){const t=this.getTable();return t?t.getMinAutoRowCount():0}return this.getProperty("minRowCount")};s.prototype.getRowContentHeight=function(){if(this.bLegacy){const t=this.getTable();return t?t.getRowHeight():0}return this.getProperty("rowContentHeight")};s.prototype.setHideEmptyRows=function(t){this.setProperty("hideEmptyRows",t);if(t){this.disableNoData()}else{this.enableNoData()}return this};s.prototype.getHideEmptyRows=function(){return this.getProperty("hideEmptyRows")};s.prototype._getMinRowCount=function(){const t=this.getMinRowCount();const e=this.getMaxRowCount();if(e>=0){return Math.min(t,e)}else{return t}};s.prototype.getMinRequestLength=function(){const e=this.getTable();let i=this.getConfiguredRowCount();if(u(this)||e&&!e._bContextsAvailable){const e=Math.ceil(o.resize.height/t.DefaultRowHeight.sapUiSizeCondensed);i=Math.max(i,e)}return i};s.prototype.updateTable=function(){if(this.getHideEmptyRows()&&this.getComputedRowCounts().count===0){const t=this.getConfiguredRowCount();if(t>0){this.getRowContexts(t)}}return e.prototype.updateTable.apply(this,arguments)};s.prototype.getComputedRowCounts=function(){if(u(this)){return{count:0,scrollable:0,fixedTop:0,fixedBottom:0}}let t=this.getConfiguredRowCount();const e=this.getFixedTopRowCount();const o=this.getFixedBottomRowCount();if(this.getHideEmptyRows()){t=Math.min(t,this.getTotalRowCountOfTable())}return this.computeStandardizedRowCounts(t,e,o)};s.prototype.getTableStyles=function(){let t="0px";if(u(this)){t="auto"}else{const e=this.getConfiguredRowCount();if(e===0||e===this._getMinRowCount()){t="auto"}}return{height:t}};s.prototype.getTableBottomPlaceholderStyles=function(){if(!this.getHideEmptyRows()){return undefined}let t;if(u(this)){t=this._getMinRowCount()}else{t=this.getConfiguredRowCount()-this.getComputedRowCounts().count}return{height:t*this.getBaseRowHeightOfTable()+"px"}};s.prototype.getRowContainerStyles=function(){return{height:this.getComputedRowCounts().count*Math.max(this.getBaseRowHeightOfTable(),a(this))+"px"}};s.prototype.renderRowStyles=function(t){const e=this.getRowContentHeight();if(e>0){t.style("height",this.getBaseRowHeightOfTable()+"px")}};s.prototype.renderCellContentStyles=function(t){let e=this.getRowContentHeight();if(this.bLegacy){if(e>0){t.style("max-height",e+"px")}return}if(e<=0){e=this.getDefaultRowContentHeightOfTable()}if(e>0){t.style("max-height",e+"px")}};s.prototype.getBaseRowContentHeight=function(){return Math.max(0,this.getRowContentHeight())};s.prototype._onTableRefreshRows=function(){const t=this.getConfiguredRowCount();if(t>0){if(!u(this)){this.initTableRowsAfterDataRequested(t)}this.getRowContexts(t)}};s.prototype.getConfiguredRowCount=function(){let t=Math.max(0,this.getMinRowCount(),i(this).rowCount);const e=this.getMaxRowCount();if(e>=0){t=Math.min(t,e)}return t};s.prototype.startAutoRowMode=function(){i(this).adjustRowCountToAvailableSpaceAsync(t.RowsUpdateReason.Render,true)};s.prototype.stopAutoRowMode=function(){this.deregisterResizeHandler();i(this).adjustRowCountToAvailableSpaceAsync.cancel();i(this).bRowCountAutoAdjustmentActive=false;l(this)};s.prototype.registerResizeHandler=function(e){const o=this.getTable();if(o){t.registerResizeHandler(o,"AutoRowMode",this.onResize.bind(this),null,e===true);t.registerResizeHandler(o,"AutoRowMode-BeforeTable",this.onResize.bind(this),"before");t.registerResizeHandler(o,"AutoRowMode-AfterTable",this.onResize.bind(this),"after")}};s.prototype.deregisterResizeHandler=function(){const e=this.getTable();if(e){t.deregisterResizeHandler(e,["AutoRowMode, AutoRowMode-BeforeTable, AutoRowMode-AfterTable"])}};s.prototype.onResize=function(e){const o=e.oldSize.height;const s=e.size.height;if(o!==s){r(this);i(this).adjustRowCountToAvailableSpaceAsync(t.RowsUpdateReason.Resize)}};s.prototype._onUpdateTableSizes=function(e){if(e===t.RowsUpdateReason.Resize||e===t.RowsUpdateReason.Render){return}if(i(this).bRowCountAutoAdjustmentActive){r(this);i(this).adjustRowCountToAvailableSpaceAsync(e)}};s.prototype.adjustRowCountToAvailableSpace=function(e,o){o=o===true;const s=this.getTable();const n=s?s.getDomRef():null;if(!s||s._bInvalid||!n||!t.isThemeApplied()){l(this);return}i(this).bTableIsFlexItem=window.getComputedStyle(n.parentNode).display==="flex";if(n.scrollHeight===0){if(o){this.registerResizeHandler(!i(this).bTableIsFlexItem);i(this).bRowCountAutoAdjustmentActive=true}l(this);return}const r=this.determineAvailableSpace();const u=this.getConfiguredRowCount();const h=Math.floor(r/a(this));const p=this.getComputedRowCounts().count;i(this).rowCount=h;const g=this.getComputedRowCounts().count;if(this.bLegacy){s.setProperty("visibleRowCount",g,true)}if(p!==g){this.updateTable(e)}else{if(u!==h||e===t.RowsUpdateReason.Zoom){this.applyTableStyles();this.applyRowContainerStyles();this.applyTableBottomPlaceholderStyles()}if(!this._bFiredRowsUpdatedAfterRendering&&s.getRows().length>0){this.fireRowsUpdated(e)}}if(o){this.registerResizeHandler(!i(this).bTableIsFlexItem);i(this).bRowCountAutoAdjustmentActive=true}l(this)};s.prototype.determineAvailableSpace=function(){const t=this.getTable();const e=t?t.getDomRef():null;const s=t?t.getDomRef("tableCCnt"):null;const n=t?t.getDomRef("placeholder-bottom"):null;if(!e||!s||!e.parentNode){return 0}let a=0;const r=s.clientHeight;const l=n?n.clientHeight:0;if(i(this).bTableIsFlexItem){const t=e.childNodes;for(let e=0;e<t.length;e++){a+=t[e].offsetHeight}a-=r-l}else{a=e.scrollHeight-r-l}const u=t._getScrollExtension();if(!u.isHorizontalScrollbarVisible()){const t={};t[o.browser.BROWSER.CHROME]=16;t[o.browser.BROWSER.FIREFOX]=16;t[o.browser.BROWSER.SAFARI]=16;t[o.browser.BROWSER.ANDROID]=8;a+=t[o.browser.name]}const h=i(this).bTableIsFlexItem?e:e.parentNode;const p=Math.max(0,Math.floor(jQuery(h).height()-a));const g=Math.abs(p-i(this).iLastAvailableSpace);if(g>=5){i(this).iLastAvailableSpace=p}return i(this).iLastAvailableSpace};n.onBeforeRendering=function(t){const e=t&&t.isMarked("renderRows");if(!e){this.stopAutoRowMode()}};n.onAfterRendering=function(t){const e=t&&t.isMarked("renderRows");if(!e){this.startAutoRowMode()}};function r(e){i(e).iPendingStartTableUpdateSignals++;t.Hook.call(e.getTable(),t.Hook.Keys.Signal,"StartTableUpdate")}function l(e){for(let o=0;o<i(e).iPendingStartTableUpdateSignals;o++){t.Hook.call(e.getTable(),t.Hook.Keys.Signal,"EndTableUpdate")}i(e).iPendingStartTableUpdateSignals=0}function u(t){return i(t).rowCount===-1}return s});
/*
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/rowmodes/Fixed", ["./RowMode","../utils/TableUtils"],function(t,e){"use strict";const o=t.extend("sap.ui.table.rowmodes.Fixed",{metadata:{library:"sap.ui.table",properties:{rowCount:{type:"int",defaultValue:10,group:"Appearance"},fixedTopRowCount:{type:"int",defaultValue:0,group:"Appearance"},fixedBottomRowCount:{type:"int",defaultValue:0,group:"Appearance"},rowContentHeight:{type:"int",defaultValue:0,group:"Appearance"},hideEmptyRows:{type:"boolean",defaultValue:false,group:"Appearance",visibility:"hidden"}}},constructor:function(e){Object.defineProperty(this,"bLegacy",{value:typeof e==="boolean"?e:false});t.apply(this,arguments)}});const i={};o.prototype.attachEvents=function(){t.prototype.attachEvents.apply(this,arguments);e.addDelegate(this.getTable(),i,this)};o.prototype.detachEvents=function(){t.prototype.detachEvents.apply(this,arguments);e.removeDelegate(this.getTable(),i)};o.prototype.registerHooks=function(){t.prototype.registerHooks.apply(this,arguments);e.Hook.register(this.getTable(),e.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this)};o.prototype.deregisterHooks=function(){t.prototype.deregisterHooks.apply(this,arguments);e.Hook.deregister(this.getTable(),e.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this)};o.prototype.getRowCount=function(){if(this.bLegacy){const t=this.getTable();return t?t.getVisibleRowCount():0}return this.getProperty("rowCount")};o.prototype.getFixedTopRowCount=function(){if(this.bLegacy){const t=this.getTable();return t?t.getFixedRowCount():0}return this.getProperty("fixedTopRowCount")};o.prototype.getFixedBottomRowCount=function(){if(this.bLegacy){const t=this.getTable();return t?t.getFixedBottomRowCount():0}return this.getProperty("fixedBottomRowCount")};o.prototype.getRowContentHeight=function(){if(this.bLegacy){const t=this.getTable();return t?t.getRowHeight():0}return this.getProperty("rowContentHeight")};o.prototype.setHideEmptyRows=function(t){this.setProperty("hideEmptyRows",t);if(t){this.disableNoData()}else{this.enableNoData()}return this};o.prototype.getHideEmptyRows=function(){return this.getProperty("hideEmptyRows")};o.prototype.getMinRequestLength=function(){return Math.max(0,this.getRowCount())};o.prototype.updateTable=function(){if(this.getHideEmptyRows()&&this.getComputedRowCounts().count===0){const t=this.getRowCount();if(t>0){this.getRowContexts(t)}}return t.prototype.updateTable.apply(this,arguments)};o.prototype.getComputedRowCounts=function(){let t=this.getRowCount();const e=this.getFixedTopRowCount();const o=this.getFixedBottomRowCount();if(this.getHideEmptyRows()){t=Math.min(t,this.getTotalRowCountOfTable())}return this.computeStandardizedRowCounts(t,e,o)};o.prototype.getTableStyles=function(){return{height:"auto"}};o.prototype.getTableBottomPlaceholderStyles=function(){if(!this.getHideEmptyRows()){return undefined}const t=Math.max(0,this.getRowCount()-this.getComputedRowCounts().count);return{height:t*this.getBaseRowHeightOfTable()+"px"}};o.prototype.getRowContainerStyles=function(){const t=this.getComputedRowCounts().count*this.getBaseRowHeightOfTable()+"px";if(this.bLegacy&&!e.isVariableRowHeightEnabled(this.getTable())){return{minHeight:t}}return{height:t}};o.prototype.renderRowStyles=function(t){const e=this.getRowContentHeight();if(e>0){t.style("height",this.getBaseRowHeightOfTable()+"px")}};o.prototype.renderCellContentStyles=function(t){let e=this.getRowContentHeight();if(this.bLegacy){return}if(e<=0){e=this.getDefaultRowContentHeightOfTable()}if(e>0){t.style("max-height",e+"px")}};o.prototype.getBaseRowContentHeight=function(){return Math.max(0,this.getRowContentHeight())};o.prototype._onTableRefreshRows=function(){let t=this.getRowCount();if(t>0){if(e.isVariableRowHeightEnabled(this.getTable())){t++}this.initTableRowsAfterDataRequested(t);this.getRowContexts(t)}};i.onAfterRendering=function(t){const o=this.getTable();const i=t&&t.isMarked("renderRows");if(!i&&o.getRows().length>0){this.fireRowsUpdated(e.RowsUpdateReason.Render)}};return o});
/*
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/rowmodes/Interactive", ["./RowMode","../utils/TableUtils","sap/ui/Device","sap/m/Menu","sap/m/MenuItem","sap/ui/core/InvisibleMessage"],function(t,e,o,n,i,s){"use strict";const a=e.createWeakMapFacade();const r=t.extend("sap.ui.table.rowmodes.Interactive",{metadata:{library:"sap.ui.table",final:true,properties:{rowCount:{type:"int",defaultValue:10,group:"Appearance"},minRowCount:{type:"int",defaultValue:5,group:"Appearance"},maxRowCount:{type:"int",defaultValue:-1,group:"Appearance"},fixedTopRowCount:{type:"int",defaultValue:0,group:"Appearance"},fixedBottomRowCount:{type:"int",defaultValue:0,group:"Appearance"},rowContentHeight:{type:"int",defaultValue:0,group:"Appearance"}}},constructor:function(e){Object.defineProperty(this,"bLegacy",{value:typeof e==="boolean"?e:false});t.apply(this,arguments)}});const u={};const g={};function h(t){a(this).rowCount=t;s.getInstance().announce(e.getResourceText("TBL_RSZ_RESIZED",[t]))}r.prototype.attachEvents=function(){t.prototype.attachEvents.apply(this,arguments);e.addDelegate(this.getTable(),u,this)};r.prototype.detachEvents=function(){t.prototype.detachEvents.apply(this,arguments);e.removeDelegate(this.getTable(),u)};r.prototype.registerHooks=function(){t.prototype.registerHooks.apply(this,arguments);e.Hook.register(this.getTable(),e.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this)};r.prototype.deregisterHooks=function(){t.prototype.deregisterHooks.apply(this,arguments);e.Hook.deregister(this.getTable(),e.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this)};r.prototype.getRowCount=function(){if(this.bLegacy){const t=this.getTable();return t?t.getVisibleRowCount():0}return this.getProperty("rowCount")};r.prototype.getFixedTopRowCount=function(){if(this.bLegacy){const t=this.getTable();return t?t.getFixedRowCount():0}return this.getProperty("fixedTopRowCount")};r.prototype.getFixedBottomRowCount=function(){if(this.bLegacy){const t=this.getTable();return t?t.getFixedBottomRowCount():0}return this.getProperty("fixedBottomRowCount")};r.prototype.getMinRowCount=function(){if(this.bLegacy){const t=this.getTable();return t?t.getMinAutoRowCount():0}return this.getProperty("minRowCount")};r.prototype.getRowContentHeight=function(){if(this.bLegacy){const t=this.getTable();return t?t.getRowHeight():0}return this.getProperty("rowContentHeight")};r.prototype.getMinRequestLength=function(){return this.getActualRowCount()};r.prototype.getComputedRowCounts=function(){const t=this.getActualRowCount();const e=this.getFixedTopRowCount();const o=this.getFixedBottomRowCount();return this.computeStandardizedRowCounts(t,e,o)};r.prototype.getTableStyles=function(){return{height:"auto"}};r.prototype.getRowContainerStyles=function(){const t=this.getComputedRowCounts().count*this.getBaseRowHeightOfTable()+"px";if(this.bLegacy&&!e.isVariableRowHeightEnabled(this.getTable())){return{minHeight:t}}return{height:t}};r.prototype.renderRowStyles=function(t){const e=this.getRowContentHeight();if(e>0){t.style("height",this.getBaseRowHeightOfTable()+"px")}};r.prototype.renderCellContentStyles=function(t){let e=this.getRowContentHeight();if(this.bLegacy){return}if(e<=0){e=this.getDefaultRowContentHeightOfTable()}if(e>0){t.style("max-height",e+"px")}};r.prototype.renderInTableBottomArea=function(t){const o=this.getTable();t.openStart("div",o.getId()+"-heightResizer").attr("role","separator").attr("aria-orientation","horizontal").attr("title",e.getResourceText("TBL_RSZ_BTN_TOOLTIP")).attr("tabindex","0").attr("aria-valuemin",this.getMinRowCount()).attr("aria-valuenow",this.getActualRowCount()).class("sapUiTableHeightResizer");const n=o.getAriaLabelledBy();if(n.length){t.attr("aria-labelledby",n.join(" "))}t.openEnd();t.openStart("div").class("sapUiTableHeightResizerDecorationBefore").openEnd().close("div");t.openStart("div").attr("role","presentation").class("sapUiTableHeightResizerGrip").openEnd().icon("sap-icon://horizontal-grip",["sapUiTableHeightResizerGripIcon"]).close("div");t.openStart("div").class("sapUiTableHeightResizerDecorationAfter").openEnd().close("div");t.close("div")};r.prototype.getBaseRowContentHeight=function(){return Math.max(0,this.getRowContentHeight())};r.prototype._onTableRefreshRows=function(){const t=this.getActualRowCount();if(t>0){this.initTableRowsAfterDataRequested(t);this.getRowContexts(t)}};r.prototype.getActualRowCount=function(){return Math.max(0,this.getMinRowCount(),a(this).rowCount||this.getRowCount())};r.prototype._getMaxRowCount=function(){const t=this.getMaxRowCount();const e=this.getMinRowCount();if(t>=0){return Math.max(t,e)}const o=this._determineAvailableSpace();return Math.max(Math.floor(o/this.getBaseRowHeightOfTable()),e)};r.prototype._determineAvailableSpace=function(){const t=this.getTable();const e=t.getDomRef();const n=t.getDomRef("tableCCnt");const i=o.resize.height;if(!e||!n){return 0}return Math.max(0,Math.floor(i-e.getBoundingClientRect().height+n.getBoundingClientRect().height))};r.prototype.setRowCount=function(t){this.setProperty("rowCount",t);h.call(this,t);return this};r.prototype.updateTable=function(e){this.getTable().getDomRef("heightResizer")?.setAttribute("aria-valuenow",this.getActualRowCount());t.prototype.updateTable.apply(this,arguments)};u.onBeforeRendering=function(t){if(this.bLegacy){this.getTable().setVisibleRowCount(this.getComputedRowCounts().count)}};u.onAfterRendering=function(t){const o=this.getTable();const n=t&&t.isMarked("renderRows");if(!n&&o.getRows().length>0){this.fireRowsUpdated(e.RowsUpdateReason.Render)}const i=o.getDomRef("heightResizer");i.setAttribute("aria-valuemax",this._getMaxRowCount())};u.onmousedown=function(t){const e=this.getTable();if(t.button===0&&e.getDomRef("heightResizer").contains(t.target)){g.initResizing(e,this,t)}};u.oncontextmenu=function(t){const e=this.getTable();const o=e.getDomRef("heightResizer");if(o.contains(t.target)){t.preventDefault();o.classList.add("sapUiTableHeightResizerActive");g.openContextMenu(e,this,t)}};u.onkeydown=function(t){const o=this.getTable();if(t.target===o.getDomRef("heightResizer")){switch(t.key){case"ArrowUp":t.preventDefault();h.call(this,Math.max(this.getActualRowCount()-1,this.getMinRowCount()));this.updateTable(e.RowsUpdateReason.Render);break;case"ArrowDown":t.preventDefault();h.call(this,Math.min(this.getActualRowCount()+1,this._getMaxRowCount()));this.updateTable(e.RowsUpdateReason.Render);break;case"Home":t.preventDefault();h.call(this,this.getMinRowCount());this.updateTable(e.RowsUpdateReason.Render);break;case"End":t.preventDefault();h.call(this,this._getMaxRowCount());this.updateTable(e.RowsUpdateReason.Render);break;default:}}};u.ondblclick=function(t){if(!this.getTable().getDomRef("heightResizer").contains(t.target)){return}const o=this.getActualRowCount();if(o===this._getMaxRowCount()){h.call(this,this.getMinRowCount())}else if(o===this.getMinRowCount()){h.call(this,this.getRowCount())}else{h.call(this,this._getMaxRowCount())}this.updateTable(e.RowsUpdateReason.Render)};g.initResizing=function(t,e,o){t._disableTextSelection();g._oTable=t;g._iResizerStartPos=o.pageY;document.addEventListener("touchend",g.onResizingEnd.bind(t,e),{once:true});document.addEventListener("touchmove",g.onResizerMove);document.addEventListener("mouseup",g.onResizingEnd.bind(t,e),{once:true});document.addEventListener("mousemove",g.onResizerMove);const n=t.getDomRef("heightResizer");n.classList.add("sapUiTableHeightResizerActive");n.style.top="0"};g.onResizerMove=function(t){const e=t.pageY-g._iResizerStartPos;g._oTable.getDomRef("heightResizer").style.top=e+"px"};g.onResizingEnd=function(t,o){const n=e.getEventPosition(o,this).y;const i=this.getDomRef("tableCCnt").getBoundingClientRect().top;const s=this.getDomRef().querySelector(".sapUiTableFtr");const a=s?s.getBoundingClientRect().height:0;const r=n-i-a;const u=Math.floor(r/t.getBaseRowHeightOfTable());let R=Math.max(0,u,t.getMinRowCount());const c=t._getMaxRowCount();if(c>0){R=Math.min(R,c)}if(t.bLegacy){R=Math.max(R,t.getFixedTopRowCount()+t.getFixedBottomRowCount()+1);this.setVisibleRowCount(R)}h.call(t,R);t.updateTable(e.RowsUpdateReason.Render);document.removeEventListener("touchmove",g.onResizerMove);document.removeEventListener("mousemove",g.onResizerMove);const p=this.getDomRef("heightResizer");p.classList.remove("sapUiTableHeightResizerActive");p.style.top="";this._enableTextSelection()};g.openContextMenu=function(t,o,s){if(!g._oContextMenu){g._oContextMenu=new n({items:[new i({text:e.getResourceText("TBL_RSZ_ROW_UP"),shortcutText:e.getResourceText("TBL_RSZ_ROW_UP_SHORTCUT"),press:function(){const t=o.getActualRowCount();a(o).rowCount=Math.max(t-1,o.getMinRowCount());o.updateTable(e.RowsUpdateReason.Render)}}),new i({text:e.getResourceText("TBL_RSZ_ROW_DOWN"),shortcutText:e.getResourceText("TBL_RSZ_ROW_DOWN_SHORTCUT"),press:function(){const t=o.getActualRowCount();a(o).rowCount=Math.min(t+1,o._getMaxRowCount());o.updateTable(e.RowsUpdateReason.Render)}}),new i({text:e.getResourceText("TBL_RSZ_MINIMIZE"),shortcutText:e.getResourceText("TBL_RSZ_MINIMIZE_SHORTCUT"),press:function(){a(o).rowCount=o.getMinRowCount();o.updateTable(e.RowsUpdateReason.Render)}}),new i({text:e.getResourceText("TBL_RSZ_MAXIMIZE"),shortcutText:e.getResourceText("TBL_RSZ_MAXIMIZE_SHORTCUT"),press:function(){a(o).rowCount=o._getMaxRowCount();o.updateTable(e.RowsUpdateReason.Render)}})],closed:function(){t.getDomRef("heightResizer").classList.remove("sapUiTableHeightResizerActive")}});g._oContextMenu.openAsContextMenu(s,t.getDomRef("heightResizer"))}else{g._oContextMenu.openAsContextMenu(s,t.getDomRef("heightResizer"))}};return r});
/*
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/rowmodes/RowMode", ["../utils/TableUtils","sap/ui/core/Element","sap/ui/core/RenderManager","sap/ui/thirdparty/jquery","sap/ui/Device"],function(e,t,o,jQuery,n){"use strict";const s=e.createWeakMapFacade();const i=t.extend("sap.ui.table.rowmodes.RowMode",{metadata:{library:"sap.ui.table",abstract:true}});const r={};i.prototype.init=function(){this._bFiredRowsUpdatedAfterRendering=false;s(this).bListeningForFirstRowsUpdatedAfterRendering=false;s(this).bNoDataDisabled=false;s(this).updateTableAsync=e.throttle(this.updateTable.bind(this),50,{asyncLeading:true})};i.prototype.exit=function(){this.detachEvents();this.cancelAsyncOperations();this.deregisterHooks()};i.prototype.setParent=function(){this.detachEvents();this.cancelAsyncOperations();this.deregisterHooks();t.prototype.setParent.apply(this,arguments);this.attachEvents();this.registerHooks()};i.prototype.attachEvents=function(){e.addDelegate(this.getTable(),r,this)};i.prototype.detachEvents=function(){e.removeDelegate(this.getTable(),r)};i.prototype.cancelAsyncOperations=function(){const e=this.getTable();if(e){clearTimeout(e._mTimeouts.refreshRowsCreateRows)}s(this).updateTableAsync.cancel()};i.prototype.registerHooks=function(){const t=this.getTable();const o=e.Hook.Keys;e.Hook.register(t,o.Table.RowsUnbound,this._onTableRowsUnbound,this);e.Hook.register(t,o.Table.UpdateRows,this._onTableUpdateRows,this);e.Hook.register(t,o.TableRenderer.RenderTableStyles,this.applyTableStyles,this);e.Hook.register(t,o.TableRenderer.RenderInTableBottomArea,this.renderInTableBottomArea,this);e.Hook.register(t,o.TableRenderer.RenderRowContainerStyles,this.applyRowContainerStyles,this);e.Hook.register(t,o.TableRenderer.RenderRowStyles,this.renderRowStyles,this);e.Hook.register(t,o.TableRenderer.RenderCellContentStyles,this.renderCellContentStyles,this)};i.prototype.deregisterHooks=function(){const t=this.getTable();const o=e.Hook.Keys;e.Hook.deregister(t,o.Table.RowsUnbound,this._onTableRowsUnbound,this);e.Hook.deregister(t,o.Table.UpdateRows,this._onTableUpdateRows,this);e.Hook.deregister(t,o.TableRenderer.RenderTableStyles,this.applyTableStyles,this);e.Hook.deregister(t,o.TableRenderer.RenderInTableBottomArea,this.renderInTableBottomArea,this);e.Hook.deregister(t,o.TableRenderer.RenderRowContainerStyles,this.applyRowContainerStyles,this);e.Hook.deregister(t,o.TableRenderer.RenderRowStyles,this.renderRowStyles,this);e.Hook.deregister(t,o.TableRenderer.RenderCellContentStyles,this.renderCellContentStyles,this)};i.prototype.getMinRequestLength=function(){d(this,"getMinRequestLength")};i.prototype.getComputedRowCounts=function(){d(this,"getComputedRowCounts")};i.prototype.getTableStyles=function(){d(this,"getTableStyles")};i.prototype.getTableBottomPlaceholderStyles=function(){return undefined};i.prototype.getRowContainerStyles=function(){d(this,"getRowContainerStyles")};i.prototype.getTable=function(){const t=this.getParent();return e.isA(t,"sap.ui.table.Table")?t:null};i.prototype.updateTable=function(e){const t=this.getTable();if(!t){return}s(this).updateTableAsync.cancel();t._adjustFirstVisibleRowToTotalRowCount();const o=this.updateTableRows();if(t._bInvalid){return}this.applyTableStyles();this.applyRowContainerStyles();this.applyTableBottomPlaceholderStyles();if(o||t.getRows().some(function(e){return e.getDomRef()==null})){this.renderTableRows()}if(o||t.getRows().length>0){this.fireRowsUpdated(e)}};i.prototype.getBaseRowContentHeight=function(){return 0};i.prototype.getBaseRowHeightOfTable=function(){const e=this.getTable();return e?e._getBaseRowHeight():0};i.prototype.getDefaultRowContentHeightOfTable=function(){const e=this.getTable();return e?e._getDefaultRowContentHeight():0};i.prototype.getTotalRowCountOfTable=function(){const e=this.getTable();return e?e._getTotalRowCount():0};i.prototype._onTableRowsUnbound=function(){clearTimeout(this.getTable()._mTimeouts.refreshRowsCreateRows);this.updateTable(e.RowsUpdateReason.Unbind)};i.prototype._onTableUpdateRows=function(e){const t=this.getTable();clearTimeout(t._mTimeouts.refreshRowsCreateRows);s(this).updateTableAsync(e)};i.prototype.applyTableStyles=function(e){const t=this.getTableStyles();if(e){e.style("height",t.height);e.style("min-height",t.minHeight);e.style("max-height",t.maxHeight);return}const o=this.getTable();const n=o?o.getDomRef():null;if(n){n.style.height=t.height;n.style.minHeight=t.minHeight;n.style.maxHeight=t.maxHeight}};i.prototype.applyTableBottomPlaceholderStyles=function(e){const t=this.getTableBottomPlaceholderStyles();if(e){e.style("height",t.height);return}const o=this.getTable();const n=o?o.getDomRef("placeholder-bottom"):null;if(n){n.style.height=t.height}};i.prototype.applyRowContainerStyles=function(e){const t=this.getRowContainerStyles();if(e){e.style("height",t.height);e.style("min-height",t.minHeight);e.style("max-height",t.maxHeight);return}const o=this.getTable();const n=o?o.getDomRef("tableCCnt"):null;if(n){n.style.height=t.height;n.style.minHeight=t.minHeight;n.style.maxHeight=t.maxHeight}};i.prototype.computeStandardizedRowCounts=function(e,t,o){const n=this.getRowCountConstraints();if(n.fixedTop===true){t=1}else if(n.fixedTop===false){t=0}if(n.fixedBottom===true){o=1}else if(n.fixedBottom===false){o=0}e=Math.max(0,e);t=Math.max(0,t);o=Math.max(0,o);if(t+o>=e){o=Math.max(o>0?1:0,o-Math.max(0,t+o-(e-1)));t=Math.max(t>0?1:0,t-Math.max(0,t+o-(e-1)))}if(t+o>=e){o=0}if(t+o>=e){t=0}return{count:e,scrollable:e-t-o,fixedTop:t,fixedBottom:o}};i.prototype.getRowCountConstraints=function(){const e=this.getTable();return e?e.getProperty("rowCountConstraints")||{}:{}};i.prototype.renderRowStyles=function(e){};i.prototype.renderCellContentStyles=function(e){};i.prototype.renderInTableBottomArea=function(e){const t=this.getTableBottomPlaceholderStyles();if(t===undefined){return}e.openStart("div",this.getTable().getId()+"-placeholder-bottom");e.class("sapUiTablePlaceholder");this.applyTableBottomPlaceholderStyles(e);e.openEnd();e.close("div")};i.prototype.initTableRowsAfterDataRequested=function(e){const t=this.getTable();const o=t.getBinding();clearTimeout(t._mTimeouts.refreshRowsCreateRows);if(!o||e<=0||t.getRows().length>0){return}o.attachEventOnce("dataRequested",function(){clearTimeout(t._mTimeouts.refreshRowsCreateRows);t._mTimeouts.refreshRowsCreateRows=setTimeout(function(){if(t.getRows().length>0){return}const o=l(t,e);let n;for(let e=0;e<o.length;e++){n=o[e];n.setRowBindingContext(null,t);t.addAggregation("rows",n,true)}t._bRowAggregationInvalid=false},0)})};i.prototype.updateTableRows=function(){const t=this.getTable();let o=t.getRows();let n=this.getComputedRowCounts().count;let s=false;if(e.isNoDataVisible(t)&&!t.getBinding()){n=0}else if(e.isVariableRowHeightEnabled(t)&&n>0){n++}const i=t.getDomRef("tableCCnt");const r=window.getSelection();if(i&&r.containsNode(i,true)){r.empty()}if(t._bRowAggregationInvalid){s=o.length>0;t.destroyAggregation("rows",t._bInvalid?"KeepDom":true);o=[]}if(n===o.length){h(this,o);return s}e.dynamicCall(t._getSyncExtension,function(e){e.syncRowCount(n)});a(this,n);s=true;t._bRowAggregationInvalid=false;return s};i.prototype.renderTableRows=function(){const e=this.getTable();const t=e?e.getDomRef("tableCCnt"):null;if(!t){return}const s=jQuery.Event("BeforeRendering");s.setMarked("renderRows");s.srcControl=e;e._handleEvent(s);const i=(new o).getInterface();const r=e.getRenderer();r.renderTableCCnt(i,e);i.flush(t,false,false);i.destroy();const a=jQuery.Event("AfterRendering");a.setMarked("renderRows");a.srcControl=e;e._handleEvent(a);const l=e.getRows().length>0;const h=e.getDomRef();h.querySelector(".sapUiTableCtrlBefore").setAttribute("tabindex",l?"0":"-1");h.querySelector(".sapUiTableCtrlAfter").setAttribute("tabindex",l?"0":"-1");if(n.browser.safari){const t=document.getElementById(e.getId()+"-header");const o=document.getElementById(e.getId()+"-table");o.style.width=t.style.width}};i.prototype.getRowContexts=function(e){const t=this.getTable();return t?t._getRowContexts(e):[]};i.prototype.fireRowsUpdated=function(t){const o=this.getTable();if(!o||!o._bContextsAvailable){return}if(!this._bFiredRowsUpdatedAfterRendering){t=e.RowsUpdateReason.Render;if(!s(this).bListeningForFirstRowsUpdatedAfterRendering){s(this).bListeningForFirstRowsUpdatedAfterRendering=true;o.attachEvent("_rowsUpdated",function(){this._bFiredRowsUpdatedAfterRendering=true;s(this).bListeningForFirstRowsUpdatedAfterRendering=false}.bind(this))}}o._fireRowsUpdated(t)};i.prototype.disableNoData=function(){if(this.isNoDataDisabled()){return}s(this).bNoDataDisabled=true;const e=this.getTable();if(e){e.invalidate()}};i.prototype.enableNoData=function(){if(!this.isNoDataDisabled()){return}s(this).bNoDataDisabled=false;const e=this.getTable();if(e){e.invalidate()}};i.prototype.isNoDataDisabled=function(){return s(this).bNoDataDisabled};function a(e,t){const o=e.getTable();let n=o.getRows();if(n.length<t){const s=l(o,t-n.length);n=n.concat(s);h(e,n);s.forEach(function(e){o.addAggregation("rows",e,true)})}else{for(let e=n.length-1;e>=t;e--){o.removeAggregation("rows",e,true)}n.splice(t);h(e,n)}}function l(e,t){const o=[];const n=e.getRows().length;for(let s=0;s<t;s++){o.push(e._getRowClone(n+s))}return o}function h(e,t){const o=e.getTable();if(!o||t.length===0){return}const n=e.getRowContexts(t.length);for(let e=0;e<t.length;e++){t[e].setRowBindingContext(n[e],o)}}function d(e,t){throw new Error(e+": sap.ui.table.rowmodes.RowMode subclass does not implement #"+t)}r.onBeforeRendering=function(t){const o=t&&t.isMarked("renderRows");if(!o){this._bFiredRowsUpdatedAfterRendering=false;this.updateTable(e.RowsUpdateReason.Render)}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/rowmodes/Type", ["sap/ui/base/DataType"],function(e){"use strict";const t={Fixed:"Fixed",Auto:"Auto",Interactive:"Interactive"};e.registerEnum("sap.ui.table.rowmodes.Type",t);return t});
/*
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/rowmodes/Variable", ["../library","./RowMode"],function(t,e){"use strict";const o=e.extend("sap.ui.table.rowmodes.Variable",{metadata:{library:"sap.ui.table",properties:{tableHeight:{type:"sap.ui.core.CSSSize",defaultValue:"100%",group:"Dimension"}}}});o.prototype.getComputedRowCounts=function(){const t=this.getTotalRowCountOfTable();const e=this.getHideEmptyRows()?Math.min(this.getRowCount(),t):this.getRowCount();return{count:e,fixedTopCount:this.getFixedTopRowCount(),fixedBottomCount:this.getFixedBottomRowCount()}};o.prototype.getTableHeight=function(){return{height:this.getTableHeight()}};o.prototype.getRowContainerHeight=function(){return{height:this.getComputedRowCounts().count*this.getBaseRowHeightOfTable()}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/utils/TableUtils", ["./_GroupingUtils","./_ColumnUtils","./_MenuUtils","./_BindingUtils","./_HookUtils","../library","sap/ui/base/Object","sap/ui/core/Element","sap/ui/core/ResizeHandler","sap/ui/core/theming/Parameters","sap/ui/core/Theming","sap/ui/core/Icon","sap/ui/core/Lib","sap/ui/core/InvisibleMessage","sap/ui/core/message/MessageType","sap/ui/model/ChangeReason","sap/ui/thirdparty/jquery","sap/base/util/restricted/_throttle","sap/base/Log"],function(e,t,n,o,i,s,l,a,r,u,c,d,f,g,p,C,jQuery,m,R){"use strict";const _=s.SelectionBehavior;const h=s.SelectionMode;let w=null;const I={DATACELL:1<<1,COLUMNHEADER:1<<2,ROWHEADER:1<<3,ROWACTION:1<<4,COLUMNROWHEADER:1<<5,ROWACTIONCOLUMNHEADER:1<<6,PSEUDO:1<<7};I.ANYCONTENTCELL=I.ROWHEADER|I.DATACELL|I.ROWACTION;I.ANYCOLUMNHEADER=I.COLUMNHEADER|I.COLUMNROWHEADER|I.ROWACTIONCOLUMNHEADER;I.ANYROWHEADER=I.ROWHEADER|I.COLUMNROWHEADER;I.ANY=I.ANYCONTENTCELL|I.ANYCOLUMNHEADER;const b={sapUiSizeCozy:48,sapUiSizeCompact:32,sapUiSizeCondensed:24,undefined:32};let T=1;let E=1;const S={sapUiSizeCozy:b.sapUiSizeCozy+E,sapUiSizeCompact:b.sapUiSizeCompact+E,sapUiSizeCondensed:b.sapUiSizeCondensed+E,undefined:b.undefined+E};const x={navigationIcon:"navigation-right-arrow",deleteIcon:"sys-cancel",clearSelectionIcon:"clear-all",allSelectedIcon:"complete",checkboxIcon:"border",navIndicatorWidth:3};const y={Render:"Render",VerticalScroll:"VerticalScroll",FirstVisibleRowChange:"FirstVisibleRowChange",Unbind:"Unbind",Animation:"Animation",Resize:"Resize",Zoom:"Zoom",Unknown:"Unknown"};for(const e in C){y[e]=C[e]}const A=":sapTabbable, .sapUiTableTreeIcon:not(.sapUiTableTreeIconLeaf)";const U={Grouping:e,Column:t,Menu:n,Binding:o,Hook:i,CELLTYPE:I,BaseSize:b,BaseBorderWidth:T,RowHorizontalFrameSize:E,DefaultRowHeight:S,RowsUpdateReason:y,INTERACTIVE_ELEMENT_SELECTORS:A,ThemeParameters:x,hasRowHeader:function(t){return t.getSelectionMode()!==h.None&&t.getSelectionBehavior()!==_.RowOnly||e.isInGroupMode(t)},hasSelectAll:function(e){const t=e?e.getSelectionMode():h.None;return t===h.MultiToggle&&e.getEnableSelectAll()},hasRowHighlights:function(e){if(!e){return false}const t=e.getRowSettingsTemplate();if(!t){return false}const n=t.getHighlight();return t.isBound("highlight")||n!=null&&n!==p.None},hasRowNavigationIndicators:function(e){if(!e){return false}const t=e.getRowSettingsTemplate();if(!t){return false}const n=t.getNavigated();return t.isBound("navigated")||n},hasRowActions:function(e){const t=e?e.getRowActionTemplate():null;return t!=null&&(t.isBound("visible")||t.getVisible())&&e.getRowActionCount()>0},isRowSelectionAllowed:function(e){return e.getSelectionMode()!==h.None&&(e.getSelectionBehavior()===_.Row||e.getSelectionBehavior()===_.RowOnly)},isRowSelectorSelectionAllowed:function(e){return e.getSelectionMode()!==h.None&&U.hasRowHeader(e)},isNoDataVisible:function(e){return!e._isNoDataDisabled()&&!U.hasData(e)||U.getVisibleColumnCount(e)===0},hasData:function(e){return e._getTotalRowCount()>0},isBusyIndicatorVisible:function(e){if(!e||!e.getDomRef()){return false}const t=e.getCreationRow()?"-sapUiTableGridCnt":"-sapUiTableCnt";return e.getDomRef().querySelector('[id="'+e.getId()+t+'"] > .sapUiLocalBusyIndicator')!=null},isA:function(e,t){return l.isObjectA(e,t)},toggleRowSelection:function(e,t,n,o){let i;if(U.isA(t,"sap.ui.table.Row")){i=t}else if(typeof t==="number"){i=e.getRows()[t]}else{const n=jQuery(t);const o=U.getCellInfo(n[0]);const s=U.isRowSelectionAllowed(e);if(!U.Grouping.isInGroupHeaderRow(n[0])&&(o.isOfType(U.CELLTYPE.DATACELL|U.CELLTYPE.ROWACTION)&&s||o.isOfType(U.CELLTYPE.ROWHEADER)&&U.isRowSelectorSelectionAllowed(e))){i=e.getRows()[o.rowIndex]}}if(!i||i.isEmpty()){return}e._iSourceRowIndex=i.getIndex();if(o){o(i)}else{i._setSelected(n??!i._isSelected())}delete e._iSourceRowIndex},getNoContentMessage:function(e){if(U.getVisibleColumnCount(e)>0){return e.getNoData()||U.getResourceText("TBL_NO_DATA")}else{return e.getAggregation("_noColumnsMessage")||U.getResourceText("TBL_NO_COLUMNS")}},getVisibleColumnCount:function(e){return e._getVisibleColumns().length},getHeaderRowCount:function(e){if(e._iHeaderRowCount===undefined){if(!e.getColumnHeaderVisible()){e._iHeaderRowCount=0}else{let t=1;const n=e.getColumns();for(let e=0;e<n.length;e++){if(n[e].shouldRender()){t=Math.max(t,n[e].getMultiLabels().length)}}e._iHeaderRowCount=t}}return e._iHeaderRowCount},isVariableRowHeightEnabled:function(e){const t=e._getRowCounts();return e&&e._bVariableRowHeightEnabled&&!t.fixedTop&&!t.fixedBottom},getNonEmptyRowCount:function(e){return Math.min(e._getRowCounts().count,e._getTotalRowCount())},getFocusedItemInfo:function(e){const t=e._getItemNavigation();if(!t){return null}return{cell:t.getFocusedIndex(),columnCount:t.iColumns,cellInRow:t.getFocusedIndex()%t.iColumns,row:Math.floor(t.getFocusedIndex()/t.iColumns),cellCount:t.getItemDomRefs().length,domRef:t.getFocusedDomRef()}},getRowIndexOfFocusedCell:function(e){const t=U.getFocusedItemInfo(e);return t.row-U.getHeaderRowCount(e)},isFixedColumn:function(e,t){return t<e.getComputedFixedColumnCount()},hasFixedColumns:function(e){return e.getComputedFixedColumnCount()>0},focusItem:function(e,t,n){const o=e._getItemNavigation();if(o){o.focusItem(t,n)}},scrollTableToIndex:function(e,t,n){if(!e){return Promise.resolve()}const o=e.getFirstVisibleRow();const i=e._getRowCounts();const s=o+i.scrollable-1;let l=false;if(t<o||t>s){const o=n?t-i.fixedTop-1:t-i.scrollable-i.fixedTop+2;l=e._setFirstVisibleRowIndex(Math.max(0,o))}return new Promise(function(t){if(l){e.attachEventOnce("_rowsUpdated",t)}else{t()}})},showNotificationPopoverAtIndex:function(e,t,n){let o=e._oNotificationPopover;const i=e.getRows()[t-e._getFirstRenderedRowIndex()];const s=U.getResourceText("TBL_SELECT_LIMIT_TITLE");const l=U.getResourceText("TBL_SELECT_LIMIT",[n]);if(!i){return Promise.resolve()}return new Promise(function(t){sap.ui.require(["sap/m/Popover","sap/m/Bar","sap/m/Title","sap/m/Text","sap/m/HBox","sap/ui/core/library","sap/m/library"],function(n,a,r,u,c,f,p){if(!o){o=new n(e.getId()+"-notificationPopover",{customHeader:[new a({contentMiddle:[new c({items:[new d({src:"sap-icon://message-warning",color:f.IconColor.Critical}).addStyleClass("sapUiTinyMarginEnd"),new r({text:s,level:f.TitleLevel.H2})],renderType:p.FlexRendertype.Bare,justifyContent:p.FlexJustifyContent.Center,alignItems:p.FlexAlignItems.Center})]})],content:new u({text:l})});o.addStyleClass("sapUiContentPadding");e._oNotificationPopover=o;e.addAggregation("_hiddenDependents",e._oNotificationPopover)}else{o.getContent()[0].setText(l)}e.detachFirstVisibleRowChanged(this.onFirstVisibleRowChange,this);e.attachFirstVisibleRowChanged(this.onFirstVisibleRowChange,this);const C=i.getDomRefs().rowSelector;if(C){o.attachEventOnce("afterOpen",function(){g.getInstance().announce(l);t()});o.openBy(C)}else{t()}}.bind(this))}.bind(this))},onFirstVisibleRowChange:function(e){const t=e.getSource();if(!t._oNotificationPopover){return}if(t){t.detachFirstVisibleRowChanged(this.onFirstVisibleRowChange,this)}t._oNotificationPopover.close()},loadContexts:function(e,t,n){const o=e.getContexts(t,n,0,true);const i=o.length===Math.min(n,e.getLength())&&!o.includes(undefined);if(i){return Promise.resolve(o)}return new Promise(function(o){e.attachEventOnce("dataReceived",function(){o(this.loadContexts(e,t,n))}.bind(this))}.bind(this))},getCellInfo:function(e){const t={type:0,cell:null,rowIndex:null,columnIndex:null,columnSpan:null};const n=jQuery(e);let o;let i;let s;let l;let r;if(n.hasClass("sapUiTableDataCell")){o=n.attr("data-sap-ui-colid");i=a.getElementById(o);t.type=U.CELLTYPE.DATACELL;t.rowIndex=parseInt(n.parent().attr("data-sap-ui-rowindex"));t.columnIndex=i?.getIndex()??-1;t.columnSpan=1}else if(n.hasClass("sapUiTableHeaderDataCell")){s=/_([\d]+)/;o=n.attr("id");l=s.exec(o);r=l&&l[1]!=null?parseInt(l[1]):0;t.type=U.CELLTYPE.COLUMNHEADER;t.rowIndex=r;t.columnIndex=parseInt(n.attr("data-sap-ui-colindex"));t.columnSpan=parseInt(n.attr("colspan")||1)}else if(n.hasClass("sapUiTableRowSelectionCell")){t.type=U.CELLTYPE.ROWHEADER;t.rowIndex=parseInt(n.parent().attr("data-sap-ui-rowindex"));t.columnIndex=-1;t.columnSpan=1}else if(n.hasClass("sapUiTableRowActionCell")){t.type=U.CELLTYPE.ROWACTION;t.rowIndex=parseInt(n.parent().attr("data-sap-ui-rowindex"));t.columnIndex=-2;t.columnSpan=1}else if(n.hasClass("sapUiTableRowActionHeaderCell")){t.type=U.CELLTYPE.ROWACTIONCOLUMNHEADER;t.columnIndex=-2;t.columnSpan=1}else if(n.hasClass("sapUiTableRowSelectionHeaderCell")){t.type=U.CELLTYPE.COLUMNROWHEADER;t.columnIndex=-1;t.columnSpan=1}else if(n.hasClass("sapUiTablePseudoCell")){o=n.attr("data-sap-ui-colid");i=a.getElementById(o);t.type=U.CELLTYPE.PSEUDO;t.rowIndex=-1;t.columnIndex=i?.getIndex()??-1;t.columnSpan=1}if(t.type!==0){t.cell=n[0]}t.isOfType=function(e){if(e==null){return false}return(this.type&e)>0};return t},getRowColCell:function(e,t,n,o){const i=e.getRows()[t]||null;const s=o?e.getColumns():e._getVisibleColumns();const l=s[n]||null;let a;let r=null;if(i&&l){if(!a){let e=l.getMetadata();while(e.getName()!=="sap.ui.table.Column"){e=e.getParent()}a=e.getClass()}r=i.getCells().find(function(e){return l===a.ofCell(e)})||null}return{row:i,column:l,cell:r}},getCell:function(e,t,n){n=n===true;if(!e||!t){return null}const o=jQuery(t);const i=e.getDomRef();let s=".sapUiTableCell";if(!n){s+=":not(.sapUiTablePseudoCell)"}const l=o.closest(s,i);if(l.length>0){return l}return null},getParentCell:function(e,t,n){n=n===true;const o=jQuery(t);const i=U.getCell(e,t,n);if(!i||i[0]===o[0]){return null}else{return i}},registerResizeHandler:function(e,t,n,o,i){o=o==null?"":o;i=i===true;if(!e||typeof t!=="string"||typeof n!=="function"){return undefined}let s=e.getDomRef(o);U.deregisterResizeHandler(e,t);if(!e._mResizeHandlerIds){e._mResizeHandlerIds={}}if(i&&s){s=s.parentNode}if(s){e._mResizeHandlerIds[t]=r.register(s,n)}return e._mResizeHandlerIds[t]},deregisterResizeHandler:function(e,t){let n=[];if(!e._mResizeHandlerIds){return}if(typeof t==="string"){n.push(t)}else if(t===undefined){for(const t in e._mResizeHandlerIds){if(typeof t==="string"&&e._mResizeHandlerIds.hasOwnProperty(t)){n.push(t)}}}else if(Array.isArray(t)){n=t}for(let t=0;t<n.length;t++){const o=n[t];if(e._mResizeHandlerIds[o]){r.deregister(e._mResizeHandlerIds[o]);e._mResizeHandlerIds[o]=undefined}}},isFirstScrollableRow:function(e,t){if(isNaN(t)){const e=jQuery(t);t=parseInt(e.add(e.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"))}return t===e._getRowCounts().fixedTop},isLastScrollableRow:function(e,t){if(isNaN(t)){const e=jQuery(t);t=parseInt(e.add(e.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"))}const n=e._getRowCounts();return t===n.count-n.fixedBottom-1},getContentDensity:function(e){let t;const n=["sapUiSizeCondensed","sapUiSizeCompact","sapUiSizeCozy"];const o=function(e,t){if(!t[e]){return}for(let o=0;o<n.length;o++){if(t[e](n[o])){return n[o]}}};let i=e.$();if(i.length>0){t=o("hasClass",i)}else{t=o("hasStyleClass",e)}if(t){return t}let s=null;let l=e.getParent();if(l){do{t=o("hasStyleClass",l);if(t){return t}if(l.getDomRef){s=l.getDomRef()}else if(l.getRootNode){s=l.getRootNode()}if(!s&&l.getParent){l=l.getParent()}else{l=null}}while(l&&!s)}i=jQuery(s||document.body);t=o("hasClass",i.closest("."+n.join(",.")));return t},isVariableWidth:function(e){return!e||e==="auto"||e.toString().match(/%$/)},getFirstFixedBottomRowIndex:function(e){const t=e._getRowCounts();if(!e.getBinding()||t.fixedBottom===0){return-1}let n=-1;const o=e.getFirstVisibleRow();const i=e._getTotalRowCount();if(i>=t.count){n=t.count-t.fixedBottom}else{const e=i-t.fixedBottom-o;if(e>=0&&o+e<i){n=e}}return n},getResourceText:function(e,t){return f.getResourceBundleFor("sap.ui.table").getText(e,t)},dynamicCall:function(e,t,n){const o=typeof e==="function"?e():e;if(!o||!t){return undefined}n=n||o;if(typeof t==="function"){t.call(n,o);return undefined}else{let e;const i=[];for(const s in t){if(typeof o[s]==="function"){e=t[s];i.push(o[s].apply(n,e))}else{i.push(undefined)}}if(i.length===1){return i[0]}else{return i}}},throttle:function(e,t,n){n=Object.assign({leading:true,asyncLeading:false,trailing:true},n);let o;let i=false;let s={};let l;let a;if(n.leading&&n.asyncLeading){l=function(){if(i){const t=Promise.resolve().then(function(){if(!t.canceled){e.apply(s.context,s.args)}o=null});t.cancel=function(){t.canceled=true};o=t}else{e.apply(this,arguments)}}}else{l=e}const r=m(l,t,{leading:n.leading,trailing:n.trailing});if(n.leading&&n.asyncLeading){const e=r.cancel;r.cancel=function(){if(o){o.cancel()}e()};a=Object.assign(function(){s={context:this,args:arguments};i=true;r.apply(this,arguments);i=false},r)}else{a=r}return a},throttleFrameWise:function(e){let t=null;const n=function(){n.cancel();t=window.requestAnimationFrame(function(t){e.apply(this,t)}.bind(this,arguments))};n.cancel=function(){window.cancelAnimationFrame(t);t=null};return n},getInteractiveElements:function(e){if(!e){return null}const t=jQuery(e);const n=U.getCellInfo(t);if(n.isOfType(I.ANY|I.PSEUDO)){const e=t.find(A);if(e.length>0){return e}}return null},getFirstInteractiveElement:function(e,t){if(!e){return null}const n=e.getTable();const o=e.getCells();if(t===true&&U.hasRowActions(n)){o.push(e.getRowAction())}for(let e=0;e<o.length;e++){const t=o[e].getDomRef();const i=U.getCell(n,t,true);const s=U.getInteractiveElements(i);if(s){return s[0]}}return null},convertCSSSizeToPixel:function(e,t){let n;if(typeof e!=="string"){return null}if(e.endsWith("px")){n=parseFloat(e)}else if(e.endsWith("em")||e.endsWith("rem")){n=parseFloat(e)*U.getBaseFontSize()}else{return null}if(t){return n+"px"}else{return n}},getBaseFontSize:function(){if(w==null){const e=document.documentElement;if(e){w=parseInt(window.getComputedStyle(e).fontSize)}}return w==null?16:w},readThemeParameters:function(){const e=u.get({name:["_sap_ui_table_BaseSize","_sap_ui_table_BaseSizeCozy","_sap_ui_table_BaseSizeCompact","_sap_ui_table_BaseSizeCondensed","_sap_ui_table_BaseBorderWidth","_sap_ui_table_NavigationIcon","_sap_ui_table_DeleteIcon","_sap_ui_table_ClearSelectionIcon","_sap_ui_table_AllSelectedIcon","_sap_ui_table_CheckboxIcon","_sap_ui_table_NavIndicatorWidth"]});function t(t){return U.convertCSSSizeToPixel(e[t])}b.undefined=t("_sap_ui_table_BaseSize");b.sapUiSizeCozy=t("_sap_ui_table_BaseSizeCozy");b.sapUiSizeCompact=t("_sap_ui_table_BaseSizeCompact");b.sapUiSizeCondensed=t("_sap_ui_table_BaseSizeCondensed");T=t("_sap_ui_table_BaseBorderWidth");E=T;S.undefined=b.undefined+E;S.sapUiSizeCozy=b.sapUiSizeCozy+E;S.sapUiSizeCompact=b.sapUiSizeCompact+E;S.sapUiSizeCondensed=b.sapUiSizeCondensed+E;x.navigationIcon=e["_sap_ui_table_NavigationIcon"];x.deleteIcon=e["_sap_ui_table_DeleteIcon"];x.clearSelectionIcon=e["_sap_ui_table_ClearSelectionIcon"];x.allSelectedIcon=e["_sap_ui_table_AllSelectedIcon"];x.checkboxIcon=e["_sap_ui_table_CheckboxIcon"];x.navIndicatorWidth=t("_sap_ui_table_NavIndicatorWidth")},isThemeApplied:function(){let e=false;const t=function(){e=true};c.attachApplied(t);c.detachApplied(t);return e},addDelegate:function(e,t,n){if(e&&t){e.addDelegate(t,false,n?n:t,false)}},removeDelegate:function(e,t){if(e&&t){e.removeDelegate(t)}},createWeakMapFacade:function(){const e=new window.WeakMap;return function(t){if(!t||!(typeof t==="object")){return null}if(!e.has(t)){e.set(t,{})}return e.get(t)}},_getTableTemplateHelper:function(e){const t="An automatic control and template generation for the sap.ui.table.Table is not supported "+"anymore for the aggragations footer and title and the aggregations label and template of "+"the sap.ui.table.Columns. Use concrete controls for those aggregations instead of altType string.";if(s.TableHelper){if(!e){R.warning(t)}return s.TableHelper}throw new Error(t)},getEventPosition:function(e,t){const n=o(e)||e;function o(n){if(!t._isTouchEvent(n)){return null}const o=["touches","targetTouches","changedTouches"];for(let t=0;t<o.length;t++){const n=o[t];if(e[n]&&e[n][0]){return e[n][0]}if(e.originalEvent[n]&&e.originalEvent[n][0]){return e.originalEvent[n][0]}}return null}return{x:n.pageX,y:n.pageY}}};e.TableUtils=U;t.TableUtils=U;n.TableUtils=U;o.TableUtils=U;i.TableUtils=U;return U},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/utils/_BindingUtils", [],function(){"use strict";const t={TableUtils:null,metadataLoaded:function(t){const a=t.getBinding();const e=a?a.getModel():null;let n=null;let d=null;const o=new Promise(function(t,a){n=t;d=a});if(!e){d();return o}if(e.metadataLoaded){e.metadataLoaded().then(function(){n()})}else if(e.attachMetadataLoaded){if(e.oMetadata&&e.oMetadata.isLoaded()){n()}else{e.attachMetadataLoaded(function(){n()})}}return o}};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/utils/_ColumnUtils", ["sap/ui/Device","../library","sap/base/Log"],function(e,n,t){"use strict";const o={TableUtils:null,initColumnUtils:function(e){if(!e._oColumnInfo){o.updateColumnInfo(e,o.collectColumnInfo(e))}},invalidateColumnUtils:function(e){e._oColumnInfo=null},updateColumnInfo:function(e,n){e._oColumnInfo=n},collectColumnInfo:function(e){return{columnCount:e.getColumns().length,visibleColumnCount:o.TableUtils.getVisibleColumnCount(e),columnMap:o.getColumnMap(e)}},getColumnMap:function(e){let n;let t;let l={};const u={};const i=e.getColumns();const r=o.TableUtils.getHeaderRowCount(e);const s={};for(let e=0;e<i.length;e++){t=i[e];l={};l.id=t.getId();l.column=t;l.levelInfo=[];l.parents=[];for(let u=0;u<r;u++){l.levelInfo[u]={};l.levelInfo[u].spannedColumns=[];const r=o.getHeaderSpan(t,u);for(n=1;n<r;n++){const o=i[e+n];if(o){const r=o.getId();l.levelInfo[u].spannedColumns.push(i[e+n]);if(!s[r]){s[r]=[]}s[r].push({column:t,level:u})}}}u[l.id]=l}const a=Object.keys(s);for(n=0;n<a.length;n++){const e=a[n];u[e].parents=s[e]}return u},getColumnMapItem:function(e,n){o.initColumnUtils(e);const l=e._oColumnInfo.columnMap[n];if(!l){t.error("Column with ID '"+n+"' not found",e)}else{return l}},getParentSpannedColumns:function(e,n,t){const l=o.getColumnMapItem(e,n);if(!l){return undefined}const u=[];for(let e=0;e<l.parents.length;e++){const n=l.parents[e];if(t===undefined||n.level===t){u.push(n)}}return u},getChildrenSpannedColumns:function(e,n,t){const l=o.getColumnMapItem(e,n);if(!l){return undefined}const u=[];let i;if(t===undefined){i=l.levelInfo.length}else{i=t+1}for(let e=t||0;e<i;e++){const n=l.levelInfo[e];for(let t=0;t<n.spannedColumns.length;t++){u.push({column:n.spannedColumns[t],level:e})}}return u},getHeaderSpan:function(e,n){let t=e.getHeaderSpan();let o;if(!t){return 1}if(!Array.isArray(t)){t=(t+"").split(",")}function l(e){const n=parseInt(e);return isNaN(n)?1:n}if(isNaN(n)){o=Math.max.apply(null,t.map(l))}else{o=l(t[n])}return Math.max(o,1)},getMaxHeaderSpan:function(e){return o.getHeaderSpan(e)},hasHeaderSpan:function(e){return o.getHeaderSpan(e)>1},getColumnBoundaries:function(e,n){const t=o.getColumnMapItem(e,n);if(!t){return undefined}let l={};if(n){l[n]=t.column}const u=function(n,t){let l;let i;let r=[];t=t||[];for(i=0;i<t.length;i++){l=n[t[i]];r=r.concat(o.getParentSpannedColumns(e,l.getId()));r=r.concat(o.getChildrenSpannedColumns(e,l.getId()))}t=[];for(i=0;i<r.length;i++){l=r[i].column;const e=l.getId();if(!n[e]){t.push(e);n[e]=l}}if(t.length>0){return u(n,t)}else{return n}};l=u(l,[n]);let i=e.indexOfColumn(t.column);const r={startColumn:t.column,startIndex:i,endColumn:t.column,endIndex:-1};const s=e.getColumns();const a=Object.getOwnPropertyNames(l);for(let n=0;n<a.length;n++){const t=l[a[n]];i=e.indexOfColumn(t);const u=o.getMaxHeaderSpan(t);if(i<r.startIndex){r.startIndex=i;r.startColumn=t}const f=i+u-1;if(f>r.endIndex){r.endIndex=f;r.endColumn=s[f]}}return r},isColumnMovable:function(e,n){const t=e._getTable();if(!t||!t.getEnableColumnReordering()&&!n){return false}const l=t.indexOfColumn(e);if(l<t.getComputedFixedColumnCount()||l<t._iFirstReorderableIndex){return false}if(o.hasHeaderSpan(e)||o.getParentSpannedColumns(t,e.getId()).length!==0){return false}return true},normalizeColumnMoveTargetIndex:function(e,n){const t=e._getTable();const o=t.indexOfColumn(e);const l=t.getColumns();if(n>o){n--}if(n<0){n=0}else if(n>l.length){n=l.length}return n},isColumnMovableTo:function(e,n,t){const l=e._getTable();if(!l||n===undefined||!o.isColumnMovable(e,t)){return false}n=o.normalizeColumnMoveTargetIndex(e,n);if(n<l.getComputedFixedColumnCount()||n<l._iFirstReorderableIndex){return false}const u=l.indexOfColumn(e);const i=l.getColumns();if(n>u){const e=i[n>=i.length?i.length-1:n];const t=o.getColumnBoundaries(l,e.getId());if(o.hasHeaderSpan(e)||t.endIndex>n){return false}}else{const e=i[n];if(o.getParentSpannedColumns(l,e.getId()).length!==0){return false}}return true},moveColumnTo:function(e,n){if(!o.isColumnMovableTo(e,n)){return false}const t=e._getTable();const l=t.indexOfColumn(e);if(n===l){return false}n=o.normalizeColumnMoveTargetIndex(e,n);const u=t.fireColumnMove({column:e,newPos:n});if(!u){return false}t._bReorderInProcess=true;t.removeColumn(e,true);t.insertColumn(e,n);t._bReorderInProcess=false;return true},getMinColumnWidth:function(){return e.system.desktop?48:88},autoResizeColumn:function(e){const n=e._getTable();const t=e.getWidth();const l=o._calculateColumnWidth(e);if(l+"px"!==t){o.resizeColumn(n,e,l)}},_calculateColumnWidth:function(e){const n=e._getTable().getDomRef();const t=document.createElement("div");t.classList.add("sapUiTableHiddenSizeDetector","sapUiTableHeaderDataCell","sapUiTableDataCell");n.appendChild(t);const l=Array.from(n.querySelectorAll(`td[data-sap-ui-colid="${e.getId()}"]:not([colspan])`)).filter(e=>!e.classList.contains("sapUiTableHidden")).map(e=>e.firstElementChild.cloneNode(true));l.forEach(e=>{e.removeAttribute("id");t.appendChild(e)});let u=t.getBoundingClientRect().width+4;const i=n.querySelector(".sapUiTableCnt").getBoundingClientRect().width;u=Math.min(u,i);u=Math.max(u,o.getMinColumnWidth());n.removeChild(t);return Math.round(u)},resizeColumn:function(e,n,t,l=true,u=1){if(!e||!n||t==null||t<=0){return false}const i=o._getVisibleColumnsInSpan(e,n.getIndex(),u);const r=o._getResizableColumns(i);if(r.length===0){return false}const s=o._calculateSpanWidth(e,i);if(!o.TableUtils.isFixedColumn(e,n.getIndex())){o._fixAutoColumns(e,r)}const a=t-s;return o._performResize(e,r,a,l)},_getVisibleColumnsInSpan:function(e,n,t){const o=e.getColumns();if(n>=o.length||!o[n].getVisible()){return false}const l=[];for(let e=n;e<o.length;e++){const n=o[e];if(n.getVisible()){l.push(n);if(l.length===t){break}}}return l},_getResizableColumns:function(e){const n=[];for(let t=0;t<e.length;t++){const o=e[t];if(o.getResizable()){n.push(o)}}return n},_fixAutoColumns:function(e,n){const t=e.getDomRef();e._getVisibleColumns().forEach(function(e){const l=e.getWidth();let u;if(t&&n.indexOf(e)<0&&o.TableUtils.isVariableWidth(l)){u=t.querySelector('th[data-sap-ui-colid="'+e.getId()+'"]');if(u){e._minWidth=Math.max(u.offsetWidth,o.getMinColumnWidth())}}})},_calculateSpanWidth:function(e,n){let t=0;for(let l=0;l<n.length;l++){const u=n[l];t+=o.getColumnWidth(e,u.getIndex())}return t},_performResize:function(e,n,t,l){let u=Math.round(t/n.length);let i=false;for(let r=0;r<n.length;r++){const s=n[r];const a=o.getColumnWidth(e,s.getIndex());let f=a+u;const c=o.getMinColumnWidth();if(f<c){f=c}const d=f-a;if(Math.abs(d)<Math.abs(u)){const e=n.length-(r+1);t-=d;u=Math.round(t/e)}if(d!==0){let n=true;const t=f+"px";if(l){n=e.fireColumnResize({column:s,width:t})}if(n){s.setWidth(t);i=true}}}return i},getColumnWidth:function(e,n){if(!e||n==null||n<0){return null}const t=e.getColumns();if(n>=t.length){return null}const l=t[n];const u=l.getWidth();if(u===""||u==="auto"||u.match(/%$/)){if(l.getVisible()){const e=l.getDomRef();return e?e.offsetWidth:0}else{return 0}}else{return o.TableUtils.convertCSSSizeToPixel(u)}},getHeaderText:function(e){return e.getName()||o.getHeaderLabel(e)?.getText?.()||""},getHeaderLabel:function(e){let n;const t=e.getMultiLabels();for(let l=t.length-1;l>=0;l--){if(o.getHeaderSpan(e,l)===1){n=t[l];break}}if(!n){n=e.getLabel()}return n}};return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/utils/_GroupingUtils", ["sap/ui/core/Element","sap/ui/model/Sorter","sap/ui/Device","sap/ui/thirdparty/jquery"],function(e,t,o,jQuery){"use strict";const n=new window.WeakMap;const r={TableUtils:null,HierarchyMode:{Flat:"Flat",Group:"Group",Tree:"Tree",GroupedTree:"GroupedTree"},setHierarchyMode:function(e,t){if(!r.TableUtils.isA(e,"sap.ui.table.Table")||!(t in r.HierarchyMode)){return}const o=r.getHierarchyMode(e);if(o!==t){n.set(e,t);e.invalidate()}},getHierarchyMode:function(e){return r.TableUtils.isA(e,"sap.ui.table.Table")?n.get(e)||r.HierarchyMode.Flat:null},setToDefaultFlatMode:function(e){r.setHierarchyMode(e,r.HierarchyMode.Flat)},setToDefaultGroupMode:function(e){r.setHierarchyMode(e,r.HierarchyMode.Group)},setToDefaultTreeMode:function(e){r.setHierarchyMode(e,r.HierarchyMode.Tree)},isInFlatMode:function(e){return r.getHierarchyMode(e)===r.HierarchyMode.Flat},isInGroupMode:function(e){const t=r.getHierarchyMode(e);return t===r.HierarchyMode.Group||t===r.HierarchyMode.GroupedTree},isInTreeMode:function(e){return r.getHierarchyMode(e)===r.HierarchyMode.Tree},getModeCssClass:function(e){switch(r.getHierarchyMode(e)){case r.HierarchyMode.Group:case r.HierarchyMode.GroupedTree:return"sapUiTableGroupMode";case r.HierarchyMode.Tree:return"sapUiTableTreeMode";default:return null}},isInGroupHeaderRow:function(e){const t=r.TableUtils.getCellInfo(e);if(t.isOfType(r.TableUtils.CELLTYPE.ANYCONTENTCELL)){return t.cell.parentElement.classList.contains("sapUiTableGroupHeaderRow")}return false},isInSummaryRow:function(e){const t=r.TableUtils.getCellInfo(e);if(t.isOfType(r.TableUtils.CELLTYPE.ANYCONTENTCELL)){return t.cell.parentElement.classList.contains("sapUiTableSummaryRow")}return false},calcGroupIndent:function(e){const t=r.getHierarchyMode(e.getTable())===r.HierarchyMode.GroupedTree;const o=!t&&!e.isGroupHeader()&&!e.isTotalSummary();const n=e.getLevel()-(o?1:0);let a=0;for(let e=1;e<n;e++){if(e===1){a=24}else if(e===2){a+=12}else{a+=8}}return a},calcTreeIndent:function(e){return(e.getLevel()-1)*17},setGroupIndent:function(e,t){const o=e.getDomRefs(true);const n=o.row;const r=o.rowHeaderPart;const a=e.getTable()._bRtlMode;const i=n.find("td.sapUiTableCellFirst > .sapUiTableCellInner");const s=r.find(".sapUiTableGroupShield");if(t<=0){r.css(a?"right":"left","");s.css("width","").css(a?"margin-right":"margin-left","");i.css(a?"padding-right":"padding-left","");n.css("--CalculatedGroupIndent","0")}else{r.css(a?"right":"left",t+"px");s.css("width",t+"px").css(a?"margin-right":"margin-left",-1*t+"px");i.css(a?"padding-right":"padding-left",t+8+"px");n.css("--CalculatedGroupIndent",t+"px")}},setTreeIndent:function(e,t){const o=e.getDomRefs(true);const n=o.row;const r=e.getTable()._bRtlMode;const a=n.find(".sapUiTableTreeIcon");a.css(r?"margin-right":"margin-left",t>0?t+"px":"")},updateTableRowForGrouping:function(e){const t=e.getTable();const o=e.getDomRefs(true);const n=o.row;const a=e.isExpanded();const i=e.isExpandable();n.toggleClass("sapUiTableSummaryRow",e.isSummary());if(r.isInGroupMode(t)){const t=e.getTitle();const o=r.calcGroupIndent(e);e.$("groupHeader").toggleClass("sapUiTableGroupIconOpen",i&&a).toggleClass("sapUiTableGroupIconClosed",i&&!a).text(t);r.setGroupIndent(e,o);n.toggleClass("sapUiTableRowIndented",o>0).toggleClass("sapUiTableGroupHeaderRow",e.isGroupHeader())}if(r.isInTreeMode(t)){const o=n.find(".sapUiTableTreeIcon");if(!i&&document.activeElement===o[0]){r.TableUtils.getParentCell(t,o[0]).trigger("focus")}o.toggleClass("sapUiTableTreeIconLeaf",!i).toggleClass("sapUiTableTreeIconNodeOpen",i&&a).toggleClass("sapUiTableTreeIconNodeClosed",i&&!a);r.setTreeIndent(e,r.calcTreeIndent(e))}if(!r.isInFlatMode(t)){t._getAccExtension().updateAriaExpandAndLevelState(e)}},cleanupTableRowForGrouping:function(e){const t=e.getTable();const o=e.getDomRefs(true);if(r.isInGroupMode(t)){o.row.removeClass("sapUiTableGroupHeaderRow sapUiTableSummaryRow sapUiTableRowIndented");e.$("groupHeader").removeClass("sapUiTableGroupIconOpen","sapUiTableGroupIconClosed").attr("title","").text("");r.setGroupIndent(e,0)}if(r.isInTreeMode(t)){o.row.find(".sapUiTableTreeIcon").removeClass("sapUiTableTreeIconLeaf").removeClass("sapUiTableTreeIconNodeOpen").removeClass("sapUiTableTreeIconNodeClosed");r.setTreeIndent(e,0)}t._getAccExtension().updateAriaExpandAndLevelState(e)},updateGroups:function(e){if(e.getBinding()){e.getRows().forEach(function(e){r.updateTableRowForGrouping(e)})}else{e.getRows().forEach(function(e){r.cleanupTableRowForGrouping(e)})}},setupExperimentalGrouping:function(o){if(!o.getEnableGrouping()){return}const n=o.getBinding();const a=e.getElementById(o.getGroupBy());const i=a&&a.getGrouped()&&r.TableUtils.isA(n,"sap.ui.model.ClientListBinding");if(!i||n._modified){return}n._modified=true;r.setToDefaultGroupMode(o);const s=a.getSortProperty();n.sort(new t(s));const l=o._getTotalRowCount();const p=n.getContexts(0,l);let u;let d=0;for(let e=l-1;e>=0;e--){const t=p[e].getProperty(s);if(!u){u=t}if(u!==t){const o=p[e+1].getModel().getContext("/sap.ui.table.GroupInfo"+e);o.__groupInfo={oContext:p[e+1],name:u,count:d,groupHeader:true,expanded:true};p.splice(e+1,0,o);u=t;d=0}d++}const c=p[0].getModel().getContext("/sap.ui.table.GroupInfo");c.__groupInfo={oContext:p[0],name:u,count:d,groupHeader:true,expanded:true};p.splice(0,0,c);jQuery.extend(n,{getLength:function(){return p.length},getContexts:function(e,t){return p.slice(e,e+t)}});function g(e){const t=p[e];return(t&&t.__groupInfo&&t.__groupInfo.groupHeader)===true}o._experimentalGroupingRowState=function(e){const t=e.context;if((t&&t.__groupInfo&&t.__groupInfo.groupHeader)===true){e.type=e.Type.GroupHeader}e.title=t&&t.__groupInfo&&t.__groupInfo.name+" - "+t.__groupInfo.count;e.expandable=e.type===e.Type.GroupHeader;e.expanded=e.expandable&&t.__groupInfo&&t.__groupInfo.expanded;e.level=e.expandable?1:2;e.contentHidden=e.expandable};o._experimentalGroupingExpand=function(e){const t=e.getIndex();if(g(t)&&!p[t].__groupInfo.expanded){for(let e=0;e<p[t].__childs.length;e++){p.splice(t+1+e,0,p[t].__childs[e])}delete p[t].__childs;p[t].__groupInfo.expanded=true;n._fireChange()}};o._experimentalGroupingCollapse=function(e){const t=e.getIndex();if(g(t)&&p[t].__groupInfo.expanded){p[t].__childs=p.splice(t+1,p[t].__groupInfo.count);p[t].__groupInfo.expanded=false;n._fireChange()}};const f=r.TableUtils.Hook;f.register(o,f.Keys.Row.UpdateState,o._experimentalGroupingRowState);f.register(o,f.Keys.Row.Expand,o._experimentalGroupingExpand);f.register(o,f.Keys.Row.Collapse,o._experimentalGroupingCollapse);o._mTimeouts.groupingFireBindingChange=o._mTimeouts.groupingFireBindingChange||window.setTimeout(function(){n._fireChange()},0)},resetExperimentalGrouping:function(e){const t=e.getBinding();const o=r.TableUtils.Hook;if(t&&t._modified){r.setToDefaultFlatMode(e);e.bindRows(e.getBindingInfo("rows"))}o.deregister(e,o.Keys.Row.UpdateState,e._experimentalGroupingRowState);o.deregister(e,o.Keys.Row.Expand,e._experimentalGroupingExpand);o.deregister(e,o.Keys.Row.Collapse,e._experimentalGroupingCollapse);delete e._experimentalGroupingRowState;delete e._experimentalGroupingExpand;delete e._experimentalGroupingCollapse}};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/utils/_HookUtils", ["sap/ui/base/DataType","sap/ui/model/ChangeReason"],function(e,t){"use strict";const n=new window.WeakMap;const s={};const r={};const a={};const o=["function"];const l={};const u={Table:{BindRows:{arguments:[{type:"object"}]},RowsBound:{arguments:[{type:"class:sap.ui.model.Binding"}]},UnbindRows:{arguments:[{type:"object"}]},RowsUnbound:{arguments:[]},RefreshRows:{arguments:[{type:b}]},UpdateRows:{arguments:[{type:b}]},UpdateSizes:{arguments:[{type:b}]},TotalRowCountChanged:{arguments:[]},InvalidateColumnMenus:{arguments:[{type:"class:sap.ui.table.Table"}]}},TableRenderer:{RenderTableStyles:{arguments:[{type:"object"}]},RenderInTableBottomArea:{arguments:[{type:"object"}]},RenderRowContainerStyles:{arguments:[{type:"object"}]},RenderRowStyles:{arguments:[{type:"object"}]},RenderCellContentStyles:{arguments:[{type:"object"}]}},Row:{UpdateState:{arguments:[{type:h}]},Expand:{arguments:[{type:"class:sap.ui.table.Row"}]},Collapse:{arguments:[{type:"class:sap.ui.table.Row"}]}},Column:{SetFilterState:{arguments:[{type:"class:sap.ui.table.Column"},{type:"string"}]}},Signal:{arguments:[{type:"string"}]}};l.TableUtils=null;l.Keys=r;l.call=function(e,t){const r=n.get(e);if(!p(e)||!c(t)){return}const a=y(t);if(r==null){return}const o=f(Array.prototype.slice.call(arguments,2));const u=g(a,o);if(!u){throw new Error("Hook with key "+t+" was not called. Invalid arguments passed\n"+e)}r.map(e=>{if(e.key===s){const n={};const s=e.handlerContext==null?e.target:e.handlerContext;n[t]=o;l.TableUtils.dynamicCall(e.target,n,s)}else if(e.key===t){e.handler.apply(e.handlerContext,o)}})};l.install=function(e,t,r){if(!t||!p(e)){return}let a=n.get(e);if(a==null){a=[]}const o=a.some(function(e){return e.key===s&&e.target===t&&e.handlerContext===r});if(o){return}a.push({key:s,target:t,handlerContext:r});n.set(e,a)};l.uninstall=function(e,t,r){const a=n.get(e);if(a==null||!t){return}for(let e=0;e<a.length;e++){const n=a[e];if(n.key===s&&n.target===t&&n.handlerContext===r){a.splice(e,1);break}}if(a.length===0){n.delete(e)}else{n.set(e,a)}};l.register=function(e,t,s,r){if(typeof s!=="function"||!p(e)||!c(t)){return}let a=n.get(e);if(a==null){a=[]}a.push({key:t,handler:s,handlerContext:r});n.set(e,a)};l.deregister=function(e,t,s,r){const a=n.get(e);if(a==null){return}for(let e=0;e<a.length;e++){const n=a[e];if(n.key===t&&n.handler===s&&n.handlerContext===r){a.splice(e,1);break}}if(a.length===0){n.delete(e)}else{n.set(e,a)}};function i(e,t,n){Object.keys(t).forEach(function(s){const r=n?n+"."+s:s;if("arguments"in t[s]){o.forEach(function(e){if(t[s].arguments.includes(e)){throw new Error("Forbidden type found in metadata of hook "+n+": "+e)}});e[s]=r;a[r]=t[s]}else{e[s]={};i(e[s],t[s],r)}});return e}i(r,u);function c(e){return e in a}function p(e){return l.TableUtils.isA(e,"sap.ui.table.Table")&&!e.bIsDestroyed&&!e._bIsBeingDestroyed}function y(e){return a[e]}function f(e){while(e.length>0){const t=e.pop();if(t!=null){e.push(t);break}}return e}function g(t,n){return t.arguments.length>=n.length&&n.every(function(n,s){const r=t.arguments[s];if(typeof r.type==="function"){return r.type(n)}if(r.type.startsWith("class:")){return l.TableUtils.isA(n,r.type.substring(6))}return r.optional===true&&n==null||e.getType(r.type).isValid(n)})}function d(e){return typeof e==="string"&&Object.values(t).includes(e)}function b(e){return e in l.TableUtils.RowsUpdateReason||d(e)}function h(e){return e!=null&&e.hasOwnProperty("context")&&e.hasOwnProperty("Type")&&e.hasOwnProperty("type")&&e.type in e.Type}return l},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/table/utils/_MenuUtils", [],function(){"use strict";const e={TableUtils:null,openContextMenu:function(n,t){const o=e.TableUtils.getCell(n,t.target);const l=e.TableUtils.getCellInfo(o);if(l.isOfType(e.TableUtils.CELLTYPE.COLUMNHEADER)){n.getColumns()[l.columnIndex]._openHeaderMenu(l.cell);t.preventDefault()}else if(l.isOfType(e.TableUtils.CELLTYPE.ANYCONTENTCELL)){if(l.columnIndex>=0){const o=e.TableUtils.getRowColCell(n,l.rowIndex,l.columnIndex,true);const u=n.fireCellContextmenu({rowIndex:o.row.getIndex(),columnIndex:l.columnIndex,columnId:o.column.getId(),cellControl:o.cell,rowBindingContext:o.row.getRowBindingContext(),cellDomRef:l.cell});if(!u){t.preventDefault()}}e._openContentCellContextMenu(n,l,t)}},_openContentCellContextMenu:function(n,t,o){const l=n.getRows()[t.rowIndex];if(l.isEmpty()){return}if(n.getContextMenu()&&!l.isGroupHeader()&&!l.isSummary()){e._openCustomContentCellContextMenu(n,n.getContextMenu(),t,o)}else if(n.getAggregation("groupHeaderRowContextMenu")&&l.isGroupHeader()){e._openCustomContentCellContextMenu(n,n.getAggregation("groupHeaderRowContextMenu"),t,o)}else{e._openDefaultContentCellContextMenu(n,t,o)}},_openCustomContentCellContextMenu:function(e,n,t,o){const l=e.getRows()[t.rowIndex];n.setBindingContext(l.getRowBindingContext(),e.getBindingInfo("rows").model);const u=e.fireBeforeOpenContextMenu({rowIndex:l.getIndex(),columnIndex:t.columnIndex>=0?t.columnIndex:null,contextMenu:n});if(u){n.openAsContextMenu(o,t.cell);o.preventDefault()}},_openDefaultContentCellContextMenu:function(e,n,t){const o=e.getRows()[n.rowIndex];const l=e.getColumns()[n.columnIndex];const u=e._getDefaultContextMenu();u.initContent(o,l);if(!u.isEmpty()){u.open(t,n.cell);t.preventDefault()}},closeContentCellContextMenu:function(e){e.getContextMenu()?.close?.();e.getAggregation("groupHeaderRowContextMenu")?.close?.();e._getDefaultContextMenu()?.close?.()}};return e},true);
sap.ui.require.preload({
	"sap/ui/table/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.table","type":"library","embeds":[],"applicationVersion":{"version":"1.135.0"},"title":"Table-like controls, mainly for desktop scenarios.","description":"Table-like controls, mainly for desktop scenarios.","ach":"CA-UI5-TBL","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.135","libs":{"sap.ui.core":{"minVersion":"1.135.0"},"sap.ui.unified":{"minVersion":"1.135.0"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cnr","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","mk","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sr","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.ui.table.AnalyticalColumnMenu","sap.ui.table.AnalyticalTable","sap.ui.table.ColumnMenu","sap.ui.table.CreationRow","sap.ui.table.Table","sap.ui.table.TreeTable","sap.ui.table.RowAction"],"elements":["sap.ui.table.AnalyticalColumn","sap.ui.table.Column","sap.ui.table.Row","sap.ui.table.RowActionItem","sap.ui.table.RowSettings","sap.ui.table.rowmodes.RowMode","sap.ui.table.rowmodes.Fixed","sap.ui.table.rowmodes.Interactive","sap.ui.table.rowmodes.Auto","sap.ui.table.plugins.SelectionPlugin","sap.ui.table.plugins.MultiSelectionPlugin","sap.ui.table.plugins.ODataV4Selection"],"types":["sap.ui.table.NavigationMode","sap.ui.table.RowActionType","sap.ui.table.SelectionBehavior","sap.ui.table.SelectionMode","sap.ui.table.SortOrder","sap.ui.table.VisibleRowCountMode","sap.ui.table.TreeAutoExpandMode"],"interfaces":[]}}}}'
});
//# sourceMappingURL=library-preload.js.map
