/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_7_2;

import java.util.Map;
import javax.xml.ws.BindingProvider;
import org.virtualbox_7_2.IEventListener;
import org.virtualbox_7_2.IMachine;
import org.virtualbox_7_2.ISession;
import org.virtualbox_7_2.IVirtualBox;
import org.virtualbox_7_2.LockType;
import org.virtualbox_7_2.ObjectRefManager;
import org.virtualbox_7_2.PortPool;
import org.virtualbox_7_2.VBoxException;
import org.virtualbox_7_2.VBoxTLSSocketFactory;
import org.virtualbox_7_2.jaxws.InvalidObjectFaultMsg;
import org.virtualbox_7_2.jaxws.RuntimeFaultMsg;
import org.virtualbox_7_2.jaxws.VboxPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualBoxManager {
    private static PortPool pool = new PortPool(true);
    private static final ObjectRefManager objMgr = new ObjectRefManager();
    protected VboxPortType port;
    private IVirtualBox vbox;

    private VirtualBoxManager() {
    }

    public static void initPerThread() {
    }

    public static void deinitPerThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String string, String string2, String string3) {
        this.port = pool.getPort();
        try {
            ((BindingProvider)this.port).getRequestContext().put("javax.xml.ws.service.endpoint.address", string);
            VBoxTLSSocketFactory vBoxTLSSocketFactory = new VBoxTLSSocketFactory();
            ((BindingProvider)this.port).getRequestContext().put("com.sun.xml.internal.ws.transport.https.client.SSLSocketFactory", vBoxTLSSocketFactory);
            ((BindingProvider)this.port).getRequestContext().put("com.sun.xml.ws.transport.https.client.SSLSocketFactory", vBoxTLSSocketFactory);
            String string4 = this.port.iWebsessionManagerLogon(string2, string3);
            objMgr.preventObjRelease();
            try {
                this.vbox = new IVirtualBox(string4, objMgr, this.port);
            }
            finally {
                objMgr.allowObjRelease();
            }
        }
        catch (Throwable throwable) {
            if (this.port != null && pool != null) {
                pool.releasePort(this.port);
                this.port = null;
            }
            throw new VBoxException(throwable.getMessage(), throwable, objMgr, this.port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String string, String string2, String string3, Map<String, Object> map, Map<String, Object> map2) {
        this.port = pool.getPort();
        try {
            ((BindingProvider)this.port).getRequestContext();
            if (map != null) {
                ((BindingProvider)this.port).getRequestContext().putAll(map);
            }
            if (map2 != null) {
                ((BindingProvider)this.port).getResponseContext().putAll(map2);
            }
            ((BindingProvider)this.port).getRequestContext().put("javax.xml.ws.service.endpoint.address", string);
            String string4 = this.port.iWebsessionManagerLogon(string2, string3);
            objMgr.preventObjRelease();
            try {
                this.vbox = new IVirtualBox(string4, objMgr, this.port);
            }
            finally {
                objMgr.allowObjRelease();
            }
        }
        catch (Throwable throwable) {
            if (this.port != null && pool != null) {
                pool.releasePort(this.port);
                this.port = null;
            }
            throw new VBoxException(throwable.getMessage(), throwable, objMgr, this.port);
        }
    }

    public void disconnect() {
        if (this.port == null) {
            return;
        }
        try {
            if (this.vbox != null && this.port != null) {
                this.port.iWebsessionManagerLogoff(this.vbox.getWrapped());
            }
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, objMgr, this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, objMgr, this.port);
        }
        finally {
            if (this.port != null) {
                pool.releasePort(this.port);
                this.port = null;
            }
        }
    }

    public String getClientAPIVersion() {
        return "7_2";
    }

    public IVirtualBox getVBox() {
        return this.vbox;
    }

    public ISession getSessionObject() {
        ISession iSession;
        if (this.vbox == null) {
            throw new VBoxException("connect first");
        }
        String string = this.port.iWebsessionManagerGetSessionObject(this.vbox.getWrapped());
        objMgr.preventObjRelease();
        try {
            iSession = new ISession(string, objMgr, this.port);
        }
        catch (Throwable throwable) {
            try {
                objMgr.allowObjRelease();
                throw throwable;
            }
            catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
                throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, objMgr, this.port);
            }
            catch (RuntimeFaultMsg runtimeFaultMsg) {
                throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, objMgr, this.port);
            }
        }
        objMgr.allowObjRelease();
        return iSession;
    }

    public ISession openMachineSession(IMachine iMachine) throws Exception {
        ISession iSession = this.getSessionObject();
        iMachine.lockMachine(iSession, LockType.Shared);
        return iSession;
    }

    public void closeMachineSession(ISession iSession) {
        if (iSession != null) {
            iSession.unlockMachine();
        }
    }

    public static synchronized VirtualBoxManager createInstance(String string) {
        return new VirtualBoxManager();
    }

    public IEventListener createListener(Object object) {
        throw new VBoxException("no active listeners here");
    }

    public void cleanup() {
        this.disconnect();
        VirtualBoxManager.deinitPerThread();
    }

    public void waitForEvents(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.cleanup();
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }
}

