cmake_minimum_required(VERSION 3.25.0)

enable_language(CXX)

if(NOT DEFINED VSTGUI_CXX_VERSION)
    set(VSTGUI_CXX_VERSION "17" CACHE STRING "The C++ language version to compile VSTGUI")
endif()

if(NOT DEFINED VSTGUI_ENABLE_DEPRECATED_METHODS)
    option(VSTGUI_ENABLE_DEPRECATED_METHODS "Enable VSTGUI deprecated methods" ON)
endif()

if(NOT DEFINED VSTGUI_ENABLE_XMLPARSER)
    option(VSTGUI_ENABLE_XMLPARSER "Enable building deprecated Expat based XML Parser" ON)
endif()

if(NOT DEFINED VSTGUI_ENABLE_OPENGL_SUPPORT)
    option(VSTGUI_ENABLE_OPENGL_SUPPORT "Enable OpenGL support" ON)
endif()

##########################################################################################
if(UNIX AND NOT CMAKE_HOST_APPLE)
    set(LINUX TRUE CACHE INTERNAL "VSTGUI linux platform")
endif()

##########################################################################################
if(CMAKE_CONFIGURATION_TYPES)
    set(CMAKE_CONFIGURATION_TYPES Debug Release ReleaseLTO)
    set_property(GLOBAL PROPERTY USE_FOLDERS ON)
endif()

if(CMAKE_HOST_APPLE)
    if(CMAKE_C_COMPILER_VERSION VERSION_GREATER 7)
        set(VSTGUI_LTO_COMPILER_FLAGS "-O3 -flto=thin")
    else()
        set(VSTGUI_LTO_COMPILER_FLAGS "-O3 -flto")
    endif()
  set(VSTGUI_LTO_LINKER_FLAGS "")
  set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -g")
  enable_language(OBJCXX)
endif()
if(LINUX)
    set(VSTGUI_LTO_COMPILER_FLAGS "-O3 -flto")
    set(VSTGUI_LTO_LINKER_FLAGS "")
    if(VSTGUI_WARN_EVERYTHING)
        set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -Wall")
    endif()
    set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -Wno-multichar")
    set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -g")
endif()
if(MSVC)
    set(VSTGUI_COMPILE_DEFINITIONS_DEBUG "${VSTGUI_COMPILE_DEFINITIONS_DEBUG};_CRT_SECURE_NO_WARNINGS")
    set(VSTGUI_COMPILE_DEFINITIONS_RELEASE "${VSTGUI_COMPILE_DEFINITIONS_RELEASE};_CRT_SECURE_NO_WARNINGS")
    set(VSTGUI_LTO_COMPILER_FLAGS "/GL /MP")
    set(VSTGUI_LTO_LINKER_FLAGS "/LTCG")
    set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} /MP")
    set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} /Zi")
    set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} /utf-8")
    set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} /Zc:__cplusplus")
    set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} /permissive-")
    set(CMAKE_STATIC_LINKER_FLAGS "${CMAKE_STATIC_LINKER_FLAGS} /IGNORE:4221")
endif()

##########################################################################################
set(VSTGUI_COMPILE_DEFINITIONS_DEBUG "${VSTGUI_COMPILE_DEFINITIONS_DEBUG};VSTGUI_LIVE_EDITING;DEBUG")
set(VSTGUI_COMPILE_DEFINITIONS_RELEASE "${VSTGUI_COMPILE_DEFINITIONS_RELEASE};NDEBUG;RELEASE")

if(VSTGUI_ENABLE_DEPRECATED_METHODS)
	set(VSTGUI_COMPILE_DEFINITIONS_DEBUG "${VSTGUI_COMPILE_DEFINITIONS_DEBUG};VSTGUI_ENABLE_DEPRECATED_METHODS=1")
	set(VSTGUI_COMPILE_DEFINITIONS_RELEASE "${VSTGUI_COMPILE_DEFINITIONS_RELEASE};VSTGUI_ENABLE_DEPRECATED_METHODS=1")
else()
	set(VSTGUI_COMPILE_DEFINITIONS_DEBUG "${VSTGUI_COMPILE_DEFINITIONS_DEBUG};VSTGUI_ENABLE_DEPRECATED_METHODS=0")
	set(VSTGUI_COMPILE_DEFINITIONS_RELEASE "${VSTGUI_COMPILE_DEFINITIONS_RELEASE};VSTGUI_ENABLE_DEPRECATED_METHODS=0")
endif()

if(VSTGUI_ENABLE_XMLPARSER)
	set(VSTGUI_COMPILE_DEFINITIONS_DEBUG "${VSTGUI_COMPILE_DEFINITIONS_DEBUG};VSTGUI_ENABLE_XML_PARSER=1")
	set(VSTGUI_COMPILE_DEFINITIONS_RELEASE "${VSTGUI_COMPILE_DEFINITIONS_RELEASE};VSTGUI_ENABLE_XML_PARSER=1")
else()
	set(VSTGUI_COMPILE_DEFINITIONS_DEBUG "${VSTGUI_COMPILE_DEFINITIONS_DEBUG};VSTGUI_ENABLE_XML_PARSER=0")
	set(VSTGUI_COMPILE_DEFINITIONS_RELEASE "${VSTGUI_COMPILE_DEFINITIONS_RELEASE};VSTGUI_ENABLE_XML_PARSER=0")
endif()

if(VSTGUI_ENABLE_OPENGL_SUPPORT)
	set(VSTGUI_COMPILE_DEFINITIONS_DEBUG "${VSTGUI_COMPILE_DEFINITIONS_DEBUG};VSTGUI_OPENGL_SUPPORT=1")
	set(VSTGUI_COMPILE_DEFINITIONS_RELEASE "${VSTGUI_COMPILE_DEFINITIONS_RELEASE};VSTGUI_OPENGL_SUPPORT=1")
else()
	set(VSTGUI_COMPILE_DEFINITIONS_DEBUG "${VSTGUI_COMPILE_DEFINITIONS_DEBUG};VSTGUI_OPENGL_SUPPORT=0")
	set(VSTGUI_COMPILE_DEFINITIONS_RELEASE "${VSTGUI_COMPILE_DEFINITIONS_RELEASE};VSTGUI_OPENGL_SUPPORT=0")
endif()

set(VSTGUI_COMPILE_DEFINITIONS PRIVATE
    $<$<CONFIG:Debug>:${VSTGUI_COMPILE_DEFINITIONS_DEBUG}>
    $<$<CONFIG:Release>:${VSTGUI_COMPILE_DEFINITIONS_RELEASE}>
    $<$<CONFIG:ReleaseLTO>:${VSTGUI_COMPILE_DEFINITIONS_RELEASE}>
        CACHE INTERNAL "VSTGUI compile definitions"
)

##########################################################################################
set(CMAKE_CXX_FLAGS_RELEASELTO
    "${CMAKE_CXX_FLAGS_RELEASE} ${VSTGUI_LTO_COMPILER_FLAGS}"
)
set(CMAKE_EXE_LINKER_FLAGS_RELEASELTO
    "${CMAKE_EXE_LINKER_FLAGS_RELEASE} ${VSTGUI_LTO_LINKER_FLAGS}"
)
set(CMAKE_STATIC_LINKER_FLAGS_RELEASELTO
    "${CMAKE_STATIC_LINKER_FLAGS_RELEASE} ${VSTGUI_LTO_LINKER_FLAGS}"
)

