// This test uses '<prefix>-SAME: {{^}}' to start matching immediately where the
// previous check finished matching (specifically, caret is not treated as
// matching a start of line when used like this in FileCheck).

// RUN: not %clang_cc1 -triple i386--- -target-cpu not-a-cpu -fsyntax-only %s 2>&1 | FileCheck %s --check-prefix X86
// X86: error: unknown target CPU 'not-a-cpu'
// X86-NEXT: note: valid target CPU values are:
// X86-SAME: {{^}} i386
// X86-SAME: {{^}}, i486
// X86-SAME: {{^}}, winchip-c6
// X86-SAME: {{^}}, winchip2
// X86-SAME: {{^}}, c3
// X86-SAME: {{^}}, i586
// X86-SAME: {{^}}, pentium
// X86-SAME: {{^}}, pentium-mmx
// X86-SAME: {{^}}, pentiumpro
// X86-SAME: {{^}}, i686
// X86-SAME: {{^}}, pentium2
// X86-SAME: {{^}}, pentium3
// X86-SAME: {{^}}, pentium3m
// X86-SAME: {{^}}, pentium-m
// X86-SAME: {{^}}, c3-2
// X86-SAME: {{^}}, yonah
// X86-SAME: {{^}}, pentium4
// X86-SAME: {{^}}, pentium4m
// X86-SAME: {{^}}, prescott
// X86-SAME: {{^}}, nocona
// X86-SAME: {{^}}, core2
// X86-SAME: {{^}}, penryn
// X86-SAME: {{^}}, bonnell
// X86-SAME: {{^}}, atom
// X86-SAME: {{^}}, silvermont
// X86-SAME: {{^}}, slm
// X86-SAME: {{^}}, goldmont
// X86-SAME: {{^}}, goldmont-plus
// X86-SAME: {{^}}, tremont
// X86-SAME: {{^}}, nehalem
// X86-SAME: {{^}}, corei7
// X86-SAME: {{^}}, westmere
// X86-SAME: {{^}}, sandybridge
// X86-SAME: {{^}}, corei7-avx
// X86-SAME: {{^}}, ivybridge
// X86-SAME: {{^}}, core-avx-i
// X86-SAME: {{^}}, haswell
// X86-SAME: {{^}}, core-avx2
// X86-SAME: {{^}}, broadwell
// X86-SAME: {{^}}, skylake
// X86-SAME: {{^}}, skylake-avx512
// X86-SAME: {{^}}, skx
// X86-SAME: {{^}}, cascadelake
// X86-SAME: {{^}}, cooperlake
// X86-SAME: {{^}}, cannonlake
// X86-SAME: {{^}}, icelake-client
// X86-SAME: {{^}}, rocketlake
// X86-SAME: {{^}}, icelake-server
// X86-SAME: {{^}}, tigerlake
// X86-SAME: {{^}}, sapphirerapids
// X86-SAME: {{^}}, alderlake
// X86-SAME: {{^}}, raptorlake
// X86-SAME: {{^}}, meteorlake
// X86-SAME: {{^}}, arrowlake
// X86-SAME: {{^}}, arrowlake-s
// X86-SAME: {{^}}, lunarlake
// X86-SAME: {{^}}, gracemont
// X86-SAME: {{^}}, pantherlake
// X86-SAME: {{^}}, sierraforest
// X86-SAME: {{^}}, grandridge
// X86-SAME: {{^}}, graniterapids
// X86-SAME: {{^}}, graniterapids-d
// X86-SAME: {{^}}, emeraldrapids
// X86-SAME: {{^}}, clearwaterforest
// X86-SAME: {{^}}, diamondrapids
// X86-SAME: {{^}}, knl
// X86-SAME: {{^}}, knm
// X86-SAME: {{^}}, lakemont
// X86-SAME: {{^}}, k6
// X86-SAME: {{^}}, k6-2
// X86-SAME: {{^}}, k6-3
// X86-SAME: {{^}}, athlon
// X86-SAME: {{^}}, athlon-tbird
// X86-SAME: {{^}}, athlon-xp
// X86-SAME: {{^}}, athlon-mp
// X86-SAME: {{^}}, athlon-4
// X86-SAME: {{^}}, k8
// X86-SAME: {{^}}, athlon64
// X86-SAME: {{^}}, athlon-fx
// X86-SAME: {{^}}, opteron
// X86-SAME: {{^}}, k8-sse3
// X86-SAME: {{^}}, athlon64-sse3
// X86-SAME: {{^}}, opteron-sse3
// X86-SAME: {{^}}, amdfam10
// X86-SAME: {{^}}, barcelona
// X86-SAME: {{^}}, btver1
// X86-SAME: {{^}}, btver2
// X86-SAME: {{^}}, bdver1
// X86-SAME: {{^}}, bdver2
// X86-SAME: {{^}}, bdver3
// X86-SAME: {{^}}, bdver4
// X86-SAME: {{^}}, znver1
// X86-SAME: {{^}}, znver2
// X86-SAME: {{^}}, znver3
// X86-SAME: {{^}}, znver4
// X86-SAME: {{^}}, znver5
// X86-SAME: {{^}}, x86-64
// X86-SAME: {{^}}, x86-64-v2
// X86-SAME: {{^}}, x86-64-v3
// X86-SAME: {{^}}, x86-64-v4
// X86-SAME: {{^}}, geode
// X86-SAME: {{$}}

// RUN: not %clang_cc1 -triple x86_64--- -target-cpu not-a-cpu -fsyntax-only %s 2>&1 | FileCheck %s --check-prefix=X86_64 
// X86_64: error: unknown target CPU 'not-a-cpu'
// X86_64-NEXT: note: valid target CPU values are:
// X86_64-SAME: {{^}} nocona
// X86_64-SAME: {{^}}, core2
// X86_64-SAME: {{^}}, penryn
// X86_64-SAME: {{^}}, bonnell
// X86_64-SAME: {{^}}, atom
// X86_64-SAME: {{^}}, silvermont
// X86_64-SAME: {{^}}, slm
// X86_64-SAME: {{^}}, goldmont
// X86_64-SAME: {{^}}, goldmont-plus
// X86_64-SAME: {{^}}, tremont
// X86_64-SAME: {{^}}, nehalem
// X86_64-SAME: {{^}}, corei7
// X86_64-SAME: {{^}}, westmere
// X86_64-SAME: {{^}}, sandybridge
// X86_64-SAME: {{^}}, corei7-avx
// X86_64-SAME: {{^}}, ivybridge
// X86_64-SAME: {{^}}, core-avx-i
// X86_64-SAME: {{^}}, haswell
// X86_64-SAME: {{^}}, core-avx2
// X86_64-SAME: {{^}}, broadwell
// X86_64-SAME: {{^}}, skylake
// X86_64-SAME: {{^}}, skylake-avx512
// X86_64-SAME: {{^}}, skx
// X86_64-SAME: {{^}}, cascadelake
// X86_64-SAME: {{^}}, cooperlake
// X86_64-SAME: {{^}}, cannonlake
// X86_64-SAME: {{^}}, icelake-client
// X86_64-SAME: {{^}}, rocketlake
// X86_64-SAME: {{^}}, icelake-server
// X86_64-SAME: {{^}}, tigerlake
// X86_64-SAME: {{^}}, sapphirerapids
// X86_64-SAME: {{^}}, alderlake
// X86_64-SAME: {{^}}, raptorlake
// X86_64-SAME: {{^}}, meteorlake
// X86_64-SAME: {{^}}, arrowlake
// X86_64-SAME: {{^}}, arrowlake-s
// X86_64-SAME: {{^}}, lunarlake
// X86_64-SAME: {{^}}, gracemont
// X86_64-SAME: {{^}}, pantherlake
// X86_64-SAME: {{^}}, sierraforest
// X86_64-SAME: {{^}}, grandridge
// X86_64-SAME: {{^}}, graniterapids
// X86_64-SAME: {{^}}, graniterapids-d
// X86_64-SAME: {{^}}, emeraldrapids
// X86_64-SAME: {{^}}, clearwaterforest
// X86_64-SAME: {{^}}, diamondrapids
// X86_64-SAME: {{^}}, knl
// X86_64-SAME: {{^}}, knm
// X86_64-SAME: {{^}}, k8
// X86_64-SAME: {{^}}, athlon64
// X86_64-SAME: {{^}}, athlon-fx
// X86_64-SAME: {{^}}, opteron
// X86_64-SAME: {{^}}, k8-sse3
// X86_64-SAME: {{^}}, athlon64-sse3
// X86_64-SAME: {{^}}, opteron-sse3
// X86_64-SAME: {{^}}, amdfam10
// X86_64-SAME: {{^}}, barcelona
// X86_64-SAME: {{^}}, btver1
// X86_64-SAME: {{^}}, btver2
// X86_64-SAME: {{^}}, bdver1
// X86_64-SAME: {{^}}, bdver2
// X86_64-SAME: {{^}}, bdver3
// X86_64-SAME: {{^}}, bdver4
// X86_64-SAME: {{^}}, znver1
// X86_64-SAME: {{^}}, znver2
// X86_64-SAME: {{^}}, znver3
// X86_64-SAME: {{^}}, znver4
// X86_64-SAME: {{^}}, znver5
// X86_64-SAME: {{^}}, x86-64
// X86_64-SAME: {{^}}, x86-64-v2
// X86_64-SAME: {{^}}, x86-64-v3
// X86_64-SAME: {{^}}, x86-64-v4
// X86_64-SAME: {{$}}

// RUN: not %clang_cc1 -triple i386--- -tune-cpu not-a-cpu -fsyntax-only %s 2>&1 | FileCheck %s --check-prefix=TUNE_X86
// TUNE_X86: error: unknown target CPU 'not-a-cpu'
// TUNE_X86-NEXT: note: valid target CPU values are:
// TUNE_X86-SAME: {{^}} i386
// TUNE_X86-SAME: {{^}}, i486
// TUNE_X86-SAME: {{^}}, winchip-c6
// TUNE_X86-SAME: {{^}}, winchip2
// TUNE_X86-SAME: {{^}}, c3
// TUNE_X86-SAME: {{^}}, i586
// TUNE_X86-SAME: {{^}}, pentium
// TUNE_X86-SAME: {{^}}, pentium-mmx
// TUNE_X86-SAME: {{^}}, pentiumpro
// TUNE_X86-SAME: {{^}}, i686
// TUNE_X86-SAME: {{^}}, pentium2
// TUNE_X86-SAME: {{^}}, pentium3
// TUNE_X86-SAME: {{^}}, pentium3m
// TUNE_X86-SAME: {{^}}, pentium-m
// TUNE_X86-SAME: {{^}}, c3-2
// TUNE_X86-SAME: {{^}}, yonah
// TUNE_X86-SAME: {{^}}, pentium4
// TUNE_X86-SAME: {{^}}, pentium4m
// TUNE_X86-SAME: {{^}}, prescott
// TUNE_X86-SAME: {{^}}, nocona
// TUNE_X86-SAME: {{^}}, core2
// TUNE_X86-SAME: {{^}}, penryn
// TUNE_X86-SAME: {{^}}, bonnell
// TUNE_X86-SAME: {{^}}, atom
// TUNE_X86-SAME: {{^}}, silvermont
// TUNE_X86-SAME: {{^}}, slm
// TUNE_X86-SAME: {{^}}, goldmont
// TUNE_X86-SAME: {{^}}, goldmont-plus
// TUNE_X86-SAME: {{^}}, tremont
// TUNE_X86-SAME: {{^}}, nehalem
// TUNE_X86-SAME: {{^}}, corei7
// TUNE_X86-SAME: {{^}}, westmere
// TUNE_X86-SAME: {{^}}, sandybridge
// TUNE_X86-SAME: {{^}}, corei7-avx
// TUNE_X86-SAME: {{^}}, ivybridge
// TUNE_X86-SAME: {{^}}, core-avx-i
// TUNE_X86-SAME: {{^}}, haswell
// TUNE_X86-SAME: {{^}}, core-avx2
// TUNE_X86-SAME: {{^}}, broadwell
// TUNE_X86-SAME: {{^}}, skylake
// TUNE_X86-SAME: {{^}}, skylake-avx512
// TUNE_X86-SAME: {{^}}, skx
// TUNE_X86-SAME: {{^}}, cascadelake
// TUNE_X86-SAME: {{^}}, cooperlake
// TUNE_X86-SAME: {{^}}, cannonlake
// TUNE_X86-SAME: {{^}}, icelake-client
// TUNE_X86-SAME: {{^}}, rocketlake
// TUNE_X86-SAME: {{^}}, icelake-server
// TUNE_X86-SAME: {{^}}, tigerlake
// TUNE_X86-SAME: {{^}}, sapphirerapids
// TUNE_X86-SAME: {{^}}, alderlake
// TUNE_X86-SAME: {{^}}, raptorlake
// TUNE_X86-SAME: {{^}}, meteorlake
// TUNE_X86-SAME: {{^}}, arrowlake
// TUNE_X86-SAME: {{^}}, arrowlake-s
// TUNE_X86-SAME: {{^}}, lunarlake
// TUNE_X86-SAME: {{^}}, gracemont
// TUNE_X86-SAME: {{^}}, pantherlake
// TUNE_X86-SAME: {{^}}, sierraforest
// TUNE_X86-SAME: {{^}}, grandridge
// TUNE_X86-SAME: {{^}}, graniterapids
// TUNE_X86-SAME: {{^}}, graniterapids-d
// TUNE_X86-SAME: {{^}}, emeraldrapids
// TUNE_X86-SAME: {{^}}, clearwaterforest
// TUNE_X86-SAME: {{^}}, diamondrapids
// TUNE_X86-SAME: {{^}}, knl
// TUNE_X86-SAME: {{^}}, knm
// TUNE_X86-SAME: {{^}}, lakemont
// TUNE_X86-SAME: {{^}}, k6
// TUNE_X86-SAME: {{^}}, k6-2
// TUNE_X86-SAME: {{^}}, k6-3
// TUNE_X86-SAME: {{^}}, athlon
// TUNE_X86-SAME: {{^}}, athlon-tbird
// TUNE_X86-SAME: {{^}}, athlon-xp
// TUNE_X86-SAME: {{^}}, athlon-mp
// TUNE_X86-SAME: {{^}}, athlon-4
// TUNE_X86-SAME: {{^}}, k8
// TUNE_X86-SAME: {{^}}, athlon64
// TUNE_X86-SAME: {{^}}, athlon-fx
// TUNE_X86-SAME: {{^}}, opteron
// TUNE_X86-SAME: {{^}}, k8-sse3
// TUNE_X86-SAME: {{^}}, athlon64-sse3
// TUNE_X86-SAME: {{^}}, opteron-sse3
// TUNE_X86-SAME: {{^}}, amdfam10
// TUNE_X86-SAME: {{^}}, barcelona
// TUNE_X86-SAME: {{^}}, btver1
// TUNE_X86-SAME: {{^}}, btver2
// TUNE_X86-SAME: {{^}}, bdver1
// TUNE_X86-SAME: {{^}}, bdver2
// TUNE_X86-SAME: {{^}}, bdver3
// TUNE_X86-SAME: {{^}}, bdver4
// TUNE_X86-SAME: {{^}}, znver1
// TUNE_X86-SAME: {{^}}, znver2
// TUNE_X86-SAME: {{^}}, znver3
// TUNE_X86-SAME: {{^}}, znver4
// TUNE_X86-SAME: {{^}}, znver5
// TUNE_X86-SAME: {{^}}, x86-64
// TUNE_X86-SAME: {{^}}, geode
// TUNE_X86-SAME: {{$}}

// RUN: not %clang_cc1 -triple x86_64--- -tune-cpu not-a-cpu -fsyntax-only %s 2>&1 | FileCheck %s --check-prefix=TUNE_X86_64
// TUNE_X86_64: error: unknown target CPU 'not-a-cpu'
// TUNE_X86_64-NEXT: note: valid target CPU values are:
// TUNE_X86_64-SAME: {{^}} i386
// TUNE_X86_64-SAME: {{^}}, i486
// TUNE_X86_64-SAME: {{^}}, winchip-c6
// TUNE_X86_64-SAME: {{^}}, winchip2
// TUNE_X86_64-SAME: {{^}}, c3
// TUNE_X86_64-SAME: {{^}}, i586
// TUNE_X86_64-SAME: {{^}}, pentium
// TUNE_X86_64-SAME: {{^}}, pentium-mmx
// TUNE_X86_64-SAME: {{^}}, pentiumpro
// TUNE_X86_64-SAME: {{^}}, i686
// TUNE_X86_64-SAME: {{^}}, pentium2
// TUNE_X86_64-SAME: {{^}}, pentium3
// TUNE_X86_64-SAME: {{^}}, pentium3m
// TUNE_X86_64-SAME: {{^}}, pentium-m
// TUNE_X86_64-SAME: {{^}}, c3-2
// TUNE_X86_64-SAME: {{^}}, yonah
// TUNE_X86_64-SAME: {{^}}, pentium4
// TUNE_X86_64-SAME: {{^}}, pentium4m
// TUNE_X86_64-SAME: {{^}}, prescott
// TUNE_X86_64-SAME: {{^}}, nocona
// TUNE_X86_64-SAME: {{^}}, core2
// TUNE_X86_64-SAME: {{^}}, penryn
// TUNE_X86_64-SAME: {{^}}, bonnell
// TUNE_X86_64-SAME: {{^}}, atom
// TUNE_X86_64-SAME: {{^}}, silvermont
// TUNE_X86_64-SAME: {{^}}, slm
// TUNE_X86_64-SAME: {{^}}, goldmont
// TUNE_X86_64-SAME: {{^}}, goldmont-plus
// TUNE_X86_64-SAME: {{^}}, tremont
// TUNE_X86_64-SAME: {{^}}, nehalem
// TUNE_X86_64-SAME: {{^}}, corei7
// TUNE_X86_64-SAME: {{^}}, westmere
// TUNE_X86_64-SAME: {{^}}, sandybridge
// TUNE_X86_64-SAME: {{^}}, corei7-avx
// TUNE_X86_64-SAME: {{^}}, ivybridge
// TUNE_X86_64-SAME: {{^}}, core-avx-i
// TUNE_X86_64-SAME: {{^}}, haswell
// TUNE_X86_64-SAME: {{^}}, core-avx2
// TUNE_X86_64-SAME: {{^}}, broadwell
// TUNE_X86_64-SAME: {{^}}, skylake
// TUNE_X86_64-SAME: {{^}}, skylake-avx512
// TUNE_X86_64-SAME: {{^}}, skx
// TUNE_X86_64-SAME: {{^}}, cascadelake
// TUNE_X86_64-SAME: {{^}}, cooperlake
// TUNE_X86_64-SAME: {{^}}, cannonlake
// TUNE_X86_64-SAME: {{^}}, icelake-client
// TUNE_X86_64-SAME: {{^}}, rocketlake
// TUNE_X86_64-SAME: {{^}}, icelake-server
// TUNE_X86_64-SAME: {{^}}, tigerlake
// TUNE_X86_64-SAME: {{^}}, sapphirerapids
// TUNE_X86_64-SAME: {{^}}, alderlake
// TUNE_X86_64-SAME: {{^}}, raptorlake
// TUNE_X86_64-SAME: {{^}}, meteorlake
// TUNE_X86_64-SAME: {{^}}, arrowlake
// TUNE_X86_64-SAME: {{^}}, arrowlake-s
// TUNE_X86_64-SAME: {{^}}, lunarlake
// TUNE_X86_64-SAME: {{^}}, gracemont
// TUNE_X86_64-SAME: {{^}}, pantherlake
// TUNE_X86_64-SAME: {{^}}, sierraforest
// TUNE_X86_64-SAME: {{^}}, grandridge
// TUNE_X86_64-SAME: {{^}}, graniterapids
// TUNE_X86_64-SAME: {{^}}, graniterapids-d
// TUNE_X86_64-SAME: {{^}}, emeraldrapids
// TUNE_X86_64-SAME: {{^}}, clearwaterforest
// TUNE_X86_64-SAME: {{^}}, diamondrapids
// TUNE_X86_64-SAME: {{^}}, knl
// TUNE_X86_64-SAME: {{^}}, knm
// TUNE_X86_64-SAME: {{^}}, lakemont
// TUNE_X86_64-SAME: {{^}}, k6
// TUNE_X86_64-SAME: {{^}}, k6-2
// TUNE_X86_64-SAME: {{^}}, k6-3
// TUNE_X86_64-SAME: {{^}}, athlon
// TUNE_X86_64-SAME: {{^}}, athlon-tbird
// TUNE_X86_64-SAME: {{^}}, athlon-xp
// TUNE_X86_64-SAME: {{^}}, athlon-mp
// TUNE_X86_64-SAME: {{^}}, athlon-4
// TUNE_X86_64-SAME: {{^}}, k8
// TUNE_X86_64-SAME: {{^}}, athlon64
// TUNE_X86_64-SAME: {{^}}, athlon-fx
// TUNE_X86_64-SAME: {{^}}, opteron
// TUNE_X86_64-SAME: {{^}}, k8-sse3
// TUNE_X86_64-SAME: {{^}}, athlon64-sse3
// TUNE_X86_64-SAME: {{^}}, opteron-sse3
// TUNE_X86_64-SAME: {{^}}, amdfam10
// TUNE_X86_64-SAME: {{^}}, barcelona
// TUNE_X86_64-SAME: {{^}}, btver1
// TUNE_X86_64-SAME: {{^}}, btver2
// TUNE_X86_64-SAME: {{^}}, bdver1
// TUNE_X86_64-SAME: {{^}}, bdver2
// TUNE_X86_64-SAME: {{^}}, bdver3
// TUNE_X86_64-SAME: {{^}}, bdver4
// TUNE_X86_64-SAME: {{^}}, znver1
// TUNE_X86_64-SAME: {{^}}, znver2
// TUNE_X86_64-SAME: {{^}}, znver3
// TUNE_X86_64-SAME: {{^}}, znver4
// TUNE_X86_64-SAME: {{^}}, znver5
// TUNE_X86_64-SAME: {{^}}, x86-64
// TUNE_X86_64-SAME: {{^}}, geode
// TUNE_X86_64-SAME: {{$}}
