; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=arm64-eabi -verify-machineinstrs | FileCheck %s

define i24 @ldi24(ptr %p) nounwind {
; CHECK-LABEL: ldi24:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrb w8, [x0, #2]
; CHECK-NEXT:    ldrh w9, [x0]
; CHECK-NEXT:    orr w0, w9, w8, lsl #16
; CHECK-NEXT:    ret
    %r = load i24, ptr %p
    ret i24 %r
}

define i56 @ldi56(ptr %p) nounwind {
; CHECK-LABEL: ldi56:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrb w8, [x0, #6]
; CHECK-NEXT:    ldrh w9, [x0, #4]
; CHECK-NEXT:    orr w8, w9, w8, lsl #16
; CHECK-NEXT:    ldr w9, [x0]
; CHECK-NEXT:    orr x0, x9, x8, lsl #32
; CHECK-NEXT:    ret
    %r = load i56, ptr %p
    ret i56 %r
}

define i80 @ldi80(ptr %p) nounwind {
; CHECK-LABEL: ldi80:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    ldrh w1, [x0, #8]
; CHECK-NEXT:    mov x0, x8
; CHECK-NEXT:    ret
    %r = load i80, ptr %p
    ret i80 %r
}

define i120 @ldi120(ptr %p) nounwind {
; CHECK-LABEL: ldi120:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrb w8, [x0, #14]
; CHECK-NEXT:    ldrh w9, [x0, #12]
; CHECK-NEXT:    orr w8, w9, w8, lsl #16
; CHECK-NEXT:    ldr w9, [x0, #8]
; CHECK-NEXT:    ldr x0, [x0]
; CHECK-NEXT:    orr x1, x9, x8, lsl #32
; CHECK-NEXT:    ret
    %r = load i120, ptr %p
    ret i120 %r
}

define i280 @ldi280(ptr %p) nounwind {
; CHECK-LABEL: ldi280:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrb w9, [x0, #34]
; CHECK-NEXT:    ldrh w10, [x0, #32]
; CHECK-NEXT:    ldp x8, x1, [x0]
; CHECK-NEXT:    ldp x2, x3, [x0, #16]
; CHECK-NEXT:    orr x4, x10, x9, lsl #16
; CHECK-NEXT:    mov x0, x8
; CHECK-NEXT:    ret
    %r = load i280, ptr %p
    ret i280 %r
}

define void @sti24(ptr %p, i24 %a) nounwind {
; CHECK-LABEL: sti24:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsr w8, w1, #16
; CHECK-NEXT:    strh w1, [x0]
; CHECK-NEXT:    strb w8, [x0, #2]
; CHECK-NEXT:    ret
    store i24 %a, ptr %p
    ret void
}

define void @sti56(ptr %p, i56 %a) nounwind {
; CHECK-LABEL: sti56:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsr x8, x1, #48
; CHECK-NEXT:    lsr x9, x1, #32
; CHECK-NEXT:    str w1, [x0]
; CHECK-NEXT:    strb w8, [x0, #6]
; CHECK-NEXT:    strh w9, [x0, #4]
; CHECK-NEXT:    ret
    store i56 %a, ptr %p
    ret void
}

define void @sti80(ptr %p, i80 %a) nounwind {
; CHECK-LABEL: sti80:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x2, [x0]
; CHECK-NEXT:    strh w3, [x0, #8]
; CHECK-NEXT:    ret
    store i80 %a, ptr %p
    ret void
}

define void @sti120(ptr %p, i120 %a) nounwind {
; CHECK-LABEL: sti120:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsr x8, x3, #48
; CHECK-NEXT:    lsr x9, x3, #32
; CHECK-NEXT:    str x2, [x0]
; CHECK-NEXT:    str w3, [x0, #8]
; CHECK-NEXT:    strb w8, [x0, #14]
; CHECK-NEXT:    strh w9, [x0, #12]
; CHECK-NEXT:    ret
    store i120 %a, ptr %p
    ret void
}

define void @sti280(ptr %p, i280 %a) nounwind {
; CHECK-LABEL: sti280:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsr x8, x6, #16
; CHECK-NEXT:    stp x4, x5, [x0, #16]
; CHECK-NEXT:    stp x2, x3, [x0]
; CHECK-NEXT:    strh w6, [x0, #32]
; CHECK-NEXT:    strb w8, [x0, #34]
; CHECK-NEXT:    ret
    store i280 %a, ptr %p
    ret void
}

define void @i56_or(ptr %a) {
; CHECK-LABEL: i56_or:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr w8, [x0]
; CHECK-NEXT:    mov x9, x0
; CHECK-NEXT:    ldrh w10, [x9, #4]!
; CHECK-NEXT:    ldrb w11, [x9, #2]
; CHECK-NEXT:    orr w8, w8, #0x180
; CHECK-NEXT:    str w8, [x0]
; CHECK-NEXT:    orr w8, w10, w11, lsl #16
; CHECK-NEXT:    strb w11, [x9, #2]
; CHECK-NEXT:    strh w8, [x9]
; CHECK-NEXT:    ret
  %aa = load i56, ptr %a, align 1
  %b = or i56 %aa, 384
  store i56 %b, ptr %a, align 1
  ret void
}

define void @i56_and_or(ptr %a) {
; CHECK-LABEL: i56_and_or:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr w8, [x0]
; CHECK-NEXT:    mov x9, x0
; CHECK-NEXT:    ldrh w10, [x9, #4]!
; CHECK-NEXT:    ldrb w11, [x9, #2]
; CHECK-NEXT:    orr w8, w8, #0x180
; CHECK-NEXT:    and w8, w8, #0xffffff80
; CHECK-NEXT:    strb w11, [x9, #2]
; CHECK-NEXT:    str w8, [x0]
; CHECK-NEXT:    orr w8, w10, w11, lsl #16
; CHECK-NEXT:    strh w8, [x9]
; CHECK-NEXT:    ret
  %b = load i56, ptr %a, align 1
  %c = and i56 %b, -128
  %d = or i56 %c, 384
  store i56 %d, ptr %a, align 1
  ret void
}

define void @i56_insert_bit(ptr %a, i1 zeroext %bit) {
; CHECK-LABEL: i56_insert_bit:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, x0
; CHECK-NEXT:    ldr w11, [x0]
; CHECK-NEXT:    ldrh w9, [x8, #4]!
; CHECK-NEXT:    ldrb w10, [x8, #2]
; CHECK-NEXT:    orr w9, w9, w10, lsl #16
; CHECK-NEXT:    strb w10, [x8, #2]
; CHECK-NEXT:    orr x11, x11, x9, lsl #32
; CHECK-NEXT:    strh w9, [x8]
; CHECK-NEXT:    and x11, x11, #0xffffffffffffdfff
; CHECK-NEXT:    orr w11, w11, w1, lsl #13
; CHECK-NEXT:    str w11, [x0]
; CHECK-NEXT:    ret
  %extbit = zext i1 %bit to i56
  %b = load i56, ptr %a, align 1
  %extbit.shl = shl nuw nsw i56 %extbit, 13
  %c = and i56 %b, -8193
  %d = or i56 %c, %extbit.shl
  store i56 %d, ptr %a, align 1
  ret void
}

