/* i086-dos16.sys.h
   created from i086-dos16.sys.bin, 5408 (0x1520) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) Markus Franz Xaver Johannes Oberhumer
   Copyright (C) Laszlo Molnar
   Copyright (C) John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_I086_DOS16_SYS_SIZE    5408
#define STUB_I086_DOS16_SYS_ADLER32 0xcd2bc44f
#define STUB_I086_DOS16_SYS_CRC32   0xd3934726

unsigned char stub_i086_dos16_sys[5408] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */ 148,  2,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */   0,  0,  0,  0,255,255,255,255,  0,  0, 10,  0,  0,  0, 96, 80,
/* 0x0040 */  83, 81, 82, 86, 87, 85,190,  0,  0,191,  0,  0,137,241,  6, 30,
/* 0x0050 */   7,253,243,164,252,187,  0,128,135,247,131,238,  0, 25,237, 87,
/* 0x0060 */ 233,255,255, 85, 80, 88, 33,161,216,208,213,  0,  0,  0,  0,  0,
/* 0x0070 */   0,  0,  0,  0,  0,  0,  0,  0, 45,164,232, 11,  0,114,250, 65,
/* 0x0080 */ 232,  6,  0,227, 21,227, 20,115,  6,131,233,  3,114,  6,136,204,
/* 0x0090 */ 172,247,208,149, 49,201,232,  6,  0, 17,201,117,  8, 65,232,  6,
/* 0x00a0 */   0,115,251, 65, 65, 65,129,253,  0,243,131,209,  1,141,  3,150,
/* 0x00b0 */ 243,164,150,235,  0,232,  2,  0, 17,201,  1,219,117,  4,173, 17,
/* 0x00c0 */ 192,147,195, 94,185,  0,  0,172, 44,232, 60,  1,119,249,193,  4,
/* 0x00d0 */   8, 41, 52,139, 28,134,223, 41,243,137, 28,173,226,  3,176,232,
/* 0x00e0 */ 176,233, 95,185,  0,  0,242,174,117, 20,117,  2,193,  5,  8, 41,
/* 0x00f0 */  61,139, 29,134,223, 41,251,137, 29,175,235,  3,  7, 97, 93, 95,
/* 0x0100 */  94, 90, 89, 91, 88,233,254,255,102,105,108,101, 32,102,111,114,
/* 0x0110 */ 109, 97,116, 32,101,108,102, 51, 50, 45,105, 51, 56, 54, 10, 10,
/* 0x0120 */  83,101, 99,116,105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,
/* 0x0130 */ 109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101,
/* 0x0140 */  32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32,
/* 0x0150 */  76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,
/* 0x0160 */ 102,102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,115, 10,
/* 0x0170 */  32, 32, 48, 32, 83, 89, 83, 77, 65, 73, 78, 49, 32, 32, 32, 32,
/* 0x0180 */  32, 32, 48, 97, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 52, 32,
/* 0x0190 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x01a0 */  32, 32, 49, 32, 83, 89, 83, 73, 50, 56, 54, 49, 32, 32, 32, 32,
/* 0x01b0 */  32, 32, 48, 49, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51,101, 32,
/* 0x01c0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x01d0 */  32, 32, 50, 32, 83, 89, 83, 73, 48, 56, 54, 49, 32, 32, 32, 32,
/* 0x01e0 */  32, 32, 48, 55, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51,102, 32,
/* 0x01f0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x0200 */  32, 32, 51, 32, 83, 89, 83, 77, 65, 73, 78, 50, 32, 32, 32, 32,
/* 0x0210 */  32, 32, 48, 49, 55, 32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 54,
/* 0x0220 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x0230 */  10, 32, 32, 52, 32, 83, 89, 83, 83, 66, 66, 66, 80, 32, 32, 32,
/* 0x0240 */  32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 53,100,
/* 0x0250 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x0260 */  10, 32, 32, 53, 32, 83, 89, 83, 67, 65, 76, 76, 84, 32, 32, 32,
/* 0x0270 */  32, 32, 32, 48, 49, 32, 32, 48, 32, 32, 48, 32, 32, 48, 53,102,
/* 0x0280 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x0290 */  10, 32, 32, 54, 32, 83, 89, 83, 77, 65, 73, 78, 51, 32, 32, 32,
/* 0x02a0 */  32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 54, 48,
/* 0x02b0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x02c0 */  10, 32, 32, 55, 32, 85, 80, 88, 49, 72, 69, 65, 68, 32, 32, 32,
/* 0x02d0 */  32, 32, 32, 48, 49, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 54,
/* 0x02e0 */  51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x02f0 */  83, 10, 32, 32, 56, 32, 83, 89, 83, 67, 85, 84, 80, 79, 32, 32,
/* 0x0300 */  32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 55, 57,
/* 0x0310 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x0320 */  10, 32, 32, 57, 32, 78, 82, 86, 50, 66, 49, 54, 48, 32, 32, 32,
/* 0x0330 */  32, 32, 32, 48, 97, 32, 32, 48, 32, 32, 48, 32, 32, 48, 55, 57,
/* 0x0340 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x0350 */  10, 32, 49, 48, 32, 78, 82, 86, 68, 68, 79, 78, 69, 32, 32, 32,
/* 0x0360 */  32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 56, 51,
/* 0x0370 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x0380 */  10, 32, 49, 49, 32, 78, 82, 86, 68, 82, 69, 84, 85, 32, 32, 32,
/* 0x0390 */  32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 56, 53,
/* 0x03a0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x03b0 */  10, 32, 49, 50, 32, 78, 82, 86, 68, 69, 67, 79, 49, 32, 32, 32,
/* 0x03c0 */  32, 32, 32, 48, 49,101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 56,
/* 0x03d0 */  55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x03e0 */  83, 10, 32, 49, 51, 32, 78, 82, 86, 76, 69, 68, 48, 48, 32, 32,
/* 0x03f0 */  32, 32, 32, 32, 48, 49, 32, 32, 48, 32, 32, 48, 32, 32, 48, 97,
/* 0x0400 */  53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x0410 */  83, 10, 32, 49, 52, 32, 78, 82, 86, 71, 84, 68, 48, 48, 32, 32,
/* 0x0420 */  32, 32, 32, 32, 48, 55, 32, 32, 48, 32, 32, 48, 32, 32, 48, 97,
/* 0x0430 */  54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x0440 */  83, 10, 32, 49, 53, 32, 78, 82, 86, 68, 69, 67, 79, 50, 32, 32,
/* 0x0450 */  32, 32, 32, 32, 48, 49, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x0460 */  97,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x0470 */  84, 83, 10, 32, 49, 54, 32, 67, 65, 76, 76, 84, 82, 49, 54, 32,
/* 0x0480 */  32, 32, 32, 32, 32, 48, 98, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x0490 */  99, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x04a0 */  84, 83, 10, 32, 49, 55, 32, 67, 84, 49, 54, 73, 50, 56, 54, 32,
/* 0x04b0 */  32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x04c0 */  99,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x04d0 */  84, 83, 10, 32, 49, 56, 32, 67, 84, 49, 54, 83, 85, 66, 48, 32,
/* 0x04e0 */  32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x04f0 */ 100, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x0500 */  84, 83, 10, 32, 49, 57, 32, 67, 84, 49, 54, 73, 48, 56, 54, 32,
/* 0x0510 */  32, 32, 32, 32, 32, 48, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x0520 */ 100, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x0530 */  84, 83, 10, 32, 50, 48, 32, 67, 65, 76, 76, 84, 82, 73, 50, 32,
/* 0x0540 */  32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x0550 */ 100, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x0560 */  84, 83, 10, 32, 50, 49, 32, 67, 84, 49, 54, 69, 56, 48, 48, 32,
/* 0x0570 */  32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x0580 */ 100,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x0590 */  84, 83, 10, 32, 50, 50, 32, 67, 84, 49, 54, 69, 57, 48, 48, 32,
/* 0x05a0 */  32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x05b0 */ 101, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x05c0 */  84, 83, 10, 32, 50, 51, 32, 67, 65, 76, 76, 84, 82, 73, 53, 32,
/* 0x05d0 */  32, 32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x05e0 */ 101, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x05f0 */  84, 83, 10, 32, 50, 52, 32, 67, 84, 49, 54, 74, 69, 78, 68, 32,
/* 0x0600 */  32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x0610 */ 101, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x0620 */  84, 83, 10, 32, 50, 53, 32, 67, 84, 49, 54, 74, 85, 76, 50, 32,
/* 0x0630 */  32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x0640 */ 101, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x0650 */  84, 83, 10, 32, 50, 54, 32, 67, 84, 49, 54, 73, 50, 56, 55, 32,
/* 0x0660 */  32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x0670 */ 101, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x0680 */  84, 83, 10, 32, 50, 55, 32, 67, 84, 49, 54, 83, 85, 66, 49, 32,
/* 0x0690 */  32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x06a0 */ 101,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x06b0 */  84, 83, 10, 32, 50, 56, 32, 67, 84, 49, 54, 73, 48, 56, 55, 32,
/* 0x06c0 */  32, 32, 32, 32, 32, 48, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x06d0 */ 102, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x06e0 */  84, 83, 10, 32, 50, 57, 32, 67, 65, 76, 76, 84, 82, 73, 54, 32,
/* 0x06f0 */  32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x0700 */ 102, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x0710 */  84, 83, 10, 32, 51, 48, 32, 83, 89, 83, 77, 65, 73, 78, 53, 32,
/* 0x0720 */  32, 32, 32, 32, 32, 48, 49, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x0730 */ 102, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x0740 */  84, 83, 10, 32, 51, 49, 32, 83, 89, 83, 73, 50, 56, 54, 50, 32,
/* 0x0750 */  32, 32, 32, 32, 32, 48, 49, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x0760 */ 102,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x0770 */  84, 83, 10, 32, 51, 50, 32, 83, 89, 83, 73, 48, 56, 54, 50, 32,
/* 0x0780 */  32, 32, 32, 32, 32, 48, 55, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x0790 */ 102,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x07a0 */  84, 83, 10, 32, 51, 51, 32, 83, 89, 83, 74, 85, 77, 80, 49, 32,
/* 0x07b0 */  32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x07c0 */  49, 48, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x07d0 */  78, 84, 83, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69,
/* 0x07e0 */  58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x07f0 */ 100, 32, 32, 83, 89, 83, 77, 65, 73, 78, 49, 32, 48, 32, 83, 89,
/* 0x0800 */  83, 77, 65, 73, 78, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x0810 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66, 49, 54, 48,
/* 0x0820 */  32, 48, 32, 78, 82, 86, 50, 66, 49, 54, 48, 10, 48, 48, 48, 48,
/* 0x0830 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86,
/* 0x0840 */  68, 69, 67, 79, 50, 32, 48, 32, 78, 82, 86, 68, 69, 67, 79, 50,
/* 0x0850 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x0860 */  32, 32, 67, 65, 76, 76, 84, 82, 49, 54, 32, 48, 32, 67, 65, 76,
/* 0x0870 */  76, 84, 82, 49, 54, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x0880 */  32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 73, 53, 32,
/* 0x0890 */  48, 32, 67, 65, 76, 76, 84, 82, 73, 53, 10, 48, 48, 48, 48, 48,
/* 0x08a0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76,
/* 0x08b0 */  84, 82, 73, 54, 32, 48, 32, 67, 65, 76, 76, 84, 82, 73, 54, 10,
/* 0x08c0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x08d0 */  32, 83, 89, 83, 73, 50, 56, 54, 49, 32, 48, 32, 83, 89, 83, 73,
/* 0x08e0 */  50, 56, 54, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x08f0 */  32, 32, 32,100, 32, 32, 83, 89, 83, 73, 48, 56, 54, 49, 32, 48,
/* 0x0900 */  32, 83, 89, 83, 73, 48, 56, 54, 49, 10, 48, 48, 48, 48, 48, 48,
/* 0x0910 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 83, 89, 83, 77, 65,
/* 0x0920 */  73, 78, 50, 32, 48, 32, 83, 89, 83, 77, 65, 73, 78, 50, 10, 48,
/* 0x0930 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x0940 */  83, 89, 83, 83, 66, 66, 66, 80, 32, 48, 32, 83, 89, 83, 83, 66,
/* 0x0950 */  66, 66, 80, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x0960 */  32, 32,100, 32, 32, 83, 89, 83, 67, 65, 76, 76, 84, 32, 48, 32,
/* 0x0970 */  83, 89, 83, 67, 65, 76, 76, 84, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x0980 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 83, 89, 83, 77, 65, 73,
/* 0x0990 */  78, 51, 32, 48, 32, 83, 89, 83, 77, 65, 73, 78, 51, 10, 48, 48,
/* 0x09a0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 85,
/* 0x09b0 */  80, 88, 49, 72, 69, 65, 68, 32, 48, 32, 85, 80, 88, 49, 72, 69,
/* 0x09c0 */  65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x09d0 */  32,100, 32, 32, 83, 89, 83, 67, 85, 84, 80, 79, 32, 48, 32, 83,
/* 0x09e0 */  89, 83, 67, 85, 84, 80, 79, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x09f0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 68, 68, 79, 78,
/* 0x0a00 */  69, 32, 48, 32, 78, 82, 86, 68, 68, 79, 78, 69, 10, 48, 48, 48,
/* 0x0a10 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82,
/* 0x0a20 */  86, 68, 82, 69, 84, 85, 32, 48, 32, 78, 82, 86, 68, 82, 69, 84,
/* 0x0a30 */  85, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x0a40 */ 100, 32, 32, 78, 82, 86, 68, 69, 67, 79, 49, 32, 48, 32, 78, 82,
/* 0x0a50 */  86, 68, 69, 67, 79, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x0a60 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 76, 69, 68, 48, 48,
/* 0x0a70 */  32, 48, 32, 78, 82, 86, 76, 69, 68, 48, 48, 10, 48, 48, 48, 48,
/* 0x0a80 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86,
/* 0x0a90 */  71, 84, 68, 48, 48, 32, 48, 32, 78, 82, 86, 71, 84, 68, 48, 48,
/* 0x0aa0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x0ab0 */  32, 32, 67, 84, 49, 54, 73, 50, 56, 54, 32, 48, 32, 67, 84, 49,
/* 0x0ac0 */  54, 73, 50, 56, 54, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x0ad0 */  32, 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 83, 85, 66, 48, 32,
/* 0x0ae0 */  48, 32, 67, 84, 49, 54, 83, 85, 66, 48, 10, 48, 48, 48, 48, 48,
/* 0x0af0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 49, 54,
/* 0x0b00 */  73, 48, 56, 54, 32, 48, 32, 67, 84, 49, 54, 73, 48, 56, 54, 10,
/* 0x0b10 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x0b20 */  32, 67, 65, 76, 76, 84, 82, 73, 50, 32, 48, 32, 67, 65, 76, 76,
/* 0x0b30 */  84, 82, 73, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x0b40 */  32, 32, 32,100, 32, 32, 67, 84, 49, 54, 69, 56, 48, 48, 32, 48,
/* 0x0b50 */  32, 67, 84, 49, 54, 69, 56, 48, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x0b60 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 69,
/* 0x0b70 */  57, 48, 48, 32, 48, 32, 67, 84, 49, 54, 69, 57, 48, 48, 10, 48,
/* 0x0b80 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x0b90 */  67, 84, 49, 54, 74, 69, 78, 68, 32, 48, 32, 67, 84, 49, 54, 74,
/* 0x0ba0 */  69, 78, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x0bb0 */  32, 32,100, 32, 32, 67, 84, 49, 54, 74, 85, 76, 50, 32, 48, 32,
/* 0x0bc0 */  67, 84, 49, 54, 74, 85, 76, 50, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x0bd0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 73, 50,
/* 0x0be0 */  56, 55, 32, 48, 32, 67, 84, 49, 54, 73, 50, 56, 55, 10, 48, 48,
/* 0x0bf0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x0c00 */  84, 49, 54, 83, 85, 66, 49, 32, 48, 32, 67, 84, 49, 54, 83, 85,
/* 0x0c10 */  66, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x0c20 */  32,100, 32, 32, 67, 84, 49, 54, 73, 48, 56, 55, 32, 48, 32, 67,
/* 0x0c30 */  84, 49, 54, 73, 48, 56, 55, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0c40 */  32,108, 32, 32, 32, 32,100, 32, 32, 83, 89, 83, 77, 65, 73, 78,
/* 0x0c50 */  53, 32, 48, 32, 83, 89, 83, 77, 65, 73, 78, 53, 10, 48, 48, 48,
/* 0x0c60 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 83, 89,
/* 0x0c70 */  83, 73, 50, 56, 54, 50, 32, 48, 32, 83, 89, 83, 73, 50, 56, 54,
/* 0x0c80 */  50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x0c90 */ 100, 32, 32, 83, 89, 83, 73, 48, 56, 54, 50, 32, 48, 32, 83, 89,
/* 0x0ca0 */  83, 73, 48, 56, 54, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x0cb0 */ 108, 32, 32, 32, 32,100, 32, 32, 83, 89, 83, 74, 85, 77, 80, 49,
/* 0x0cc0 */  32, 48, 32, 83, 89, 83, 74, 85, 77, 80, 49, 10, 48, 48, 48, 48,
/* 0x0cd0 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x0ce0 */  68, 42, 32, 48, 32, 97,116,116,114,105, 98,117,116,101, 10, 48,
/* 0x0cf0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x0d00 */  42, 85, 78, 68, 42, 32, 48, 32,105,110,116,101,114,114,117,112,
/* 0x0d10 */ 116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x0d20 */  32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32, 99,111,112,121, 95,
/* 0x0d30 */ 115,111,117,114, 99,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x0d40 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,
/* 0x0d50 */  99,111,112,121, 95,100,101,115,116,105,110, 97,116,105,111,110,
/* 0x0d60 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,
/* 0x0d70 */  32, 32, 42, 85, 78, 68, 42, 32, 48, 32,110,101,103, 95,101, 95,
/* 0x0d80 */ 108,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x0d90 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32, 99, 97,108,
/* 0x0da0 */ 108,116,114,105, 99,107, 95, 99, 97,108,108,115, 10, 48, 48, 48,
/* 0x0db0 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x0dc0 */  78, 68, 42, 32, 48, 32,111,114,105,103,105,110, 97,108, 95,115,
/* 0x0dd0 */ 116,114, 97,116,101,103,121, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x0de0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x0df0 */  91, 83, 89, 83, 77, 65, 73, 78, 49, 93, 58, 10, 79, 70, 70, 83,
/* 0x0e00 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x0e10 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x0e20 */  48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32,
/* 0x0e30 */  32, 32, 32, 32, 32, 32, 32, 32, 97,116,116,114,105, 98,117,116,
/* 0x0e40 */ 101, 10, 48, 48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 51, 56, 54,
/* 0x0e50 */  95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83,
/* 0x0e60 */  77, 65, 73, 78, 49, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82,
/* 0x0e70 */  95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x0e80 */  32,105,110,116,101,114,114,117,112,116, 10, 10, 82, 69, 76, 79,
/* 0x0e90 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x0ea0 */  79, 82, 32, 91, 83, 89, 83, 77, 65, 73, 78, 50, 93, 58, 10, 79,
/* 0x0eb0 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x0ec0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x0ed0 */  48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 49,
/* 0x0ee0 */  54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,111,112,121, 95,
/* 0x0ef0 */ 115,111,117,114, 99,101, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32,
/* 0x0f00 */  82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x0f10 */  32, 32, 99,111,112,121, 95,100,101,115,116,105,110, 97,116,105,
/* 0x0f20 */ 111,110, 10, 48, 48, 48, 48, 48, 48, 49, 54, 32, 82, 95, 51, 56,
/* 0x0f30 */  54, 95, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,110,101,
/* 0x0f40 */ 103, 95,101, 95,108,101,110, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x0f50 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x0f60 */  91, 83, 89, 83, 77, 65, 73, 78, 51, 93, 58, 10, 79, 70, 70, 83,
/* 0x0f70 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x0f80 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x0f90 */  48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 49, 54,
/* 0x0fa0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 49, 54, 48,
/* 0x0fb0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x0fc0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 66, 49,
/* 0x0fd0 */  54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x0fe0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x0ff0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82,
/* 0x1000 */  95, 51, 56, 54, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32,
/* 0x1010 */  32, 78, 82, 86, 68, 69, 67, 79, 50, 10, 48, 48, 48, 48, 48, 48,
/* 0x1020 */  48, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 49, 54, 32, 32, 32,
/* 0x1030 */  32, 32, 32, 32, 32, 78, 82, 86, 68, 69, 67, 79, 50, 10, 10, 82,
/* 0x1040 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x1050 */  83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 68, 68, 79, 78, 69, 93,
/* 0x1060 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x1070 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x1080 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56,
/* 0x1090 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x10a0 */  86, 68, 69, 67, 79, 50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x10b0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x10c0 */  78, 82, 86, 68, 82, 69, 84, 85, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x10d0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x10e0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x10f0 */  48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x1100 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 68, 69, 67, 79, 50, 10,
/* 0x1110 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x1120 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 68, 69, 67, 79,
/* 0x1130 */  49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x1140 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x1150 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95,
/* 0x1160 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1170 */  78, 82, 86, 50, 66, 49, 54, 48, 10, 48, 48, 48, 48, 48, 48, 49,
/* 0x1180 */  48, 32, 82, 95, 51, 56, 54, 95, 80, 67, 49, 54, 32, 32, 32, 32,
/* 0x1190 */  32, 32, 32, 32, 78, 82, 86, 68, 69, 67, 79, 50, 10, 48, 48, 48,
/* 0x11a0 */  48, 48, 48, 49, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 49, 54,
/* 0x11b0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 68, 69, 67, 79, 50,
/* 0x11c0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x11d0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 68, 69, 67,
/* 0x11e0 */  79, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x11f0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1200 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 55, 32, 82,
/* 0x1210 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1220 */  32, 78, 82, 86, 50, 66, 49, 54, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x1230 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x1240 */  82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 54, 93, 58, 10, 79, 70,
/* 0x1250 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x1260 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x1270 */  48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 49, 54,
/* 0x1280 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99, 97,108,108,116,114,
/* 0x1290 */ 105, 99,107, 95, 99, 97,108,108,115, 10, 10, 82, 69, 76, 79, 67,
/* 0x12a0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x12b0 */  82, 32, 91, 67, 65, 76, 76, 84, 82, 73, 50, 93, 58, 10, 79, 70,
/* 0x12c0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x12d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x12e0 */  48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x12f0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82,
/* 0x1300 */  49, 54, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x1310 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76,
/* 0x1320 */  84, 82, 73, 53, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x1330 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1340 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x1350 */  32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32,
/* 0x1360 */  32, 32, 32, 99, 97,108,108,116,114,105, 99,107, 95, 99, 97,108,
/* 0x1370 */ 108,115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x1380 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84, 49, 54,
/* 0x1390 */  74, 69, 78, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x13a0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x13b0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x13c0 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x13d0 */  32, 32, 32, 78, 82, 86, 68, 69, 67, 79, 50, 10, 10, 82, 69, 76,
/* 0x13e0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x13f0 */  70, 79, 82, 32, 91, 67, 84, 49, 54, 74, 85, 76, 50, 93, 58, 10,
/* 0x1400 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x1410 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x1420 */  10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95,
/* 0x1430 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76,
/* 0x1440 */  84, 82, 73, 54, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x1450 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65,
/* 0x1460 */  76, 76, 84, 82, 73, 54, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x1470 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1480 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x1490 */  48, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x14a0 */  32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 73, 53, 10, 10, 82,
/* 0x14b0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x14c0 */  83, 32, 70, 79, 82, 32, 91, 83, 89, 83, 74, 85, 77, 80, 49, 93,
/* 0x14d0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x14e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x14f0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56,
/* 0x1500 */  54, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32,111,114,
/* 0x1510 */ 105,103,105,110, 97,108, 95,115,116,114, 97,116,101,103,121, 10
};
