/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ngrams;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.language.Demo;
import org.languagetool.rules.ngrams.GoogleToken;
import org.languagetool.tagging.Tagger;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.WordTokenizer;

public class GoogleTokenTest {
    @Test
    public void testTokenization() {
        List tokens = GoogleToken.getGoogleTokens((String)"This, isn't a test.", (boolean)false, (Tokenizer)new MyWordTokenizer());
        MatcherAssert.assertThat((Object)((GoogleToken)tokens.get((int)0)).token, (Matcher)CoreMatchers.is((Object)"This"));
        MatcherAssert.assertThat((Object)((GoogleToken)tokens.get((int)0)).posTags.toString(), (Matcher)CoreMatchers.is((Object)"[]"));
        MatcherAssert.assertThat((Object)((GoogleToken)tokens.get((int)1)).token, (Matcher)CoreMatchers.is((Object)","));
        MatcherAssert.assertThat((Object)((GoogleToken)tokens.get((int)2)).token, (Matcher)CoreMatchers.is((Object)"isn"));
        MatcherAssert.assertThat((Object)((GoogleToken)tokens.get((int)3)).token, (Matcher)CoreMatchers.is((Object)"'t"));
        MatcherAssert.assertThat((Object)((GoogleToken)tokens.get((int)4)).token, (Matcher)CoreMatchers.is((Object)"a"));
        MatcherAssert.assertThat((Object)((GoogleToken)tokens.get((int)5)).token, (Matcher)CoreMatchers.is((Object)"test"));
        MatcherAssert.assertThat((Object)((GoogleToken)tokens.get((int)6)).token, (Matcher)CoreMatchers.is((Object)"."));
    }

    @Test
    public void testTokenizationWithPosTag() throws IOException {
        JLanguageTool lt = new JLanguageTool((Language)new PosTaggingDemo());
        AnalyzedSentence analyzedSentence = lt.getAnalyzedSentence("This, isn't a test.");
        List tokens = GoogleToken.getGoogleTokens((AnalyzedSentence)analyzedSentence, (boolean)false, (Tokenizer)new MyWordTokenizer());
        MatcherAssert.assertThat((Object)((GoogleToken)tokens.get((int)0)).token, (Matcher)CoreMatchers.is((Object)"This"));
        MatcherAssert.assertThat((Object)((GoogleToken)tokens.get((int)0)).posTags.toString(), (Matcher)CoreMatchers.is((Object)"[This/DT]"));
        MatcherAssert.assertThat((Object)((GoogleToken)tokens.get((int)1)).token, (Matcher)CoreMatchers.is((Object)","));
        MatcherAssert.assertThat((Object)((GoogleToken)tokens.get((int)1)).posTags.toString(), (Matcher)CoreMatchers.is((Object)"[,/null]"));
        MatcherAssert.assertThat((Object)((GoogleToken)tokens.get((int)2)).token, (Matcher)CoreMatchers.is((Object)"isn"));
        MatcherAssert.assertThat((Object)((GoogleToken)tokens.get((int)3)).token, (Matcher)CoreMatchers.is((Object)"'t"));
        MatcherAssert.assertThat((Object)((GoogleToken)tokens.get((int)4)).token, (Matcher)CoreMatchers.is((Object)"a"));
        MatcherAssert.assertThat((Object)((GoogleToken)tokens.get((int)5)).token, (Matcher)CoreMatchers.is((Object)"test"));
        MatcherAssert.assertThat((Object)((GoogleToken)tokens.get((int)5)).posTags.toString(), (Matcher)CoreMatchers.is((Object)"[test/NN]"));
        MatcherAssert.assertThat((Object)((GoogleToken)tokens.get((int)6)).token, (Matcher)CoreMatchers.is((Object)"."));
    }

    private class MyWordTokenizer
    extends WordTokenizer {
        private MyWordTokenizer() {
        }

        public List<String> tokenize(String text) {
            List tokens = super.tokenize(text);
            String prev = null;
            Stack<String> l = new Stack<String>();
            for (String token : tokens) {
                if ("'".equals(prev)) {
                    if (token.equals("t")) {
                        l.pop();
                        l.push("'t");
                    } else {
                        l.push(token);
                    }
                } else {
                    l.push(token);
                }
                prev = token;
            }
            return l;
        }
    }

    class PosTaggingDemo
    extends Demo {
        PosTaggingDemo() {
        }

        @Override
        public Tagger createDefaultTagger() {
            return new Tagger(){

                public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) {
                    ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
                    int pos = 0;
                    for (String word : sentenceTokens) {
                        ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
                        switch (word) {
                            case "This": {
                                l.add(new AnalyzedToken(word, "DT", word));
                                break;
                            }
                            case "is": {
                                l.add(new AnalyzedToken(word, "VBZ", word));
                                break;
                            }
                            case "test": {
                                l.add(new AnalyzedToken(word, "NN", word));
                                break;
                            }
                            default: {
                                l.add(new AnalyzedToken(word, null, word));
                            }
                        }
                        tokenReadings.add(new AnalyzedTokenReadings(l, pos));
                        pos += word.length();
                    }
                    return tokenReadings;
                }

                public AnalyzedTokenReadings createNullToken(String token, int startPos) {
                    return null;
                }

                public AnalyzedToken createToken(String token, String posTag) {
                    return null;
                }
            };
        }
    }
}

