/* SPDX-License-Identifier: (GPL-2.0-only OR MIT) */
/*
 * Copyright (c) 2025 Rockchip Electronics Co., Ltd.
 * Author: Elaine Zhang <zhangqing@rock-chips.com>
 */

#ifndef _DT_BINDINGS_CLK_ROCKCHIP_RV1126B_H
#define _DT_BINDINGS_CLK_ROCKCHIP_RV1126B_H

/* pll clocks */
#define PLL_GPLL				0
#define PLL_CPLL				1
#define PLL_AUPLL				2
#define ARMCLK					3
#define SCLK_DDR				4

/* clk (clocks) */
#define CLK_CPLL_DIV20				5
#define CLK_CPLL_DIV10				6
#define CLK_CPLL_DIV8				7
#define CLK_GPLL_DIV8				8
#define CLK_GPLL_DIV6				9
#define CLK_GPLL_DIV4				10
#define CLK_CPLL_DIV3				11
#define CLK_GPLL_DIV3				12
#define CLK_CPLL_DIV2				13
#define CLK_GPLL_DIV2				14
#define CLK_CM_FRAC0				15
#define CLK_CM_FRAC1				16
#define CLK_CM_FRAC2				17
#define CLK_UART_FRAC0				18
#define CLK_UART_FRAC1				19
#define CLK_AUDIO_FRAC0				20
#define CLK_AUDIO_FRAC1				21
#define CLK_AUDIO_INT0				22
#define CLK_AUDIO_INT1				23
#define SCLK_UART0_SRC				24
#define SCLK_UART1				25
#define SCLK_UART2				26
#define SCLK_UART3				27
#define SCLK_UART4				28
#define SCLK_UART5				29
#define SCLK_UART6				30
#define SCLK_UART7				31
#define MCLK_SAI0				32
#define MCLK_SAI1				33
#define MCLK_SAI2				34
#define MCLK_PDM				35
#define CLKOUT_PDM				36
#define MCLK_ASRC0				37
#define MCLK_ASRC1				38
#define MCLK_ASRC2				39
#define MCLK_ASRC3				40
#define CLK_ASRC0				41
#define CLK_ASRC1				42
#define CLK_CORE_PLL				43
#define CLK_NPU_PLL				44
#define CLK_VEPU_PLL				45
#define CLK_ISP_PLL				46
#define CLK_AISP_PLL				47
#define CLK_SARADC0_SRC				48
#define CLK_SARADC1_SRC				49
#define CLK_SARADC2_SRC				50
#define HCLK_NPU_ROOT				51
#define PCLK_NPU_ROOT				52
#define ACLK_VEPU_ROOT				53
#define HCLK_VEPU_ROOT				54
#define PCLK_VEPU_ROOT				55
#define CLK_CORE_RGA_SRC			56
#define ACLK_GMAC_ROOT				57
#define ACLK_VI_ROOT				58
#define HCLK_VI_ROOT				59
#define PCLK_VI_ROOT				60
#define DCLK_VICAP_ROOT				61
#define CLK_SYS_DSMC_ROOT			62
#define ACLK_VDO_ROOT				63
#define ACLK_RKVDEC_ROOT			64
#define HCLK_VDO_ROOT				65
#define PCLK_VDO_ROOT				66
#define DCLK_OOC_SRC				67
#define DCLK_VOP				68
#define DCLK_DECOM_SRC				69
#define PCLK_DDR_ROOT				70
#define ACLK_SYSMEM_SRC				71
#define ACLK_TOP_ROOT				72
#define ACLK_BUS_ROOT				73
#define HCLK_BUS_ROOT				74
#define PCLK_BUS_ROOT				75
#define CCLK_SDMMC0				76
#define CCLK_SDMMC1				77
#define CCLK_EMMC				78
#define SCLK_2X_FSPI0				79
#define CLK_GMAC_PTP_REF_SRC			80
#define CLK_GMAC_125M				81
#define CLK_TIMER_ROOT				82
#define TCLK_WDT_NS_SRC				83
#define TCLK_WDT_S_SRC				84
#define TCLK_WDT_HPMCU				85
#define CLK_CAN0				86
#define CLK_CAN1				87
#define PCLK_PERI_ROOT				88
#define ACLK_PERI_ROOT				89
#define CLK_I2C_BUS_SRC				90
#define CLK_SPI0				91
#define CLK_SPI1				92
#define BUSCLK_PMU_SRC				93
#define CLK_PWM0				94
#define CLK_PWM2				95
#define CLK_PWM3				96
#define CLK_PKA_RKCE_SRC			97
#define ACLK_RKCE_SRC				98
#define ACLK_VCP_ROOT				99
#define HCLK_VCP_ROOT				100
#define PCLK_VCP_ROOT				101
#define CLK_CORE_FEC_SRC			102
#define CLK_CORE_AVSP_SRC			103
#define CLK_50M_GMAC_IOBUF_VI			104
#define PCLK_TOP_ROOT				105
#define CLK_MIPI0_OUT2IO			106
#define CLK_MIPI1_OUT2IO			107
#define CLK_MIPI2_OUT2IO			108
#define CLK_MIPI3_OUT2IO			109
#define CLK_CIF_OUT2IO				110
#define CLK_MAC_OUT2IO				111
#define MCLK_SAI0_OUT2IO			112
#define MCLK_SAI1_OUT2IO			113
#define MCLK_SAI2_OUT2IO			114
#define CLK_CM_FRAC0_SRC			115
#define CLK_CM_FRAC1_SRC			116
#define CLK_CM_FRAC2_SRC			117
#define CLK_UART_FRAC0_SRC			118
#define CLK_UART_FRAC1_SRC			119
#define CLK_AUDIO_FRAC0_SRC			120
#define CLK_AUDIO_FRAC1_SRC			121
#define ACLK_NPU_ROOT				122
#define HCLK_RKNN				123
#define ACLK_RKNN				124
#define PCLK_GPIO3				125
#define DBCLK_GPIO3				126
#define PCLK_IOC_VCCIO3				127
#define PCLK_SARADC0				128
#define CLK_SARADC0				129
#define HCLK_SDMMC1				130
#define HCLK_VEPU				131
#define ACLK_VEPU				132
#define CLK_CORE_VEPU				133
#define HCLK_FEC				134
#define ACLK_FEC				135
#define CLK_CORE_FEC				136
#define HCLK_AVSP				137
#define ACLK_AVSP				138
#define BUSCLK_PMU1_ROOT			139
#define HCLK_AISP				140
#define ACLK_AISP				141
#define CLK_CORE_AISP				142
#define CLK_CORE_ISP_ROOT			143
#define PCLK_DSMC				144
#define ACLK_DSMC				145
#define HCLK_CAN0				146
#define HCLK_CAN1				147
#define PCLK_GPIO2				148
#define DBCLK_GPIO2				149
#define PCLK_GPIO4				150
#define DBCLK_GPIO4				151
#define PCLK_GPIO5				152
#define DBCLK_GPIO5				153
#define PCLK_GPIO6				154
#define DBCLK_GPIO6				155
#define PCLK_GPIO7				156
#define DBCLK_GPIO7				157
#define PCLK_IOC_VCCIO2				158
#define PCLK_IOC_VCCIO4				159
#define PCLK_IOC_VCCIO5				160
#define PCLK_IOC_VCCIO6				161
#define PCLK_IOC_VCCIO7				162
#define HCLK_ISP				163
#define ACLK_ISP				164
#define CLK_CORE_ISP				165
#define HCLK_VICAP				166
#define ACLK_VICAP				167
#define DCLK_VICAP				168
#define ISP0CLK_VICAP				169
#define HCLK_VPSS				170
#define ACLK_VPSS				171
#define CLK_CORE_VPSS				172
#define PCLK_CSI2HOST0				173
#define DCLK_CSI2HOST0				174
#define PCLK_CSI2HOST1				175
#define DCLK_CSI2HOST1				176
#define PCLK_CSI2HOST2				177
#define DCLK_CSI2HOST2				178
#define PCLK_CSI2HOST3				179
#define DCLK_CSI2HOST3				180
#define HCLK_SDMMC0				181
#define ACLK_GMAC				182
#define PCLK_GMAC				183
#define CLK_GMAC_PTP_REF			184
#define PCLK_CSIPHY0				185
#define PCLK_CSIPHY1				186
#define PCLK_MACPHY				187
#define PCLK_SARADC1				188
#define CLK_SARADC1				189
#define PCLK_SARADC2				190
#define CLK_SARADC2				191
#define ACLK_RKVDEC				192
#define HCLK_RKVDEC				193
#define CLK_HEVC_CA_RKVDEC			194
#define ACLK_VOP				195
#define HCLK_VOP				196
#define HCLK_RKJPEG				197
#define ACLK_RKJPEG				198
#define ACLK_RKMMU_DECOM			199
#define HCLK_RKMMU_DECOM			200
#define DCLK_DECOM				201
#define ACLK_DECOM				202
#define PCLK_DECOM				203
#define PCLK_MIPI_DSI				204
#define PCLK_DSIPHY				205
#define ACLK_OOC				206
#define ACLK_SYSMEM				207
#define PCLK_DDRC				208
#define PCLK_DDRMON				209
#define CLK_TIMER_DDRMON			210
#define PCLK_DFICTRL				211
#define PCLK_DDRPHY				212
#define PCLK_DMA2DDR				213
#define CLK_RCOSC_SRC				214
#define BUSCLK_PMU_MUX				215
#define BUSCLK_PMU_ROOT				216
#define PCLK_PMU				217
#define CLK_XIN_RC_DIV				218
#define CLK_32K					219
#define PCLK_PMU_GPIO0				220
#define DBCLK_PMU_GPIO0				221
#define PCLK_PMU_HP_TIMER			222
#define CLK_PMU_HP_TIMER			223
#define CLK_PMU_32K_HP_TIMER			224
#define PCLK_PWM1				225
#define CLK_PWM1				226
#define CLK_OSC_PWM1				227
#define CLK_RC_PWM1				228
#define CLK_FREQ_PWM1				229
#define CLK_COUNTER_PWM1			230
#define PCLK_I2C2				231
#define CLK_I2C2				232
#define PCLK_UART0				233
#define SCLK_UART0				234
#define PCLK_RCOSC_CTRL				235
#define CLK_OSC_RCOSC_CTRL			236
#define CLK_REF_RCOSC_CTRL			237
#define PCLK_IOC_PMUIO0				238
#define CLK_REFOUT				239
#define CLK_PREROLL				240
#define CLK_PREROLL_32K				241
#define HCLK_PMU_SRAM				242
#define PCLK_WDT_LPMCU				243
#define TCLK_WDT_LPMCU				244
#define CLK_LPMCU				245
#define CLK_LPMCU_RTC				246
#define PCLK_LPMCU_MAILBOX			247
#define HCLK_OOC				248
#define PCLK_SPI2AHB				249
#define HCLK_SPI2AHB				250
#define HCLK_FSPI1				251
#define HCLK_XIP_FSPI1				252
#define SCLK_1X_FSPI1				253
#define PCLK_IOC_PMUIO1				254
#define PCLK_AUDIO_ADC_PMU			255
#define MCLK_AUDIO_ADC_PMU			256
#define MCLK_AUDIO_ADC_DIV4_PMU			257
#define MCLK_LPSAI				258
#define ACLK_GIC400				259
#define PCLK_WDT_NS				260
#define TCLK_WDT_NS				261
#define PCLK_WDT_HPMCU				262
#define HCLK_CACHE				263
#define PCLK_HPMCU_MAILBOX			264
#define PCLK_HPMCU_INTMUX			265
#define CLK_HPMCU				266
#define CLK_HPMCU_RTC				267
#define PCLK_RKDMA				268
#define ACLK_RKDMA				269
#define PCLK_DCF				270
#define ACLK_DCF				271
#define HCLK_RGA				272
#define ACLK_RGA				273
#define CLK_CORE_RGA				274
#define PCLK_TIMER				275
#define CLK_TIMER0				276
#define CLK_TIMER1				277
#define CLK_TIMER2				278
#define CLK_TIMER3				279
#define CLK_TIMER4				280
#define CLK_TIMER5				281
#define PCLK_I2C0				282
#define CLK_I2C0				283
#define PCLK_I2C1				284
#define CLK_I2C1				285
#define PCLK_I2C3				286
#define CLK_I2C3				287
#define PCLK_I2C4				288
#define CLK_I2C4				289
#define PCLK_I2C5				290
#define CLK_I2C5				291
#define PCLK_SPI0				292
#define PCLK_SPI1				293
#define PCLK_PWM0				294
#define CLK_OSC_PWM0				295
#define CLK_RC_PWM0				296
#define PCLK_PWM2				297
#define CLK_OSC_PWM2				298
#define CLK_RC_PWM2				299
#define PCLK_PWM3				300
#define CLK_OSC_PWM3				301
#define CLK_RC_PWM3				302
#define PCLK_UART1				303
#define PCLK_UART2				304
#define PCLK_UART3				305
#define PCLK_UART4				306
#define PCLK_UART5				307
#define PCLK_UART6				308
#define PCLK_UART7				309
#define PCLK_TSADC				310
#define CLK_TSADC				311
#define HCLK_SAI0				312
#define HCLK_SAI1				313
#define HCLK_SAI2				314
#define HCLK_RKDSM				315
#define MCLK_RKDSM				316
#define HCLK_PDM				317
#define HCLK_ASRC0				318
#define HCLK_ASRC1				319
#define PCLK_AUDIO_ADC_BUS			320
#define MCLK_AUDIO_ADC_BUS			321
#define MCLK_AUDIO_ADC_DIV4_BUS			322
#define PCLK_RKCE				323
#define HCLK_NS_RKCE				324
#define PCLK_OTPC_NS				325
#define CLK_SBPI_OTPC_NS			326
#define CLK_USER_OTPC_NS			327
#define CLK_OTPC_ARB				328
#define PCLK_OTP_MASK				329
#define CLK_TSADC_PHYCTRL			330
#define LRCK_SRC_ASRC0				331
#define LRCK_DST_ASRC0				332
#define LRCK_SRC_ASRC1				333
#define LRCK_DST_ASRC1				334
#define PCLK_KEY_READER				335
#define ACLK_NSRKCE				336
#define CLK_PKA_NSRKCE				337
#define PCLK_RTC_ROOT				338
#define PCLK_GPIO1				339
#define DBCLK_GPIO1				340
#define PCLK_IOC_VCCIO1				341
#define ACLK_USB3OTG				342
#define CLK_REF_USB3OTG				343
#define CLK_SUSPEND_USB3OTG			344
#define HCLK_USB2HOST				345
#define HCLK_ARB_USB2HOST			346
#define PCLK_RTC_TEST				347
#define HCLK_EMMC				348
#define HCLK_FSPI0				349
#define HCLK_XIP_FSPI0				350
#define PCLK_PIPEPHY				351
#define PCLK_USB2PHY				352
#define CLK_REF_PIPEPHY_CPLL_SRC		353
#define CLK_REF_PIPEPHY				354
#define HCLK_VPSL				355
#define ACLK_VPSL				356
#define CLK_CORE_VPSL				357
#define CLK_MACPHY				358
#define HCLK_RKRNG_NS				359
#define HCLK_RKRNG_S_NS				360
#define CLK_AISP_PLL_SRC			361

/* secure clks */
#define CLK_USER_OTPC_S				362
#define CLK_SBPI_OTPC_S				363
#define PCLK_OTPC_S				364
#define PCLK_KEY_READER_S			365
#define HCLK_KL_RKCE_S				366
#define HCLK_RKCE_S				367
#define PCLK_WDT_S				368
#define TCLK_WDT_S				369
#define CLK_STIMER0				370
#define CLK_STIMER1				371
#define PLK_STIMER				372
#define HCLK_RKRNG_S				373
#define CLK_PKA_RKCE_S				374
#define ACLK_RKCE_S				375

#endif
