/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.text.Collator;
import java.util.Locale;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Charset;

public class Collation
implements SchemaObject {
    static String defaultCollationName = "SQL_TEXT";
    static String defaultIgnoreCaseCollationName = "SQL_TEXT_UCC";
    public static final HashMap nameToJavaName = new HashMap(101);
    public static final HashMap dbNameToJavaName = new HashMap(101);
    public static final HashMap dbNameToCollation = new HashMap(11);
    static final Collation defaultCollation;
    static final Collation defaultIgnoreCaseCollation;
    final HsqlNameManager.HsqlName name;
    private Collator collator;
    private Locale locale;
    private boolean isUnicodeSimple;
    private boolean isUpperCaseCompare;
    private boolean isFinal;
    private boolean padSpace = true;
    private Charset charset;
    private HsqlNameManager.HsqlName sourceName;

    private Collation(boolean bl) {
        String string = bl ? defaultCollationName : defaultIgnoreCaseCollationName;
        this.locale = Locale.ENGLISH;
        this.name = HsqlNameManager.newInfoSchemaObjectName(string, false, 15);
        this.isUnicodeSimple = bl;
        this.isFinal = true;
    }

    private Collation(String string, String string2, String string3, int n, int n2, boolean bl) {
        this.locale = new Locale(string2, string3);
        this.collator = Collator.getInstance(this.locale);
        if (n >= 0) {
            this.collator.setStrength(n);
        }
        if (n2 >= 0) {
            this.collator.setDecomposition(n2);
        }
        n = this.collator.getStrength();
        this.isUnicodeSimple = false;
        this.name = HsqlNameManager.newInfoSchemaObjectName(string, true, 15);
        this.charset = Charset.SQL_TEXT;
        this.isUpperCaseCompare = bl;
        this.isFinal = true;
    }

    public Collation(HsqlNameManager.HsqlName hsqlName, Collation collation, Charset charset, Boolean bl) {
        this.name = hsqlName;
        this.locale = collation.locale;
        this.collator = collation.collator;
        this.isUnicodeSimple = collation.isUnicodeSimple;
        this.isFinal = true;
        this.charset = charset;
        this.sourceName = collation.name;
        if (bl != null) {
            this.padSpace = bl;
        }
    }

    public static Collation getDefaultInstance() {
        return defaultCollation;
    }

    public static Collation getDefaultIgnoreCaseInstance() {
        return defaultIgnoreCaseCollation;
    }

    public static Collation newDatabaseInstance() {
        Collation collation = new Collation(true);
        collation.isFinal = false;
        return collation;
    }

    public static Iterator getCollationsIterator() {
        return nameToJavaName.keySet().iterator();
    }

    public static Iterator getLocalesIterator() {
        return nameToJavaName.values().iterator();
    }

    public static synchronized Collation getCollation(String string) {
        Collation collation = (Collation)dbNameToCollation.get(string);
        if (collation != null) {
            return collation;
        }
        collation = Collation.getNewCollation(string);
        dbNameToCollation.put(string, collation);
        return collation;
    }

    public static synchronized Collation getUpperCaseCompareCollation(Collation collation) {
        if (defaultCollationName.equals(collation.name.name) || defaultIgnoreCaseCollationName.equals(collation.name.name)) {
            return defaultIgnoreCaseCollation;
        }
        if (collation.isUpperCaseCompare) {
            return collation;
        }
        String string = collation.getName().name;
        if (string.contains(" UCC")) {
            return collation;
        }
        string = string + " UCC";
        return Collation.getCollation(string);
    }

    private static Collation getNewCollation(String string) {
        int n = -1;
        int n2 = -1;
        boolean bl = false;
        String[] stringArray = StringUtil.split(string, " ");
        String string2 = stringArray[0];
        int n3 = 1;
        int n4 = stringArray.length;
        if (stringArray.length > n3 && "UCC".equals(stringArray[n4 - 1])) {
            bl = true;
            --n4;
        }
        if (n3 < n4) {
            n = Integer.parseInt(stringArray[n3]);
            ++n3;
        }
        if (n3 < n4) {
            n2 = Integer.parseInt(stringArray[n3]);
            ++n3;
        }
        if (n3 < n4) {
            throw Error.error(5501, string);
        }
        String string3 = (String)dbNameToJavaName.get(string2);
        if (string3 == null && (string3 = (String)nameToJavaName.get(string2)) == null) {
            throw Error.error(5501, string2);
        }
        stringArray = StringUtil.split(string3, "-");
        String string4 = stringArray[0];
        String string5 = stringArray.length == 2 ? stringArray[1] : "";
        return new Collation(string, string4, string5, n, n2, bl);
    }

    public void setPadding(boolean bl) {
        if (this.isFinal) {
            throw Error.error(5503);
        }
        this.padSpace = bl;
    }

    public void setCollationAsLocale() {
        Locale locale = Locale.getDefault();
        String string = locale.getDisplayLanguage(Locale.ENGLISH);
        try {
            this.setCollation(string, false);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    public void setCollation(String string, boolean bl) {
        if (this.isFinal) {
            throw Error.error(5503, string);
        }
        Collation collation = Collation.getCollation(string);
        this.name.rename(collation.name.name, true);
        this.locale = collation.locale;
        this.collator = collation.collator;
        this.isUnicodeSimple = collation.isUnicodeSimple;
        this.padSpace = bl;
    }

    public boolean isPadSpace() {
        return this.padSpace;
    }

    public boolean isUnicodeSimple() {
        return this.isUnicodeSimple;
    }

    public boolean isUpperCaseCompare() {
        return this.isUpperCaseCompare;
    }

    public boolean isCaseSensitive() {
        if (this.collator == null) {
            return this.isUnicodeSimple;
        }
        return !this.isUpperCaseCompare;
    }

    public int compare(String string, String string2) {
        int n = this.collator == null ? (this.isUnicodeSimple ? string.compareTo(string2) : string.compareToIgnoreCase(string2)) : (this.isUpperCaseCompare ? this.collator.compare(this.toUpperCase(string), this.toUpperCase(string2)) : this.collator.compare(string, string2));
        return n == 0 ? 0 : (n < 0 ? -1 : 1);
    }

    public String toUpperCase(String string) {
        return string.toUpperCase(this.locale);
    }

    public String toLowerCase(String string) {
        return string.toLowerCase(this.locale);
    }

    public boolean isDefaultCollation() {
        return this.collator == null && this.isUnicodeSimple && this.padSpace;
    }

    public boolean isObjectCollation() {
        return this.isFinal;
    }

    @Override
    public int getType() {
        return 15;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        if (this.charset == null) {
            return new OrderedHashSet();
        }
        return this.charset.getReferences();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject schemaObject) {
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE").append(' ');
        stringBuilder.append("COLLATION").append(' ');
        if ("INFORMATION_SCHEMA".equals(this.name.schema.name)) {
            stringBuilder.append(this.name.getStatementName());
        } else {
            stringBuilder.append(this.name.getSchemaQualifiedStatementName());
        }
        stringBuilder.append(' ').append("FOR").append(' ');
        if ("INFORMATION_SCHEMA".equals(this.charset.name.schema.name)) {
            stringBuilder.append(this.charset.name.getStatementName());
        } else {
            stringBuilder.append(this.charset.name.getSchemaQualifiedStatementName());
        }
        stringBuilder.append(' ').append("FROM").append(' ');
        stringBuilder.append(this.sourceName.statementName);
        stringBuilder.append(' ');
        if (this.padSpace) {
            stringBuilder.append("PAD").append(' ').append("SPACE");
        } else {
            stringBuilder.append("NO").append(' ').append("PAD");
        }
        return stringBuilder.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public String getCollateSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("COLLATE").append(' ');
        if (this.isObjectCollation()) {
            stringBuilder.append(this.getName().getSchemaQualifiedStatementName());
        } else {
            stringBuilder.append(this.getName().statementName);
        }
        return stringBuilder.toString();
    }

    public String getDatabaseCollationSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SET").append(' ');
        stringBuilder.append("DATABASE").append(' ');
        stringBuilder.append("COLLATION").append(' ');
        stringBuilder.append(this.getName().statementName);
        stringBuilder.append(' ');
        if (this.padSpace) {
            stringBuilder.append("PAD").append(' ').append("SPACE");
        } else {
            stringBuilder.append("NO").append(' ').append("PAD");
        }
        return stringBuilder.toString();
    }

    static {
        nameToJavaName.put("Afrikaans", "af-ZA");
        nameToJavaName.put("Amharic", "am-ET");
        nameToJavaName.put("Arabic", "ar");
        nameToJavaName.put("Assamese", "as-IN");
        nameToJavaName.put("Azerbaijani_Latin", "az-AZ");
        nameToJavaName.put("Azerbaijani_Cyrillic", "az-cyrillic");
        nameToJavaName.put("Belarusian", "be-BY");
        nameToJavaName.put("Bulgarian", "bg-BG");
        nameToJavaName.put("Bengali", "bn-IN");
        nameToJavaName.put("Tibetan", "bo-CN");
        nameToJavaName.put("Bosnian", "bs-BA");
        nameToJavaName.put("Catalan", "ca-ES");
        nameToJavaName.put("Czech", "cs-CZ");
        nameToJavaName.put("Welsh", "cy-GB");
        nameToJavaName.put("Danish", "da-DK");
        nameToJavaName.put("German", "de-DE");
        nameToJavaName.put("Greek", "el-GR");
        nameToJavaName.put("Latin1_General", "en-US");
        nameToJavaName.put("English", "en-US");
        nameToJavaName.put("Spanish", "es-ES");
        nameToJavaName.put("Estonian", "et-EE");
        nameToJavaName.put("Basque", "eu");
        nameToJavaName.put("Finnish", "fi-FI");
        nameToJavaName.put("French", "fr-FR");
        nameToJavaName.put("Guarani", "gn-PY");
        nameToJavaName.put("Gujarati", "gu-IN");
        nameToJavaName.put("Hausa", "ha-NG");
        nameToJavaName.put("Hebrew", "he-IL");
        nameToJavaName.put("Hindi", "hi-IN");
        nameToJavaName.put("Croatian", "hr-HR");
        nameToJavaName.put("Hungarian", "hu-HU");
        nameToJavaName.put("Armenian", "hy-AM");
        nameToJavaName.put("Indonesian", "id-ID");
        nameToJavaName.put("Igbo", "ig-NG");
        nameToJavaName.put("Icelandic", "is-IS");
        nameToJavaName.put("Italian", "it-IT");
        nameToJavaName.put("Inuktitut", "iu-CA");
        nameToJavaName.put("Japanese", "ja-JP");
        nameToJavaName.put("Georgian", "ka-GE");
        nameToJavaName.put("Kazakh", "kk-KZ");
        nameToJavaName.put("Khmer", "km-KH");
        nameToJavaName.put("Kannada", "kn-IN");
        nameToJavaName.put("Korean", "ko-KR");
        nameToJavaName.put("Konkani", "kok-IN");
        nameToJavaName.put("Kashmiri", "ks");
        nameToJavaName.put("Kirghiz", "ky-KG");
        nameToJavaName.put("Lao", "lo-LA");
        nameToJavaName.put("Lithuanian", "lt-LT");
        nameToJavaName.put("Latvian", "lv-LV");
        nameToJavaName.put("Maori", "mi-NZ");
        nameToJavaName.put("Macedonian", "mk-MK");
        nameToJavaName.put("Malayalam", "ml-IN");
        nameToJavaName.put("Mongolian", "mn-MN");
        nameToJavaName.put("Manipuri", "mni-IN");
        nameToJavaName.put("Marathi", "mr-IN");
        nameToJavaName.put("Malay", "ms-MY");
        nameToJavaName.put("Maltese", "mt-MT");
        nameToJavaName.put("Burmese", "my-MM");
        nameToJavaName.put("Danish_Norwegian", "nb-NO");
        nameToJavaName.put("Nepali", "ne-NP");
        nameToJavaName.put("Dutch", "nl-NL");
        nameToJavaName.put("Norwegian", "nn-NO");
        nameToJavaName.put("Oriya", "or-IN");
        nameToJavaName.put("Punjabi", "pa-IN");
        nameToJavaName.put("Polish", "pl-PL");
        nameToJavaName.put("Pashto", "ps-AF");
        nameToJavaName.put("Portuguese", "pt-PT");
        nameToJavaName.put("Romanian", "ro-RO");
        nameToJavaName.put("Russian", "ru-RU");
        nameToJavaName.put("Sanskrit", "sa-IN");
        nameToJavaName.put("Sindhi", "sd-IN");
        nameToJavaName.put("Slovak", "sk-SK");
        nameToJavaName.put("Slovenian", "sl-SI");
        nameToJavaName.put("Somali", "so-SO");
        nameToJavaName.put("Albanian", "sq-AL");
        nameToJavaName.put("Serbian_Cyrillic", "sr-YU");
        nameToJavaName.put("Serbian_Latin", "sh-BA");
        nameToJavaName.put("Swedish", "sv-SE");
        nameToJavaName.put("Swahili", "sw-KE");
        nameToJavaName.put("Tamil", "ta-IN");
        nameToJavaName.put("Telugu", "te-IN");
        nameToJavaName.put("Tajik", "tg-TJ");
        nameToJavaName.put("Thai", "th-TH");
        nameToJavaName.put("Turkmen", "tk-TM");
        nameToJavaName.put("Tswana", "tn-BW");
        nameToJavaName.put("Turkish", "tr-TR");
        nameToJavaName.put("Tatar", "tt-RU");
        nameToJavaName.put("Ukrainian", "uk-UA");
        nameToJavaName.put("Urdu", "ur-PK");
        nameToJavaName.put("Uzbek_Latin", "uz-UZ");
        nameToJavaName.put("Venda", "ven-ZA");
        nameToJavaName.put("Vietnamese", "vi-VN");
        nameToJavaName.put("Yoruba", "yo-NG");
        nameToJavaName.put("Chinese", "zh-CN");
        nameToJavaName.put("Zulu", "zu-ZA");
        Iterator iterator = nameToJavaName.values().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = string.replace('-', '_').toUpperCase(Locale.ENGLISH);
            dbNameToJavaName.put(string2, string);
        }
        defaultCollation = new Collation(true);
        defaultIgnoreCaseCollation = new Collation(false);
        Collation.defaultCollation.charset = Charset.SQL_TEXT;
        Collation.defaultIgnoreCaseCollation.charset = Charset.SQL_TEXT;
        dbNameToCollation.put(defaultCollationName, defaultCollation);
        dbNameToCollation.put(defaultIgnoreCaseCollationName, defaultIgnoreCaseCollation);
    }
}

