/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.AlgebraicExpression;
import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.property.StyleExpression;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

class ProductExpression
extends StyleExpression
implements AlgebraicExpression {
    private static final long serialVersionUID = 1L;
    private final LinkedList<CSSExpression> operands = new LinkedList();

    ProductExpression() {
    }

    ProductExpression(ProductExpression copyFrom) {
        super(copyFrom);
        Iterator it = copyFrom.operands.iterator();
        while (it.hasNext()) {
            this.operands.add(((CSSExpression)it.next()).clone());
        }
    }

    @Override
    void addExpression(StyleExpression expr) {
        StyleExpression oparent = expr.getParentExpression();
        if (oparent != null && oparent.getPartType() == CSSExpression.AlgebraicPart.SUM) {
            oparent.replaceLastExpression(this);
        } else {
            this.operands.add(expr);
            expr.setParentExpression(this);
            if (this.nextOperandInverse) {
                expr.setInverseOperation(true);
                this.nextOperandInverse = false;
            }
        }
    }

    @Override
    public CSSExpression item(int index) {
        try {
            return this.operands.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public int getLength() {
        return this.operands.size();
    }

    @Override
    public CSSExpression.AlgebraicPart getPartType() {
        return CSSExpression.AlgebraicPart.PRODUCT;
    }

    @Override
    public int hashCode() {
        int prime = 211;
        int result = super.hashCode();
        result = 211 * result + (this.operands == null ? 0 : this.operands.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ProductExpression other = (ProductExpression)obj;
        if (this.operands == null) {
            return other.operands == null;
        }
        return this.operands.equals(other.operands);
    }

    @Override
    public ProductExpression clone() {
        return new ProductExpression(this);
    }

    @Override
    public String getCssText() {
        if (this.operands.isEmpty()) {
            return "";
        }
        BufferSimpleWriter wri = new BufferSimpleWriter(32 + this.operands.size() * 16);
        try {
            this.writeCssText((SimpleWriter)wri);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return wri.toString();
    }

    @Override
    public String getMinifiedCssText() {
        if (this.operands.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder(32);
        Iterator it = this.operands.iterator();
        CSSExpression expr = (CSSExpression)it.next();
        if (expr.getPartType() == CSSExpression.AlgebraicPart.SUM) {
            buf.append('(').append(expr.getMinifiedCssText()).append(')');
        } else {
            buf.append(expr.getMinifiedCssText());
        }
        while (it.hasNext()) {
            expr = (CSSExpression)it.next();
            if (expr.isInverseOperation()) {
                buf.append('/');
            } else {
                buf.append('*');
            }
            if (expr.getPartType() == CSSExpression.AlgebraicPart.SUM) {
                buf.append('(').append(expr.getMinifiedCssText()).append(')');
                continue;
            }
            buf.append(expr.getMinifiedCssText());
        }
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        Iterator it = this.operands.iterator();
        if (!it.hasNext()) {
            return;
        }
        CSSExpression expr = (CSSExpression)it.next();
        if (expr.getPartType() == CSSExpression.AlgebraicPart.SUM) {
            wri.write('(');
            expr.writeCssText(wri);
            wri.write(')');
        } else {
            expr.writeCssText(wri);
        }
        while (it.hasNext()) {
            expr = (CSSExpression)it.next();
            if (expr.isInverseOperation()) {
                wri.write('/');
            } else {
                wri.write('*');
            }
            if (expr.getPartType() == CSSExpression.AlgebraicPart.SUM) {
                wri.write('(');
                expr.writeCssText(wri);
                wri.write(')');
                continue;
            }
            expr.writeCssText(wri);
        }
    }

    static AlgebraicExpression createProductExpression() {
        return new ProductExpression();
    }
}

