/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.sasl;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;

final class DefaultCallbackHandler
implements CallbackHandler {
    private char[] passwd;
    private String authenticationID;
    private String authRealm;

    DefaultCallbackHandler(String string, Object object, String string2) throws IOException {
        this.authenticationID = string;
        this.authRealm = string2;
        if (object instanceof String) {
            this.passwd = ((String)object).toCharArray();
        } else if (object instanceof char[]) {
            this.passwd = (char[])((char[])object).clone();
        } else if (object != null) {
            String string3 = new String((byte[])object, "UTF8");
            this.passwd = string3.toCharArray();
        }
    }

    @Override
    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbackArray.length; ++i) {
            Object object;
            if (callbackArray[i] instanceof NameCallback) {
                ((NameCallback)callbackArray[i]).setName(this.authenticationID);
                continue;
            }
            if (callbackArray[i] instanceof PasswordCallback) {
                ((PasswordCallback)callbackArray[i]).setPassword(this.passwd);
                continue;
            }
            if (callbackArray[i] instanceof RealmChoiceCallback) {
                object = ((RealmChoiceCallback)callbackArray[i]).getChoices();
                int n = 0;
                if (this.authRealm != null && this.authRealm.length() > 0) {
                    n = -1;
                    for (int j = 0; j < ((Object)object).length; ++j) {
                        if (!((String)object[j]).equals(this.authRealm)) continue;
                        n = j;
                    }
                    if (n == -1) {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int j = 0; j < ((Object)object).length; ++j) {
                            stringBuffer.append((String)object[j] + ",");
                        }
                        throw new IOException("Cannot match 'java.naming.security.sasl.realm' property value, '" + this.authRealm + "' with choices " + stringBuffer + "in RealmChoiceCallback");
                    }
                }
                ((RealmChoiceCallback)callbackArray[i]).setSelectedIndex(n);
                continue;
            }
            if (callbackArray[i] instanceof RealmCallback) {
                object = (RealmCallback)callbackArray[i];
                if (this.authRealm != null) {
                    ((TextInputCallback)object).setText(this.authRealm);
                    continue;
                }
                String string = ((TextInputCallback)object).getDefaultText();
                if (string != null) {
                    ((TextInputCallback)object).setText(string);
                    continue;
                }
                ((TextInputCallback)object).setText("");
                continue;
            }
            throw new UnsupportedCallbackException(callbackArray[i]);
        }
    }

    void clearPassword() {
        if (this.passwd != null) {
            for (int i = 0; i < this.passwd.length; ++i) {
                this.passwd[i] = '\u0000';
            }
            this.passwd = null;
        }
    }

    protected void finalize() throws Throwable {
        this.clearPassword();
    }
}

