/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia.basic;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.plaf.basic.BasicButtonUI;

public class PixmapButton
extends JButton {
    private Dimension size;

    public PixmapButton(ImageIcon imageIcon) {
        this(imageIcon, null);
    }

    public PixmapButton(ImageIcon imageIcon, ImageIcon imageIcon2) {
        this.initPixmapButton(imageIcon, imageIcon2);
    }

    public PixmapButton(Action action, ImageIcon imageIcon) {
        super(action);
        this.initPixmapButton(imageIcon, null);
    }

    private void initPixmapButton(ImageIcon imageIcon, ImageIcon imageIcon2) {
        this.setText("");
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setIcon(imageIcon);
        if (imageIcon2 != null) {
            this.setRolloverIcon(imageIcon2);
            this.setRolloverEnabled(true);
        } else {
            this.setRolloverEnabled(false);
        }
        this.size = new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight());
        this.setPreferredSize(this.size);
        this.setMaximumSize(this.size);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void updateUI() {
        this.setUI(new BasicButtonUI());
    }
}

