/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.validator;

import java.util.List;
import org.keycloak.services.validation.Validation;
import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.UserProfileAttributeValidationContext;
import org.keycloak.validate.SimpleValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;

public class BlankAttributeValidator
implements SimpleValidator {
    public static final String ID = "up-blank-attribute-value";
    public static final String CFG_ERROR_MESSAGE = "error-message";
    public static final String CFG_FAIL_ON_NULL = "fail-on-null";

    public String getId() {
        return ID;
    }

    public ValidationContext validate(Object input, String inputHint, ValidationContext context, ValidatorConfig config) {
        String value;
        List values = (List)input;
        boolean failOnNull = config.getBooleanOrDefault(CFG_FAIL_ON_NULL, Boolean.valueOf(false));
        if (values.isEmpty() && !failOnNull) {
            return context;
        }
        AttributeContext attributeContext = UserProfileAttributeValidationContext.from((ValidationContext)context).getAttributeContext();
        if (!attributeContext.getMetadata().isRequired(attributeContext)) {
            return context;
        }
        String string = value = values.isEmpty() ? null : (String)values.get(0);
        if ((failOnNull || value != null) && Validation.isBlank(value)) {
            context.addError(new ValidationError(ID, inputHint, config.getStringOrDefault(CFG_ERROR_MESSAGE, "error-user-attribute-required")));
        }
        return context;
    }

    public static ValidatorConfig createConfig(String errorMessage, boolean failOnNull) {
        ValidatorConfig.ValidatorConfigBuilder builder = ValidatorConfig.builder();
        builder.config(CFG_FAIL_ON_NULL, (Object)failOnNull);
        if (errorMessage != null) {
            builder.config(CFG_ERROR_MESSAGE, (Object)errorMessage);
        }
        return builder.build();
    }
}

