/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.metrics.CardinalityAggregator;
import org.opensearch.search.aggregations.metrics.CardinalityAggregatorFactory;
import org.opensearch.search.aggregations.metrics.HyperLogLogPlusPlus;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.streaming.Streamable;
import org.opensearch.search.streaming.StreamingCostMetrics;

public class StreamCardinalityAggregator
extends CardinalityAggregator
implements Streamable {
    private CardinalityAggregator.Collector streamCollector;

    public StreamCardinalityAggregator(String name, ValuesSourceConfig valuesSourceConfig, int precision, SearchContext context, Aggregator parent, Map<String, Object> metadata, CardinalityAggregatorFactory.ExecutionMode executionMode) throws IOException {
        super(name, valuesSourceConfig, precision, context, parent, metadata, executionMode);
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.streamCollector != null) {
            try {
                this.streamCollector.postCollect();
            }
            finally {
                this.streamCollector.close();
                this.streamCollector = null;
            }
        }
        if (this.valuesSource == null) {
            ++this.emptyCollectorsUsed;
            this.streamCollector = new CardinalityAggregator.EmptyCollector();
            return this.streamCollector;
        }
        if (!(this.valuesSource instanceof ValuesSource.Bytes.WithOrdinals)) {
            throw new IllegalStateException("StreamCardinalityAggregator only supports ordinal value sources");
        }
        SortedSetDocValues ordinalValues = ((ValuesSource.Bytes.WithOrdinals)this.valuesSource).ordinalsValues(ctx);
        long maxOrd = ordinalValues.getValueCount();
        if (maxOrd == 0L) {
            ++this.emptyCollectorsUsed;
            this.streamCollector = new CardinalityAggregator.EmptyCollector();
        } else {
            ++this.ordinalsCollectorsUsed;
            this.streamCollector = new CardinalityAggregator.OrdinalsCollector(this.counts, ordinalValues, this.context.bigArrays());
        }
        return this.streamCollector;
    }

    @Override
    public void doReset() {
        super.doReset();
        if (this.streamCollector != null) {
            this.streamCollector.close();
            this.streamCollector = null;
        }
        if (this.counts != null) {
            this.counts.close();
            this.counts = this.valuesSource == null ? null : new HyperLogLogPlusPlus(this.precision, this.context.bigArrays(), 1L);
        }
    }

    @Override
    protected void doPostCollection() throws IOException {
        if (this.streamCollector != null) {
            try {
                this.streamCollector.postCollect();
            }
            finally {
                this.streamCollector.close();
                this.streamCollector = null;
            }
        }
    }

    @Override
    protected void doClose() {
        super.doClose();
        if (this.streamCollector != null) {
            this.streamCollector.close();
            this.streamCollector = null;
        }
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        StreamingCostMetrics metrics = this.getStreamingCostMetrics();
        add.accept("streaming_enabled", metrics.streamable());
        add.accept("streaming_precision", this.precision);
        add.accept("streaming_estimated_cardinality", metrics.estimatedBucketCount());
        add.accept("streaming_estimated_docs", metrics.estimatedDocCount());
        add.accept("streaming_segment_count", metrics.segmentCount());
    }

    @Override
    public StreamingCostMetrics getStreamingCostMetrics() {
        try {
            int topNSize = 1 << this.precision;
            if (!(this.valuesSource instanceof ValuesSource.Bytes.WithOrdinals)) {
                return StreamingCostMetrics.nonStreamable();
            }
            ValuesSource.Bytes.WithOrdinals ordinalValuesSource = (ValuesSource.Bytes.WithOrdinals)this.valuesSource;
            List leaves = this.context.searcher().getIndexReader().leaves();
            long maxCardinality = 0L;
            long totalDocsWithField = 0L;
            for (LeafReaderContext leaf : leaves) {
                SortedSetDocValues docValues = ordinalValuesSource.ordinalsValues(leaf);
                if (docValues == null) continue;
                maxCardinality = Math.max(maxCardinality, docValues.getValueCount());
                totalDocsWithField += docValues.cost();
            }
            return new StreamingCostMetrics(true, topNSize, maxCardinality, leaves.size(), totalDocsWithField);
        }
        catch (IOException e) {
            return StreamingCostMetrics.nonStreamable();
        }
    }
}

