/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.ml;

import java.util.List;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.Condition;
import org.opensearch.ad.model.Rule;
import org.opensearch.ad.model.ThresholdType;

public class IgnoreSimilarExtractor {
    public static ThresholdArrays processDetectorRules(AnomalyDetector detector) {
        List<String> featureNames = detector.getEnabledFeatureNames();
        int baseDimension = featureNames.size();
        Ref<Object> ignoreSimilarFromAbove = Ref.of(null);
        Ref<Object> ignoreSimilarFromBelow = Ref.of(null);
        Ref<Object> ignoreSimilarFromAboveByRatio = Ref.of(null);
        Ref<Object> ignoreSimilarFromBelowByRatio = Ref.of(null);
        List<Rule> rules = detector.getRules();
        if (rules != null) {
            for (Rule rule : rules) {
                for (Condition condition : rule.getConditions()) {
                    if (condition.getThresholdType() == ThresholdType.ACTUAL_IS_BELOW_EXPECTED || condition.getThresholdType() == ThresholdType.ACTUAL_IS_OVER_EXPECTED) continue;
                    IgnoreSimilarExtractor.processCondition(condition, featureNames, baseDimension, ignoreSimilarFromAbove, ignoreSimilarFromBelow, ignoreSimilarFromAboveByRatio, ignoreSimilarFromBelowByRatio);
                }
            }
        }
        return new ThresholdArrays((double[])ignoreSimilarFromAbove.value, (double[])ignoreSimilarFromBelow.value, (double[])ignoreSimilarFromAboveByRatio.value, (double[])ignoreSimilarFromBelowByRatio.value);
    }

    private static void processCondition(Condition condition, List<String> featureNames, int baseDimension, Ref<double[]> ignoreSimilarFromAbove, Ref<double[]> ignoreSimilarFromBelow, Ref<double[]> ignoreSimilarFromAboveByRatio, Ref<double[]> ignoreSimilarFromBelowByRatio) {
        String featureName = condition.getFeatureName();
        int featureIndex = featureNames.indexOf(featureName);
        ThresholdType thresholdType = condition.getThresholdType();
        Double value = condition.getValue();
        if (value == null) {
            value = 0.0;
        }
        switch (thresholdType) {
            case ACTUAL_OVER_EXPECTED_MARGIN: {
                IgnoreSimilarExtractor.updateThresholdValue(baseDimension, ignoreSimilarFromAbove, featureIndex, value);
                break;
            }
            case EXPECTED_OVER_ACTUAL_MARGIN: {
                IgnoreSimilarExtractor.updateThresholdValue(baseDimension, ignoreSimilarFromBelow, featureIndex, value);
                break;
            }
            case ACTUAL_OVER_EXPECTED_RATIO: {
                IgnoreSimilarExtractor.updateThresholdValue(baseDimension, ignoreSimilarFromAboveByRatio, featureIndex, value);
                break;
            }
            case EXPECTED_OVER_ACTUAL_RATIO: {
                IgnoreSimilarExtractor.updateThresholdValue(baseDimension, ignoreSimilarFromBelowByRatio, featureIndex, value);
                break;
            }
        }
    }

    private static void updateThresholdValue(int baseDimension, Ref<double[]> thresholdArrayRef, int featureIndex, double value) {
        if (thresholdArrayRef.value == null) {
            thresholdArrayRef.value = new double[baseDimension];
        }
        ((double[])thresholdArrayRef.value)[featureIndex] = value;
    }

    private static class Ref<T> {
        public T value;

        private Ref(T value) {
            this.value = value;
        }

        public static <T> Ref<T> of(T value) {
            return new Ref<T>(value);
        }
    }

    public static class ThresholdArrays {
        public double[] ignoreSimilarFromAbove;
        public double[] ignoreSimilarFromBelow;
        public double[] ignoreSimilarFromAboveByRatio;
        public double[] ignoreSimilarFromBelowByRatio;

        public ThresholdArrays(double[] ignoreSimilarFromAbove, double[] ignoreSimilarFromBelow, double[] ignoreSimilarFromAboveByRatio, double[] ignoreSimilarFromBelowByRatio) {
            this.ignoreSimilarFromAbove = ignoreSimilarFromAbove;
            this.ignoreSimilarFromBelow = ignoreSimilarFromBelow;
            this.ignoreSimilarFromAboveByRatio = ignoreSimilarFromAboveByRatio;
            this.ignoreSimilarFromBelowByRatio = ignoreSimilarFromBelowByRatio;
        }
    }
}

